/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.ManagerFactoryParameters;
import org.bouncycastle.jsse.provider.ProvX509KeyManager;

class ProvKeyManagerFactorySpi
extends KeyManagerFactorySpi {
    KeyManager keyManager;

    ProvKeyManagerFactorySpi() {
    }

    @Override
    protected void engineInit(KeyStore keyStore, char[] passwd) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keyStore == null) {
            this.keyManager = new ProvX509KeyManager(Collections.emptyList());
        } else {
            try {
                KeyStore.Builder builder = KeyStore.Builder.newInstance(keyStore, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(passwd));
                this.keyManager = new ProvX509KeyManager(Collections.singletonList(builder));
            }
            catch (RuntimeException e) {
                throw new KeyStoreException("initialization failed", e);
            }
        }
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (managerFactoryParameters instanceof KeyStoreBuilderParameters) {
            List<KeyStore.Builder> builders = ((KeyStoreBuilderParameters)managerFactoryParameters).getParameters();
            this.keyManager = new ProvX509KeyManager(builders);
        }
        throw new InvalidAlgorithmParameterException("Parameters must be instance of KeyStoreBuilderParameters");
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        if (this.keyManager != null) {
            return new KeyManager[]{this.keyManager};
        }
        throw new IllegalStateException("KeyManagerFactory not initialized");
    }
}

