/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;

class JsseUtils {
    protected static X509Certificate[] EMPTY_CHAIN = new X509Certificate[0];

    JsseUtils() {
    }

    static boolean contains(String[] values, String value) {
        for (int i = 0; i < values.length; ++i) {
            if (!value.equals(values[i])) continue;
            return true;
        }
        return false;
    }

    public static String getAuthType(int keyExchangeAlgorithm) throws IOException {
        switch (keyExchangeAlgorithm) {
            case 11: {
                return "DH_anon";
            }
            case 7: {
                return "DH_DSS";
            }
            case 9: {
                return "DH_RSA";
            }
            case 3: {
                return "DHE_DSS";
            }
            case 14: {
                return "DHE_PSK";
            }
            case 5: {
                return "DHE_RSA";
            }
            case 20: {
                return "ECDH_anon";
            }
            case 16: {
                return "ECDH_ECDSA";
            }
            case 18: {
                return "ECDH_RSA";
            }
            case 17: {
                return "ECDHE_ECDSA";
            }
            case 24: {
                return "ECDHE_PSK";
            }
            case 19: {
                return "ECDHE_RSA";
            }
            case 1: {
                return "RSA";
            }
            case 15: {
                return "RSA_PSK";
            }
            case 21: {
                return "SRP";
            }
            case 22: {
                return "SRP_DSS";
            }
            case 23: {
                return "SRP_RSA";
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static Certificate getCertificateMessage(TlsCrypto crypto, X509Certificate[] chain) throws IOException {
        if (chain == null || chain.length < 1) {
            return Certificate.EMPTY_CHAIN;
        }
        TlsCertificate[] certificateList = new TlsCertificate[chain.length];
        try {
            for (int i = 0; i < chain.length; ++i) {
                certificateList[i] = crypto.createCertificate(chain[i].getEncoded());
            }
        }
        catch (CertificateEncodingException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        return new Certificate(certificateList);
    }

    public static String getClientAuthType(short clientCertificateType) throws IOException {
        switch (clientCertificateType) {
            case 2: {
                return "DSA";
            }
            case 64: {
                return "EC";
            }
            case 1: {
                return "RSA";
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static X509Certificate[] getX509CertificateChain(Certificate certificateMessage) {
        if (certificateMessage == null || certificateMessage.isEmpty()) {
            return EMPTY_CHAIN;
        }
        DefaultJcaJceHelper helper = new DefaultJcaJceHelper();
        try {
            X509Certificate[] chain = new X509Certificate[certificateMessage.getLength()];
            for (int i = 0; i < chain.length; ++i) {
                chain[i] = JcaTlsCertificate.convert(certificateMessage.getCertificateAt(i), (JcaJceHelper)helper).getX509Certificate();
            }
            return chain;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static X500Principal getSubject(Certificate certificateMessage) {
        if (certificateMessage == null || certificateMessage.isEmpty()) {
            return null;
        }
        DefaultJcaJceHelper helper = new DefaultJcaJceHelper();
        try {
            return JcaTlsCertificate.convert(certificateMessage.getCertificateAt(0), (JcaJceHelper)helper).getX509Certificate().getSubjectX500Principal();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Set<X500Principal> toX500Principals(X500Name[] names) throws IOException {
        if (names == null || names.length == 0) {
            return Collections.emptySet();
        }
        HashSet<X500Principal> principals = new HashSet<X500Principal>(names.length);
        for (int i = 0; i < names.length; ++i) {
            X500Name name = names[i];
            if (name == null) continue;
            principals.add(new X500Principal(name.getEncoded("DER")));
        }
        return principals;
    }

    static Set<X500Name> toX500Names(Principal[] principals) {
        if (principals == null || principals.length == 0) {
            return Collections.emptySet();
        }
        HashSet<X500Name> names = new HashSet<X500Name>(principals.length);
        for (int i = 0; i != principals.length; ++i) {
            Principal principal = principals[i];
            if (principal instanceof X500Principal) {
                names.add(X500Name.getInstance((Object)((X500Principal)principal).getEncoded()));
                continue;
            }
            if (principal == null) continue;
            names.add(new X500Name(principal.getName()));
        }
        return names;
    }
}

