/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.util.net;

import com.jscape.inet.cZ;
import com.jscape.util.aV;
import com.jscape.util.aa;
import com.jscape.util.eC;
import com.jscape.util.net.MessageConnectionHandler;
import com.jscape.util.net.TransportAddress;
import com.jscape.util.net.connection.AsyncConnector;
import com.jscape.util.net.connection.AsyncMessageConnection;
import com.jscape.util.net.connection.Connection;
import com.jscape.util.net.connection.RawConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageConnectionServer<C extends RawConnection, M>
extends eC<MessageConnectionHandler<C, M>>
implements AsyncConnector.Listener<C>,
AsyncMessageConnection.Listener<M> {
    private final AsyncConnector<C> connector;
    private final String name;
    private final AtomicInteger totalConnectionCount;
    private final List<AsyncMessageConnection<M>> connections;
    private final Lock lock;
    private final Logger logger;
    private volatile boolean paused;
    private static final String[] d;

    public MessageConnectionServer(AsyncConnector<C> asyncConnector, String string, Logger logger) {
        aV.a(asyncConnector);
        this.connector = asyncConnector;
        aV.a((Object)string);
        this.name = string;
        this.totalConnectionCount = new AtomicInteger(0);
        this.connections = new LinkedList<AsyncMessageConnection<M>>();
        this.lock = new ReentrantLock();
        aV.a(logger);
        this.logger = logger;
    }

    public TransportAddress boundAddress() {
        return this.connector.boundAddress();
    }

    public boolean paused() {
        return this.paused;
    }

    public int connectionCount() {
        this.lock.lock();
        try {
            int n2 = this.connections.size();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int totalConnectionCount() {
        return this.totalConnectionCount.get();
    }

    public Collection<AsyncMessageConnection<M>> connections() {
        this.lock.lock();
        try {
            ArrayList<AsyncMessageConnection<M>> arrayList = new ArrayList<AsyncMessageConnection<M>>(this.connections);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onConnection(AsyncConnector<C> asyncConnector, C c10) {
        try {
            if (this.paused) {
                c10.close();
                return;
            }
        }
        catch (MessageConnectionHandler.OperationException operationException) {
            throw MessageConnectionServer.a(operationException);
        }
        this.logIncomingConnection((Connection)c10);
        this.totalConnectionCount.incrementAndGet();
        try {
            AsyncMessageConnection asyncMessageConnection = ((MessageConnectionHandler)this.b).onConnection(c10);
            this.add(asyncMessageConnection);
            this.startConnection(asyncMessageConnection);
        }
        catch (MessageConnectionHandler.OperationException operationException) {
            c10.close();
        }
    }

    @Override
    public void onError(AsyncConnector<C> asyncConnector, Throwable throwable) {
        this.logConnectorError(throwable);
        this.c();
    }

    @Override
    public void onMessage(AsyncMessageConnection<M> asyncMessageConnection, M m2) {
        ((MessageConnectionHandler)this.b).onMessage(asyncMessageConnection, m2);
    }

    @Override
    public void onEof(AsyncMessageConnection<M> asyncMessageConnection) {
        this.logConnectionEof(asyncMessageConnection);
        ((MessageConnectionHandler)this.b).close(asyncMessageConnection);
    }

    @Override
    public void onIdle(AsyncMessageConnection<M> asyncMessageConnection) {
        this.logConnectionIdle(asyncMessageConnection);
        ((MessageConnectionHandler)this.b).onIdle(asyncMessageConnection);
    }

    @Override
    public void onError(AsyncMessageConnection<M> asyncMessageConnection, Throwable throwable) {
        if (!(throwable instanceof Connection.ConnectionClosedException)) {
            this.logConnectionError(asyncMessageConnection, throwable);
        }
        ((MessageConnectionHandler)this.b).close(asyncMessageConnection);
    }

    @Override
    public void onClosed(AsyncMessageConnection<M> asyncMessageConnection) {
        this.logConnectionClosed(asyncMessageConnection);
        this.remove(asyncMessageConnection);
        ((MessageConnectionHandler)this.b).onClosed(asyncMessageConnection);
    }

    public synchronized void pause() throws aa {
        this.e();
        this.paused = true;
        this.logServicePaused();
    }

    public synchronized void resume() throws aa {
        this.e();
        this.paused = false;
        this.logServiceResumed();
    }

    @Override
    protected void actualStart() throws Exception {
        this.paused = false;
        this.connector.a(this);
        ((MessageConnectionHandler)this.b).onServerStarted(this.connector.boundAddress());
        this.logServiceStarted();
    }

    @Override
    protected void actualStop() {
        this.connector.c();
        ((MessageConnectionHandler)this.b).onServerStopped();
        this.logServiceStopped();
    }

    @Override
    protected void actualDispose() {
        this.connector.d();
        this.closeConnections();
        this.logServiceDisposed();
    }

    protected void closeConnections() {
        cZ[] cZArray = TransportAddress.b();
        for (AsyncMessageConnection<M> asyncMessageConnection : this.connections()) {
            ((MessageConnectionHandler)this.b).close(asyncMessageConnection);
            if (cZArray == null) continue;
        }
    }

    private void startConnection(AsyncMessageConnection<M> asyncMessageConnection) {
        try {
            asyncMessageConnection.start(this);
        }
        catch (Connection.ConnectionException connectionException) {
            this.logErrorStartingConnection(asyncMessageConnection, connectionException);
            this.remove(asyncMessageConnection);
            ((MessageConnectionHandler)this.b).close(asyncMessageConnection);
        }
    }

    private void add(AsyncMessageConnection<M> asyncMessageConnection) {
        this.lock.lock();
        try {
            this.connections.add(asyncMessageConnection);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void remove(AsyncMessageConnection<M> asyncMessageConnection) {
        this.lock.lock();
        try {
            this.connections.remove(asyncMessageConnection);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void logServiceStarted() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[9], this.name, this.connector.boundAddress()));
        }
    }

    private void logServiceStopped() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[11], this.name));
        }
    }

    private void logServicePaused() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[10], this.name));
        }
    }

    private void logServiceResumed() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[5], this.name));
        }
    }

    private void logServiceDisposed() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[4], this.name));
        }
    }

    private void logIncomingConnection(Connection connection) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, String.format(d[8], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logConnectionEof(Connection connection) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, String.format(d[2], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logConnectorError(Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, String.format(d[6], this.name), throwable);
        }
    }

    private void logConnectionIdle(Connection connection) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, String.format(d[3], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logConnectionError(Connection connection, Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, String.format(d[7], this.name, connection.localAddress(), connection.remoteAddress()), throwable);
        }
    }

    private void logConnectionClosed(Connection connection) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, String.format(d[1], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logErrorStartingConnection(Connection connection, Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, String.format(d[0], this.name, connection.localAddress(), connection.remoteAddress()), throwable);
        }
    }

    private static MessageConnectionHandler.OperationException a(MessageConnectionHandler.OperationException operationException) {
        return operationException;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[12];
                var3_1 = 0;
                var2_2 = "\"'U\u0011DY)\u00134U\n_\u0017=GpT^U\u00164\t0D\n_\u00164]u|[EYfJk\u0007[E$t\"B&\u0007\u001dY\u00174\u00026S\u0017Y\u0017z\u00049H\rS\u001d`G\u000e\u0002\r\u0016EwYu\u0002\rkW\u001fB&\u0007\u001dY\u00174\u00026S\u0017Y\u0017z\"\u001aaD\u0016\"\u007f\u0014u\u001bS\bY\u007f\u0014\b\t B&\u0007\u001dY\u00174\u00026S\u0017Y\u0017z\u000e1K\u001b\fY\u0001B&\u0007B\u001bGzB&zP\u0013B&\u0007-S\u000b,\u0002'\u0007\u001a_\n*\b&B\u001a\u0018\u0012B&\u0007-S\u000b,\u0002'\u0007\fS\n/\n0CP\u0013B&\u0007\u001dY\u00174\u00026S\u0011DY?\u0015'H\f\u0018!B&\u0007\u001dY\u00174\u00026S\u0017Y\u0017z\u0002'U\u0011DCz<pT^\nTdGpT#\u0018$.;D\u0011[\u00104\u0000u\u0002\r\u0016\u001a5\t;B\u001dB\u00105\to\u0007%\u0013\nz[x\u0019^\u0013\n\u0007I\u001aB&\u0007-S\u000b,\u0002'\u0007\rB\u0018(\u00130C^W\rz<pT#\u0018";
                var4_3 = "\"'U\u0011DY)\u00134U\n_\u0017=GpT^U\u00164\t0D\n_\u00164]u|[EYfJk\u0007[E$t\"B&\u0007\u001dY\u00174\u00026S\u0017Y\u0017z\u00049H\rS\u001d`G\u000e\u0002\r\u0016EwYu\u0002\rkW\u001fB&\u0007\u001dY\u00174\u00026S\u0017Y\u0017z\"\u001aaD\u0016\"\u007f\u0014u\u001bS\bY\u007f\u0014\b\t B&\u0007\u001dY\u00174\u00026S\u0017Y\u0017z\u000e1K\u001b\fY\u0001B&\u0007B\u001bGzB&zP\u0013B&\u0007-S\u000b,\u0002'\u0007\u001a_\n*\b&B\u001a\u0018\u0012B&\u0007-S\u000b,\u0002'\u0007\fS\n/\n0CP\u0013B&\u0007\u001dY\u00174\u00026S\u0011DY?\u0015'H\f\u0018!B&\u0007\u001dY\u00174\u00026S\u0017Y\u0017z\u0002'U\u0011DCz<pT^\nTdGpT#\u0018$.;D\u0011[\u00104\u0000u\u0002\r\u0016\u001a5\t;B\u001dB\u00105\to\u0007%\u0013\nz[x\u0019^\u0013\n\u0007I\u001aB&\u0007-S\u000b,\u0002'\u0007\rB\u0018(\u00130C^W\rz<pT#\u0018".length();
                var1_4 = 42;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 80;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "I-\f&X\u0000'\t,\f\u0005\\\u0007\"\t:\u0002\u0012I-\f&X\u0000'\t,\f\u0006I\u001d!\u001c;H[";
                    var4_3 = "I-\f&X\u0000'\t,\f\u0005\\\u0007\"\t:\u0002\u0012I-\f&X\u0000'\t,\f\u0006I\u001d!\u001c;H[".length();
                    var1_4 = 17;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 91;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 55;
                            break;
                        }
                        case 1: {
                            v15 = 5;
                            break;
                        }
                        case 2: {
                            v15 = 119;
                            break;
                        }
                        case 3: {
                            v15 = 46;
                            break;
                        }
                        case 4: {
                            v15 = 102;
                            break;
                        }
                        case 5: {
                            v15 = 41;
                            break;
                        }
                        default: {
                            v15 = 10;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        MessageConnectionServer.d = var5;
    }
}

