/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.context.UnattendedProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.GUIProgressInterface;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.ProgressDisplay;
import com.install4j.runtime.installer.frontend.headless.UnattendedScreenExecutor;
import com.install4j.runtime.util.CustomDialog;
import com.install4j.runtime.wizard.CustomFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SplashProgressInterface
implements UnattendedProgressInterface {
    private static final int FRAME_WIDTH = Integer.getInteger("install4j.splashWidth", 350);
    private final GUIProgressInterface guiProgressInterface = new GUIProgressInterface();
    private ProgressDisplay progressDisplay;
    private boolean userConfirmations;
    private boolean quietOverwrite;
    private boolean quietRetryFail;
    private UnattendedScreenExecutor unattendedScreenExecutor;
    private JPanel cancelButtonPanel;
    private JButton btnCancel;
    private Window window;

    public SplashProgressInterface(String title, boolean userConfirmations, boolean quietOverwrite, boolean quietRetryFail, UnattendedScreenExecutor unattendedScreenExecutor, boolean dialog, Window parentWindow) {
        JPanel contentPane;
        this.userConfirmations = userConfirmations;
        this.quietOverwrite = quietOverwrite;
        this.quietRetryFail = quietRetryFail;
        this.unattendedScreenExecutor = unattendedScreenExecutor;
        this.btnCancel = GUIHelper.adjustButton(new JButton(Messages.getMessages().getString("ButtonCancel")));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SplashProgressInterface.this.btnCancel.isEnabled() && SplashProgressInterface.this.btnCancel.isVisible()) {
                    SplashProgressInterface.this.doCancel();
                }
            }
        });
        this.progressDisplay = new ProgressDisplay();
        this.cancelButtonPanel = new JPanel(new BorderLayout());
        GUIHelper.setEmptyBorder(this.cancelButtonPanel, 0, 5, 0, 0);
        this.cancelButtonPanel.add((Component)this.btnCancel, "Last");
        if (dialog) {
            SplashScreenDialog splashScreenDialog = new SplashScreenDialog(parentWindow);
            this.window = splashScreenDialog;
            contentPane = (JPanel)splashScreenDialog.getContentPane();
        } else {
            this.window = new SplashScreenFrame();
            SplashScreenFrame splashScreenFrame = (SplashScreenFrame)this.window;
            contentPane = (JPanel)splashScreenFrame.getContentPane();
        }
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add((Component)this.progressDisplay, "Center");
        if (unattendedScreenExecutor != null) {
            contentPane.add((Component)this.cancelButtonPanel, "After");
        }
        if (this.window instanceof SplashScreenDialog) {
            ((SplashScreenDialog)this.window).init(title);
        } else {
            ((SplashScreenFrame)this.window).init(title);
        }
    }

    private void doCancel() {
        ContextImpl.setAskingForCancel(true);
        try {
            this.btnCancel.setEnabled(false);
            ContextImpl.setCancelling();
            this.unattendedScreenExecutor.getCommandSink().returnToController(ControllerCommand.CANCEL);
        }
        finally {
            ContextImpl.setAskingForCancel(false);
        }
    }

    @Override
    public void setStatusMessage(String message) {
        this.progressDisplay.setStatusMessage(message);
    }

    @Override
    public void setDetailMessage(String message) {
        this.progressDisplay.setDetailMessage(message);
    }

    @Override
    public void setPercentCompleted(int value) {
        this.progressDisplay.setPercentCompleted(value);
    }

    @Override
    public int getPercentCompleted() {
        return this.progressDisplay.getPercentCompleted();
    }

    @Override
    public void setSecondaryPercentCompleted(int value) {
        this.progressDisplay.setSecondaryPercentCompleted(value);
    }

    @Override
    public void setIndeterminateProgress(boolean indeterminateProgress) {
        this.progressDisplay.setIndeterminateProgress(indeterminateProgress);
    }

    @Override
    public void showFailure(String message) {
        if (this.userConfirmations) {
            this.guiProgressInterface.showFailure(message);
        }
    }

    @Override
    public int askOverwrite(File file) throws UserCanceledException {
        if (this.userConfirmations) {
            return this.guiProgressInterface.askOverwrite(file);
        }
        if (this.quietOverwrite) {
            return 2;
        }
        return 1;
    }

    @Override
    public int askRetry(File file) throws UserCanceledException {
        if (this.userConfirmations) {
            return this.guiProgressInterface.askRetry(file);
        }
        if (this.quietRetryFail) {
            return 3;
        }
        return 1;
    }

    @Override
    public boolean askContinue(File file) throws UserCanceledException {
        if (this.userConfirmations) {
            return this.guiProgressInterface.askContinue(file);
        }
        return true;
    }

    @Override
    public void setCancelButtonEnabled(boolean enabled) {
        this.btnCancel.setEnabled(enabled);
    }

    @Override
    public void setCancelButtonVisible(boolean visible) {
        this.cancelButtonPanel.setVisible(visible);
    }

    @Override
    public boolean isAskForProxy() {
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        this.window.setVisible(visible);
        if (!visible) {
            this.window.dispose();
        }
    }

    private static class SplashScreenFrame
    extends CustomFrame {
        private SplashScreenFrame() {
        }

        @Override
        protected int getFrameHeight() {
            return -1;
        }

        @Override
        protected int getFrameWidth() {
            return FRAME_WIDTH;
        }

        public void init(String title) {
            this.setTitle(title);
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.pack();
            this.setBounds(this.getNewFrameBounds());
            GUIHelper.setIconImages(this);
        }
    }

    private static class SplashScreenDialog
    extends CustomDialog {
        SplashScreenDialog(Window wizardWindow) {
            super(wizardWindow);
        }

        @Override
        protected int getFrameHeight() {
            return -1;
        }

        @Override
        protected int getFrameWidth() {
            return FRAME_WIDTH;
        }

        public void init(String title) {
            this.setTitle(title);
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.pack();
            this.setBounds(this.getFrameBounds());
            GUIHelper.setIconImages(this);
        }
    }
}

