/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.inet.gateway.adapter.web;

import com.jscape.a.Page;
import com.jscape.a.PageRequest;
import com.jscape.inet.cZ;
import com.jscape.inet.gateway.Administrator;
import com.jscape.inet.gateway.AdministratorData;
import com.jscape.inet.gateway.AdministratorSummary;
import com.jscape.inet.gateway.AgentData;
import com.jscape.inet.gateway.AgentServiceConfiguration;
import com.jscape.inet.gateway.AgentSessionSummary;
import com.jscape.inet.gateway.AgentSummary;
import com.jscape.inet.gateway.BlockIpRequest;
import com.jscape.inet.gateway.CertificateGenerationData;
import com.jscape.inet.gateway.CertificateImportData;
import com.jscape.inet.gateway.ClusterData;
import com.jscape.inet.gateway.ClusterInfo;
import com.jscape.inet.gateway.ClusterSummary;
import com.jscape.inet.gateway.EmailServiceConfiguration;
import com.jscape.inet.gateway.FtpServiceConfiguration;
import com.jscape.inet.gateway.HttpServiceConfiguration;
import com.jscape.inet.gateway.I;
import com.jscape.inet.gateway.IpAccessConfiguration;
import com.jscape.inet.gateway.LogRecord;
import com.jscape.inet.gateway.LogServiceConfiguration;
import com.jscape.inet.gateway.MonitorServiceConfiguration;
import com.jscape.inet.gateway.PasswordCredentials;
import com.jscape.inet.gateway.ProxyServiceData;
import com.jscape.inet.gateway.ProxyServiceSummary;
import com.jscape.inet.gateway.RawServiceConfiguration;
import com.jscape.inet.gateway.ServerKeyGenerationData;
import com.jscape.inet.gateway.ServerKeyImportData;
import com.jscape.inet.gateway.ServerKeySummary;
import com.jscape.inet.gateway.ServerParameters;
import com.jscape.inet.gateway.ServerStatistics;
import com.jscape.inet.gateway.WebServiceConfiguration;
import com.jscape.inet.gateway.adapter.web.a;
import com.jscape.inet.gateway.adapter.web.b;
import com.jscape.inet.gateway.adapter.web.c;
import com.jscape.inet.gateway.adapter.web.g;
import com.jscape.inet.gateway.adapter.web.protocol.messages.ErrorSummary;
import com.jscape.inet.gateway.adapter.web.protocol.messages.NewPasswordData;
import com.jscape.inet.gateway.adapter.web.protocol.messages.ResetPasswordRequest;
import com.jscape.inet.gateway.adapter.web.protocol.messages.SubmitState;
import com.jscape.inet.gateway.av;
import com.jscape.inet.gateway.u;
import com.jscape.inet.gateway.x;
import com.jscape.util.FileService;
import com.jscape.util.a2;
import com.jscape.util.aG;
import com.jscape.util.aV;
import com.jscape.util.io.ByteArrayOutputStream;
import com.jscape.util.io.LimitedInputStream;
import com.jscape.util.net.TransportAddress;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/")
@Api(value="/api", description="Application operations")
@a2
public class ApiServer {
    private static final int MAX_LICENSE_FILE_SIZE = 2048;
    private final HttpServletRequest request;
    private HttpSession session;
    private final TransportAddress localAddress;
    private final TransportAddress remoteAddress;
    private final av gateway;
    private final String username;
    private final Logger logger;
    private static final String[] a;

    public ApiServer(@Context ServletContext servletContext, @Context HttpServletRequest httpServletRequest) {
        aV.a(httpServletRequest);
        this.request = httpServletRequest;
        this.session = this.request.getSession();
        this.localAddress = new TransportAddress(this.request.getLocalAddr(), this.request.getLocalPort());
        this.remoteAddress = new TransportAddress(this.request.getRemoteHost(), this.request.getRemotePort());
        this.gateway = (av)com.jscape.inet.gateway.adapter.web.a.GATEWAY.of(servletContext);
        this.username = (String)c.USERNAME.of(this.session);
        this.logger = Logger.getLogger(a[0]);
        this.logRequest();
    }

    @GET
    @Path(value="/test")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Test API", notes="Tests an API accessibility.", response=String.class)
    public String test() {
        return a[9];
    }

    @POST
    @Path(value="/login")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Login API", notes="Performs user authentication for accessing API.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void login(@ApiParam(value="Authentication credentials", required=true) PasswordCredentials passwordCredentials) throws g {
        try {
            this.gateway.a(this.localAddress, this.remoteAddress);
            String string = this.gateway.a(passwordCredentials);
            Administrator administrator = this.gateway.j(string);
            this.logout();
            long l10 = administrator.b(this.gateway);
            this.session = this.request.getSession(true);
            c.USERNAME.set(this.session, string);
            c.LAST_LOGIN_DATE.set(this.session, new Date(l10));
        }
        catch (I i10) {
            this.cleanupSession();
            this.gateway.b(this.localAddress, this.remoteAddress);
            String[] stringArray = a;
            throw new g(ErrorSummary.Code.NOT_AUTHENTICATED, stringArray[1], "");
        }
        catch (x x2) {
            this.cleanupSession();
            this.gateway.b(this.localAddress, this.remoteAddress);
            throw new g(ErrorSummary.Code.NOT_AUTHENTICATED, a[15], "");
        }
        catch (Throwable throwable) {
            this.cleanupSession();
            this.gateway.b(this.localAddress, this.remoteAddress);
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/logout")
    @ApiOperation(value="Logout API", notes="Performs user logout.")
    public void logout() {
        try {
            Administrator administrator = this.currentAdministrator();
            administrator.c(this.gateway);
            this.gateway.b(this.localAddress, this.remoteAddress);
        }
        catch (Exception exception) {
        }
        finally {
            this.cleanupSession();
            this.session.invalidate();
        }
    }

    @POST
    @Path(value="/login/test")
    @ApiOperation(value="Check user logged in", notes="Checks if user is still logged in.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void assertLoggedIn() throws g {
        this.assertAuthenticated();
    }

    @POST
    @Path(value="/password-changing/start")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Start password changing", notes="Starts password changing procedure.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void startPasswordChanging(String string) throws g {
        try {
            this.cleanupSession();
            this.session.invalidate();
            this.session = this.request.getSession(true);
            Administrator administrator = this.gateway.j(string);
            String string2 = administrator.d(this.gateway);
            c.RESET_PASSWORD_REQUEST.set(this.session, new ResetPasswordRequest(string, string2));
        }
        catch (u u2) {
            this.cleanupSession();
            throw new g(ErrorSummary.Code.INVALID_OPERATION_DATA, a[5], "");
        }
        catch (Throwable throwable) {
            this.cleanupSession();
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/password-changing/finish")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Finish password changing", notes="Finishes password changing procedure.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void finishPasswordChanging(NewPasswordData newPasswordData) throws g {
        try {
            ResetPasswordRequest resetPasswordRequest = (ResetPasswordRequest)c.RESET_PASSWORD_REQUEST.of(this.session);
            try {
                this.cleanupSession();
                this.session.invalidate();
                this.session = this.request.getSession(true);
                if (resetPasswordRequest == null) {
                    throw new g(ErrorSummary.Code.OPERATION_NOT_ALLOWED, a[10], "");
                }
            }
            catch (Throwable throwable) {
                throw ApiServer.a(throwable);
            }
            try {
                if (!resetPasswordRequest.securityCode.equals(newPasswordData.securityCode)) {
                    throw new g(ErrorSummary.Code.INVALID_OPERATION_DATA, a[12], "");
                }
            }
            catch (Throwable throwable) {
                throw ApiServer.a(throwable);
            }
            Administrator administrator = this.gateway.j(resetPasswordRequest.username);
            administrator.a(newPasswordData.password, this.gateway);
        }
        catch (Throwable throwable) {
            this.cleanupSession();
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/server/parameters")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get server parameters", notes="Obtains server parameters.", response=ServerParameters.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ServerParameters serverParameters() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.e(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/server/parameters/addresses")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get server IP's", notes="Obtains available server IP's.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public String[] serverAddresses() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.f(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/server/statistics")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get server statistics", notes="Obtains current server statistics.", response=ServerStatistics.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ServerStatistics serverStatistics() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.g(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/license")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @ApiOperation(value="Import license", notes="Imports an application license.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void importLicense(@ApiParam(value="License file", required=true) @FormDataParam(value="dataFile") InputStream inputStream) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            c.SUBMIT_STATE.set(this.session, SubmitState.inProgress());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            aG.b((InputStream)new LimitedInputStream(inputStream, 2048L, false), (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.d();
            administrator.a(byArray, this.gateway);
            c.SUBMIT_STATE.set(this.session, SubmitState.done());
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.session, SubmitState.error(throwable));
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/proxies")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get proxy services", notes="Obtains available proxy services.", response=ProxyServiceSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ProxyServiceSummary[] proxyServices() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.h(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/proxy")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get proxy service", notes="Obtains a proxy service data.", response=ProxyServiceData.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ProxyServiceData proxyServiceFor(@ApiParam(value="Service ID", required=true) @QueryParam(value="id") String string) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.b(string, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/proxy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add proxy service", notes="Adds a new proxy service.", response=ProxyServiceSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ProxyServiceSummary addProxyService(@ApiParam(value="Data", required=true) ProxyServiceData proxyServiceData) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(proxyServiceData, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy/start")
    @ApiOperation(value="Start proxy service", notes="Starts a proxy service.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void startProxyService(@QueryParam(value="id") @ApiParam(value="Service ID", required=true) String string) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            administrator.c(string, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy/stop")
    @ApiOperation(value="Stop proxy service", notes="Stops a proxy service.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void stopProxyService(@QueryParam(value="id") @ApiParam(value="Service ID", required=true) String string) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            administrator.d(string, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/proxy")
    @ApiOperation(value="Delete proxy service", notes="Deletes a proxy service.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void removeProxyService(@QueryParam(value="id") @ApiParam(value="Service ID", required=true) String string) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            administrator.e(string, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/proxy/ftp/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get FTP service configuration", notes="Obtains a FTP service configuration.", response=FtpServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public FtpServiceConfiguration ftpProxyServiceConfiguration() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.i(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy/ftp/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update FTP service configuration", notes="Updates a FTP service configuration.", response=FtpServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public FtpServiceConfiguration updateFtpProxyServiceConfiguration(@ApiParam(value="Configuration", required=true) FtpServiceConfiguration ftpServiceConfiguration) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(ftpServiceConfiguration, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/proxy/raw/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get raw service configuration", notes="Obtains a raw service configuration.", response=RawServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public RawServiceConfiguration rawProxyServiceConfiguration() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.j(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy/raw/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update raw service configuration", notes="Updates a raw service configuration.", response=RawServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public RawServiceConfiguration updateRawProxyServiceConfiguration(@ApiParam(value="Configuration", required=true) RawServiceConfiguration rawServiceConfiguration) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(rawServiceConfiguration, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/proxy/http/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get HTTP service configuration", notes="Obtains an HTTP service configuration.", response=HttpServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public HttpServiceConfiguration httpProxyServiceConfiguration() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.k(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy/http/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update HTTP service configuration", notes="Updates an HTTP service configuration.", response=HttpServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public HttpServiceConfiguration updateHttpProxyServiceConfiguration(@ApiParam(value="Configuration", required=true) HttpServiceConfiguration httpServiceConfiguration) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(httpServiceConfiguration, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy/http/cache/clear")
    @ApiOperation(value="Clear HTTP service cache", notes="Clears an HTTP service cache.", response=HttpServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void clearHttpProxyServiceCache() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            administrator.l(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/clusters")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get clusters", notes="Obtains available clusters.", response=Page.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ClusterInfo[] clusters() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.m(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/clusters")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get clusters", notes="Obtains available clusters.", response=Page.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public Page<ClusterSummary> clustersFor(@ApiParam(value="Page request", required=true) PageRequest pageRequest) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(pageRequest, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/cluster")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get cluster data", notes="Obtains a cluster data.", response=ClusterData.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ClusterData clusterFor(@ApiParam(value="Name", required=true) @QueryParam(value="name") String string) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.f(string, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/cluster")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add cluster", notes="Adds a new cluster.", response=ClusterSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ClusterSummary addCluster(@ApiParam(value="Data", required=true) ClusterData clusterData) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(clusterData, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/cluster")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update cluster", notes="Updates a cluster.", response=ClusterSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ClusterSummary updateCluster(@ApiParam(value="Data", required=true) ClusterData clusterData) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.b(clusterData, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/cluster")
    @ApiOperation(value="Delete cluster", notes="Deletes a cluster.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void removeCluster(@ApiParam(value="Name", required=true) @QueryParam(value="name") String string) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            administrator.g(string, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/ip-access/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get IP access service configuration", notes="Obtains an IP access service configuration.", response=IpAccessConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public IpAccessConfiguration ipAccessConfiguration() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.n(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/ip-access/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update IP access service configuration", notes="Updates an IP access service configuration.", response=IpAccessConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public IpAccessConfiguration updateIpAccessConfiguration(@ApiParam(value="Configuration", required=true) IpAccessConfiguration ipAccessConfiguration) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(ipAccessConfiguration, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/ip-access/block-ip")
    @Produces(value={"application/json"})
    @ApiOperation(value="Block client IP", notes="Blocks client IP that corresponds to the server connection.", response=TransportAddress.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public TransportAddress blockClientIpFor(@QueryParam(value="gatewayHost") @ApiParam(value="GatewayHost", required=true) String string, @QueryParam(value="gatewayPort") @ApiParam(value="GatewayPort", required=true) int n2, @QueryParam(value="serverHost") @ApiParam(value="ServerHost", required=true) String string2, @QueryParam(value="serverPort") @ApiParam(value="ServerPort", required=true) int n3, @QueryParam(value="period") @ApiParam(value="Period", required=false) Long l10) {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            BlockIpRequest blockIpRequest = new BlockIpRequest(new TransportAddress(string, n2), new TransportAddress(string2, n3), l10);
            return administrator.a(blockIpRequest, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/log/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get log service configuration", notes="Obtains a log service configuration.", response=LogServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public LogServiceConfiguration logServiceConfiguration() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.o(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/log/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update log service configuration", notes="Updates a log service configuration.", response=LogServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public LogServiceConfiguration updateLogServiceConfiguration(@ApiParam(value="Configuration", required=true) LogServiceConfiguration logServiceConfiguration) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(logServiceConfiguration, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/log/configuration/test")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Test log service configuration", notes="Tests a log service configuration.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void testLogServiceConfiguration(@ApiParam(value="Configuration", required=true) LogServiceConfiguration logServiceConfiguration) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            administrator.b(logServiceConfiguration, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/log/repository/init")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Init log service repository", notes="Initializes a log service record repository.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void initLogServiceRepository(@ApiParam(value="Configuration", required=true) LogServiceConfiguration logServiceConfiguration) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            administrator.c(logServiceConfiguration, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/log")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get log records", notes="Obtains latest log records.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public LogRecord[] latestLogRecords(@QueryParam(value="count") @ApiParam(value="Records count", required=true) int n2) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(n2, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/monitor/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get monitor service configuration", notes="Obtains a monitor service configuration.", response=MonitorServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public MonitorServiceConfiguration monitorServiceConfiguration() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.p(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/monitor/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update monitor service configuration", notes="Updates a monitor service configuration.", response=MonitorServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public MonitorServiceConfiguration updateMonitorServiceConfiguration(@ApiParam(value="Configuration", required=true) MonitorServiceConfiguration monitorServiceConfiguration) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(monitorServiceConfiguration, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/administrators")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get administrators", notes="Obtains available administrators.", response=Page.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public Page<AdministratorSummary> administratorsFor(@ApiParam(value="Page request", required=true) PageRequest pageRequest) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.b(pageRequest, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/administrator")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get administrator data", notes="Obtains an administrator data.", response=AdministratorData.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AdministratorData administratorFor(@ApiParam(value="Username", required=true) @QueryParam(value="username") String string) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.h(string, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/administrator")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add administrator", notes="Adds a new administrator.", response=AdministratorSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AdministratorSummary addAdministrator(@ApiParam(value="Data", required=true) AdministratorData administratorData) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(administratorData, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/administrator")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update administrator", notes="Updates an administrator.", response=AdministratorSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AdministratorSummary updateAdministrator(@ApiParam(value="Data", required=true) AdministratorData administratorData) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.b(administratorData, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/administrator")
    @ApiOperation(value="Delete administrator", notes="Deletes an administrator.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void removeAdministrator(@ApiParam(value="Username", required=true) @QueryParam(value="username") String string) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            administrator.i(string, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/agents")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get agents", notes="Obtains available agents.", response=Page.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public Page<AgentSummary> agentsFor(@ApiParam(value="Page request", required=true) PageRequest pageRequest) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.c(pageRequest, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/agent")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get agent data", notes="Obtains an agent data.", response=AgentData.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AgentData agentFor(@ApiParam(value="Username", required=true) @QueryParam(value="username") String string) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.j(string, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/agent")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add agent", notes="Adds a new agent.", response=AgentSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AgentSummary addAgent(@ApiParam(value="Data", required=true) AgentData agentData) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(agentData, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/agent")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update agent", notes="Updates an agent.", response=AgentSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AgentSummary updateAgent(@ApiParam(value="Data", required=true) AgentData agentData) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.b(agentData, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/agent")
    @ApiOperation(value="Delete agent", notes="Deletes an agent.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void removeAgent(@ApiParam(value="Username", required=true) @QueryParam(value="username") String string) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            administrator.k(string, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/keys/server")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get server keys", notes="Obtains available server keys.", response=Page.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public Page<ServerKeySummary> serverKeysFor(@ApiParam(value="Page request", required=true) PageRequest pageRequest) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.d(pageRequest, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/keys/server/names")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get server key names", notes="Obtains available server key names.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public String[] serverKeyAliases() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.q(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/key/server/generate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Generate server key", notes="Generates a new server key.", response=ServerKeySummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ServerKeySummary generateServerKey(@ApiParam(value="Key data", required=true) ServerKeyGenerationData serverKeyGenerationData) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(serverKeyGenerationData, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/key/server")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @ApiOperation(value="Import server key", notes="Imports a server key.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void importServerKey(@ApiParam(value="Form", required=true) FormDataMultiPart formDataMultiPart, @ApiParam(value="Key file", required=true) @FormDataParam(value="dataFile") InputStream inputStream) throws g {
        int[] nArray = c.b();
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            String[] stringArray = a;
            String string = formDataMultiPart.getField(stringArray[7]).getValue().trim();
            String string2 = formDataMultiPart.getField(stringArray[13]).getValue();
            String string3 = formDataMultiPart.getField(stringArray[4]).getValue().trim();
            String string4 = formDataMultiPart.getField(stringArray[3]).getValue();
            ServerKeyImportData serverKeyImportData = new ServerKeyImportData(string, string2, string3, string4);
            c.SUBMIT_STATE.set(this.session, SubmitState.inProgress());
            ServerKeySummary serverKeySummary = administrator.a(serverKeyImportData, inputStream, this.gateway);
            c.SUBMIT_STATE.set(this.session, SubmitState.done(serverKeySummary));
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.session, SubmitState.error(throwable));
            throw this.wrap(throwable);
        }
        try {
            if (!cZ.b()) {
                c.b(new int[4]);
            }
        }
        catch (Throwable throwable) {
            throw ApiServer.a(throwable);
        }
    }

    @POST
    @Path(value="/key/server/certificate")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @ApiOperation(value="Import server certificate", notes="Imports a server certificate(s).")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void importServerCertificate(@ApiParam(value="Name", required=true) @QueryParam(value="name") String string, @ApiParam(value="Form", required=true) FormDataMultiPart formDataMultiPart, @ApiParam(value="Certificate file", required=true) @FormDataParam(value="dataFile") InputStream inputStream) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            String[] stringArray = a;
            String string2 = formDataMultiPart.getField(stringArray[2]).getValue();
            String string3 = formDataMultiPart.getField(stringArray[11]).getValue().trim();
            CertificateImportData certificateImportData = new CertificateImportData(string, string2, string3);
            c.SUBMIT_STATE.set(this.session, SubmitState.inProgress());
            ServerKeySummary serverKeySummary = administrator.a(certificateImportData, inputStream, this.gateway);
            c.SUBMIT_STATE.set(this.session, SubmitState.done(serverKeySummary));
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.session, SubmitState.error(throwable));
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/key/server/certificate/generate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Generate server certificate", notes="Generates a self-signed server certificate.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ServerKeySummary generateServerCertificate(@ApiParam(value="Name", required=true) @QueryParam(value="name") String string, @ApiParam(value="Certificate data", required=true) CertificateGenerationData certificateGenerationData) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(string, certificateGenerationData, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/key/server/{name}.key")
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Export server private key", notes="Exports a server private key.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public InputStream serverKeyFor(@ApiParam(value="Key name", required=true) @PathParam(value="name") String string, @ApiParam(value="File format", required=true) @QueryParam(value="format") String string2, @ApiParam(value="File password", required=true) @QueryParam(value="password") String string3) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(string, string2, string3, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/key/server/certificate/{name}.cer")
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Export server certificate", notes="Exports a server certificate.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public InputStream serverCertificateFor(@ApiParam(value="Key name", required=true) @PathParam(value="name") String string, @ApiParam(value="File format", required=true) @QueryParam(value="format") String string2) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(string, string2, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/key/server/public-key/{name}.pub")
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Export server public key", notes="Exports a server public key.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public InputStream serverPublicKeyFor(@ApiParam(value="Key name", required=true) @PathParam(value="name") String string, @ApiParam(value="File format", required=true) @QueryParam(value="format") String string2) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.b(string, string2, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/key/server/csr/{name}.csr")
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Generate CSR", notes="Generates a CSR.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public InputStream serverKeyCsrFor(@ApiParam(value="Key name", required=true) @PathParam(value="name") String string) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.l(string, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/key/server")
    @ApiOperation(value="Delete server key", notes="Deletes a server key.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void removeServerKey(@ApiParam(value="Key name", required=true) @QueryParam(value="name") String string) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            administrator.m(string, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/email/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get email service configuration", notes="Obtains an email service configuration.", response=EmailServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public EmailServiceConfiguration emailServiceConfiguration() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.r(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/email/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update email service configuration", notes="Updates an email service configuration.", response=EmailServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public EmailServiceConfiguration updateEmailServiceConfiguration(@ApiParam(value="Configuration", required=true) EmailServiceConfiguration emailServiceConfiguration) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(emailServiceConfiguration, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/email/configuration/test")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Test email service configuration", notes="Tests an email service configuration.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void testEmailServiceConfiguration(@ApiParam(value="Configuration", required=true) EmailServiceConfiguration emailServiceConfiguration, @ApiParam(value="Recipient", required=true) @QueryParam(value="recipient") String string) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            administrator.a(emailServiceConfiguration, string, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/web/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get web service configuration", notes="Obtains a web service configuration.", response=WebServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public WebServiceConfiguration webServiceConfiguration() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.s(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/web/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update web service configuration", notes="Updates a web service configuration.", response=WebServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public WebServiceConfiguration updateWebServiceConfiguration(@ApiParam(value="Configuration", required=true) WebServiceConfiguration webServiceConfiguration) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(webServiceConfiguration, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/agent/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get agent service configuration", notes="Obtains an agent service configuration.", response=AgentServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AgentServiceConfiguration agentConnectorFactoryConfiguration() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.t(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/agent/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update agent service configuration", notes="Updates an agent service configuration.", response=AgentServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AgentServiceConfiguration updateAgentConnectorFactoryConfiguration(@ApiParam(value="Configuration", required=true) AgentServiceConfiguration agentServiceConfiguration) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.a(agentServiceConfiguration, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/agent/sessions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gent agent sessions", notes="Obtains current agent sessions.", response=AgentSessionSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AgentSessionSummary[] agentSessions() throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            return administrator.u(this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/files/log")
    @Produces(value={"application/json"})
    @ApiOperation(value="List log directory", notes="Obtains available log directories.", response=FileService.Entry.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public FileService.Entry listLogDirectory(@ApiParam(value="Path", required=false) @QueryParam(value="path") String string) throws g {
        this.assertAuthenticated();
        try {
            String string2;
            Administrator administrator;
            Administrator administrator2 = this.currentAdministrator();
            try {
                administrator = administrator2;
                string2 = string != null ? string.trim() : null;
            }
            catch (Throwable throwable) {
                throw ApiServer.a(throwable);
            }
            return administrator.n(string2, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/files/log")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create log directory", notes="Creates a new log directory.", response=FileService.Entry.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public FileService.Entry createLogDirectory(@ApiParam(value="Path", required=true) @QueryParam(value="path") String string, @ApiParam(value="Name", required=true) @QueryParam(value="name") String string2) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            administrator.c(string.trim(), string2, this.gateway);
            return administrator.n(string.trim(), this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/files/cache")
    @Produces(value={"application/json"})
    @ApiOperation(value="List cache directory", notes="Obtains available cache directories.", response=FileService.Entry.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public FileService.Entry listCacheDirectory(@ApiParam(value="Path", required=false) @QueryParam(value="path") String string) throws g {
        this.assertAuthenticated();
        try {
            String string2;
            Administrator administrator;
            Administrator administrator2 = this.currentAdministrator();
            try {
                administrator = administrator2;
                string2 = string != null ? string.trim() : null;
            }
            catch (Throwable throwable) {
                throw ApiServer.a(throwable);
            }
            return administrator.o(string2, this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/files/cache")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create cache directory", notes="Creates a new cache directory.", response=FileService.Entry.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public FileService.Entry createCacheDirectory(@ApiParam(value="Path", required=true) @QueryParam(value="path") String string, @ApiParam(value="Name", required=true) @QueryParam(value="name") String string2) throws g {
        this.assertAuthenticated();
        try {
            Administrator administrator = this.currentAdministrator();
            administrator.d(string.trim(), string2, this.gateway);
            return administrator.o(string.trim(), this.gateway);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/submit/state")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get import state", notes="Obtains current operation state.", response=SubmitState.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public SubmitState submitState() throws g {
        this.assertAuthenticated();
        SubmitState submitState = (SubmitState)c.SUBMIT_STATE.of(this.session);
        try {
            if (submitState == null) {
                return SubmitState.none();
            }
        }
        catch (g g10) {
            throw ApiServer.a((Throwable)((Object)g10));
        }
        try {
            if (submitState.status == com.jscape.inet.gateway.adapter.web.protocol.messages.a.ERROR) {
                throw this.wrap((Throwable)submitState.data);
            }
        }
        catch (g g11) {
            throw ApiServer.a((Throwable)((Object)g11));
        }
        return submitState;
    }

    private void assertAuthenticated() {
        try {
            if (this.username == null) {
                throw new g(ErrorSummary.Code.NOT_AUTHENTICATED, a[14], "");
            }
        }
        catch (g g10) {
            throw ApiServer.a((Throwable)((Object)g10));
        }
    }

    private Administrator currentAdministrator() throws Exception {
        return this.gateway.j(this.username);
    }

    private void cleanupSession() {
        c.cleanup(this.session);
    }

    private g wrap(Throwable throwable) {
        this.logError(throwable);
        b.ERROR.set(this.request, throwable);
        return g.a(throwable);
    }

    private void logRequest() {
        try {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, a[8] + this.request);
            }
        }
        catch (g g10) {
            throw ApiServer.a((Throwable)((Object)g10));
        }
    }

    private void logError(Throwable throwable) {
        try {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, a[6], throwable);
            }
        }
        catch (g g10) {
            throw ApiServer.a((Throwable)((Object)g10));
        }
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[16];
                var3_1 = 0;
                var2_2 = "8t@bnOV:kHbmRP/5J-pYB:b\u0003-`]E/~_bsYW*\u001anY$aRA2xL8mS[{~_>kN\u000f{rC:eP\\?;N>aXP5oD-hO\u001b\f=rA)T]F(lB>`\u000b0~T\u001ceOF,t_(\u000b:wD-wu[\u001drA)\u0017\u0012u[-hUQ{t])v]A2tCl`]A:5\u0014\u001aKdlkLP)zY%kR\u0015>i_#v\u0012\u0005:wD-w\u0016\u0012uN#iU[<;l\u001cM\u001cG>jX)wH\u000f{$\u0011Hn\rTy\u0015\u0016]ylC]A>lL5$kP9;l\u001cM\u0006\u0015/~^8$s~u\u0016\u0014kH>eH\\4u\r\"kH\u0015:wA#sYQu\u000b:wD-wu[\u001drA)\u0017\u0012u[-hUQ{t])v]A2tCl`]A:5\f=rA)T]F(lB>`";
                var4_3 = "8t@bnOV:kHbmRP/5J-pYB:b\u0003-`]E/~_bsYW*\u001anY$aRA2xL8mS[{~_>kN\u000f{rC:eP\\?;N>aXP5oD-hO\u001b\f=rA)T]F(lB>`\u000b0~T\u001ceOF,t_(\u000b:wD-wu[\u001drA)\u0017\u0012u[-hUQ{t])v]A2tCl`]A:5\u0014\u001aKdlkLP)zY%kR\u0015>i_#v\u0012\u0005:wD-w\u0016\u0012uN#iU[<;l\u001cM\u001cG>jX)wH\u000f{$\u0011Hn\rTy\u0015\u0016]ylC]A>lL5$kP9;l\u001cM\u0006\u0015/~^8$s~u\u0016\u0014kH>eH\\4u\r\"kH\u0015:wA#sYQu\u000b:wD-wu[\u001drA)\u0017\u0012u[-hUQ{t])v]A2tCl`]A:5\f=rA)T]F(lB>`".length();
                var1_4 = 35;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 37;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0004eH}tXP\"oR)|NE>oXs\u0015\u000b\u007fH5pCP#i])|BJjoN/z_\n";
                    var4_3 = "\u0004eH}tXP\"oR)|NE>oXs\u0015\u000b\u007fH5pCP#i])|BJjoN/z_\n".length();
                    var1_4 = 18;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 52;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 126;
                            break;
                        }
                        case 1: {
                            v15 = 62;
                            break;
                        }
                        case 2: {
                            v15 = 8;
                            break;
                        }
                        case 3: {
                            v15 = 105;
                            break;
                        }
                        case 4: {
                            v15 = 33;
                            break;
                        }
                        case 5: {
                            v15 = 25;
                            break;
                        }
                        default: {
                            v15 = 16;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        ApiServer.a = var5;
    }
}

