# -*- coding: utf-8 -*-
import argparse
import os

from qiling import Qiling
from qiling.const import QL_VERBOSE

# these offsets can be found in the vulnerable function 0x2409 (`pass_phrase_to_keys`)
PBOX1_OFFSET = 0x3120
PBOX2_OFFSET = 0x3220
PBOX3_OFFSET = 0x3320
PBOX4_OFFSET = 0x3420
PBOX5_OFFSET = 0x3520
PBOX6_OFFSET = 0x3620

PBOX_LENGTH = 256

ROOTFS = '/'

if __name__ == '__main__':
    # parse cmd args
    parser = argparse.ArgumentParser()
    parser.add_argument('binary_path', type=str, help='Path to tridea binary')

    args = parser.parse_args()

    # extract the PBOXes and output to stdout
    ql = Qiling([args.binary_path], ROOTFS, verbose=QL_VERBOSE.OFF)
    base_addr = ql.mem.get_lib_base(os.path.basename(ql.path))

    print('The PBOXes:')
    for i, offset in enumerate([PBOX1_OFFSET, PBOX2_OFFSET, PBOX3_OFFSET, PBOX4_OFFSET, PBOX5_OFFSET, PBOX6_OFFSET]):
        pbox = list(ql.mem.read(base_addr + offset, PBOX_LENGTH))
        print('const uint8_t PBOX{0}[] = {{{1}}};\n'.format(i + 1, ', '.join(map(str, pbox))))

    pass
