<?php

/*----- Activate Slightly Modified Options Framework -----*/



require_once('admin/index.php');



// Register Custom Navigation Walker

require_once('wp_bootstrap_navwalker.php');

include_once ("functions/update.php");

register_nav_menus( array(

    'primary' => __( 'Primary Menu', 'wpsocialbizfullblown'),

));

register_nav_menus( array(

    'footer' => __( 'Footer Menu', 'wpsocialbizfullblown'),

));


/*----- Translation -----*/

load_theme_textdomain('oft_theme', TEMPLATEPATH.'/inc/lang');



/*----- shortcodes -----*/

include_once(get_template_directory() .'/functions/symple-shortcodes/symple-shortcodes.php');

include_once(get_template_directory() .'/inc/appointments/appointments.php');

include_once(get_template_directory() .'/inc/practice-areas/practice-areas_post_type.php');





/*----- http://wp.tutsplus.com/tutorials/theme-deveopment/create-a-quicksand-portfolio-with-wordpress/ -----*/

/*----- Add Portfolio Custom Post Type -----*/





/*----- Enqueue Jquery -----*/



function custom_function() 

{

wp_deregister_script('jquery'); 

wp_register_script('jquery','http://ajax.googleapis.com/ajax/libs/jquery/1.8.2/jquery.min.js');

wp_enqueue_script('jquery');



/*----- Enqueue Jquery for bxslider-----*/



wp_register_script('slider', get_template_directory_uri() . '/js/jquery.bxslider.min.js', array('jquery'), '1.0');

wp_enqueue_script('slider');



/*----- Enqueue Jquery for custom-----*/

wp_register_script('customfiles', get_template_directory_uri() . '/js/customjavascriptfile.js', array('jquery'), '1.0');

wp_enqueue_script('customfiles');



/*----- Enqueue Jquery for Navigation-----*/



wp_enqueue_script( 'twentytwelve-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '1.0', true );



} 

add_action('wp_enqueue_scripts', 'custom_function');



/*----- Enqueue Jquery for Waypoint-----*/



function main_scripts ()

{   wp_deregister_script( 'main');

    wp_register_script( 'main', get_template_directory_uri().'/js/main.js','jquery','1.0',true); 

	wp_enqueue_script( 'main' );

	

	wp_register_script('bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'), '1.0',true);

 wp_enqueue_script('bootstrap');

 
 
   wp_register_script('waypoints', get_template_directory_uri() . '/js/waypoints.min.js', array('jquery'), '1.0',true);

 wp_enqueue_script('waypoints');
 
   wp_register_script('easypiechart', get_template_directory_uri() . '/js/jquery.easypiechart.min.js', array('jquery'), '1.0',true);

 wp_enqueue_script('easypiechart');

 wp_register_script('custom', get_template_directory_uri() . '/js/custom.js', array('jquery'), '1.0',true);

 wp_enqueue_script('custom');

	

	wp_register_script('carousel', get_template_directory_uri() . '/js/owl.carousel.js', array('jquery'), '1.0',true);

 wp_enqueue_script('carousel');

 

  wp_register_script('slider', get_template_directory_uri() . '/js/jquery.flexslider-min.js', array('jquery'), '1.0',false );

wp_enqueue_script('slider');





 wp_register_script('custom1', get_template_directory_uri() . '/js/custom1.js', array('jquery'), '1.0',true);

 wp_enqueue_script('custom1');


 wp_register_script('validate', get_template_directory_uri() . '/js/jquery.validate.min.js', array('jquery'), '1.0',true);

 wp_enqueue_script('validate');
 

wp_register_script('multi_step_form', get_template_directory_uri() . '/js/multi_step_form.js', array('jquery'), '1.0',true);

 wp_enqueue_script('multi_step_form');
 wp_register_script( 'blockUI', get_template_directory_uri().'/js/jquery.blockUI.js','jquery','1.0',true); 

	wp_enqueue_script( 'blockUI' );
	

/*----- Enqueue Jquery for  Flexslider-----*/

wp_register_script('modernizr', get_template_directory_uri() . '/js1/modernizr.js', array('jquery'), '1.0',false );

wp_enqueue_script('modernizr');

wp_register_script('flex_slider', get_template_directory_uri() . '/js1/jquery.flexslider.js', array('jquery'), '1.0',false );

wp_enqueue_script('flex_slider');

wp_register_script('flex', get_template_directory_uri() . '/js1/flex.js', array('jquery'), '1.0',false );

wp_enqueue_script('flex');


/*----- Enqueue Jquery for  Pop up box-----*/


wp_register_script('popup', get_template_directory_uri() . '/js1/popup.js', array('jquery'), '1.0',false );

wp_enqueue_script('popup');




	}



add_action('wp_enqueue_scripts', 'main_scripts');







function register_js() 

{

wp_register_script('quicksand', get_template_directory_uri() . '/js/jquery.quicksand.js', 'jquery','1.0',true);

wp_enqueue_script('quicksand');

wp_register_script('easing', get_template_directory_uri() . '/js/jquery.easing.1.3.js', 'jquery','1.0',true);

wp_enqueue_script('easing');

wp_deregister_script( 'custom');

wp_register_script('custom', get_template_directory_uri() . '/js/jquery.custom.js', 'jquery', '1.0',true);

wp_enqueue_script('custom');

/*wp_register_script('prettyPhoto', get_template_directory_uri() . '/js/jquery.prettyPhoto.js','jquery','1.0',true);

wp_enqueue_script('prettyPhoto');				
*/
}

add_action('wp_enqueue_scripts', 'register_js');



function register_styles()

	{

		global $wp_styles;		

		wp_register_style('prettyPhoto', get_template_directory_uri() .	'/inc/portfolio/portfolio.css');

		wp_enqueue_style( 'prettyPhoto');

		

	}

add_action('init', 'register_styles');







/*----- Register Sidebars -----*/



if ( function_exists('register_sidebar') )

register_sidebar(array('name'=>'sidebar',

'id'=> 'main-sidebar',

'description'=>'Sidebar Area',

'before_widget' => '',

'after_widget' => '',

'before_title' => '<h3>',

'after_title' => '</h3>',

));





/*----- http://codex.wordpress.org/Function_Reference/add_theme_support -----*/



/*----- Add theme support for thumbnails and post formats -----*/

add_theme_support( 'automatic-feed-links' );



add_theme_support( 'post-thumbnails' );

set_post_thumbnail_size(1000,1000,true);

add_image_size( 'aboutfull-thumb', 990, 256,true );

add_image_size( 'bloginnerfull-thumb', 980, 256,true);

add_image_size( 'blog-thumb', 900, 256,true);

add_image_size( 'blogfull-thumb', 900, 256,true);

add_image_size( 'blogmain-thumb', 600, 256,true);

add_image_size( 'bloginner-thumb', 622, 256,true);

add_image_size( 'portfoliofull-thumb', 980, 256,true);

add_image_size( 'portfolio-thumb', 296, 160,true);

add_image_size( 'bloghome-thumb', 296, 160,true);

add_image_size( 'review-thumb', 296, 160,true);

add_image_size( 'thumbnail', 300, 300,true);



if ( ! isset( $content_width ) )

	$content_width = 600;





/*----- Custom Function for Displaying Comments -----*/



function oft_comments($comment, $args, $depth) {

$GLOBALS['comment'] = $comment;



if (get_comment_type() == 'pingback' || get_comment_type() == 'trackback') : ?>

	<li class="pingback" id="comment-<?php comment_ID(); ?>">

		<article <?php comment_class('clearfix'); ?>>		

			<header>			

				<h4><?php _e('Pingback:', 'oft_theme'); ?></h4>

				<p><?php edit_comment_link(); ?></p>				

			</header>

			<?php comment_author_link(); ?>							

		</article>	

<?php endif; ?>

	

<?php if (get_comment_type() == 'comment') : ?>

	<li id="comment-<?php comment_ID(); ?>">

		<article <?php comment_class('clearfix'); ?>>		

			<header>			

				<h4><span><?php _e('AUTHOR', 'oft_theme'); ?></span><?php comment_author_link(); ?></h4>

				<p><span>on <?php comment_date(); ?> at <?php comment_time(); ?> - </span><?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); ?></p>				

			</header>

			<figure class="comment-avatar">

				<?php 

					$avatar_size = 80;

					if ($comment->comment_parent != 0) {

						$avatar_size = 48;

					}					

					echo get_avatar($comment, $avatar_size);

				?>

			</figure>			

			<?php if ($comment->comment_approved == '0') : ?>			

				<p class="awaiting-moderation"><?php _e('Your comment is awaiting moderation.', 'oft_theme'); ?></p>				

			<?php endif; ?>

			<?php echo $comment->comment_content; ?>							

		</article>		

<?php endif;	

}



/*----- Custom Comment Form -----*/



function oft_custom_comment_form($defaults) {

	$comment_notes_after = '' .

	$defaults['comment_notes_before'] = '';

	$defaults['comment_notes_after'] = $comment_notes_after;

	$defaults['id_form'] = 'comment-form';

	$defaults['comment_field'] = '<p><textarea name="comment" id="comment" cols="30" rows="10"></textarea></p>';

	return $defaults;

}



add_filter('comment_form_defaults', 'oft_custom_comment_form');



function oft_custom_comment_fields() {

	$commenter = wp_get_current_commenter();

	$req = get_option('require_name_email');

	$aria_req = ($req ? " aria-required='true'" : '');

	

	$fields = array(

		'author' => '<p>' . 

						'<input id="author" name="author" type="text" value="' . esc_attr($commenter['comment_author']) . '" ' . $aria_req . ' />' .

						'<label for="author">' . __('Name', 'oft_theme') . '' . ($req ? __(' (required)', 'oft_theme') : '') . '</label>' .

		            '</p>',

		'email' => '<p>' . 

						'<input id="email" name="email" type="text" value="' . esc_attr($commenter['comment_author_email']) . '" ' . $aria_req . ' />' .

						'<label for="email">' . __('Email', 'oft_theme') . '' . ($req ? __(' (required)', 'oft_theme') : '') . '</label>' .

		            '</p>',

		'url' => '<p>' . 

						'<input id="url" name="url" type="text" value="' . esc_attr($commenter['comment_author_url']) . '" />' .

						'<label for="url">' . __('Website', 'oft_theme') . '</label>' .

		            '</p>'

	);



	return $fields;

}



add_filter('comment_form_default_fields', 'oft_custom_comment_fields');





if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )

		wp_enqueue_script( 'comment-reply' );



/*----- http://design.sparklette.net/teaches/how-to-add-wordpress-pagination-without-a-plugin/  -----*/



function pagination($pages = '', $range = 4)

{  

     $showitems = ($range * 2)+1;  

 

     global $paged;

     if(empty($paged)) $paged = 1;

 

     if($pages == '')

     {

         global $wp_query;

         $pages = $wp_query->max_num_pages;

         if(!$pages)

         {

             $pages = 1;

         }

     }  

	  

     if(1 != $pages)

     {

         echo "<div class=\"pagination\"><ul>";

         if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<li><a href='".get_pagenum_link(1)."'>&laquo; First</a></li>";

         if($paged > 1 && $showitems < $pages) echo "<li><a href='".get_pagenum_link($paged - 1)."'>&lsaquo; Previous</a></li>";

 

         for ($i=1; $i <= $pages; $i++)

         {

             if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))

             {

                 echo ($paged == $i)? "<li><a class=\"current\">".$i."</a></li>":"<li><a href='".get_pagenum_link($i)."' class=\"inactive\">".$i."</a></li>";

             }

         }

          if ($paged < $pages && $showitems < $pages) echo "<li><a href=\"".get_pagenum_link($paged + 1)."\">Next &rsaquo;</a></li>";  

         if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<li><a href='".get_pagenum_link($pages)."'>Last &raquo;</a><li>";

         echo "</ul></div>\n";

     }



}

/*----- Pagination Ends here -----*/



function new_excerpt_more( $more ) {

	return '<p class="Align_right"><a class="read-more" href="'. get_permalink( get_the_ID() ) . '">Read More +</a>';

}

add_filter( 'excerpt_more', 'new_excerpt_more' );



function custom_excerpt_length( $length ) {

	return 20;

}

add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );



/** Add fontawesome*/

add_action( 'wp_enqueue_scripts', 'load_fontawesome_style', 999 );

function load_fontawesome_style() {

      wp_register_style( 'font-awesome', 'http://netdna.bootstrapcdn.com/font-awesome/3.2.1/css/font-awesome.css' );

      wp_enqueue_style( 'font-awesome' );

}





/*----- Breadcrumbs -----*/

function get_breadcrumbs()	{

	$delimiter = ' » ';

	$name = __("Home",'oft_theme');

	$currentBefore = ' <span class="current">';

	$currentAfter = '</span> ';

	$type=get_post_type();

	if (!is_home() && !is_front_page() && get_post_type() == $type || is_paged()) {



		echo '<nav id="breadcrumbs">';

		global $post;

		$home = get_bloginfo('url');

		echo '<a href="' . $home . '">' . $name . '</a> ' . $delimiter . '';

		

		

		 if (is_single() && get_post_type() == 'cptreviews' ){

			$cat = get_the_category();

			

			$cat = $cat[0];

			if ($cat !==NULL) {

				echo get_category_parents($cat, true, ' ' . $delimiter . '');

			}

			echo $currentBefore;

			echo 'Review »';

			echo $currentAfter;

		} 

		

		if (is_single() && get_post_type() == 'portfolio' ){

			$cat = get_the_category();

			

			$cat = $cat[0];

			if ($cat !==NULL) {

				echo get_category_parents($cat, true, ' ' . $delimiter . '');

			}

			echo $currentBefore;

			echo 'Portfolio »';

			echo $currentAfter;

		} 

		

		if (is_category()) {

			global $wp_query;

			$cat_obj = $wp_query->get_queried_object();

			$thisCat = $cat_obj->term_id;

			$thisCat = get_category($thisCat);

			$parentCat = get_category($thisCat->parent);

			if ($thisCat->parent != 0) {

				echo(get_category_parents($parentCat, true, '' . $delimiter . ''));

			}

			echo $currentBefore . single_cat_title() . $currentAfter;

		}

		else if (is_day()) {

			echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . '';

			echo '<a href="' . get_month_link(get_the_time('Y'), get_the_time('m')) . '">' . get_the_time('F') . '</a> ' . $delimiter . ' ';

			echo $currentBefore . get_the_time('d') . $currentAfter;

		} else if (is_month()) {

			echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . '';

			echo $currentBefore . get_the_time('F') . $currentAfter;

		} else if (is_year()) {

			echo $currentBefore . get_the_time('Y') . $currentAfter;

		} else if (is_attachment()) {

			echo $currentBefore;

			the_title();

			$currentAfter;

		} if (is_single() && get_post_type() == $type ){

			$cat = get_the_category();

			$cat = $cat[0];

			if ($cat !==NULL) {

				echo get_category_parents($cat, true, ' ' . $delimiter . '');

			}

			echo $currentBefore;

			the_title();

			echo $currentAfter;

		} else if (is_page() && !$post->post_parent) {

			echo $currentBefore;

			the_title();

			echo $currentAfter;

		} else if (is_page() && $post->post_parent) {

			$parent_id = $post->post_parent;

			$breadcrumbs = array();

			while ($parent_id) {

				$page = get_page($parent_id);

				$breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';

				$parent_id = $page->post_parent;

			}

			$breadcrumbs = array_reverse($breadcrumbs);

			foreach($breadcrumbs as $crumb)

			echo $crumb . ' ' . $delimiter . ' ';

			echo $currentBefore;

			the_title();

			echo $currentAfter;

		} else if (is_search()) {

			echo $currentBefore . __('Search Results For:','oft_theme') . ' ' . get_search_query() . $currentAfter;

		} else if (is_tag()) {

			echo $currentBefore . single_tag_title() . $currentAfter;

		} else if (is_author()) {

			global $author;

			$userdata = get_userdata($author);

			echo $currentBefore . $userdata->display_name . $currentAfter;

		} else if (is_404()) {

			echo $currentBefore . '404 Not Found' . $currentAfter;

		}

		if (get_query_var('paged')) {

			if (is_home() || is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author()) {

				echo  $currentBefore;

			}

			echo __('Page','oft_theme') . ' ' . get_query_var('paged');

			if (is_home() || is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author()) {

				echo $currentAfter;

		}

	}

		echo '</nav>';

} }



remove_filter( 'the_content', 'wpautop' );

add_filter( 'the_content', 'wpautop' , 12);






