<?php

add_action('init','of_options');

if (!function_exists('of_options'))
{
	function of_options()
	{
		//Access the WordPress Categories via an Array
		$of_categories 		= array();  
		$of_categories_obj 	= get_categories('hide_empty=0');
		foreach ($of_categories_obj as $of_cat) {
		    $of_categories[$of_cat->cat_ID] = $of_cat->cat_name;}
		$categories_tmp 	= array_unshift($of_categories, "Select a category:");    
	       
		//Access the WordPress Pages via an Array
		$of_pages 			= array();
		$of_pages_obj 		= get_pages('sort_column=post_parent,menu_order');    
		foreach ($of_pages_obj as $of_page) {
		    $of_pages[$of_page->ID] = $of_page->post_name; }
		$of_pages_tmp 		= array_unshift($of_pages, "Select a page:");       
	
		//Testing 
		$of_options_select 	= array("one","two","three","four","five"); 
		$of_options_radio 	= array("one" => "One","two" => "Two","three" => "Three","four" => "Four","five" => "Five");
		
		//Sample Homepage blocks for the layout manager (sorter)
		$of_options_homepage_blocks = array
		( 
			"disabled" => array (
				"placebo" 		=> "placebo", //REQUIRED!
				"block_one"		=> "Block One",
				"block_two"		=> "Block Two",
				"block_three"	=> "Block Three",
			), 
			"enabled" => array (
				"placebo" 		=> "placebo", //REQUIRED!
				"block_four"	=> "Block Four",
			),
		);
		
		$of_options_mobile_blocks = array( 
			"disabled" 			=> array(
			"placebo"   		=> "placebo", //REQUIRED!
			"call_button"		=> "Call Button",
			"social_profiles"	=> "Social Profiles",
			"leadform"			=> "Lead Form",
			"video"				=> "Video",
			"search_form"		=> "Search Form",
			"aweber_optinform"  => "aweber optinform"
			), 
			"enabled" 		=> array(
			"placebo"   		=> "placebo", //REQUIRED!
			"menus" 			=> "Menus"
			),
);
		
		//Stylesheets Reader
		$alt_stylesheet_path = LAYOUT_PATH;
		$alt_stylesheets = array();
		
		if ( is_dir($alt_stylesheet_path) ) 
		{
		    if ($alt_stylesheet_dir = opendir($alt_stylesheet_path) ) 
		    { 
		        while ( ($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false ) 
		        {
		            if(stristr($alt_stylesheet_file, ".css") !== false)
		            {
		                $alt_stylesheets[] = $alt_stylesheet_file;
		            }
		        }    
		    }
		}


		//Background Images Reader
		$bg_images_path = get_stylesheet_directory(). '/images/bg/'; // change this to where you store your bg images
		$bg_images_url = get_template_directory_uri().'/images/bg/'; // change this to where you store your bg images
		$bg_images = array();
		
		if ( is_dir($bg_images_path) ) {
		    if ($bg_images_dir = opendir($bg_images_path) ) { 
		        while ( ($bg_images_file = readdir($bg_images_dir)) !== false ) {
		            if(stristr($bg_images_file, ".png") !== false || stristr($bg_images_file, ".jpg") !== false) {
		                $bg_images[] = $bg_images_url . $bg_images_file;
		            }
		        }    
		    }
		}
		

		/*-----------------------------------------------------------------------------------*/
		/* TO DO: Add options/functions that use these */
		/*-----------------------------------------------------------------------------------*/
		
		//More Options
		$uploads_arr 		= wp_upload_dir();
		$all_uploads_path 	= $uploads_arr['path'];
		$all_uploads 		= get_option('of_uploads');
		$other_entries 		= array("Select a number:","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19");
		$body_repeat 		= array("no-repeat","repeat-x","repeat-y","repeat");
		$body_pos 			= array("top left","top center","top right","center left","center center","center right","bottom left","bottom center","bottom right");
		
		// Image Alignment radio box
		$of_options_thumb_align = array("alignleft" => "Left","alignright" => "Right","aligncenter" => "Center"); 
		
		// Image Links to Options
		$of_options_image_link_to = array("image" => "The Image","post" => "The Post"); 
		
		$font_sizes = array(
			'10' => '10',
			'11' => '11',
			'12' => '12',
			'13' => '13',
			'14' => '14',
			'15' => '15',
			'16' => '16',
			'17' => '17',
			'18' => '18',
			'19' => '19',
			'20' => '20',
			'21' => '21',
			'22' => '22',
			'23' => '23',
			'24' => '24',
			'25' => '25',
			'26' => '26',
			'27' => '27',
			'28' => '28',
			'29' => '29',
			'30' => '30',
			'31' => '31',
			'32' => '32',
			'33' => '33',
			'34' => '34',
			'35' => '35',
			'36' => '36',
			'37' => '37',
			'38' => '38',
			'39' => '39',
			'40' => '40',
			'41' => '41',
			'42' => '42',
		);
       
	  $font_weight = array(	   
	   '100'=>'100',
	   '200'=>'200',
	   '300'=>'300',
	   '400'=>'400',
	   '500'=>'500',
	   '600'=>'600',
	   '700'=>'700',
	   '800'=>'800',
	   '900'=>'900',
	   'normal'=>'normal',
	   'bold'=>'bold',
	   'bolder'=>'bolder',
	   'lighter'=>'lighter',
	   'inherit'=>'inherit',
	  );

	      $google_fonts = array(
            "0" => "Select Font",
            "ABeeZee" => "ABeeZee",
            "Abel" => "Abel",
            "Abril Fatface" => "Abril Fatface",
            "Aclonica" => "Aclonica",
            "Acme" => "Acme",
            "Actor" => "Actor",
            "Adamina" => "Adamina",
            "Advent Pro" => "Advent Pro",
            "Aguafina Script" => "Aguafina Script",
            "Akronim" => "Akronim",
            "Aladin" => "Aladin",
            "Aldrich" => "Aldrich",
            "Alef" => "Alef",
            "Alegreya" => "Alegreya",
            "Alegreya SC" => "Alegreya SC",
            "Alex Brush" => "Alex Brush",
            "Alfa Slab One" => "Alfa Slab One",
            "Alice" => "Alice",
            "Alike" => "Alike",
            "Alike Angular" => "Alike Angular",
            "Allan" => "Allan",
            "Allerta" => "Allerta",
            "Allerta Stencil" => "Allerta Stencil",
            "Allura" => "Allura",
            "Almendra" => "Almendra",
            "Almendra Display" => "Almendra Display",
            "Almendra SC" => "Almendra SC",
            "Amarante" => "Amarante",
            "Amaranth" => "Amaranth",
            "Amatic SC" => "Amatic SC",
            "Amethysta" => "Amethysta",
            "Anaheim" => "Anaheim",
            "Andada" => "Andada",
            "Andika" => "Andika",
            "Angkor" => "Angkor",
            "Annie Use Your Telescope" => "Annie Use Your Telescope",
            "Anonymous Pro" => "Anonymous Pro",
            "Antic" => "Antic",
            "Antic Didone" => "Antic Didone",
            "Antic Slab" => "Antic Slab",
            "Anton" => "Anton",
            "Arapey" => "Arapey",
            "Arbutus" => "Arbutus",
            "Arbutus Slab" => "Arbutus Slab",
            "Architects Daughter" => "Architects Daughter",
            "Archivo Black" => "Archivo Black",
            "Archivo Narrow" => "Archivo Narrow",
            "Arimo" => "Arimo",
            "Arizonia" => "Arizonia",
            "Armata" => "Armata",
            "Artifika" => "Artifika",
            "Arvo" => "Arvo",
            "Asap" => "Asap",
            "Asset" => "Asset",
            "Astloch" => "Astloch",
            "Asul" => "Asul",
            "Atomic Age" => "Atomic Age",
            "Aubrey" => "Aubrey",
            "Audiowide" => "Audiowide",
            "Autour One" => "Autour One",
            "Average" => "Average",
            "Average Sans" => "Average Sans",
            "Averia Gruesa Libre" => "Averia Gruesa Libre",
            "Averia Libre" => "Averia Libre",
            "Averia Sans Libre" => "Averia Sans Libre",
            "Averia Serif Libre" => "Averia Serif Libre",
            "Bad Script" => "Bad Script",
            "Balthazar" => "Balthazar",
            "Bangers" => "Bangers",
            "Basic" => "Basic",
            "Battambang" => "Battambang",
            "Baumans" => "Baumans",
            "Bayon" => "Bayon",
            "Belgrano" => "Belgrano",
            "Belleza" => "Belleza",
            "BenchNine" => "BenchNine",
            "Bentham" => "Bentham",
            "Berkshire Swash" => "Berkshire Swash",
            "Bevan" => "Bevan",
            "Bigelow Rules" => "Bigelow Rules",
            "Bigshot One" => "Bigshot One",
            "Bilbo" => "Bilbo",
            "Bilbo Swash Caps" => "Bilbo Swash Caps",
            "Bitter" => "Bitter",
            "Black Ops One" => "Black Ops One",
            "Bokor" => "Bokor",
            "Bonbon" => "Bonbon",
            "Boogaloo" => "Boogaloo",
            "Bowlby One" => "Bowlby One",
            "Bowlby One SC" => "Bowlby One SC",
            "Brawler" => "Brawler",
            "Bree Serif" => "Bree Serif",
            "Bubblegum Sans" => "Bubblegum Sans",
            "Bubbler One" => "Bubbler One",
            "Buda" => "Buda",
            "Buenard" => "Buenard",
            "Butcherman" => "Butcherman",
            "Butterfly Kids" => "Butterfly Kids",
            "Cabin" => "Cabin",
            "Cabin Condensed" => "Cabin Condensed",
            "Cabin Sketch" => "Cabin Sketch",
            "Caesar Dressing" => "Caesar Dressing",
            "Cagliostro" => "Cagliostro",
            "Calligraffitti" => "Calligraffitti",
            "Cambo" => "Cambo",
            "Candal" => "Candal",
            "Cantarell" => "Cantarell",
            "Cantata One" => "Cantata One",
            "Cantora One" => "Cantora One",
            "Capriola" => "Capriola",
            "Cardo" => "Cardo",
            "Carme" => "Carme",
            "Carrois Gothic" => "Carrois Gothic",
            "Carrois Gothic SC" => "Carrois Gothic SC",
            "Carter One" => "Carter One",
            "Caudex" => "Caudex",
            "Cedarville Cursive" => "Cedarville Cursive",
            "Ceviche One" => "Ceviche One",
            "Changa One" => "Changa One",
            "Chango" => "Chango",
            "Chau Philomene One" => "Chau Philomene One",
            "Chela One" => "Chela One",
            "Chelsea Market" => "Chelsea Market",
            "Chenla" => "Chenla",
            "Cherry Cream Soda" => "Cherry Cream Soda",
            "Cherry Swash" => "Cherry Swash",
            "Chewy" => "Chewy",
            "Chicle" => "Chicle",
            "Chivo" => "Chivo",
            "Cinzel" => "Cinzel",
            "Cinzel Decorative" => "Cinzel Decorative",
            "Clicker Script" => "Clicker Script",
            "Coda" => "Coda",
            "Coda Caption" => "Coda Caption",
            "Codystar" => "Codystar",
            "Combo" => "Combo",
            "Comfortaa" => "Comfortaa",
            "Coming Soon" => "Coming Soon",
            "Concert One" => "Concert One",
            "Condiment" => "Condiment",
            "Content" => "Content",
            "Contrail One" => "Contrail One",
            "Convergence" => "Convergence",
            "Cookie" => "Cookie",
            "Copse" => "Copse",
            "Corben" => "Corben",
            "Courgette" => "Courgette",
            "Cousine" => "Cousine",
            "Coustard" => "Coustard",
            "Covered By Your Grace" => "Covered By Your Grace",
            "Crafty Girls" => "Crafty Girls",
            "Creepster" => "Creepster",
            "Crete Round" => "Crete Round",
            "Crimson Text" => "Crimson Text",
            "Croissant One" => "Croissant One",
            "Crushed" => "Crushed",
            "Cuprum" => "Cuprum",
            "Cutive" => "Cutive",
            "Cutive Mono" => "Cutive Mono",
            "Damion" => "Damion",
            "Dancing Script" => "Dancing Script",
            "Dangrek" => "Dangrek",
            "Dawning of a New Day" => "Dawning of a New Day",
            "Days One" => "Days One",
            "Delius" => "Delius",
            "Delius Swash Caps" => "Delius Swash Caps",
            "Delius Unicase" => "Delius Unicase",
            "Della Respira" => "Della Respira",
            "Denk One" => "Denk One",
            "Devonshire" => "Devonshire",
            "Didact Gothic" => "Didact Gothic",
            "Diplomata" => "Diplomata",
            "Diplomata SC" => "Diplomata SC",
            "Domine" => "Domine",
            "Donegal One" => "Donegal One",
            "Doppio One" => "Doppio One",
            "Dorsa" => "Dorsa",
            "Dosis" => "Dosis",
            "Dr Sugiyama" => "Dr Sugiyama",
            "Droid Sans" => "Droid Sans",
            "Droid Sans Mono" => "Droid Sans Mono",
            "Droid Serif" => "Droid Serif",
            "Duru Sans" => "Duru Sans",
            "Dynalight" => "Dynalight",
            "EB Garamond" => "EB Garamond",
            "Eagle Lake" => "Eagle Lake",
            "Eater" => "Eater",
            "Economica" => "Economica",
            "Electrolize" => "Electrolize",
            "Elsie" => "Elsie",
            "Elsie Swash Caps" => "Elsie Swash Caps",
            "Emblema One" => "Emblema One",
            "Emilys Candy" => "Emilys Candy",
            "Engagement" => "Engagement",
            "Englebert" => "Englebert",
            "Enriqueta" => "Enriqueta",
            "Erica One" => "Erica One",
            "Esteban" => "Esteban",
            "Euphoria Script" => "Euphoria Script",
            "Ewert" => "Ewert",
            "Exo" => "Exo",
            "Expletus Sans" => "Expletus Sans",
            "Fanwood Text" => "Fanwood Text",
            "Fascinate" => "Fascinate",
            "Fascinate Inline" => "Fascinate Inline",
            "Faster One" => "Faster One",
            "Fasthand" => "Fasthand",
            "Fauna One" => "Fauna One",
            "Federant" => "Federant",
            "Federo" => "Federo",
            "Felipa" => "Felipa",
            "Fenix" => "Fenix",
            "Finger Paint" => "Finger Paint",
            "Fjalla One" => "Fjalla One",
            "Fjord One" => "Fjord One",
            "Flamenco" => "Flamenco",
            "Flavors" => "Flavors",
            "Fondamento" => "Fondamento",
            "Fontdiner Swanky" => "Fontdiner Swanky",
            "Forum" => "Forum",
            "Francois One" => "Francois One",
            "Freckle Face" => "Freckle Face",
            "Fredericka the Great" => "Fredericka the Great",
            "Fredoka One" => "Fredoka One",
            "Freehand" => "Freehand",
            "Fresca" => "Fresca",
            "Frijole" => "Frijole",
            "Fruktur" => "Fruktur",
            "Fugaz One" => "Fugaz One",
            "GFS Didot" => "GFS Didot",
            "GFS Neohellenic" => "GFS Neohellenic",
            "Gabriela" => "Gabriela",
            "Gafata" => "Gafata",
            "Galdeano" => "Galdeano",
            "Galindo" => "Galindo",
            "Gentium Basic" => "Gentium Basic",
            "Gentium Book Basic" => "Gentium Book Basic",
            "Geo" => "Geo",
            "Geostar" => "Geostar",
            "Geostar Fill" => "Geostar Fill",
            "Germania One" => "Germania One",
            "Gilda Display" => "Gilda Display",
            "Give You Glory" => "Give You Glory",
            "Glass Antiqua" => "Glass Antiqua",
            "Glegoo" => "Glegoo",
            "Gloria Hallelujah" => "Gloria Hallelujah",
            "Goblin One" => "Goblin One",
            "Gochi Hand" => "Gochi Hand",
            "Gorditas" => "Gorditas",
            "Goudy Bookletter 1911" => "Goudy Bookletter 1911",
            "Graduate" => "Graduate",
            "Grand Hotel" => "Grand Hotel",
            "Gravitas One" => "Gravitas One",
            "Great Vibes" => "Great Vibes",
            "Griffy" => "Griffy",
            "Gruppo" => "Gruppo",
            "Gudea" => "Gudea",
			"HelveticaLTStdLight" => "HelveticaLTStdLight",
            "Habibi" => "Habibi",
            "Hammersmith One" => "Hammersmith One",
            "Hanalei" => "Hanalei",
            "Hanalei Fill" => "Hanalei Fill",
            "Handlee" => "Handlee",
            "Hanuman" => "Hanuman",
            "Happy Monkey" => "Happy Monkey",
            "Headland One" => "Headland One",
            "Henny Penny" => "Henny Penny",
            "Herr Von Muellerhoff" => "Herr Von Muellerhoff",
            "Holtwood One SC" => "Holtwood One SC",
            "Homemade Apple" => "Homemade Apple",
            "Homenaje" => "Homenaje",
            "IM Fell DW Pica" => "IM Fell DW Pica",
            "IM Fell DW Pica SC" => "IM Fell DW Pica SC",
            "IM Fell Double Pica" => "IM Fell Double Pica",
            "IM Fell Double Pica SC" => "IM Fell Double Pica SC",
            "IM Fell English" => "IM Fell English",
            "IM Fell English SC" => "IM Fell English SC",
            "IM Fell French Canon" => "IM Fell French Canon",
            "IM Fell French Canon SC" => "IM Fell French Canon SC",
            "IM Fell Great Primer" => "IM Fell Great Primer",
            "IM Fell Great Primer SC" => "IM Fell Great Primer SC",
            "Iceberg" => "Iceberg",
            "Iceland" => "Iceland",
            "Imprima" => "Imprima",
            "Inconsolata" => "Inconsolata",
            "Inder" => "Inder",
            "Indie Flower" => "Indie Flower",
            "Inika" => "Inika",
            "Irish Grover" => "Irish Grover",
            "Istok Web" => "Istok Web",
            "Italiana" => "Italiana",
            "Italianno" => "Italianno",
            "Jacques Francois" => "Jacques Francois",
            "Jacques Francois Shadow" => "Jacques Francois Shadow",
            "Jim Nightshade" => "Jim Nightshade",
            "Jockey One" => "Jockey One",
            "Jolly Lodger" => "Jolly Lodger",
            "Josefin Sans" => "Josefin Sans",
            "Josefin Slab" => "Josefin Slab",
            "Joti One" => "Joti One",
            "Judson" => "Judson",
            "Julee" => "Julee",
            "Julius Sans One" => "Julius Sans One",
            "Junge" => "Junge",
            "Jura" => "Jura",
            "Just Another Hand" => "Just Another Hand",
            "Just Me Again Down Here" => "Just Me Again Down Here",
            "Kameron" => "Kameron",
            "Karla" => "Karla",
            "Kaushan Script" => "Kaushan Script",
            "Kavoon" => "Kavoon",
            "Keania One" => "Keania One",
            "Kelly Slab" => "Kelly Slab",
            "Kenia" => "Kenia",
            "Khmer" => "Khmer",
            "Kite One" => "Kite One",
            "Knewave" => "Knewave",
            "Kotta One" => "Kotta One",
            "Koulen" => "Koulen",
            "Kranky" => "Kranky",
            "Kreon" => "Kreon",
            "Kristi" => "Kristi",
            "Krona One" => "Krona One",
            "La Belle Aurore" => "La Belle Aurore",
            "Lancelot" => "Lancelot",
            "Lato" => "Lato",
            "League Script" => "League Script",
            "Leckerli One" => "Leckerli One",
            "Ledger" => "Ledger",
            "Lekton" => "Lekton",
            "Lemon" => "Lemon",
            "Libre Baskerville" => "Libre Baskerville",
            "Life Savers" => "Life Savers",
            "Lilita One" => "Lilita One",
            "Lily Script One" => "Lily Script One",
            "Limelight" => "Limelight",
            "Linden Hill" => "Linden Hill",
            "Lobster" => "Lobster",
            "Lobster Two" => "Lobster Two",
            "Londrina Outline" => "Londrina Outline",
            "Londrina Shadow" => "Londrina Shadow",
            "Londrina Sketch" => "Londrina Sketch",
            "Londrina Solid" => "Londrina Solid",
            "Lora" => "Lora",
            "Love Ya Like A Sister" => "Love Ya Like A Sister",
            "Loved by the King" => "Loved by the King",
            "Lovers Quarrel" => "Lovers Quarrel",
            "Luckiest Guy" => "Luckiest Guy",
            "Lusitana" => "Lusitana",
            "Lustria" => "Lustria",
            "Macondo" => "Macondo",
            "Macondo Swash Caps" => "Macondo Swash Caps",
            "Magra" => "Magra",
            "Maiden Orange" => "Maiden Orange",
            "Mako" => "Mako",
            "Marcellus" => "Marcellus",
            "Marcellus SC" => "Marcellus SC",
            "Marck Script" => "Marck Script",
            "Margarine" => "Margarine",
            "Marko One" => "Marko One",
            "Marmelad" => "Marmelad",
            "Marvel" => "Marvel",
            "Mate" => "Mate",
            "Mate SC" => "Mate SC",
            "Maven Pro" => "Maven Pro",
            "McLaren" => "McLaren",
            "Meddon" => "Meddon",
            "MedievalSharp" => "MedievalSharp",
            "Medula One" => "Medula One",
            "Megrim" => "Megrim",
            "Meie Script" => "Meie Script",
            "Merienda" => "Merienda",
            "Merienda One" => "Merienda One",
            "Merriweather" => "Merriweather",
            "Merriweather Sans" => "Merriweather Sans",
            "Metal" => "Metal",
            "Metal Mania" => "Metal Mania",
            "Metamorphous" => "Metamorphous",
            "Metrophobic" => "Metrophobic",
            "Michroma" => "Michroma",
            "Milonga" => "Milonga",
            "Miltonian" => "Miltonian",
            "Miltonian Tattoo" => "Miltonian Tattoo",
            "Miniver" => "Miniver",
            "Miss Fajardose" => "Miss Fajardose",
            "Modern Antiqua" => "Modern Antiqua",
            "Molengo" => "Molengo",
            "Molle" => "Molle",
            "Monda" => "Monda",
            "Monofett" => "Monofett",
            "Monoton" => "Monoton",
            "Monsieur La Doulaise" => "Monsieur La Doulaise",
            "Montaga" => "Montaga",
            "Montez" => "Montez",
            "Montserrat" => "Montserrat",
            "Montserrat Alternates" => "Montserrat Alternates",
            "Montserrat Subrayada" => "Montserrat Subrayada",
            "Moul" => "Moul",
            "Moulpali" => "Moulpali",
            "Mountains of Christmas" => "Mountains of Christmas",
            "Mouse Memoirs" => "Mouse Memoirs",
            "Mr Bedfort" => "Mr Bedfort",
            "Mr Dafoe" => "Mr Dafoe",
            "Mr De Haviland" => "Mr De Haviland",
            "Mrs Saint Delafield" => "Mrs Saint Delafield",
            "Mrs Sheppards" => "Mrs Sheppards",
            "Muli" => "Muli",
            "Mystery Quest" => "Mystery Quest",
            "Neucha" => "Neucha",
            "Neuton" => "Neuton",
            "New Rocker" => "New Rocker",
            "News Cycle" => "News Cycle",
            "Niconne" => "Niconne",
            "Nixie One" => "Nixie One",
            "Nobile" => "Nobile",
            "Nokora" => "Nokora",
            "Norican" => "Norican",
            "Nosifer" => "Nosifer",
            "Nothing You Could Do" => "Nothing You Could Do",
            "Noticia Text" => "Noticia Text",
            "Noto Sans" => "Noto Sans",
            "Noto Serif" => "Noto Serif",
            "Nova Cut" => "Nova Cut",
            "Nova Flat" => "Nova Flat",
            "Nova Mono" => "Nova Mono",
            "Nova Oval" => "Nova Oval",
            "Nova Round" => "Nova Round",
            "Nova Script" => "Nova Script",
            "Nova Slim" => "Nova Slim",
            "Nova Square" => "Nova Square",
            "Numans" => "Numans",
            "Nunito" => "Nunito",
			"OswalReg" => "OswalReg",
            "Odor Mean Chey" => "Odor Mean Chey",
            "Offside" => "Offside",
            "Old Standard TT" => "Old Standard TT",
            "Oldenburg" => "Oldenburg",
            "Oleo Script" => "Oleo Script",
            "Oleo Script Swash Caps" => "Oleo Script Swash Caps",
            "Open Sans" => "Open Sans",
            "Open Sans Condensed" => "Open Sans Condensed",
            "Oranienbaum" => "Oranienbaum",
            "Orbitron" => "Orbitron",
            "Oregano" => "Oregano",
            "Orienta" => "Orienta",
            "Original Surfer" => "Original Surfer",
            "Oswald" => "Oswald",
            "Over the Rainbow" => "Over the Rainbow",
            "Overlock" => "Overlock",
            "Overlock SC" => "Overlock SC",
            "Ovo" => "Ovo",
            "Oxygen" => "Oxygen",
            "Oxygen Mono" => "Oxygen Mono",
            "PT Mono" => "PT Mono",
            "PT Sans" => "PT Sans",
            "PT Sans Caption" => "PT Sans Caption",
            "PT Sans Narrow" => "PT Sans Narrow",
            "PT Serif" => "PT Serif",
            "PT Serif Caption" => "PT Serif Caption",
            "Pacifico" => "Pacifico",
            "Paprika" => "Paprika",
            "Parisienne" => "Parisienne",
            "Passero One" => "Passero One",
            "Passion One" => "Passion One",
            "Pathway Gothic One" => "Pathway Gothic One",
            "Patrick Hand" => "Patrick Hand",
            "Patrick Hand SC" => "Patrick Hand SC",
            "Patua One" => "Patua One",
            "Paytone One" => "Paytone One",
            "Peralta" => "Peralta",
            "Permanent Marker" => "Permanent Marker",
            "Petit Formal Script" => "Petit Formal Script",
            "Petrona" => "Petrona",
            "Philosopher" => "Philosopher",
            "Piedra" => "Piedra",
            "Pinyon Script" => "Pinyon Script",
            "Pirata One" => "Pirata One",
            "Plaster" => "Plaster",
            "Play" => "Play",
            "Playball" => "Playball",
            "Playfair Display" => "Playfair Display",
            "Playfair Display SC" => "Playfair Display SC",
            "Podkova" => "Podkova",
            "Poiret One" => "Poiret One",
            "Poller One" => "Poller One",
            "Poly" => "Poly",
            "Pompiere" => "Pompiere",
            "Pontano Sans" => "Pontano Sans",
            "Port Lligat Sans" => "Port Lligat Sans",
            "Port Lligat Slab" => "Port Lligat Slab",
            "Prata" => "Prata",
            "Preahvihear" => "Preahvihear",
            "Press Start 2P" => "Press Start 2P",
            "Princess Sofia" => "Princess Sofia",
            "Prociono" => "Prociono",
            "Prosto One" => "Prosto One",
            "Puritan" => "Puritan",
            "Purple Purse" => "Purple Purse",
            "Quando" => "Quando",
            "Quantico" => "Quantico",
            "Quattrocento" => "Quattrocento",
            "Quattrocento Sans" => "Quattrocento Sans",
            "Questrial" => "Questrial",
            "Quicksand" => "Quicksand",
            "Quintessential" => "Quintessential",
            "Qwigley" => "Qwigley",
            "Racing Sans One" => "Racing Sans One",
            "Radley" => "Radley",
            "Raleway" => "Raleway",
            "Raleway Dots" => "Raleway Dots",
            "Rambla" => "Rambla",
            "Rammetto One" => "Rammetto One",
            "Ranchers" => "Ranchers",
            "Rancho" => "Rancho",
            "Rationale" => "Rationale",
            "Redressed" => "Redressed",
            "Reenie Beanie" => "Reenie Beanie",
            "Revalia" => "Revalia",
            "Ribeye" => "Ribeye",
            "Ribeye Marrow" => "Ribeye Marrow",
            "Righteous" => "Righteous",
            "Risque" => "Risque",
            "Roboto" => "Roboto",
            "Roboto Condensed" => "Roboto Condensed",
            "Roboto Slab" => "Roboto Slab",
            "Rochester" => "Rochester",
            "Rock Salt" => "Rock Salt",
            "Rokkitt" => "Rokkitt",
            "Romanesco" => "Romanesco",
            "Ropa Sans" => "Ropa Sans",
            "Rosario" => "Rosario",
            "Rosarivo" => "Rosarivo",
            "Rouge Script" => "Rouge Script",
            "Ruda" => "Ruda",
            "Rufina" => "Rufina",
            "Ruge Boogie" => "Ruge Boogie",
            "Ruluko" => "Ruluko",
            "Rum Raisin" => "Rum Raisin",
            "Ruslan Display" => "Ruslan Display",
            "Russo One" => "Russo One",
            "Ruthie" => "Ruthie",
            "Rye" => "Rye",
            "Sacramento" => "Sacramento",
            "Sail" => "Sail",
            "Salsa" => "Salsa",
            "Sanchez" => "Sanchez",
            "Sancreek" => "Sancreek",
            "Sansita One" => "Sansita One",
            "Sarina" => "Sarina",
            "Satisfy" => "Satisfy",
            "Scada" => "Scada",
            "Schoolbell" => "Schoolbell",
            "Seaweed Script" => "Seaweed Script",
            "Sevillana" => "Sevillana",
            "Seymour One" => "Seymour One",
            "Shadows Into Light" => "Shadows Into Light",
            "Shadows Into Light Two" => "Shadows Into Light Two",
            "Shanti" => "Shanti",
            "Share" => "Share",
            "Share Tech" => "Share Tech",
            "Share Tech Mono" => "Share Tech Mono",
            "Shojumaru" => "Shojumaru",
            "Short Stack" => "Short Stack",
            "Siemreap" => "Siemreap",
            "Sigmar One" => "Sigmar One",
            "Signika" => "Signika",
            "Signika Negative" => "Signika Negative",
            "Simonetta" => "Simonetta",
            "Sintony" => "Sintony",
            "Sirin Stencil" => "Sirin Stencil",
            "Six Caps" => "Six Caps",
            "Skranji" => "Skranji",
            "Slackey" => "Slackey",
            "Smokum" => "Smokum",
            "Smythe" => "Smythe",
            "Sniglet" => "Sniglet",
            "Snippet" => "Snippet",
            "Snowburst One" => "Snowburst One",
            "Sofadi One" => "Sofadi One",
            "Sofia" => "Sofia",
            "Sonsie One" => "Sonsie One",
            "Sorts Mill Goudy" => "Sorts Mill Goudy",
            "Source Code Pro" => "Source Code Pro",
            "Source Sans Pro" => "Source Sans Pro",
            "Special Elite" => "Special Elite",
            "Spicy Rice" => "Spicy Rice",
            "Spinnaker" => "Spinnaker",
            "Spirax" => "Spirax",
            "Squada One" => "Squada One",
            "Stalemate" => "Stalemate",
            "Stalinist One" => "Stalinist One",
            "Stardos Stencil" => "Stardos Stencil",
            "Stint Ultra Condensed" => "Stint Ultra Condensed",
            "Stint Ultra Expanded" => "Stint Ultra Expanded",
            "Stoke" => "Stoke",
            "Strait" => "Strait",
            "Sue Ellen Francisco" => "Sue Ellen Francisco",
            "Sunshiney" => "Sunshiney",
            "Supermercado One" => "Supermercado One",
            "Suwannaphum" => "Suwannaphum",
            "Swanky and Moo Moo" => "Swanky and Moo Moo",
            "Syncopate" => "Syncopate",
            "Tangerine" => "Tangerine",
            "Taprom" => "Taprom",
            "Tauri" => "Tauri",
            "Telex" => "Telex",
            "Tenor Sans" => "Tenor Sans",
            "Text Me One" => "Text Me One",
            "The Girl Next Door" => "The Girl Next Door",
            "Tienne" => "Tienne",
            "Tinos" => "Tinos",
            "Titan One" => "Titan One",
            "Titillium Web" => "Titillium Web",
            "Trade Winds" => "Trade Winds",
            "Trocchi" => "Trocchi",
            "Trochut" => "Trochut",
            "Trykker" => "Trykker",
            "Tulpen One" => "Tulpen One",
            "Ubuntu" => "Ubuntu",
            "Ubuntu Condensed" => "Ubuntu Condensed",
            "Ubuntu Mono" => "Ubuntu Mono",
            "Ultra" => "Ultra",
            "Uncial Antiqua" => "Uncial Antiqua",
            "Underdog" => "Underdog",
            "Unica One" => "Unica One",
            "UnifrakturCook" => "UnifrakturCook",
            "UnifrakturMaguntia" => "UnifrakturMaguntia",
            "Unkempt" => "Unkempt",
            "Unlock" => "Unlock",
            "Unna" => "Unna",
            "VT323" => "VT323",
            "Vampiro One" => "Vampiro One",
            "Varela" => "Varela",
            "Varela Round" => "Varela Round",
            "Vast Shadow" => "Vast Shadow",
            "Vibur" => "Vibur",
            "Vidaloka" => "Vidaloka",
            "Viga" => "Viga",
            "Voces" => "Voces",
            "Volkhov" => "Volkhov",
            "Vollkorn" => "Vollkorn",
            "Voltaire" => "Voltaire",
            "Waiting for the Sunrise" => "Waiting for the Sunrise",
            "Wallpoet" => "Wallpoet",
            "Walter Turncoat" => "Walter Turncoat",
            "Warnes" => "Warnes",
            "Wellfleet" => "Wellfleet",
            "Wendy One" => "Wendy One",
            "Wire One" => "Wire One",
            "Yanone Kaffeesatz" => "Yanone Kaffeesatz",
            "Yellowtail" => "Yellowtail",
            "Yeseva One" => "Yeseva One",
            "Yesteryear" => "Yesteryear",
            "Zeyada" => "Zeyada"
        );



/*-----------------------------------------------------------------------------------*/
/* The Options Array */
/*-----------------------------------------------------------------------------------*/

// Set the Options Array
global $of_options;
$of_options = array();

$of_options[] = array( 	"name" 		=> "Home Settings",
						"type" 		=> "heading"
				);
				
$of_options[] = array( 	"name" 		=> "Your Logo",
						"desc" 		=> "Upload images using native media uploader from Wordpress 3.5+.",
						"id" 		=> "logo",
						"std" 		=> "",
						"type" 		=> "upload"
					);	
					

$of_options[] = array( 	"name" 		=> "Favicon Icon",
						"desc" 		=> "Upload images using native media uploader from Wordpress 3.5+.",
						"id" 		=> "favicon",
						"std" 		=> "",
						"type" 		=> "upload"
					);	
					
					
$of_options[] = array( 	"name" 		=> "Contact No.",
						"desc" 		=> "",
						"id" 		=> "contact",
						"std" 		=> "",
						"type" 		=> "text"
				);

$of_options[] = array( 	"name" 		=> "Email",
						"desc" 		=> "",
						"id" 		=> "email",
						"std" 		=> "",
						"type" 		=> "text"
				);				
									

					
$of_options[] = array( 	"name" 		=> "Features Slider",
						"desc" 		=> "Unlimited slider with drag and drop sortings.",
						"id" 		=> "pingu_slider",
						"std" 		=> "",

						"type" 		=> "slider"
				);						
					
$of_options[] = array( 	"name" 		=> "Slider bottom section Heading",
						"desc" 		=> "",
						"id" 		=> "Slider_bottom_section_Heading",
						"std" 		=> "",
						"type" 		=> "textarea"
				);
				
$of_options[] = array( 	"name" 		=> "section Heading Text Color",
						"desc" 		=> "Pick a Text color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default:#fad508)",
						"id" 		=> "section_text_color",
						"std" 		=> "#fad508",
						"type" 		=> "color"
				);
				
$of_options[] = array( 	"name" 		=> "Middle section Heading",
						"desc" 		=> "",
						"id" 		=> "Middle_section_Heading",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Middle section Heading Text Color",
						"desc" 		=> "Pick a Text color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #222222)",
						"id" 		=> "Heading_section_text_color",
						"std" 		=> "#222222",
						"type" 		=> "color"
				);
				
				
$of_options[] = array( "name" => "Blog Listing Page",
					"desc" => "",
					"id" => "Bloglist",
					"std" => "<h3 style='margin: 0;''>Case Studies Option  On Home Page</h3>",
					"icon" => true,
					"type" => "info");
					
					
$of_options[] = array( "name" => "Show Case Studies Option",
					"id" => "case_studies_opt",
					"desc" => "Show Case Studies Option On Home Page.",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");									

$of_options[] = array( 	"name" 		=> "Case Studies Heading",
						"desc" 		=> "",
						"id" 		=> "Upcoming_events_heading",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Case Studies Description",
						"desc" 		=> "",
						"id" 		=> "Upcoming_events_des",
						"std" 		=> "",
						"type" 		=> "textarea"
						
						
				);

$of_options[] = array( 	"name" 		=> "Case Studies Button text",
						"desc" 		=> "",
						"id" 		=> "Upcoming_events_button",
						"std" 		=> "",
						"type" 		=> "text"

				);	
				
$of_options[] = array( 	"name" 		=> "View All Case Studies Result Url",
						"desc" 		=> "Please enter case page url here ",
						"id" 		=> "case_url",
						"std" 		=> "",
						"type" 		=> "text"

				);	
				
$of_options[] = array( "name" => "Blog Listing Page",
					"desc" => "",
					"id" => "Bloglist",
					"std" => "<h3 style='margin: 0;''>Testimonial Option  On Home Page</h3>",
					"icon" => true,
					"type" => "info");
					
$of_options[] = array( "name" => "Show Testimonial Option",
					"id" => "testimonial_opt",
					"desc" => "Show Testimonial Option On Home Page.",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");												
				
$of_options[] = array( 	"name" 		=> "Testimonial Message heading",
						"desc" 		=> "",
						"id" 		=> "Clients_Say_heading",
						"std" 		=> "",
						"type" 		=> "text"

				);	
$of_options[] = array( 	"name" 		=> "Testimonial Message Description",
						"desc" 		=> "",
						"id" 		=> "Clients_Say_des",
						"std" 		=> "",
						"type" 		=> "textarea"

				);										

$of_options[] = array( 	"name" 		=> "Testimonial Message Slider",
						"desc" 		=> "Unlimited slider with drag and drop sortings.",
						"id" 		=> "clients_slider",
						"std" 		=> "",

						"type" 		=> "slider"
				);	


$of_options[] = array( "name" => "Blog Listing Page",
					"desc" => "",
					"id" => "Bloglist",
					"std" => "<h3 style='margin: 0;''>Option For our Clients Section  On Home Page</h3>",
					"icon" => true,
					"type" => "info");	
					
$of_options[] = array( "name" => "Show Our Clients Option",
					"id" => "clients_opt",
					"desc" => "Show Our Clients Option On Home Page.",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");										
	
				
$of_options[] = array( 	"name" 		=> "Our Clients heading",
						"desc" 		=> "",
						"id" 		=> "Our_Clients_heading",
						"std" 		=> "",
						"type" 		=> "text"

				);
$of_options[] = array( 	"name" 		=> "Our Clients Description",
						"desc" 		=> "",
						"id" 		=> "Our_Clients_des",
						"std" 		=> "",
						"type" 		=> "textarea"

				);				
				
$of_options[] = array( 	"name" 		=> "Our Clients Slider",
						"desc" 		=> "Unlimited slider with drag and drop sortings.",
						"id" 		=> "Our_clients_slider",
						"std" 		=> "",

						"type" 		=> "slider"
				);	
				
$of_options[] = array( "name" => "Blog Listing Page",
					"desc" => "",
					"id" => "Bloglist",
					"std" => "<h3 style='margin: 0;''>Option For Our Team On Home Page</h3>",
					"icon" => true,
					"type" => "info");	
										

$of_options[] = array( "name" => "Show Our Team Option",
					"id" => "team_opt",
					"desc" => "Show Our Team Option On Home Page.",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");

				
$of_options[] = array( 	"name" 		=> "Our Team heading",
						"desc" 		=> "",
						"id" 		=> "Our_Team_heading",
						"std" 		=> "",
						"type" 		=> "text"

				);
$of_options[] = array( 	"name" 		=> "Our Team Description",
						"desc" 		=> "",
						"id" 		=> "Our_Team_des",
						"std" 		=> "",
						"type" 		=> "textarea"

				);


$of_options[] = array( 	"name" 		=> "Our Team Profile button text",
						"desc" 		=> "",
						"id" 		=> "Profile_button",
						"std" 		=> "",
						"type" 		=> "text"

				);								

					
					
$of_options[] = array( 	"name" 		=> "Team Member One",
						"desc" 		=> "Upload images using native media uploader from Wordpress 3.5+.",
						"id" 		=> "mem_one",
						"std" 		=> "",
						"type" 		=> "upload"
						);
						
$of_options[] = array( 	"name" 		=> "Name",
						"desc" 		=> "",
						"id" 		=> "mem_one_name",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Designation",
						"desc" 		=> "",
						"id" 		=> "mem_one_designation",
						"std" 		=> "",
						"type" 		=> "text"
				);				

$of_options[] = array( 	"name" 		=> "Description",
						"desc" 		=> "",
						"id" 		=> "mem_one_description",
						"std" 		=> "",
						"type" 		=> "textarea"
				);			
				
$of_options[] = array( 	"name" 		=> "Team Member Two",
						"desc" 		=> "Upload images using native media uploader from Wordpress 3.5+.",
						"id" 		=> "mem_two",
						"std" 		=> "",
						"type" 		=> "upload"
						);
						
$of_options[] = array( 	"name" 		=> "Name",
						"desc" 		=> "",
						"id" 		=> "mem_two_name",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Designation",
						"desc" 		=> "",
						"id" 		=> "mem_two_designation",
						"std" 		=> "",
						"type" 		=> "text"
				);				

$of_options[] = array( 	"name" 		=> "Description",
						"desc" 		=> "",
						"id" 		=> "mem_two_description",
						"std" 		=> "",
						"type" 		=> "textarea"
				);						
$of_options[] = array( 	"name" 		=> "Team Member Three",
						"desc" 		=> "Upload images using native media uploader from Wordpress 3.5+.",
						"id" 		=> "mem_three",
						"std" 		=> "",
						"type" 		=> "upload"
						);
						
$of_options[] = array( 	"name" 		=> "Name",
						"desc" 		=> "",
						"id" 		=> "mem_three_name",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Designation",
						"desc" 		=> "",
						"id" 		=> "mem_three_designation",
						"std" 		=> "",
						"type" 		=> "text"
				);				

$of_options[] = array( 	"name" 		=> "Description",
						"desc" 		=> "",
						"id" 		=> "mem_three_description",
						"std" 		=> "",
						"type" 		=> "textarea"
				);
				
$of_options[] = array( 	"name" 		=> "Team Member Four",
						"desc" 		=> "Upload images using native media uploader from Wordpress 3.5+.",
						"id" 		=> "mem_four",
						"std" 		=> "",
						"type" 		=> "upload"
						);
$of_options[] = array( 	"name" 		=> "Name",
						"desc" 		=> "",
						"id" 		=> "mem_four_name",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Designation",
						"desc" 		=> "",
						"id" 		=> "mem_four_designation",
						"std" 		=> "",
						"type" 		=> "text"
				);				

$of_options[] = array( 	"name" 		=> "Description",
						"desc" 		=> "",
						"id" 		=> "mem_four_description",
						"std" 		=> "",
						"type" 		=> "textarea"
				);	
				
				
$of_options[] = array( "name" => "Blog Listing Page",
					"desc" => "",
					"id" => "Bloglist",
					"std" => "<h3 style='margin: 0;''>Option For Disclaimer Settings On Appointment Form</h3>",
					"icon" => true,
					"type" => "info");	
					
					
$of_options[] = array( "name" => "Show Disclaimer Option",
					"id" => "disclaimer_opt",
					"desc" => "Show Disclaimer Option On Appointment Form.",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");
					
					
$of_options[] = array( 	"name" 		=> "Disclaimer Text",
						"desc" 		=> "Enter Your Disclaimer Text On Appointment Form",
						"id" 		=> "disclaimer",
						"std" 		=> "disclaimer",
						"type" 		=> "text"
				);	
				
$of_options[] = array( 	"name" 		=> "Disclaimer Content ",
						"desc" 		=> "Enter Your Disclaimer Content On Appointment Form",
						"id" 		=> "disclaimer_description",
						"std" 		=> "",
						"type" 		=> "textarea"
				);																
		
//Facebook Page  Options
					
/*$of_options[] = array( 	"name" 		=> "Facebook Fanpage Options",
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "facebook.png"
				);

$of_options[] = array( 	"name" 		=> "Facebook Page Image Upload",
						"desc" 		=> "Upload Logo Use Width = 495px  For Best Results",
						"id" 		=> "fb_image",						
						"std" 		=> "",
						"type" 		=> "upload"
				);	
				
$of_options[] = array( 	"name" 		=> "Page Background Color",
						"desc" 		=> "Pick a background color for the theme (default: #3b5999).",
						"id" 		=> "fb_container",
						"std" 		=> "#3b5999",
						"type" 		=> "color"
				);		
				
$of_options[] = array( 	"name" 		=> "Footer Text",
						"desc" 		=> "Put Your Facebok Page Footer Text Here",
						"id" 		=> "fb_footer",
						"std" 		=> "",
						"type" 		=> "text"
				);*/	
							


$of_options[] = array( 	"name" 		=> "Inner page Settings",
						"type" 		=> "heading"
				);

$of_options[] = array( 	"name" 		=> "Case Page Header",
						"desc" 		=> "Header on banner goes here",
						"id" 		=> "case_header",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Practice Areas Page Header",
						"desc" 		=> "Header on banner goes here",
						"id" 		=> "area_header",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "contact  Page Header",
						"desc" 		=> "Header on banner goes here",
						"id" 		=> "contact_header",
						"std" 		=> "",
						"type" 		=> "text"
				);

$of_options[] = array( 	"name" 		=> "Blog Page Header",
						"desc" 		=> "Header on banner goes here",
						"id" 		=> "blog_header",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
//Contact  Options
					
					
					
$of_options[] = array( 	"name" 		=> "Appointment  Option",
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "Booking_Sms_Option.png"
				);	






$of_options[] = array("name" => "Appointment Form section",
					"desc" => "",
					"id" => "appointment_section",
					"std" => "<h3 style='margin: 0;color:#fff;'>Option For Appointment Form Section</h3>",
					"icon" => true,
					"type" => "info");
					
					
$of_options[] = array( 	"name" 		=> "Appointment Form Heading",
						"desc" 		=> "Enter Your Appointment Heading",
						"id" 		=> "apt_form_heading",
						"std" 		=> "",
						"type" 		=> "text"
				);
										


 $of_options[] = array( "name" 		=> "Appointment Form Background Color",
						"desc" 		=> "Pick a Appointment Form Background Color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #9ACAF5)",
						"id" 		=> "apt_frm_bg_color",
						"std" 		=> "#9ACAF5",
						"type" 		=> "color"
				); 




$of_options[] = array( "name" => "Appointment Form Label section",
					"desc" => "",
					"id" => "appointment_label_section",
					"std" => "<h3 style='margin: 0;color:#fff;'>Option For Appointment Form Label Section</h3>",
					"icon" => true,
					"type" => "info");

$of_options[] = array( 	"name" 		=> "Name",
						"desc" 		=> "Please Enter Your Name Label Here ",
						"id" 		=> "name_label",
						"std" 		=> "",
						"type" 		=> "text"
				);
				


$of_options[] = array( 	"name" 		=> "Email",
						"desc" 		=> "Please Enter Your Email Label Here ",
						"id" 		=> "email_label",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Phone",
						"desc" 		=> "Please Enter Your Phone Label Here ",
						"id" 		=> "phone_label",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Address",
						"desc" 		=> "Please Enter Your Address Label Here ",
						"id" 		=> "address_label",
						"std" 		=> "",
						"type" 		=> "text"
				);
					
					

$of_options[] = array( 	"name" 		=> "City",
						"desc" 		=> "Please Enter Your City Label Here ",
						"id" 		=> "city_label",
						"std" 		=> "",
						"type" 		=> "text"
				);					
				
				

$of_options[] = array( 	"name" 		=> "Notes",
						"desc" 		=> "Please Enter Your Notes Label Here ",
						"id" 		=> "notes_label",
						"std" 		=> "",
						"type" 		=> "text"
				);				
				
$of_options[] = array( 	"name" 		=> "Newsletter",
						"desc" 		=> "Please Enter Your Newsletter Label Here ",
						"id" 		=> "newsletter_label",
						"std" 		=> "",
						"type" 		=> "text"
				);								
				
								
				



$of_options[] = array( "name" => "Appointment Form Color section",
					"desc" => "",
					"id" => "appointment_color_section",
					"std" => "<h3 style='margin: 0;color:#fff;'>Option For Appointment Form Color Section</h3>",
					"icon" => true,
					"type" => "info");
					


 $of_options[] = array( 	"name" 		=> "Appointment Form Primary Color",
						"desc" 		=> "Pick a Appointment Form Primary Color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #f1602c)",
						"id" 		=> "apt_primary_color",
						"std" 		=> "#f1602c",
						"type" 		=> "color"
				); 

					
					
$of_options[] = array( 	"name" 		=> "Progress Bar Default Color",
						"desc" 		=> "Pick a Progress Bar Default Color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #fff)",
						"id" 		=> "progress_default_bar",
						"std" 		=> "#fff",
						"type" 		=> "color"
				); 
 
$of_options[] = array( 	"name" 		=> "Progress Bar Current Color",
						"desc" 		=> "Pick a Progress Bar Current Color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #f1602c)",
						"id" 		=> "progress_current_bar",
						"std" 		=> "#f1602c",
						"type" 		=> "color"
				);

         
$of_options[] = array( 	"name" 		=> "Appointment Form label Color",
						"desc" 		=> "Pick a Appointment Form label Color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #fff)",
						"id" 		=> "label_color",
						"std" 		=> "#fff",
						"type" 		=> "color"
				);


 $of_options[] = array( 	"name" 		=> "Appointment Form Buttom Color",
						"desc" 		=> "Pick a Appointment Form Button Color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #f1602c)",
						"id" 		=> "apt_button_color",
						"std" 		=> "#f1602c",
						"type" 		=> "color"
				); 


$of_options[] = array( "name" => "Appointment Date And Time Color section",
					"desc" => "",
					"id" => "appointment_datetime_color_section",
					"std" => "<h3 style='margin: 0;color:#fff;'>Option For Appointment Date And Time Color Section</h3>",
					"icon" => true,
					"type" => "info");


$of_options[] = array( 	"name" 		=> "Appointment Free Date And Time Color",
						"desc" 		=> "Pick a Appointment Free Date And Time Color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #f1602c)",
						"id" 		=> "apt_free_color",
						"std" 		=> "#f1602c",
						"type" 		=> "color"
				); 
 
 
$of_options[] = array( 	"name" 		=> "Appointment Busy Date And Time Color",
						"desc" 		=> "Pick a Appointment Busy Date And Time Color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #FAA22D)",
						"id" 		=> "apt_busy_color",
						"std" 		=> "#FAA22D",
						"type" 		=> "color"
				);  


$of_options[] = array( 	"name" 		=> "Appointment Not possible Date And Time Color",
						"desc" 		=> "Pick a Appointment Not possible Date And Time Color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #e2e2e1)",
						"id" 		=> "apt_nit_color",
						"std" 		=> "#e2e2e1",
						"type" 		=> "color"
				);

					
//contact options			
					
					
$of_options[] = array( 	"name" 		=> "Contact  Options",
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-slider.png"
				);	

$of_options[] = array( 	"name" 		=> "Contact Sidebar Heading",
						"desc" 		=> "Enter Your Contact Sidebar Heading",
						"id" 		=> "contact_info",
						"std" 		=> "Enter Your Contact Sidebar Heading",
						"type" 		=> "text"
				);

$of_options[] = array( 	"name" 		=> "Contact Information Area",
						"desc" 		=> "Enter Your Information Here",
						"id" 		=> "contact_main",
						"std" 		=> "",
						"type" 		=> "text"
				);					
				
$of_options[] = array( 	"name" 		=> "Address",
						"desc" 		=> "Enter  Your Address Here",
						"id" 		=> "contact_add",
						"std" 		=> "",
						"type" 		=> "textarea"
				);		
				
$of_options[] = array( 	"name" 		=> "Phone",
						"desc" 		=> "Enter Your Phone Number Here",
						"id" 		=> "contact_phone",
						"std" 		=> "180000000",
						"type" 		=> "text"
				);	
				
/*$of_options[] = array( 	"name" 		=> "Contact Map",
						"desc" 		=> "Enter  Map Code Here",
						"id" 		=> "map_add",
						"std" 		=> "",
						"type" 		=> "textarea"
				);					
*/
$of_options[] = array( 	"name" 		=> "Email",
						"desc" 		=> "Enter Your Email Here",
						"id" 		=> "contact_email",
						"std" 		=> "sample@mail.com",
						"type" 		=> "text"
				);	
				
				
					
//Footer Options Starts Here				
					
$of_options[] = array( 	"name" 		=> "Footer Options",
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-slider.png"
				);					
									
				
		
$of_options[] = array( 	"name" 		=> "Footer Logo",
						"desc" 		=> "Upload images using native media uploader from Wordpress 3.5+.",
						"id" 		=> "footer_logo",
						"std" 		=> "",
						"type" 		=> "upload"
					);			
		
		
$of_options[] = array( 	"name" 		=> "Footer Text",
						"desc" 		=> "Put Yout CopyRight Text",
						"id" 		=> "footer_text",
						"std" 		=> "copyrights reserved by Yoursite.com",
						"type" 		=> "textarea"
				);		
		
		
		
				
					
//Blog Options Starts Here				
$of_options[] = array( 	"name" 		=> "Blog  Options",
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-edit.png"
				);		


			
				
$of_options[] = array( "name" => "Blog Listing Page",
					"desc" => "",
					"id" => "Bloglist",
					"std" => "<h3 style='margin: 0;''>Option For Blog Listing Page</h3>",
					"icon" => true,
					"type" => "info");				
				
$of_options[] = array( "name" => "Show Image",
					"id" => "show_image",
					"desc" => "Show Image on Blog Listing Page.",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");

$of_options[] = array( "name" => "Show Sidebar",
					"id" => "show_removesidebar",
					"desc" => "Show Sidebar on Blog page.",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");						
					
					
$of_options[] = array( "name" => "Blog inner Page",
					"desc" => "",
					"id" => "Bloginner",
					"std" => "<h3 style='margin: 0;''>Option For Inner Blog Page</h3>",
					"icon" => true,
					"type" => "info");						
					

$of_options[] = array( "name" => "Show Image",
					"id" => "show_innerimage",
					"desc" => "Show Image On Inner Blog Page.",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");					

				
				
$of_options[] = array( "name" => "Show Author's Bio",
					"id" => "show_author",
					"desc" => "Show Author Bio on Inner Blog page.",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");
										
/*$of_options[] = array( "name" => "Show Social Share Options",
					"id" => "show_shareoption",
					"desc" => "Show Social Share Option on Inner Blog page.",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");*/	
					
$of_options[] = array( "name" => "Show Sidebar",
					"id" => "show_addsidebar",
					"desc" => "Show Sidebar on Inner Blog page.",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");		
					
					
					

					

$of_options[] = array( 	"name" 		=> "SEO  Options",
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-slider.png"
				);				

				
/*$of_options[] = array( 	"name" 		=> "SEO For Title",
						"desc" 		=> "SEO Title goes Here",
						"id" 		=> "title_seo",
						"std" 		=> "",
						"type" 		=> "textarea"
				);*/
				
$of_options[] = array( 	"name" 		=> "SEO For Meta Keyword",
						"desc" 		=> "SEO Meta Keywords",
						"id" 		=> "keyword_seo",
						"std" 		=> "",
						"type" 		=> "textarea"
				);
				
$of_options[] = array( 	"name" 		=> "SEO For Meta Description",
						"desc" 		=> "SEO Meta Description",
						"id" 		=> "description_seo",
						"std" 		=> "",
						"type" 		=> "textarea"
				);
				
$of_options[] = array( 	"name" 		=> "SEO Option HEAD Tag",
						"desc" 		=> "Usually Used To Enter Varification Code In Heading Tag",
						"id" 		=> "act_key",
						"std" 		=> "",
						"type" 		=> "textarea"
				);

$of_options[] = array( 	"name" 		=> "Social  Options",
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-slider.png"
				);				

				
$of_options[] = array( 	"name" 		=> "Facebook",
						"desc" 		=> "Put Your FaceBook Link",
						"id" 		=> "facebook_link",
						"std" 		=> "http://www.facebook.com/yourfbid",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Twitter",
						"desc" 		=> "Put Your Twitter Link",
						"id" 		=> "twitter_link",
						"std" 		=> "http://www.twitter.com/tourtwitterid",
						"type" 		=> "text"
				);
				
				
$of_options[] = array( 	"name" 		=> "Google Plus",
						"desc" 		=> "Put Your Google Plus Link",
						"id" 		=> "gplus_link",
						"std" 		=> "http://plus.google.com/googleplusid",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "YouTube",
						"desc" 		=> "Put Your Youtube Link",
						"id" 		=> "youtube",
						"std" 		=> "http://youtube.com",
						"type" 		=> "text"
				);
				

//General Settings

$of_options[] = array( 	"name" 		=> "General Settings",
						"type" 		=> "heading"
				);	
				
			
$of_options[] = array( 	"name" 		=> "Tracking Code",
						"desc" 		=> "Put your Google Analytics (or FB) tracking code here. This will be added into the footer template of your theme.",
						"id" 		=> "google_analytics",
						"std" 		=> "",
						"type" 		=> "textarea"
				);
				


			
//Styling Options
				
$of_options[] = array( 	"name" 		=> "Styling Options",
						"type" 		=> "heading"
						
				);
				
				

$of_options[] = array( 	"name" 		=> "Body Background Image",
						"desc" 		=> "Upload images using native media uploader from Wordpress 3.5+.",
						"id" 		=> "body_image",
						"std" 		=> "",
						"type" 		=> "upload"
					);	
									
				
$of_options[] = array( 	"name" 		=> "Body Color",
						"desc" 		=> "Pick a Body background color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #F6F6F6)",
						"id" 		=> "body_background",
						"std" 		=> "#F6F6F6",
						"type" 		=> "color"
				);	


$of_options[] = array( 	"name" 		=> "Header Primary Color",
						"desc" 		=> "Pick a Header Primary background color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #1c1b1b)",
						"id" 		=> "header_primary",
						"std" 		=> "#1c1b1b",
						"type" 		=> "color"
				);	

$of_options[] = array( 	"name" 		=> "Header Secondary Color",
						"desc" 		=> "Pick a Header Secondary background color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #221e1f)",
						"id" 		=> "header_secondary",
						"std" 		=> "#221e1f",
						"type" 		=> "color"
				);
				

				
$of_options[] = array( 	"name" 		=> "Theme Primary Background Color",
						"desc" 		=> "Pick a Primary background color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #fad508)",
						"id" 		=> "primary_background",
						"std" 		=> "#fad508",
						"type" 		=> "color"
				);
				



$of_options[] = array( 	"name" 		=> "Footer Background Image",
						"desc" 		=> "Upload images using native media uploader from Wordpress 3.5+.",
						"id" 		=> "footer_bg",
						"std" 		=> "",
						"type" 		=> "upload"
					);
					
$of_options[] = array( 	"name" 		=> "Testimonial Background Image",
						"desc" 		=> "Upload images using native media uploader from Wordpress 3.5+.",
						"id" 		=> "testimonial_bg",
						"std" 		=> "",
						"type" 		=> "upload"
					);						

$of_options[] = array( 	"name" 		=> "Case Stuidies Block's Background Image",
						"desc" 		=> "Upload images using native media uploader from Wordpress 3.5+.",
						"id" 		=> "case_block_bg",
						"std" 		=> "",
						"type" 		=> "upload"
					);	
			/*	
				$of_options[] = array( 	"name"=> "Theme Second Background Color",
						"desc" 		=> "Pick a Second background color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #f05135)",
						"id" 		=> "Second_Background",
						"std" 		=> "#f05135",
						"type" 		=> "color"
				);
							



$of_options[] = array( 	"name" 		=> "Dropdown Menu Background Colors for smaller screens",
						"desc" 		=> "Pick a Menu background color for smaller screens (Menu Shifts to drop down format to make it responsive) (default: #c4c4c4).",
						"id" 		=> "menubgcolor",
						"std" 		=> "#c4c4c4",
						"type" 		=> "color"
				);
				
$of_options[] = array( 	"name" 		=> "Dropdown Menu Bar Color for smaller screens",
						"desc" 		=> "Pick a Menu background color for smaller screens (Menu Shifts to drop down format to make it responsive) (default: #c4c4c4).",
						"id" 		=> "menubarcolor",
						"std" 		=> "#c4c4c4",
						"type" 		=> "color"
				);												
					
				

				
$of_options[] = array( 	"name" 		=> "Breadcrumb Background Colors",
						"desc" 		=> "Pick a Breadcrumb background color.",
						"id" 		=> "breadcolor",
						"std" 		=> "#FCFCFC",
						"type" 		=> "color"
				);		*/				

$of_options[] = array( 	"name" 		=> "Custom CSS",
						"desc" 		=> "You can put your custom CSS which will override existing one",
						"id" 		=> "custom_css",
						"std" 		=> "",
						"type" 		=> "textarea"
				);						


//Example Options For Typography 
			
$of_options[] = array( 	"name" 		=> "Typography Options",
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-slider.png"
				);

				
$of_options[] = array( "name" => "Google Fonts",
					"desc" => "",
					"id" => "google_fonts_intro",
					"std" => "<h3 style='margin: 0;''>Google Fonts</h3>",
					"icon" => true,
					"type" => "info");

					
$of_options[] = array( "name" => "Select H1 Font",
					"desc" => "Select a font family for H1",
					"id" => "hone",
					"std" => "OswalReg",
					"type" => "select",
					"options" => $google_fonts);	

$of_options[] = array( "name" => "Select H1 Font Size (px)",
					"desc" => "Select H1 Font Size (px) (Default is 36)",
					"id" => "honesize",
					"std" => "36",
					"type" => "select",
					"options" => $font_sizes);	
					
$of_options[] = array( "name" => "Select H1 Font weight",
					"desc" => "Default is 100",
					"id" => "honeweight",
					"std" => "normal",
					"type" => "select",
					"options" => $font_weight);	
					
$of_options[] = array( 	"name" 		=> "H1 Font Color",
						"desc" 		=> "Pick a H1 Font Color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #222222)",
						"id" 		=> "h1_color",
						"std" 		=> "#222222",
						"type" 		=> "color"
				);										

/*$of_options[] = array( 	"name" 		=> "Select H1 Font Color",
						"desc" 		=> "Pick a H1 font color (default: #000).",
						"id" 		=> "honecolor",
						"std" 		=> "#000",
						"type" 		=> "color"
				);	*/				
					

$of_options[] = array( "name" => "Select H2 Font",
					"desc" => "Select a font family for footer headings",
					"id" => "htwo",
					"std" => "OswalReg",
					"type" => "select",
					"options" => $google_fonts);	

$of_options[] = array( "name" => "Select H2 Font Size (px)",
					"desc" => "Default is 35",
					"id" => "htwosize",
					"std" => "35",
					"type" => "select",
					"options" => $font_sizes);	

$of_options[] = array( "name" => "Select H2 Font weight",
					"desc" => "Default is 100",
					"id" => "htwoweight",
					"std" => "100",
					"type" => "select",
					"options" => $font_weight);		
					

/*$of_options[] = array( 	"name" 		=> "Select H2 Font Color",
						"desc" 		=> "Select H2 Font Color (default: #fff).",
						"id" 		=> "htwocolor",
						"std" 		=> "#000",
						"type" 		=> "color"
				);	*/	
				
				
$of_options[] = array( "name" => "Select H3 Font",
					"desc" => "Select a font family H3",
					"id" => "hthree",
					"std" => "OswalReg",
					"type" => "select",
					"options" => $google_fonts);	

$of_options[] = array( "name" => "Select H3 Font Size (px)",
					"desc" => "Default is 24",
					"id" => "hthreesize",
					"std" => "24",
					"type" => "select",
					"options" => $font_sizes);	

$of_options[] = array( "name" => "Select H3 Font weight",
					"desc" => "Default is 100",
					"id" => "hthreeweight",
					"std" => "100",
					"type" => "select",
					"options" => $font_weight);		
					

/*$of_options[] = array( 	"name" 		=> "Select H3 Font Color",
						"desc" 		=> "Pick a color for H3 (default: #fff).",
						"id" 		=> "hthreecolor",
						"std" 		=> "#000",
						"type" 		=> "color"
				);*/
				
				
$of_options[] = array( "name" => "Select Paragraph Font",
					"desc" => "Select a font family for footer headings",
					"id" => "pfont",
					"std" => "HelveticaLTStdLight",
					"type" => "select",
					"options" => $google_fonts);	

$of_options[] = array( "name" => "Select Paragraph Font Size (px)",
					"desc" => "Default is 18",
					"id" => "psize",
					"std" => "17",
					"type" => "select",
					"options" => $font_sizes);

$of_options[] = array( "name" => "Select Paragraph Font weight",
					"desc" => "Default is 100",
					"id" => "pweight",
					"std" => "100",
					"type" => "select",
					"options" => $font_weight);							
						
					
$of_options[] = array( 	"name" 		=> "Select Paragraph Font Color",
						"desc" 		=> "Pick a background color for p (default: #222222).",
						"id" 		=> "pcolor",
						"std" 		=> "#222222",
						"type" 		=> "color"
				);		
				
	

$of_options[] = array( "name" => "Select Breadcrumb Font Size (px)",
					"desc" => "Default is 13",
					"id" => "breadfontsize",
					"std" => "13",
					"type" => "select",
					"options" => $font_sizes);	

$of_options[] = array( "name" => "Select Breadcrumb Font weight",
					"desc" => "Default is 100",
					"id" => "breadfontweight",
					"std" => "100",
					"type" => "select",
					"options" => $font_weight);		
					

$of_options[] = array( 	"name" 		=> "Select Breadcrumb Font Color",
						"desc" 		=> "Pick a background color for the Breadcrumb (default: #000).",
						"id" 		=> "breadfontcolor",
						"std" 		=> "#000",
						"type" 		=> "color"
				);						
				
							

$of_options[] = array( "name" => "Select Menu Font",
					"desc" => "Select a font family for Menu",
					"id" => "menufont",
					"std" => "HelveticaLTStdLight",
					"type" => "select",
					"options" => $google_fonts);	

$of_options[] = array( "name" => "Select Menu Font Size (px)",
					"desc" => "Default is 13",
					"id" => "menufontsize",
					"std" => "13",
					"type" => "select",
					"options" => $font_sizes);	
					
						
					
$of_options[] = array( 	"name" 		=> "Select Menu Font Color",
						"desc" 		=> "Pick a background color for the Menu (default: #fafbfa).",
						"id" 		=> "menufontcolor",
						"std" 		=> "#fafbfa",
						"type" 		=> "color"
				);
$of_options[] = array( 	"name" 		=> "Select Menu Font Active Color",
						"desc" 		=> "Pick a background color for the Menu (default: #F082C2).",
						"id" 		=> "menufontAcolor",
						"std" 		=> "#F082C2",
						"type" 		=> "color"
				);	
									
$of_options[] = array( "name" => "Select Read More Font",
					"desc" => "Select a font family for Menu",
					"id" => "read_more_font",
					"std" => "HelveticaLTStdLight",
					"type" => "select",
					"options" => $google_fonts);				

$of_options[] = array( "name" => "Select Read More Font Size (px)",
					"desc" => "Default is 14",
					"id" => "readsize",
					"std" => "14",
					"type" => "select",
					"options" => $font_sizes);	
/*					
$of_options[] = array( "name" => "Select Read More Font weight",
					"desc" => "Default is 100",
					"id" => "readweight",
					"std" => "100",
					"type" => "select",
					"options" => $font_weight);	*/						
					
$of_options[] = array( 	"name" 		=> "Select Read More Font Color",
						"desc" 		=> "Pick a color for Read More (default: #f8b601).",
						"id" 		=> "readcolor",
						"std" 		=> "#f8b601",
						"type" 		=> "color"
				);	
				
			
$of_options[] = array( 	"name" 		=> "Footer Social Icon Color",
						"desc" 		=> "Pick a footer Text Color (default: #898989).",
						"id" 		=> "footersocialicons",
						"std" 		=> "#898989",
						"type" 		=> "color"
				);					
				
				
// Backup Options
$of_options[] = array( 	"name" 		=> "Backup Options",
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "datarec.png"
				);
				
$of_options[] = array( 	"name" 		=> "Backup and Restore Options",
						"id" 		=> "of_backup",
						"std" 		=> "",
						"type" 		=> "backup",
						"desc" 		=> 'You can use the two buttons below to backup your current options, and then restore it back at a later time. This is useful if you want to experiment on the options but would like to keep the old settings in case you need it back.',
				);
				
$of_options[] = array( 	"name" 		=> "Transfer Theme Options Data",
						"id" 		=> "of_transfer",
						"std" 		=> "",
						"type" 		=> "transfer",
						"desc" 		=> 'You can tranfer the saved options data between different installs by copying the text inside the text box. To import data from another install, replace the data in the text box with the one from another install and click "Import Options".',
				);
				
	}//End function: of_options()
}//End chack if function exists: of_options()
?>