<?php



/***********************************************************************************************/

/* Attribution: http://wp.tutsplus.com/tutorials/theme-development/adaptive-blog-theme-singles-authors-and-comments/

/***********************************************************************************************/





/* Prevent the direct loading of comments.php */



if (!empty($_SERVER['SCRIPT-FILENAME']) && basename($_SERVER['SCRIPT-FILENAME']) == 'comments.php') {

	die(__('You cannot access this page directly.', 'oft_theme'));

}





/* If we have comments to display, we display them */



if (have_comments()) : ?>

		<a href="#respond" class="article-add-comment"></a>

		<h1><?php comments_number(__('No Comments', 'oft_theme'), __('One Comment', 'oft_theme'), __('% Comments', 'oft_theme')); ?></h1>



		<ol class="commentslist">

			<?php wp_list_comments('callback=oft_comments'); ?>

		</ol>



		<?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>

		

			<div class="comment-nav-section clearfix">

			

				<p class="fl"><?php previous_comments_link(__( 'Older Comments', 'oft_theme')); ?></p>

				<p class="fr"><?php next_comments_link(__( 'Newer Comments ', 'oft_theme')); ?></p>

				

			</div> <!-- end comment-nav-section -->

		

		<?php endif; ?>



<?php



/* If we don't have comments and the comments are closed, display a text */



	elseif (!comments_open() && !is_page() && post_type_supports(get_post_type(), 'comments')) : ?>

	

<?php endif; 



/* Display the comment form */



comment_form();



?>