<?php

/**

 * This file is inspired by symple Shortcodes Plugin

 Fusionpress added many shortcodes to enhance the fuctionality

 * @package symple Shortcodes Plugin

 * @since 1.0

 * @author AJ Clarke : http://wpexplorer.com

 * @copyright Copyright (c) 2012, AJ Clarke

 * @link http://wpexplorer.com

 * @License: GNU General Public License version 2.0

 * @License URI: http://www.gnu.org/licenses/gpl-2.0.html

 */



 

 /*

 * Remove P tags from shortcodes

 * @since v1.0

 */

 

 function oft_shortcodes_structured($content) {

	$block = join("|",array( "fusion_clear_floats","fusion_callout","fusion_skillbar","fusion_spacing","fusion_social","fusion_highlight","fusion_button","fusion_box","fusion_testimonial","fusion_column","fusion_toggle","fusion_accordion","fusion_accordion_section","fusion_tabgroup","fusion_tab","fusion_pricing_table","fusion_pricing","fusion_heading","fusion_googlemap","fusion_divider","fusion_display_posts","fusion_display_posts_portfolio","fusion_opentestimonial","fusion_testimonials","fusion_closetestimonial","fusion_openslider","fusion_sliders","fusion_closeslider","fusion_title","fusion_review","fusion_div_wrapper","fusion_heading","icon","fusion_iconcolumn","fusion_iconcolumnside","fusion_iconcolumnstyle1","unordered_list","full_width_div_with_border","full_width_div_with_shadow","contact_details","fusion_titleside","animation_fadeinleftbig","animation_fadeinleft","animation_fadeinrightbig","animation_fadeinright","animation_fadeinup","animation_fadeindown","animation_bouncein","animation_pulse",));



	// opening tag

	$rep = preg_replace("/(<p>)?\[($block)(\s[^\]]+)?\](<\/p>|<br \/>)?/","[$2$3]",$content);



	// closing tag

	$rep = preg_replace("/(<p>)?\[\/($block)](<\/p>|<br \/>)/","[/$2]",$rep);



	return $rep;

}



add_filter('the_content', 'oft_shortcodes_structured');

add_filter('widget_text', 'oft_shortcodes_structured');





/*

 * Allow shortcodes in widgets

 * @since v1.0

 */





/*

 * Fix Shortcodes

 * @since v1.0*/

 

if( !function_exists('fusion_fix_shortcodes') ) {

	function fusion_fix_shortcodes($content){   

		$array = array (

			'<p>[' => '[', 

			']</p>' => ']', 

			']<br />' => ']'

		);

		$content = strtr($content, $array);

		return $content;

	}

	add_filter('the_content', 'fusion_fix_shortcodes',10);

}





/*

 * Clear Floats

 * @since v1.0

 */

if( !function_exists('fusion_clear_floats_shortcode') ) {

	function fusion_clear_floats_shortcode() {

	   return '<div class="fusion-clear-floats"></div>';

	}

	add_shortcode( 'fusion_clear_floats', 'fusion_clear_floats_shortcode' );

}





/*

 * callout

 * @since v1.4

 */

if( !function_exists('fusion_callout_shortcode') ) {

	function fusion_callout_shortcode( $atts, $content = NULL  ) {		

		extract( shortcode_atts( array(

			'caption' => '',

			'button_text' => '',

			'button_color' => 'blue',

			'button_url' => 'http://www.yoursite.com',

			'button_rel' => 'nofollow',

			'button_target' => 'blank',

			'button_border_radius' => '',

			'class' => '',

			'icon_left' => '',

			'icon_right' => ''

		), $atts ) );

		

		$border_radius_style = ( $button_border_radius ) ? 'style="border-radius:'. $button_border_radius .'"' : NULL;

		$output = '<div class="fusion-callout fusion-clearfix '. $class .'">';

		$output .= '<div class="fusion-callout-caption">';

			if ( $icon_left ) $output .= '<span class="fusion-callout-icon-left icon-'. $icon_left .'"></span>';

			$output .= do_shortcode ( $content );

			if ( $icon_right ) $output .= '<span class="fusion-callout-icon-right icon-'. $icon_right .'"></span>';

		$output .= '</div>';	

		if ( $button_text !== '' ) {

			$output .= '<div class="fusion-callout-button">';

				$output .='<a href="'. $button_url .'" title="'. $button_text .'" target="_'. $button_target .'" class="fusion-button '.$button_color .'" '. $border_radius_style .'><span class="fusion-button-inner">'. $button_text .'</span></a>';

			$output .='</div>';

		}

		$output .= '</div>';

		

		return $output;

	}

	add_shortcode( 'fusion_callout', 'fusion_callout_shortcode' );

}



/*

 * full width callout

 * @since v1.4

 */

if( !function_exists('fusion_callout_fullwidth_shortcode') ) {

	function fusion_callout_fullwidth_shortcode( $atts, $content = NULL  ) {		

		extract( shortcode_atts( array(

			'caption' => '',

			'button_text' => '',

			'button_color' => 'blue',

			'button_url' => 'http://www.yoursite.com',

			'button_rel' => 'nofollow',

			'button_target' => 'blank',

			'button_border_radius' => '',

			'class' => '',

			'icon_left' => '',

			'icon_right' => ''

		), $atts ) );

		

		$border_radius_style = ( $button_border_radius ) ? 'style="border-radius:'. $button_border_radius .'"' : NULL;

		$output = '<div class="fusion-callout fusion-clearfix '. $class .'">';

		$output .= '<div class="fusion-callout-fullwidthcaption">';

			if ( $icon_left ) $output .= '<span class="fusion-callout-icon-left icon-'. $icon_left .'"></span>';

			$output .= do_shortcode ( $content );

			if ( $icon_right ) $output .= '<span class="fusion-callout-icon-right icon-'. $icon_right .'"></span>';

		$output .= '</div>';	

		if ( $button_text !== '' ) {

			$output .= '<div class="fusion-callout-button">';

				$output .='<a href="'. $button_url .'" title="'. $button_text .'" target="_'. $button_target .'" class="fusion-button '.$button_color .'" '. $border_radius_style .'><span class="fusion-button-inner">'. $button_text .'</span></a>';

			$output .='</div>';

		}

		$output .= '</div>';

		

		return $output;

	}

	add_shortcode( 'fusion_callout_fullwidth', 'fusion_callout_fullwidth_shortcode' );

}





/*

 * Skillbars

 * @since v1.3

 */

if( !function_exists('fusion_skillbar_shortcode') ) {

	function fusion_skillbar_shortcode( $atts  ) {		

		extract( shortcode_atts( array(

			'title' => '',

			'percentage' => '100',

			'color' => '#6adcfa',

			'class' => '',

			'show_percent' => 'true'

		), $atts ) );

		

		// Enqueue scripts

		wp_enqueue_script('fusion_skillbar');

		

		// Display the accordion	';

		$output = '<div class="fusion-skillbar fusion-clearfix '. $class .'" data-percent="'. $percentage .'%">';

			if ( $title !== '' ) $output .= '<div class="fusion-skillbar-title" style="background: '. $color .';"><span>'. $title .'</span></div>';

			$output .= '<div class="fusion-skillbar-bar" style="background: '. $color .';"></div>';

			if ( $show_percent == 'true' ) {

				$output .= '<div class="fusion-skill-bar-percent">'.$percentage.'%</div>';

			}

		$output .= '</div>';

		

		return $output;

	}

	add_shortcode( 'fusion_skillbar', 'fusion_skillbar_shortcode' );

}





/*

 * Spacing

 * @since v1.0

 */

if( !function_exists('fusion_spacing_shortcode') ) {

	function fusion_spacing_shortcode( $atts ) {

		extract( shortcode_atts( array(

			'size' => '20px',

			'class' => '',

		  ),

		  $atts ) );

	 return '<hr class="fusion-spacing '. $class .'" style="height: '. $size .'" />';

	}

	add_shortcode( 'fusion_spacing', 'fusion_spacing_shortcode' );

}





/**

* Social Icons

* @since 1.0

*/

if( !function_exists('fusion_social_shortcode') ) {

	function fusion_social_shortcode( $atts ){   

		extract( shortcode_atts( array(

			'icon' => 'skype',

			'url' => 'http://www.twitter.com/fusionplorer',

			'title' => 'Follow Us',

			'target' => 'self',

			'rel' => '',

			'border_radius' => '',

			'class' => '',

		), $atts ) );

		

		return '<a href="' . $url . '" class="fusion-social-icon '. $class .'" target="_'.$target.'" title="'. $title .'" rel="'. $rel .'"

><img src="'. get_template_directory_uri() .'/functions/fusion-shortcodes/includes/images/social/'. $icon .'.png" alt="'. $icon .'" /></a>';

	}

	add_shortcode('fusion_social', 'fusion_social_shortcode');

}



/**

* Highlights

* @since 1.0

*/

if ( !function_exists( 'fusion_highlight_shortcode' ) ) {

	function fusion_highlight_shortcode( $atts, $content = null ) {

		extract( shortcode_atts( array(

			'color' => 'yellow',

			'class' => '',

		  ),

		  $atts ) );

		  return '<span class="fusion-highlight fusion-highlight-'. $color .' '. $class .'">' . do_shortcode( $content ) . '</span>';



	

	}

	add_shortcode('fusion_highlight', 'fusion_highlight_shortcode');

}





/*

 * Buttons

 * @since v1.0

 */

if( !function_exists('fusion_button_shortcode') ) {

	function fusion_button_shortcode( $atts, $content = null ) {

		extract( shortcode_atts( array(

			'color' => 'blue',

			'url' => 'http://www.yoursite.com',

			'title' => 'Visit Site',

			'target' => 'self',

			'rel' => '',

			'border_radius' => '',

			'class' => '',

			'icon_left' => '',

			'icon_right' => ''

		), $atts ) );

		

		

		$border_radius_style = ( $border_radius ) ? 'style="border-radius:'. $border_radius .'"' : NULL;		

		$rel = ( $rel ) ? 'rel="'.$rel.'"' : NULL;

		

		$button = NULL;

		$button .= '<a href="' . $url . '" class="fusion-button ' . $color . ' '. $class .'" target="_'.$target.'" title="'. $title .'" '. $border_radius_style .' '. $rel .'>';

			$button .= '<span class="fusion-button-inner" '.$border_radius_style.'>';

				if ( $icon_left ) $button .= '<span class="fusion-button-icon-left icon-'. $icon_left .'"></span>';

				$button .= $content;

				if ( $icon_right ) $button .= '<span class="fusion-button-icon-right icon-'. $icon_right .'"></span>';

			$button .= '</span>';			

		$button .= '</a>';

		return $button;

	}

	add_shortcode('fusion_button', 'fusion_button_shortcode');

}



/*

 * Custom Buttons

 * @since v1.0

 */

if( !function_exists('fusion_custom_button_shortcode') ) {

	function fusion_custom_button_shortcode( $atts, $content = null ) {

		extract( shortcode_atts( array(

			'color' => '',

			'url' => 'http://www.yoursite.com',

			'title' => 'Visit',

			'target' => 'self',

			'rel' => '',

			'font' => 'Bitter',

			'fontcolor'=>'',

			'bordercolor'=>'',

			'class' => '',

			'icon_left' => '',

			'icon_right' => ''

		), $atts ) );

		

		

		$button .= '<a href="' . $url . '" class="custom-button" target="_'.$target.'" title="'. $title .'" '. $border_radius_style .' '. $rel .' style="background:'.$color.';font-family:'.$font.';color:'.$fontcolor.';border-color:'.$bordercolor.';border-style: solid ;border-width: 2px ;padding: 15px 40px; border-radius: 3px;text-decoration: none;">';

			$button .= '<span class="fusion-button-inner" '.$border_radius_style.'>';

				if ( $icon_left ) $button .= '<span class="fusion-button-icon-left icon-'. $icon_left .'"></span>';

				$button .= $content;

				if ( $icon_right ) $button .= '<span class="fusion-button-icon-right icon-'. $icon_right .'"></span>';

			$button .= '</span>';			

		$button .= '</a>';

		return $button;

	}

	add_shortcode('fusion_custom_button', 'fusion_custom_button_shortcode');

}



/*

 * Boxes

 * @since v1.0

 *

 */

if( !function_exists('fusion_box_shortcode') ) { 

	function fusion_box_shortcode( $atts, $content = null ) {

		extract( shortcode_atts( array(

			'color' => 'gray',

			'float' => 'center',

			'text_align' => 'left',

			'width' => '100%',

			'margin_top' => '',

			'margin_bottom' => '',

			'class' => '',

		  ), $atts ) );

		  

			$style_attr = '';

			if( $margin_bottom ) {

				$style_attr .= 'margin-bottom: '. $margin_bottom .';';

			}

			if ( $margin_top ) {

				$style_attr .= 'margin-top: '. $margin_top .';';

			}

		  

		  $alert_content = '';

		  $alert_content .= '<div class="fusion-box ' . $color . ' '.$float.' '. $class .'" style="text-align:'. $text_align .'; width:'. $width .';'. $style_attr .'">';

		  $alert_content .= ' '. do_shortcode($content) .'</div>';

		  return $alert_content;

	}

	add_shortcode('fusion_box', 'fusion_box_shortcode');

}







/*

 * Testimonial

 * @since v1.0

 *

 */

if( !function_exists('fusion_testimonial_shortcode') ) { 

	function fusion_testimonial_shortcode( $atts, $content = null  ) {

		extract( shortcode_atts( array(

			'by' => '',

			'class' => '',

		  ), $atts ) );

		$testimonial_content = '';

		$testimonial_content .= '<div class="fusion-testimonial '. $class .'"><div class="fusion-testimonial-content">';

		$testimonial_content .= $content;

		$testimonial_content .= '</div><div class="fusion-testimonial-author">';

		$testimonial_content .= $by .'</div></div>';	

		return $testimonial_content;

	}

	add_shortcode( 'fusion_testimonial', 'fusion_testimonial_shortcode' );

}



/*

 * Columns

 * @since v1.0

 *

 */

if( !function_exists('fusion_column_shortcode') ) {

	function fusion_column_shortcode( $atts, $content = null ){

		extract( shortcode_atts( array(

			'size' => 'one-third',

			'position' =>'first',

			'class' => '',

		  ), $atts ) );

		  return '<div class="fusion-column fusion-' . $size . ' fusion-column-'.$position.' '. $class .'">' . do_shortcode($content) . '</div>';

	}

	add_shortcode('fusion_column', 'fusion_column_shortcode');

}







/*

 * Toggle

 * @since v1.0

 */

if( !function_exists('fusion_toggle_shortcode') ) {

	function fusion_toggle_shortcode( $atts, $content = null ) {

		extract( shortcode_atts( array(

			'title' => 'Toggle Title',

			'class' => '',

		), $atts ) );

		 

		// Enque scripts

		wp_enqueue_script('fusion_toggle');

		

		// Display the Toggle

		return '<div class="fusion-toggle '. $class .'"><h3 class="fusion-toggle-trigger">'. $title .'</h3><div class="fusion-toggle-container">' . do_shortcode($content) . '</div></div>';

	}

	add_shortcode('fusion_toggle', 'fusion_toggle_shortcode');

}





/*

 * Accordion

 * @since v1.0

 *

 */



// Main

if( !function_exists('fusion_accordion_main_shortcode') ) {

	function fusion_accordion_main_shortcode( $atts, $content = null  ) {

		

		extract( shortcode_atts( array(

			'class' => ''

		), $atts ) );

		

		// Enque scripts

		wp_enqueue_script('jquery-ui-accordion');

		wp_enqueue_script('fusion_accordion');

		

		// Display the accordion	

		return '<div class="fusion-accordion '. $class .'">' . do_shortcode($content) . '</div>';

	}

	add_shortcode( 'fusion_accordion', 'fusion_accordion_main_shortcode' );

}





// Section

if( !function_exists('fusion_accordion_section_shortcode') ) {

	function fusion_accordion_section_shortcode( $atts, $content = null  ) {

		extract( shortcode_atts( array(

			'title' => 'Title',

			'class' => '',

		), $atts ) );

		  

	   return '<h3 class="fusion-accordion-trigger '. $class .'"><a href="#">'. $title .'</a></h3><div>' . do_shortcode($content) . '</div>';

	}

	

	add_shortcode( 'fusion_accordion_section', 'fusion_accordion_section_shortcode' );

}





/*

 * Tabs

 * @since v1.0

 *

 */

if (!function_exists('fusion_tabgroup_shortcode')) {

	function fusion_tabgroup_shortcode( $atts, $content = null ) {

		

		//Enque scripts

		wp_enqueue_script('jquery-ui-tabs');

		wp_enqueue_script('fusion_tabs');

		

		// Display Tabs

		$defaults = array();

		extract( shortcode_atts( $defaults, $atts ) );

		preg_match_all( '/tab title="([^\"]+)"/i', $content, $matches, PREG_OFFSET_CAPTURE );

		$tab_titles = array();

		if( isset($matches[1]) ){ $tab_titles = $matches[1]; }

		$output = '';

		if( count($tab_titles) ){

		    $output .= '<div id="fusion-tab-'. rand(1, 100) .'" class="fusion-tabs">';

			$output .= '<ul class="ui-tabs-nav fusion-clearfix">';

			foreach( $tab_titles as $tab ){

				$output .= '<li><a href="#fusion-tab-'. sanitize_title( $tab[0] ) .'">' . $tab[0] . '</a></li>';

			}

		    $output .= '</ul>';

		    $output .= do_shortcode( $content );

		    $output .= '</div>';

		} else {

			$output .= do_shortcode( $content );

		}

		return $output;

	}

	add_shortcode( 'fusion_tabgroup', 'fusion_tabgroup_shortcode' );

}

if (!function_exists('fusion_tab_shortcode')) {

	function fusion_tab_shortcode( $atts, $content = null ) {

		$defaults = array(

			'title' => 'Tab',

			'class' => ''

		);

		extract( shortcode_atts( $defaults, $atts ) );

		return '<div id="fusion-tab-'. sanitize_title( $title ) .'" class="tab-content '. $class .'">'. do_shortcode( $content ) .'</div>';

	}

	add_shortcode( 'fusion_tab', 'fusion_tab_shortcode' );

}









/*

 * Pricing Table

 * @since v1.0

 *

 */

 

/*main*/

if( !function_exists('fusion_pricing_table_shortcode') ) {

	function fusion_pricing_table_shortcode( $atts, $content = null  ) {

		extract( shortcode_atts( array(

			'class' => ''

		), $atts ) );

		return '<div class="fusion-pricing-table '. $class .'">' . do_shortcode($content) . '</div><div class="fusion-clear-floats"></div>';

	}

	add_shortcode( 'fusion_pricing_table', 'fusion_pricing_table_shortcode' );	

}



/*section*/

if( !function_exists('fusion_pricing_shortcode') ) {

	function fusion_pricing_shortcode( $atts, $content = null  ) {

		

		extract( shortcode_atts( array(

			'size' => 'one-half',

			'position' => '',

			'featured' => 'no',

			'plan' => 'Basic',

			'cost' => '$20',

			'per' => 'month',

			'button_url' => '',

			'button_text' => 'Purchase',

			'button_color' => 'blue',

			'button_target' => 'self',

			'button_rel' => 'nofollow',

			'button_border_radius' => '',

			'class' => '',

			'header_bg_color'=>'',

			'icon'=>'',

			'iconcolor'=>'',

		), $atts ) );

		

		//set variables

		$featured_pricing = ( $featured == 'yes' ) ? 'featured' : NULL;

		$border_radius_style = ( $button_border_radius ) ? 'style="border-radius:'. $button_border_radius .'"' : NULL;

		

		//start content  

		$pricing_content ='';

		$pricing_content .= '<div class="fusion-pricing fusion-'. $size .' '. $featured_pricing .' fusion-column-'. $position. ' '. $class .'">';

			$pricing_content .= '<div class="fusion-pricing-header" style= background:'. $header_bg_color .'>';			

				$pricing_content .= '<h5 style="color:#fff;">'. $plan. '</h5>';

				$pricing_content .= '<i class="fa '.$icon.'" style="font-size:90px;color:'.$iconcolor.';"></i>';

				$pricing_content .= '<div class="fusion-pricing-cost">'. $cost .'</div><div class="fusion-pricing-per">'. $per .'</div>';

			$pricing_content .= '</div>';

			$pricing_content .= '<div class="fusion-pricing-content">';

				$pricing_content .= ''. $content. '';

			$pricing_content .= '</div>';

			if( $button_url ) {

				$pricing_content .= '<div class="fusion-pricing-button"><a href="'. $button_url .'" class="fusion-button '. $button_color .'" target="_'. $button_target .'" rel="'. $button_rel .'" '. $border_radius_style .'><span class="fusion-button-inner" '. $border_radius_style .'>'. $button_text .'</span></a></div>';

			}

		$pricing_content .= '</div>';  

		return $pricing_content;

	}

	

	add_shortcode( 'fusion_pricing', 'fusion_pricing_shortcode' );

}









/************************

 *

 * Version 1.1 Additions

 *

*************************/







/*

 * Heading

 * @since v1.1

 

if( !function_exists('fusion_heading_shortcode') ) {

	function fusion_heading_shortcode( $atts ) {

		extract( shortcode_atts( array(

			'title' => 'Sample Heading',

			'type' => 'h2',

			'margin_top' => '',

			'margin_bottom' => '',

			'text_align' => '',

			'font_size' => '',

			'color' => '',

			'class' => '',

			'icon_left' => '',

			'icon_right' => ''

		  ),

		  $atts ) );

		  

		$style_attr = '';

		if ( $font_size ) {

			$style_attr .= 'font-size: '. $font_size .';';

		}

		if ( $color ) {

			$style_attr .= 'color: '. $color .';';

		}

		if( $margin_bottom ) {

			$style_attr .= 'margin-bottom: '. $margin_bottom .';';

		}

		if ( $margin_top ) {

			$style_attr .= 'margin-top: '. $margin_top .';';

		}

		

		if ( $text_align ) {

			$text_align = 'text-align-'. $text_align;

		} else {

			$text_align = 'text-align-left';

		}

		

	 	$output = '<'.$type.' class="fusion-heading '. $text_align .' '. $class .'" style="'.$style_attr.'"><span>';

		if ( $icon_left ) $output .= '<i class="fusion-button-icon-left icon-'. $icon_left .'"></i>';

			$output .= $title;

		if ( $icon_right ) $output .= '<i class="fusion-button-icon-right icon-'. $icon_right .'"></i>';

		$output .= '</'.$type.'></span>';

		

		return $output;

	}

	add_shortcode( 'fusion_heading', 'fusion_heading_shortcode' );

}*/





/*

 * Google Maps

 * @since v1.1

 */

if (! function_exists( 'fusion_shortcode_googlemaps' ) ) :

	function fusion_shortcode_googlemaps($atts, $content = null) {

		

		extract(shortcode_atts(array(

				'title' => '',

				'location' => '',

				'width' => '', //leave width blank for responsive designs

				'height' => '300',

				'zoom' => 8,

				'align' => '',

				'class' => '',

		), $atts));

		

		// load scripts

		wp_enqueue_script('symple_googlemap');

		wp_enqueue_script('symple_googlemap_api');

		

		

		$output = '<div id="map_canvas_'.rand(1, 100).'" class="googlemap '. $class .'" style="height:'.$height.'px;width:100%">';

			$output .= (!empty($title)) ? '<input class="title" type="hidden" value="'.$title.'" />' : '';

			$output .= '<input class="location" type="hidden" value="'.$location.'" />';

			$output .= '<input class="zoom" type="hidden" value="'.$zoom.'" />';

			$output .= '<div class="map_canvas"></div>';

		$output .= '</div>';

		

		return $output;

	   

	}

	add_shortcode("fusion_googlemap", "fusion_shortcode_googlemaps");

endif;





/*

 * Divider

 * @since v1.1

 */

if( !function_exists('fusion_divider_shortcode') ) {

	function fusion_divider_shortcode( $atts ) {

		extract( shortcode_atts( array(

			'style' => 'fadeout',

			'margin_top' => '20px',

			'margin_bottom' => '20px',

			'class' => '',

		  ),

		  $atts ) );

		$style_attr = '';

		if ( $margin_top && $margin_bottom ) {  

			$style_attr = 'style="margin-top: '. $margin_top .';margin-bottom: '. $margin_bottom .';"';

		} elseif( $margin_bottom ) {

			$style_attr = 'style="margin-bottom: '. $margin_bottom .';"';

		} elseif ( $margin_top ) {

			$style_attr = 'style="margin-top: '. $margin_top .';"';

		} else {

			$style_attr = NULL;

		}

	 return '<hr class="fusion-divider '. $style .' '. $class .'" '.$style_attr.' />';

	}

	add_shortcode( 'fusion_divider', 'fusion_divider_shortcode' );

}



/*

 * Display Blog post







add_shortcode('fusion_display_posts', 'be_display_posts_shortcode');



function be_display_posts_shortcode($atts) {



global $data;



extract( shortcode_atts( array(

'tag' => '',

'category' =>'',

'posts_per_page' => '3',

'include_date' =>'',

'order' => 'DESC',

'orderby' => 'date',

'image_size' => '',

'include_excerpt' => '',

'defaultimage'=>''.do_shortcode(stripslashes($data['blog_image'])).''

), $atts ) );



$args = array(

'tag' => $tag,

'category_name' => $category,

'posts_per_page' => $posts_per_page,

'order' => $order,

'orderby' => $orderby

);

$return = '';

$listing = new WP_Query($args);

if ( $listing->have_posts() ):

$return .= '';

while ( $listing->have_posts() ): $listing->the_post(); global $post;

if($atts['posts_per_page'] == 4)

{

$return .= '<section class="fourcol"> ';

}

else if($atts['posts_per_page'] == 3)

{

$return .= '<section class="threecol"> ';	

}

else if($atts['posts_per_page'] == 2)

{

$return .= '<section class="twocol"> ';	

}

else {

$return .= '<section class="onecol"> ';	

}



if(get_the_post_thumbnail($post->ID, $image_size) != '')	

$return .= '<a href="'. get_permalink().'">'. get_the_post_thumbnail($post->ID, $image_size).'</a>';

else

$return .= '<a href="'. get_permalink().'"><img src="'. do_shortcode(stripslashes($data['blog_image'])) .'" class="attachment-bloghome-thumb wp-post-image" width="296px" height="160px" alt="" ></a>';



$return .= '<h2 style="padding: 10px 0px">'. get_the_title() .'</h2>';

if ($include_excerpt) $return .='<p class="Justify">'. get_the_excerpt() .'</p>';

if ($include_date) $return .= ' ('. get_the_date('n/j/Y') .')';

$return .= '</section>';

endwhile;

$return .= '';



endif; wp_reset_query();

if (!empty($return)) return $return;

}*/ 

/*

 * Display Portfolio

*/ 



add_shortcode('fusion_display_posts_portfolio', 'be_display_posts_portfolio_shortcode');



function be_display_posts_portfolio_shortcode($atts) {



global $data;



extract( shortcode_atts( array(

'tag' => '',

'category' =>'',

'posts_per_page' => '10',

'post_type' => 'portfolio',

'include_date' =>'',

'order' => 'DESC',

'orderby' => 'date',

'image_size' => '',

'include_excerpt' => '',

), $atts ) );

$args = array(

'tag' => $tag,

'category_name' => $category,

'post_type' =>  'portfolio' ,

'posts_per_page' => $posts_per_page,

'order' => $order,

'orderby' => $orderby

);

$return = '';

$listing = new WP_Query($args);

if ( $listing->have_posts() ):

$return .= '';
$lear=0;
while ( $listing->have_posts() ): $listing->the_post(); global $post;
$lear++;
$return .= '<section class="portfolio-threecol">';



$large_image =  wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'fullsize', false, '' ); 

$large_image = $large_image[0]; 



if ($image_size) $return .= '<a rel="prettyPhoto[gallery]" href="'. $large_image .'">'. get_the_post_thumbnail($post->ID, $image_size).'</a>';



$return .= '<h2 style="text-align:center;padding: 15px 0px 0px 0px; font-size: 15px"><a style="text-decoration:none" href="'. get_permalink().'">'. get_the_title() .'</a></h2>';



if ($include_excerpt) $return .=''. get_the_excerpt() .'';

if ($include_date) $return .= ' ('. get_the_date('n/j/Y') .')';

$return .= '</section>';
if($lear%3==0){

$return .= '<div style="clear:both;"></div>';
}


endwhile;

$return .= '';

endif; wp_reset_query();

if (!empty($return)) return $return;

}



/*

 * Testimonial slider Shortcode

 */

 

add_shortcode('fusion_opentestimonial', 'opentestimonials');



function opentestimonials($atts) {

extract( shortcode_atts( array(

'description' =>'',

'name' => '',

'fontsize'=>'',



), $atts ) );



$returns = '<ul class="bxslider">';

return $returns;

}



add_shortcode('fusion_testimonials', 'testimonials');



function testimonials($atts) {

extract( shortcode_atts( array(

'description' =>'',

'name' => '',

'fontcolor'=>'',

), $atts ) );



$returns = '<li>';

$returns .= '<p style="color:'.$fontcolor.';text-align:center; font-size: 25px;line-height: 30px;">'.$description. '</p>';

$returns .= '<h3 align="center" style="font-size:15px; color:'.$fontcolor.';">'.$name.'</h3>';

$returns .= '';

$returns .= '</li>';

return $returns;

}



add_shortcode('fusion_closetestimonial', 'closetestimonials');



function closetestimonials($atts) {

extract( shortcode_atts( array(

'description' =>'',

'name' => ''

), $atts ) );

$returns = '</ul>';

return $returns;



}

/*

 * Image slider

 *

 



add_shortcode('fusion_openslider', 'openslider');



function openslider($atts) {

extract( shortcode_atts( array(

'description' =>'',

'name' => ''

), $atts ) );



$returns = '<ul class="bxslider">';

return $returns;

}



add_shortcode('fusion_sliders', 'slider');



function slider($atts) {

extract( shortcode_atts( array(

'url' =>'',

'alt' => '',

'height' =>'',

'width' =>''

), $atts ) );



$returns = '<li>';

$returns .= '<img src="'.$url.'" width="'.$width.'" height="'.$height.'" alt="'.$alt.'" />';

$returns .= '</li>';

return $returns;

}





add_shortcode('fusion_closeslider', 'closeslider');



function closeslider($atts) {

extract( shortcode_atts( array(

'description' =>'',

'name' => ''

), $atts ) );

$returns = '</ul>';

return $returns;

}*/



/*

 * Title shortcodes

*/ 

add_shortcode('fusion_title', 'titletag');

function titletag($atts) {

extract( shortcode_atts( array(

'tag' =>'',

'content' =>'',

'align' =>''

), $atts ) );



$returns = '';

$returns .= '<'. $tag .' align="'. $align .'">'. $content .'<'. $tag .'/>';

$returns .= '';

return $returns;

}



/*

 * Display Review posts

 

add_shortcode('fusion_review', 'reviewshortcodes');



function reviewshortcodes($atts) {

	

global $data;		

	

extract( shortcode_atts( array(

'tag' => '',

'category' =>'',

'post_type'=>'cptreviews',

'posts_per_page' => '3',

'include_date' =>'',

/*'name' => '', */

/*'order' => 'DESC',

'orderby' => 'date',

'image_size' => '',

'include_excerpt' => '',

), $atts ) );

$args = array(

'tag' => $tag,

'post_type' => $post_type,

'category_name' => $category,

/*'name' => $name,*/

/*'posts_per_page' => $posts_per_page,

'order' => $order,

'orderby' => $orderby

);

$return = '';

$listing = new WP_Query($args);

if ( $listing->have_posts() ):

$return .= '';

while ( $listing->have_posts() ): $listing->the_post(); global $post;

if($atts['posts_per_page'] == 4)

{

$return .= '<section class="fourcol"> ';

}

else if($atts['posts_per_page'] == 3)

{

$return .= '<section class="threecol"> ';	

}

else if($atts['posts_per_page'] == 2)

{

$return .= '<section class="twocol"> ';	

}

else {

$return .= '<section class="onecol"> ';	

}





if(get_the_post_thumbnail($post->ID, $image_size) != '')	

$return .= '<a href="'. get_permalink().'">'. get_the_post_thumbnail($post->ID, $image_size).'</a>';



$return .='<div class="reviewinfo" >';



$return .= '<h2>'. get_the_title() .'</h2>';



if ($include_date) $return .= ' ('. get_the_date('n/j/Y') .')';

   

$return .='<b>'. esc_html( get_post_meta( get_the_ID(), 'setrtitlename', true ) ) .'';

$return .=''. esc_html( get_post_meta( get_the_ID(), 'setrtitle', true ) ) .'</b><br>';



$return .='<b>'. esc_html( get_post_meta( get_the_ID(), 'setproduct_authorname', true ) ) .'';

$return .=''. esc_html( get_post_meta( get_the_ID(), 'product_author', true ) ) .'</b> <br>';



$return .='<b>'. esc_html( get_post_meta( get_the_ID(), 'product_author_lasttitle', true ) ) .''; 

$return .=''. esc_html( get_post_meta( get_the_ID(), 'product_author_last', true ) ) .'</b><br>'; 



$return .='<b>Rating: </b>';





$nb_stars = intval( get_post_meta( get_the_ID(), 'product_rating', true ) );

for ( $star_counter = 1; $star_counter <= 5; $star_counter++ ) {

	

if ( $star_counter <= $nb_stars ) {

	$return .= '<img src="'. get_template_directory_uri() .'/inc/reviews/icon.png" />';

} else {

	$return .= '<img src="' .get_template_directory_uri() .'/inc/reviews/grey.png" />';

}

} 



$return .='</div>';



if ($include_excerpt) $return .='<p class="Justify">'. get_the_excerpt() .'</p>';



$return .= '</section>';

endwhile;

$return .= '';



endif; wp_reset_query();

if (!empty($return)) return $return;

}



/*

Div wraper







if( !function_exists('fusion_div_wrapper_shortcode') ) {

	function fusion_div_wrapper_shortcode( $atts, $content = null  ) {

		extract( shortcode_atts( array(

			'class' => '',

			'width' => '',

		), $atts ) );

		return '<div class="fusion-div-wrapper" style="width: '. $width .';">' . do_shortcode($content) . '</div><div class="fusion-clear-floats"></div>';

	}

	add_shortcode( 'fusion_div_wrapper', 'fusion_div_wrapper_shortcode' );

	

}*/



/*-----------------------------------------------------------------------------------*/

/* Heading Styles

/*-----------------------------------------------------------------------------------*/	





function oft_fusion_heading( $atts, $content = null){



	extract( shortcode_atts(array(

        "style" => '',        

		"fontsize" => '',

		"fontweight" => '',

		"color" => '',

    ), $atts) ); 



	if ( $style == '1') {

		$fusion_heading = '<div class="clearfix aligncenter"><div class="fusion_heading1"><h2 style="font-size: '. $fontsize .';font-weight: '. $fontweight .';color: '. $color .'">'. do_shortcode($content) . '</h2></div></div>';

	}

	else if ( $style == '3')  {

		$fusion_heading = '<div class="clearfix aligncenter"><div class="fusion_heading3"><h2 style="font-size: '. $fontsize .';font-weight: '. $fontweight .';color: '. $color .'">'. do_shortcode($content) . '</h2></div></div>';

	}

	else if ( $style == '2')  {

		$fusion_heading = '<div class="clearfix aligncenter"><div class="fusion_heading2"><h2 style="font-size: '. $fontsize .';font-weight: '. $fontweight .';color: '. $color .'">'. do_shortcode($content) . '</h2></div></div>';

	}

	else if ( $style == '4')  {

		$fusion_heading = '<div class="clearfix aligncenter"><div class="fusion_heading4"><h2 style="font-size: '. $fontsize .';font-weight: '. $fontweight .';color: '. $color .'">'. do_shortcode($content) . '</h2></div></div>';

	}

	else  {

		$fusion_heading = '<div class="clearfix aligncenter"><div class="fusion_heading"><h2 style="font-size: '. $fontsize .';font-weight: '. $fontweight .';color: '. $color .'">'. do_shortcode($content) . '</h2></div></div>';

		

	}

	return $fusion_heading;

}



add_shortcode('fusion_heading', 'oft_fusion_heading');





/*-----------------------------------------------------------------------------------*/

/* Font awesome shortcodes

/*-----------------------------------------------------------------------------------



function addsFontAwesome($atts) {

    extract(shortcode_atts(array(

    'type'  => '',

    'size' => '',



    'rotate' => '',

    'flip' => '',

    'pull' => '',

    'animated' => '',

	'color'=> '',

	'bordercolor'=> '',

 

    ), $atts));

     

    $type = ($type) ? 'icon-'.$type. '' : 'icon-star';

    $size = ($size) ? 'icon-'.$size. '' : '';

    $rotate = ($rotate) ? 'icon-rotate-'.$rotate. '' : '';

    $flip = ($flip) ? 'icon-flip-'.$flip. '' : '';

    $pull = ($pull) ? 'pull-'.$pull. '' : '';

    $animated = ($animated) ? 'icon-spin' : '';

   

    $theAwesomeFont = '<div class="iconwithborder" style="border-color:'.$bordercolor.'"><i class="'.sanitize_html_class($type).' '.sanitize_html_class($size).' '.sanitize_html_class($rotate).' '.sanitize_html_class($flip).' '.sanitize_html_class($pull).' '.sanitize_html_class($animated).'" style="color: '. $color .';"></i></div>';

     

    return $theAwesomeFont;

}*/	

 

add_shortcode('icon', 'addsFontAwesome');



/*

 * Icon Column style 1

 *





'<div class="clearfix aligncenter"><div class="fusion_heading4"><h2 style="font-size: '. $fontsize .';font-weight: '. $fontweight .';color: '. $color .'">'. do_shortcode($content) . '</h2></div></div>';



if( !function_exists('fusion_iconcolumn_shortcode') ) {

	function fusion_iconcolumn_shortcode( $atts, $content = null ){

		extract( shortcode_atts( array(

			'columnsize' => 'one-third',

			'position' =>'first',

			'class' => '',

			'type' => '',

			'size' => '',

			'iconbg' => '#ce2222',

			'iconcolor' => '#fff',

		  ), $atts ) );

		  

		  $type = ($type) ? 'icon-'.$type. '' : 'icon-star';

    	  $size = ($size) ? 'icon-'.$size. '' : '';

		  

		  $theFont= '<div class="fusion-iconcolumn fusion-' . $columnsize . ' fusion-column-'.$position.' '. $class .'"><div class="icon"><i class="'.sanitize_html_class($type).' '.sanitize_html_class($size).' "style="background:'.$iconbg .'; color:'.$iconcolor .'"></i></div>' . do_shortcode($content) . '</div>';		  

		  

		  return $theFont; 

	}

	add_shortcode('fusion_iconcolumn', 'fusion_iconcolumn_shortcode');

}

/*

 * Icon Column style 2 (Icon on left side)

 *

 

if( !function_exists('fusion_iconcolumnside_shortcode') ) {

	function fusion_iconcolumnside_shortcode( $atts, $content = null ){

		extract( shortcode_atts( array(

			'columnsize' => 'one-third',

			'position' =>'first',

			'class' => '',

			'type' => '',

			'size' => '',

			'iconbg' => '',

			'iconcolor' => '#fff',

		  ), $atts ) );

		  

		  $type = ($type) ? 'icon-'.$type. '' : 'icon-star';

    	  $size = ($size) ? 'icon-'.$size. '' : '';

		  

		  $theFont= '<div class="fusion-iconcolumnside fusion-' . $columnsize . ' fusion-column-'.$position.' '. $class .'"><div class="iconside"><i class="'.sanitize_html_class($type).' '.sanitize_html_class($size).' "style="background:'.$iconbg .'; color:'.$iconcolor .'"></i></div><div style="margin-left: 71px;height: 100%;";>' . do_shortcode($content) . '</div></div>';

		  

		  return $theFont; 

	}

	add_shortcode('fusion_iconcolumnside', 'fusion_iconcolumnside_shortcode');

}

/*

 * Icon Column style 3

 *

 

if( !function_exists('fusion_iconcolumnstyle1_shortcode') ) {

	function fusion_iconcolumnstyle1_shortcode( $atts, $content = null ){

		extract( shortcode_atts( array(

			'columnsize' => 'one-third',

			'position' =>'first',

			'class' => '',

			'type' => '',

			'size' => '',

			'iconbg' => '',

			'iconcolor' => '',

			'bordercolor' => '',

			), $atts ) );

		  

		  $type = ($type) ? 'icon-'.$type. '' : 'icon-star';

    	  $size = ($size) ? 'icon-'.$size. '' : '';

		  

		  $theFont= '<div class="fusion-iconcolumnstyle1 fusion-' . $columnsize . ' fusion-column-'.$position.' '. $class .'"><div class="iconwithborder" style="border-color:'.$bordercolor.'"><i class="'.sanitize_html_class($type).' '.sanitize_html_class($size).' "style="background:'.$iconbg .'; color:'.$iconcolor .';"></i></div>' . do_shortcode($content) . '</div>';

		  

		  return $theFont; 

	}

	add_shortcode('fusion_iconcolumnstyle1', 'fusion_iconcolumnstyle1_shortcode');

}*/



/*

 * Legal Pages Shortcodes



add_shortcode('privacypolicy', 'privacy');

function privacy($atts) {

 extract(shortcode_atts(array(

  	'name' => 'name',

	'address'=> 'address'

  	), $atts ));

	

  return 

  '<p>Your privacy is important to ' . $name .   ' This privacy statement provides information about the personal information that ' . $name . ' collects and the ways in which ' . $name . ' uses that personal information </p>



<h2><P><strong>Credit</strong></p></h2>



<p>This document was created using a Contractology template available at http://www.freenetlaw.com.</p>

<br>

<h2><strong>Personal information collection</strong></h2>



<P>' . $name . ' may collect and use the following kinds of personal information: 

<ul>

<li><P>information about your use of this website (including [INSERT DETAILS]);</P> </li>

<li><P>information that you provide using for the purpose of registering with the website (including [INSERT DETAILS]);</P></li>

<li><P>information about transactions carried out over this website (including [INSERT DETAILS]); </P></li>

<li><P>information that you provide for the purpose of subscribing to the website services (including [INSERT DETAILS]); and</P></li>

<li><P>any other information that you send to ' . $name .'</P></li>

<br>

<p><strong>Using personal information</strong></p>



<p>' . $name . ' may use your personal information to </p>



<li><P>administer this website;</P></li>

<li><P>personalize the website for you;</P></li>

<li><P>enable your access to and use of the website services;</P></li>

<li><P>publish information about you on the website;</P></li>

<li><P>send to you products that you purchase;</P></li>

<li><P>supply to you services that you purchase;</P></li>

<li><P>send to you statements and invoices;</P></li>

<li><P>collect payments from you; and</P></li>

<li><P>send you marketing communications.</P></li>

<p>

Where' . $name . ' discloses your personal information to its agents or sub-contractors for these purposes, the agent or sub-contractor in question will be obligated to use that personal information in accordance with the terms of this privacy statement. 

<p>

In addition to the disclosures reasonably necessary for the purposes identified elsewhere above, ' . $name . ' may disclose your personal information to the extent that it is required to do so by law, in connection with any legal proceedings or prospective legal proceedings, and in order to establish, exercise or defend its legal rights.</p>

<br>

<h2><strong>Securing your data</strong></h2>

<p>'

 . $name . ' will take reasonable technical and organisational precautions to prevent the loss, misuse or alteration of your personal information. </p>

<p>'

 . $name . ' will store all the personal information you provide [on its secure servers]. </p>

<p>

[Information relating to electronic transactions entered into via this website will be  protected by encryption technology.]</p>

<br>

<h2><strong>Cross-border data transfers</strong></h2>

<p>

Information that ' . $name . ' collects may be stored and processed in and transferred between any of the countries in which ' . $name .' operates to enable the use of the information in accordance with this privacy policy.</p>

<p>

[In addition, personal information that you submit for publication on the website will be published on the internet and may be available around the world.]</p>

<p>

You agree to such cross-border transfers of personal information.</p>

<br>

<h2><strong>Updating this statement</strong></h2>

<p>'

. $name . ' may update this privacy policy by posting a new version on this website. </p> 

<p>

You should check this page occasionally to ensure you are familiar with any changes.  </p>

<br>

<h2><strong>Other websites</strong></h2>

<p>

This website contains links to other websites.  </p>'

 ;

}



add_shortcode('webdisclaimer', 'disclaimer');



function disclaimer($atts) {

 extract(shortcode_atts(array(

  	'name' => 'name',

	  	), $atts ));

  return  '<H2><strong>TEMPLATE WEBSITE DISCLAIMER</strong></H2>

<br>

<H2><strong>Credit</strong></H2>

<p>

This document was created using a Contractology template available at http://www.freenetlaw.com.</p>

<br>

<H2><strong>No warranties</strong></H2>



<p>

This website is provided "as is" without any representations or warranties, express or implied. '   . $name .  ' makes no representations or warranties in relation to this website or the information and materials provided on this website.  </p>

<p>

Without prejudice to the generality of the foregoing paragraph, ' . $name .  ' does not warrant that:</p>

<ul>

<li><p>this website will be constantly available, or available at all; or</p></li>

<li><p>the information on this website is complete, true, accurate or non-misleading.</p></li>



<p>Nothing on this website constitutes, or is meant to constitute, advice of any kind.  [If you require advice in relation to any [legal, financial or medical] matter you should consult an appropriate professional.]</p>

<br>

<H2><strong>Limitations of liability</strong></H2> 



<li><p>' . $name . ' will not be liable to you (whether under the law of contact, the law of torts or otherwise) in relation to the contents of, or use of, or otherwise in connection with, this website:<p><li>

<ul>

<li><p>[to the extent that the website is provided free-of-charge, for any direct loss;]</p></li>

<li><p>for any indirect, special or consequential loss; or</p></li>

<li><p>for any business losses, loss of revenue, income, profits or anticipated savings, loss of contracts or business relationships, loss of reputation or goodwill, or loss or corruption of information or data.</p></li>



<p>These limitations of liability apply even if '  . $name .  ' has been expressly advised of the potential loss.</p>

<br>

<H2><strong>Exceptions</strong></H2>



<p>Nothing in this website disclaimer will exclude or limit any warranty implied by law that it would be unlawful to exclude or limit; and nothing in this website disclaimer will exclude or limit '  . $name . ' liability in respect of any:



<li><p>death or personal injury caused by '  . $name .  ' negligence;</p></li>

<li><p>fraud or fraudulent misrepresentation on the part of '  . $name . ' ; or </p></li>

<li><p>matter which it would be illegal or unlawful for '  . $name . ' to exclude or limit, or to attempt or purport to exclude or limit, its liability. </p></li>

<br>

<H2><strong>Reasonableness</strong></H2>



<p>By using this website, you agree that the exclusions and limitations of liability set out in this website disclaimer are reasonable.</p>



<p>If you do not think they are reasonable, you must not use this website.</p>

<br>

<H2><strong>Other parties</strong></H2>



<p>[You accept that, as a limited liability entity, '  . $name .  ' has an interest in limiting the personal liability of its officers and employees.  You agree that you will not bring any claim personally against '  . $name .  ' officers or employees in respect of any losses you suffer in connection with the website.]</p>



<p>[Without prejudice to the foregoing paragraph,] you agree that the limitations of warranties and liability set out in this website disclaimer will protect'  . $name .  'officers, employees, agents, subsidiaries, successors, assigns and sub-contractors as well as '  . $name . '</p>

<br>

<H2><strong>Unenforceable provisions</strong></H2>



<p>If any provision of this website disclaimer is, or is found to be, unenforceable under applicable law, that will not affect the enforceability of the other provisions of this website disclaimer.</p>



';

}

add_shortcode('copyrightnotice', 'copyright');



function copyright($atts) {

 extract(shortcode_atts(array(

  	'name' => 'name',

	'emailaddress' => 'emailaddress',

	'address' => 'address',

	'year' =>'year',

	  	), $atts ));

  return '<H2><strong>Copyright  ' .$year. ' ' . $name . '</strong></H2>

<br>

<H2><strong>Credit</strong></H2>



<p>This document was created using a Contractology template available at http://www.freenetlaw.com.</p>

<br>

<H2><strong>Ownership of copyright</strong></H2>



<p>The copyright in this website and the material on this website (including without limitation the text, computer code, artwork, photographs, images, music, audio material, video material and audio-visual material on this website) is owned by [NAME] [and its licensors].</p>

<br>

<H2><strong>Copyright license</strong></H2>



<p>' . $name . ' grants to you a worldwide non-exclusive royalty-free revocable license to:</p>

<ul>

<li><p>view this website and the material on this website on a computer or mobile device via a web browser;</p><li>

<li><p>copy and store this website and the material on this website in your web browser cache memory; and</p><li>

<li><p>print pages from this website for your own personal and non-commercial use. </p><li>

</ul> <p>'

. $name . ' does not grant you any other rights in relation to this website or the material on this website. In other words, all other rights are reserved.</p>



<p>For the avoidance of doubt, you must not adapt, edit, change, transform, publish, republish, distribute, redistribute, broadcast, rebroadcast or show or play in public this website or the material on this website (in any form or media) without '  . $name . ' prior written permission. </p>

<br>

<H2><strong>Data mining</strong></H2>



<p>The automated and/or systematic collection of data from this website is prohibited.</p>

<br>

<H2><strong>Permissions</strong></H2>



<p>You may request permission to use the copyright materials on this website by writing to ' . $emailaddress . ' or ' . $address .

'</p>

<br>

<H2><strong>Enforcement of copyright</strong></H2>



<p>' . $name .  ' takes the protection of its copyright very seriously.</p>



<p>If '  . $name . ' discovers that you have used its copyright materials in contravention of the license above, '  . $name . ' may bring legal proceedings against you seeking monetary damages and an injunction to stop you using those materials.  You could also be ordered to pay legal costs.



<p>If you become aware of any use of '  . $name . ' copyright materials that contravenes or may contravene the license above, please report this by email to ' . $emailaddress . ' or by post to ' . $address .'</p>

<br>

<H2><strong>Infringing material</strong></H2>



<p>If you become aware of any material on the website that you believe infringes your or any other persons copyright, please report this by email to '  . $emailaddress . ' or by post to ' . $address .'</p>';

}



add_shortcode('cookiespolicy', 'cookies');

function cookies($atts) {

 extract(shortcode_atts(array(

  	'name' => 'name',

		  	), $atts ));

  return '



TEMPLATE COOKIES POLICY



<H2><strong>Credit</H2></strong>



<p>This document was created using a Contractology template available at http://www.freenetlaw.com.</p>

<br>

<H2><strong>About cookies</H2></strong>



<p>This website uses cookies.  By using this website and agreeing to this policy, you consent to'  . $name . 's use of cookies in accordance with the terms of this policy.</p>



<p>Cookies are files sent by web servers to web browsers, and stored by the web browsers. </p>



<p>The information is then sent back to the server each time the browser requests a page from the server.  This enables a web server to identify and track web browsers.</p> 



<p>There are two main kinds of cookies: session cookies and persistent cookies.  Session cookies are deleted from your computer when you close your browser, whereas persistent cookies remain stored on your computer until deleted, or until they reach their expiry date.</p>

<br>

<H2><strong>Cookies on our website</H2></strong>



<p>' . $name .  ' uses the following cookies on this website, for the following purposes:</p>

<ul>

<li><p>[INSERT DETAILS]</p></li>

<li><p>[INSERT DETAILS]</p></li>

<li><p>[INSERT DETAILS]</p></li>

</ul>

<br>

<H2><strong>Google cookies</H2></strong>



<p> '. $name .  ' uses Google Analytics to analyse the use of this website.  Google Analytics generates statistical and other information about website use by means of cookies, which are stored on users computers.  The information generated relating to our website is used to create reports about the use of the website. Google will store and use this information.  Googles privacy policy is available at: http://www.google.com/privacypolicy.html.]</p>



<p>' . $name .  ' publishes Google Adsense interest-based advertisements on this website.  These are tailored by Google to reflect your interests.  To determine your interests, Google will track your behaviour across the web using cookies.  You can view, delete or add interest categories associated with your browser using Googles Ads Preference Manager, available at: http://www.google.com/ads/preferences/.  You can opt-out of the Adsense partner network cookie at: http://www.google.com/privacy_ads.html.  However, this opt-out mechanism uses a cookie, and if you clear the cookies from your browser your opt-out will not be maintained. To ensure that an opt-out is maintained in respect of a particular browser, you should use the Google browser plug-in available at: http://www.google.com/ads/preferences/plugin.]</p>

<br>

<H2><strong>[Other] third party cookies</H2></strong>



<p>When you use this website, you may also be sent the following third party cookies, which may be used for the following purposes:</p>

<ul>

<li><p>[INSERT DETAILS]</p></li>

<li><p>[INSERT DETAILS]</p></li>

<li><p>[INSERT DETAILS]</p></li>

</ul>

<br>

<H2><strong>Refusing cookies</H2></strong>



<p>Most browsers allow you to refuse to accept cookies.  </p>

<p>In Internet Explorer, you can refuse all cookies by clicking "Tools", "Internet Options", "Privacy", and selecting "Block all cookies" using the sliding selector.</p>  



<p>In Firefox, you can adjust your cookies settings by clicking "Tools", "Options" and "Privacy".</p>



<p>Blocking cookies will have a negative impact upon the usability of some websites.</p>';

}





add_shortcode('antispampolicy', 'antispam');

function antispam($atts) {

 extract(shortcode_atts(array(

  	'name' => 'name',

	'contactdetails' => 'contactdetails'

		  	), $atts ));

  return '<H2><strong>Credit</H2></strong>

<p>This document was created using a Contractology template available at http://www.freenetlaw.com.</p>

<br>

<H2><strong>What is spam?</H2></strong>



<p>In the context of electronic messaging, spam refers to unsolicited, bulk or indiscriminate messages, typically sent for a commercial purpose. </p> 



<p>'. $name .  ' has a zero-tolerance spam policy. </p>

<H2><strong>Automated spam filtering</H2></strong> 



<p>'. $name . ' s messaging systems automatically scan all incoming email [and other] messages, and filter-out messages that appear to be spam. </p> 

<br>



<H2><strong>Problems with spam filtering</H2></strong>



<p> No message filtering system is 100% accurate, and from time to time legitimate messages will be filtered-out by ' . $name . ' systems.  



If you believe this has happened to a message you have sent, please advise the message recipient by another means.</p>



<p>You can reduce the risk of a message being caught by the spam filters by sending the message in plain text (i.e. no HTML), removing any attachments, and ensuring that your messages are scanned for malware before dispatch.</p>

<br>

<H2><strong>User spam</H2></strong>

<p>' . $name . 'provides a facility that enables users to send [email messages / private messages] to others.  Users must not use this facility to send unsolicited, bulk or indiscriminate messages, whether or not for a commercial purposes.  Full terms and conditions concerning the use of the facility are set out in [DOCUMENT].]</p>

<br>

<H2><strong> Receipt of unwanted messages from </H2></strong>

<p>' . $name . ' In the unlikely event that you receive any message from ' . $name . ' or sent using ' . $name . ' systems that may be considered to be spam, please contact ' . $name . ' using the details below and the matter will be investigated.</p>

<br>

<H2><strong>Changes to this anti-spam policy</H2></strong>

<p>' . $name . ' may amend this anti-spam policy at any time by publishing a new version on this website. </p>

<br>

<H2><strong>Contact us</H2></strong>

<p>Should you have any questions about this anti-spam policy, please contact ' . $name . ' using the details set out below:</p>'



. $contactdetails .

'';

}



add_shortcode('medicaldisclaimer', 'medicald');

function medicald($atts) {

 extract(shortcode_atts(array(

  	'name' => 'name',

			  	), $atts ));

  return'<H2><strong>Credit</H2></strong>



<p>This document was created using a Contractology template available at http://www.freenetlaw.com.</p>

<br>

<H2><strong>No advice</H2></strong>

<p>This website contains general information about medical conditions and treatments.  The information is not advice, and should not be treated as such.</p>

<br>

<H2><strong>Limitation of warranties</H2></strong>



<p>The medical information on this website is provided "as is" without any representations or warranties, express or implied. '   . $name . ' makes no representations or warranties in relation to the medical information on this website.  </p>

<br>

<H2><strong>Without prejudice to the generality of the foregoing paragraph, '  . $name . ' does not warrant that:</H2></strong>



<ul>

<li><p>the medical information on this website will be constantly available, or available at all; or</p></li>

<li><p>the medical information on this website is complete, true, accurate, up-to-date, or non-misleading.</p></li>

</ul>

<br>

<H2><strong>Professional assistance</H2></strong>



<p>You must not rely on the information on this website as an alternative to medical advice from your doctor or other professional healthcare provider.</p>   



<p>If you have any specific questions about any medical matter you should consult your doctor or other professional healthcare provider.</p>



<p>If you think you may be suffering from any medical condition you should seek immediate medical attention.</p>  



<p>You should never delay seeking medical advice, disregard medical advice, or discontinue medical treatment because of information on this website.</p>

<br>

<H2><strong>Liability</H2></strong>



<p>Nothing in this medical disclaimer will limit any of our liabilities in any way that is not permitted under applicable law, or exclude any of our liabilities that may not be excluded under applicable law.</p>';

}



add_shortcode('legaldisclaimer', 'legald');

function legald($atts) {

 extract(shortcode_atts(array(

  	'name' => 'name',

			  	), $atts ));

  return'

<H2><strong>Credit</H2></strong>



<p>This document was created using a Contractology template available at http://www.freenetlaw.com.</p>

<br>

<H2><strong>No advice</H2></strong>



<p>This website contains general information about legal matters.  The information is not advice, and should not be treated as such.</p>

<br>

<H2><strong>Limitation of warranties</H2></strong>



<p>The legal information on this website is provided "as is" without any representations or warranties, express or implied. '   . $name . ' makes no representations or warranties in relation to the legal information on this website.  </p>

<br>

<H2><strong>Without prejudice to the generality of the foregoing paragraph, '   . $name . ' does not warrant that:</H2></strong>



<ul>

<li><p>the legal information on this website will be constantly available, or available at all; or</p></li>

<li><p>the legal information on this website is complete, true, accurate, up-to-date, or non-misleading.</p></li>

</ul>

<br>

<H2><strong>Professional assistance</H2></strong>



<p>You must not rely on the information on this website as an alternative to legal advice from your attorney or other professional legal services provider. </p>  



<p>If you have any specific questions about any legal matter you should consult your attorney or other professional legal services provider.</p>



<p>You should never delay seeking legal advice, disregard legal advice, or commence or discontinue any legal action because of information on this website.</p>

<br>

<H2><strong>Liability</H2></strong>



<p>Nothing in this legal disclaimer will limit any of our liabilities in any way that is not permitted under applicable law, or exclude any of our liabilities that may not be excluded under applicable law.</p>';

}



add_shortcode('amazonusdisclaimer', 'amazonus');

function amazonus($atts) {

 extract(shortcode_atts(array(

  	'name' => 'name',

			  	), $atts ));

  return'<p>' . $name . ' is a participant in the Amazon Services LLC Associates Program, an affiliate advertising program designed to provide a means for sites to earn advertising fees by advertising and linking to amazon.com, amazonsupply.com, or myhabit.com </p>';

}



add_shortcode('amazonukdisclaimer', 'amazonuk');

function amazonuk($atts) {

 extract(shortcode_atts(array(

  	'name' => 'name',

			  	), $atts ));

				

	return'<p>' . $name . ' is a participant in the Amazon EU Associates Programme, an affiliate advertising programme designed to provide a means for sites to earn advertising fees by advertising and linking to Amazon.co.uk/Javari.co.uk/Local.Amazon.co.uk.</p>';

}



add_shortcode('amazonfrdisclaimer', 'amazonfr');

function amazonfr($atts) {

 extract(shortcode_atts(array(

  	'name' => 'name',

			  	), $atts ));

  return'<p>' . $name . ' participe au Programme Partenaires d Amazon EU, un programme d affiliation conu pour permettre  des sites de percevoir une rmunration grce  la cration de liens vers Amazon.fr/Javari.fr.</p>';

}



add_shortcode('amazonitdisclaimer', 'amazonit');

function amazonit($atts) {

 extract(shortcode_atts(array(

  	'name' => 'name',

	), $atts ));

  return'<p>' . $name . ' partecipa al Programma Affiliazione Amazon EU, un programma di affiliazione che consente ai siti di percepire una commissione pubblicitaria pubblicizzando e fornendo link al sito Amazon.it/it.BuyVIP.com</p>';

}



add_shortcode('amazonesdisclaimer', 'amazones');

function amazones($atts) {

 extract(shortcode_atts(array(

  	'name' => 'name',

	), $atts ));

  return'<p>' . $name . ' participa en el Programa de Afiliados de Amazon EU, un programa de publicidad para afiliados diseado para ofrecer a sitios web un modo de obtener comisiones por publicidad, publicitando e incluyendo enlaces a Amazon.es/es.buyvip.com.</p>';

}

add_shortcode('amazoncadisclaimer', 'amazonca');

function amazonca($atts) {

 extract(shortcode_atts(array(

  	'name' => 'name',

	), $atts ));

  return'<p>' . $name . '  is a participant in the Amazon.com.ca, Inc. Associates Program, an affiliate advertising program designed to provide a means for sites to earn advertising fees by advertising and linking to Amazon.ca.</p>';

}



add_shortcode('amazondedisclaimer', 'amazonde');

function amazonde($atts) {

 extract(shortcode_atts(array(

  	'name' => 'name',

	), $atts ));

  return'<p>'. $name . ' ist Teilnehmer des Partnerprogramms von Amazon EU, das zur Bereitstellung eines Mediums fr Websites konzipiert wurde, mittels dessen durch die Platzierung von Werbeanzeigen und Links zu  Amazon.de / Javari.de / de.BuyVIP.com Werbekostenerstattung verdient werden kann.</p>';

}*/ 







/*-----------------------------------------------------------------------------------*/

/* full width Color Box with border

/*-----------------------------------------------------------------------------------

function oft_full_width_div( $atts, $content = null ) {

	

extract( shortcode_atts(array(

		"bg_color" => '#f6f6f6',

		"color" => '#333333',

		"height" => '',

), $atts) );	



   $oft_full_width_div = '<div class="full-width" style="color: '. $color .';';

   $oft_full_width_div .= 'background: '. $bg_color .';';

   $oft_full_width_div .= 'height: '. $height .';';   

   $oft_full_width_div .= '">' . do_shortcode($content) . '</div>';

   

   return $oft_full_width_div;

}



add_shortcode('full_width_div', 'oft_full_width_div');



function oft_full_width_div_with_border( $atts, $content = null ) {

	

extract( shortcode_atts(array(

		"bg_color" => '#f6f6f6',

		"color" => '#333333',

		"border_color"=>'',

		

), $atts) );	



   $oft_full_width_div_with_border = '<div class="full-width-border" style="color: '. $color .';';

   $oft_full_width_div_with_border .= 'border-top: '. $border_color .' 2px solid;'; 

   $oft_full_width_div_with_border .= 'border-bottom: '. $border_color .' 2px solid;';   

   $oft_full_width_div_with_border .= 'background: '. $bg_color .';'; 

   $oft_full_width_div_with_border .= '">' . do_shortcode($content) . '</div>';

   

   return $oft_full_width_div_with_border;

}



add_shortcode('full_width_div_with_border', 'oft_full_width_div_with_border');*/	

/*-----------------------------------------------------------------------------------*/

/* full width Color Box with shadow

/*-----------------------------------------------------------------------------------	

function oft_full_width_div_with_shadow( $atts, $content = null ) {

	

extract( shortcode_atts(array(

		"bg_color" => '#f6f6f6',

		"color" => '#333333',

		"border_color"=>'',		

		"padding_top"=>'',

		"padding_bottom"=>'',

		), $atts) );	



   $oft_full_width_div_with_shadow = '<div class="full-width-shadow" style="color: '. $color .';';

   $oft_full_width_div_with_shadow .= 'background: '. $bg_color .';';

   $oft_full_width_div_with_shadow .= 'border-bottom: '. $border_color .' 2px solid;';

   $oft_full_width_div_with_shadow .= 'padding-top: '. $padding_top .';';

   $oft_full_width_div_with_shadow .= 'padding-bottom: '. $padding_bottom .';';  

   $oft_full_width_div_with_shadow .= '">' . do_shortcode($content) . '</div>';

   

   return $oft_full_width_div_with_shadow;

}



add_shortcode('full_width_div_with_shadow', 'oft_full_width_div_with_shadow');*/



/*-----------------------------------------------------------------------------------*/

/* full width Color Box with Triangle Seperator

/*-----------------------------------------------------------------------------------*/	

/*function oft_full_width_div_tringle( $atts, $content = null ) {

	

extract( shortcode_atts(array(

		"bg_color" => '#f6f6f6',

		"color" => '#333333',

		"height" => '',

), $atts) );	



   $oft_full_width_div = '<div class="full-width-tringle" style="color: '. $color .';';

   $oft_full_width_div .= 'background: '. $bg_color .';';

   $oft_full_width_div .= 'height: '. $height .';';   

   $oft_full_width_div .= '">' . do_shortcode($content) . '</div>';

   

   return $oft_full_width_div;

}



add_shortcode('full_width_div_tringle', 'oft_full_width_div_tringle');*/





/*-----------------------------------------------------------------------------------*/

/* Contact Details Div

/*-----------------------------------------------------------------------------------





function oft_contact_area($atts, $content = null) {

	

	extract( shortcode_atts(array(              

		"fontsize" => '',

		"fontweight" => '',

		"fontfamily" => '',

		"bgcolor" => '',

		"color" => '',

		"padding" => '',

		"width" => '',

    ), $atts) ); 

	

	$contact= '<h1><div class="contact"style="font-size: '. $fontsize .'; font-weight:'. $fontweight .';color:'. $color .';background:'. $bgcolor .';padding:'. $padding .';width:'. $width .'">' . do_shortcode($content) . '</div></h1>';



  return $contact;

}

add_shortcode('contact_details', 'oft_contact_area');





function oft_title($atts, $content = null) {

	

	extract( shortcode_atts(array(



		"fontsize" => '',

		"fontweight" => '',

		"fontfamily" => '',

		"bgcolor" => '',

		"color" => '',

		"padding" => '',

		"width" => '',

		"textalign" => '',

), $atts ) );



$returns = '<h1 style="margin-top:0px"><div class="title"style="font-size: '. $fontsize .'; font-weight:'. $fontweight .';color:'. $color .';text-align:'. $textalign .';">' . do_shortcode($content) . '</div></h1>';



return $returns;

}

add_shortcode('fusion_titleside', 'oft_title');*/





// Animation Fade In Left Big



function oft_animation_bigleft($atts, $content = null) { 

    extract(shortcode_atts(array(

	"animation" => '', 

	"delay" => '', 

	"image_url" => '',

	"animation_speed" => '',

	'alt' => ''), $atts));

	

	$animation_attrs = '';

	

	if($animation_speed) {

				$animation_attrs .= ' animation_duration="'.$animation_speed.'"';

			}

	

    return'<div style="visibility:hidden;"><div class="fadeinleftbig'.$animation.'" style="visibility:hidden;"'.$animation_attrs.'>' . do_shortcode($content) . '</div></div>';

}

add_shortcode('animation_fadeinleftbig', 'oft_animation_bigleft');





// Animation Fade In Left



function oft_animation_left($atts, $content = null) { 

    extract(shortcode_atts(array(

	"animation" => '', 

	"delay" => '0', 

	"image_url" => '',

	"animation_speed" => '',

	'alt' => ''), $atts));

	

	$animation_attrs = '';

	

	if($animation_speed) {

				$animation_attrs .= ' animation_duration="'.$animation_speed.'"';

			}	

   

	return'<div style="visibility:hidden;"><div class="fadeinleft'.$animation.'" style="visibility:hidden;"'.$animation_attrs.'>' . do_shortcode($content) . '</div></div>';

}

add_shortcode('animation_fadeinleft', 'oft_animation_left');





// Animation Fade In Right Big


function oft_animation_rightbig($atts, $content = null) { 

    extract(shortcode_atts(array(

	"animation" => '', 

	"delay" => '0', 

	"image_url" => '',

	"animation_speed" => '',

	'alt' => ''), $atts));

	

	$animation_attrs = '';

	

	if($animation_speed) {

				$animation_attrs .= ' animation_duration="'.$animation_speed.'"';

			}	

    

	return'<div style="visibility:hidden;"><div class="fadeinrightbig'.$animation.'" style="visibility:hidden;"'.$animation_attrs.'>' . do_shortcode($content) . '</div></div>';

	

}

add_shortcode('animation_fadeinrightbig', 'oft_animation_rightbig');





// Animation Fade In Right



function oft_animation_right($atts, $content = null) { 

    extract(shortcode_atts(array(

	"animation" => '', 

	"delay" => '0', 

	"image_url" => '',

	"animation_speed" => '',

	'alt' => ''), $atts));	

	

	$animation_attrs = '';

	

	if($animation_speed) {

				$animation_attrs .= ' animation_duration="'.$animation_speed.'"';

			}

    

	return'<div style="visibility:hidden;"><div class="fadeinright'.$animation.'" style="visibility:hidden;"'.$animation_attrs.'>' . do_shortcode($content) . '</div></div>';

}

add_shortcode('animation_fadeinright', 'oft_animation_right');




// Animation Fade In Top


function oft_animation_up($atts, $content = null) { 

    extract(shortcode_atts(array(

	"animation" => '', 

	"delay" => '0', 

	"image_url" => '',

	"animation_speed" => '',

	'alt' => ''), $atts));

	

	$animation_attrs = '';

	

	if($animation_speed) {

				$animation_attrs .= ' animation_duration="'.$animation_speed.'"';

			}	

    

	return'<div style="visibility:hidden;"><div class="fadeinup'.$animation.'" style="visibility:hidden;"'.$animation_attrs.'>' . do_shortcode($content) . '</div></div>';

}

add_shortcode('animation_fadeinup', 'oft_animation_up');




// Animation Fade In Bottom


function oft_animation_down($atts, $content = null) { 

    extract(shortcode_atts(array(

	"animation" => '', 

	"delay" => '0', 

	"image_url" => '',

	"animation_speed" => '',

	'alt' => ''), $atts));

	

	$animation_attrs = '';

	

	if($animation_speed) {

				$animation_attrs .= ' animation_duration="'.$animation_speed.'"';

			}

	

    return'<div style="visibility:hidden;"><div class="fadeindown'.$animation.'" style="visibility:hidden;"'.$animation_attrs.'>' . do_shortcode($content) . '</div></div>';

}

add_shortcode('animation_fadeindown', 'oft_animation_down');




// Animation Bounce In



function oft_animation_bouncein($atts, $content = null) { 

    extract(shortcode_atts(array(

	"animation" => '', 

	"delay" => '0', 

	"image_url" => '',

	"animation_speed" => '',

	'alt' => ''), $atts));

	

	$animation_attrs = '';

	

	if($animation_speed) {

				$animation_attrs .= ' animation_duration="'.$animation_speed.'"';

			}	

    

	return'<div style="visibility:hidden;"><div class="bouncein'.$animation.'" style="visibility:hidden;"'.$animation_attrs.'>' . do_shortcode($content) . '</div></div>';

}

add_shortcode('animation_bouncein', 'oft_animation_bouncein');




// Animation Shake


function oft_animation_shake($atts, $content = null) { 

    extract(shortcode_atts(array(

	"animation" => '', 

	"delay" => '0', 

	"image_url" => '',

	"animation_speed" => '',

	'alt' => ''), $atts));

	

	$animation_attrs = '';

	

	if($animation_speed) {

				$animation_attrs .= ' animation_duration="'.$animation_speed.'"';

			}	

    

	return'<div style="visibility:hidden;"><div class="shake'.$animation.'" style="visibility:hidden;"'.$animation_attrs.'>' . do_shortcode($content) . '</div></div>';

}

add_shortcode('animation_shake', 'oft_animation_shake');




// Animation Pulse



function oft_animation_pulse($atts, $content = null) { 

    extract(shortcode_atts(array(

	"animation" => '', 

	"delay" => '0', 

	"image_url" => '',

	"animation_speed" => '',

	'alt' => ''), $atts));

	

	$animation_attrs = '';

	

	if($animation_speed) {

				$animation_attrs .= ' animation_duration="'.$animation_speed.'"';

			}

	

    return'<div class="pulse'.$animation.'"style="visibility:hidden;">' . do_shortcode($content) . '</div>';

	return'<div style="visibility:hidden;"><div class="fadeinleft'.$animation.'" style="visibility:hidden;"'.$animation_attrs.'>' . do_shortcode($content) . '</div></div>';

}

add_shortcode('animation_pulse', 'oft_animation_pulse');




// Animation flash


function oft_animation_flash($atts, $content = null) { 

    extract(shortcode_atts(array(

	"animation" => '', 

	"delay" => '0', 

	"image_url" => '',

	"animation_speed" => '',

	'alt' => ''), $atts));

	

	$animation_attrs = '';

	

	if($animation_speed) {

				$animation_attrs .= ' animation_duration="'.$animation_speed.'"';

			}	

    

	return'<div style="visibility:hidden;"><div class="fadeinleft'.$animation.'" style="visibility:hidden;"'.$animation_attrs.'>' . do_shortcode($content) . '</div></div>';

}

add_shortcode('animation_flash', 'oft_animation_flash');




// Animation bounce



function oft_animation_bounce($atts, $content = null) { 

    extract(shortcode_atts(array(

	"animation" => '', 

	"delay" => '0', 

	"image_url" => '',

	"animation_speed" => '',

	'alt' => ''), $atts));

	

    $animation_attrs = '';

	

	if($animation_speed) {

				$animation_attrs .= ' animation_duration="'.$animation_speed.'"';

			}

			

	return'<div style="visibility:hidden;"><div class="fadeinleft'.$animation.'" style="visibility:hidden;"'.$animation_attrs.'>' . do_shortcode($content) . '</div></div>';

}

add_shortcode('animation_bounce', 'oft_animation_bounce');




// Animation tada



function oft_animation_tada($atts, $content = null) { 

    extract(shortcode_atts(array(

	"animation" => '', 

	"delay" => '0', 

	"image_url" => '',

	"animation_speed" => '',

	'alt' => ''), $atts));

	

    $animation_attrs = '';

	

	if($animation_speed) {

				$animation_attrs .= ' animation_duration="'.$animation_speed.'"';

			}

			

	return'<div style="visibility:hidden;"><div class="fadeinleft'.$animation.'" style="visibility:hidden;"'.$animation_attrs.'>' . do_shortcode($content) . '</div></div>';

}

add_shortcode('animation_tada', 'oft_animation_tada');



/****************************************************************/

// Checklist shortcode

/***************************************************************/

	

	function oft_list( $atts, $content = null ) {

		$output = '<ul class="oft-list">' . do_shortcode($content) .'</ul>';		

		return $output;		

	}

	add_shortcode('list', 'oft_list');

	

	function oft_list_item( $atts, $content = null ) {

		extract(shortcode_atts(array(

			"icon" => ''

		), $atts));

		$output = '<li><i class="'.$icon.'"></i><span>' . do_shortcode($content) .'</span></li>';		

		return $output;		

	}

	add_shortcode('list_item', 'oft_list_item');

	

/****************************************************************/

// Youtube Responsive shortcode

/***************************************************************/



function oft_responsive_video_shortcode( $atts ) {

	extract( shortcode_atts( array (

		'identifier' => ''

	), $atts ) );

	return '<div class="oft-video-container"><iframe src="//www.youtube.com/embed/' . $identifier . '" frameborder="0" allowfullscreen></iframe></div><!--.oft-video-container-->';

}

add_shortcode ('responsive-youtube-video', 'oft_responsive_video_shortcode');



/****************************************************************/

// Vimeo Responsive shortcode

/***************************************************************/



function oft_responsive_vimeo_shortcode( $atts ) {

	extract( shortcode_atts( array (

		'vimeoidentifier' => ''

	), $atts ) );

	return '<div class="oft-video-container"><iframe src="//player.vimeo.com/video/' . $vimeoidentifier . '" frameborder="0" webkitallowfullscreen mozallowfullscreen 

allowfullscreen></iframe> </div><!--.oft-video-container-->';

}

add_shortcode ('responsive-vimeo-video', 'oft_responsive_vimeo_shortcode');



/*-----------------------------------------------------------------------------------*/

/*	Clients

/*-----------------------------------------------------------------------------------



function oft_customerlogo($atts, $content = null) {	



	extract( shortcode_atts(array(

        "logo" => '',

        "url" => '#',       

        "title" => ''

    ), $atts) );  



	return '<a href="'. $url .'" title="'. $title .'" class="customers" target="_blank"><img src="'. $logo .'" alt="'. $title .'"></a>';



	return $$rnr_client;

}



add_shortcode('customer', 'oft_customerlogo');



function oft_customer( $atts, $content = null ){



	return '<div class="customer-logos">'. do_shortcode($content) .'</div>';



}



add_shortcode('customers_area', 'oft_customer'); */



/*-----------------------------------------------------------------------------------*/

/* Icon with border shortcode

/*-----------------------------------------------------------------------------------	



function addsFontAwesome($atts) {

    extract(shortcode_atts(array(

    'type'  => '',

    'size' => '',

    'rotate' => '',

    'flip' => '',

    'pull' => '',

    'animated' => '',

	'color'=> '',

	'bordercolor'=> '',

 

    ), $atts));

     

    $type = ($type) ? 'icon-'.$type. '' : 'icon-star';

    $size = ($size) ? 'icon-'.$size. '' : '';

    $rotate = ($rotate) ? 'icon-rotate-'.$rotate. '' : '';

    $flip = ($flip) ? 'icon-flip-'.$flip. '' : '';

    $pull = ($pull) ? 'pull-'.$pull. '' : '';

    $animated = ($animated) ? 'icon-spin' : '';

   

    $theAwesomeFont = '<div class="iconwithborder" style="border-color:'.$bordercolor.'"><i class="'.sanitize_html_class($type).' '.sanitize_html_class($size).' '.sanitize_html_class($rotate).' '.sanitize_html_class($flip).' '.sanitize_html_class($pull).' '.sanitize_html_class($animated).'" style="color: '. $color .';"></i></div>';

     

    return $theAwesomeFont;

}

 

add_shortcode('iconwithborder', 'addsFontAwesome');*/



/*-----------------------------------------------------------------------------------*/

/* Icon shortcode

/*-----------------------------------------------------------------------------------	



function addsFont($atts) {

    extract(shortcode_atts(array(

    'type'  => '',

    'size' => '',

    'rotate' => '',

    'flip' => '',

    'pull' => '',

    'animated' => '',

	'color'=> '',

	'bordercolor'=> '',

 

    ), $atts));

     

    $type = ($type) ? 'icon-'.$type. '' : 'icon-star';

    $size = ($size) ? 'icon-'.$size. '' : '';

    $rotate = ($rotate) ? 'icon-rotate-'.$rotate. '' : '';

    $flip = ($flip) ? 'icon-flip-'.$flip. '' : '';

    $pull = ($pull) ? 'pull-'.$pull. '' : '';

    $animated = ($animated) ? 'icon-spin' : '';

   

    $theAwesomeFont = '<div class="icon" style="border-color:'.$bordercolor.'"><i class="'.sanitize_html_class($type).' '.sanitize_html_class($size).' '.sanitize_html_class($rotate).' '.sanitize_html_class($flip).' '.sanitize_html_class($pull).' '.sanitize_html_class($animated).'" style="color: '. $color .';"></i></div>';

     

    return $theAwesomeFont;

}

 

add_shortcode('icon', 'addsFont');*/



