package {
	
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.display.MovieClip;

	import flash.media.Sound;

	public class RPGText extends MovieClip {
		
		private const SPEAKER:int = 0;
		private const TEXT:int = 1;
		
		private var _currentTextBlockIndex:int=0;
		private var _currentTextBlock:String;
		private var _textBlocks:Array;
		private var _typingSound:Sound = new TypingSound();
		
		// CONSTRUCTOR
		public function RPGText() {
		
		}
		
		public function set textBlocks(txt:Array):void {
			_textBlocks = txt;
		}
		
		public function startText():void {
			_currentTextBlock = _textBlocks[_currentTextBlockIndex][TEXT];
			charIcon.gotoAndStop(_textBlocks[_currentTextBlockIndex][SPEAKER]);
			addEventListener(Event.ENTER_FRAME, updateText);
			addEventListener(MouseEvent.CLICK, fillText);
		}
		
		private function updateText(e:Event):void {
			if(txt.text.length < _currentTextBlock.length){
				txt.text = _currentTextBlock.substr(0, txt.text.length+1);
				_typingSound.play();
			} else {
				removeEventListener(Event.ENTER_FRAME, updateText);
				fillText();
			}
		}
		
		private function fillText(e:MouseEvent = null):void {
			txt.text = _currentTextBlock;
			if(_currentTextBlockIndex < _textBlocks.length-1){
				addEventListener(MouseEvent.CLICK, nextTextBlock);
			}
		}
		
		private function nextTextBlock(e:MouseEvent):void {
			removeEventListener(MouseEvent.CLICK, nextTextBlock);
			txt.text = ""; // clear the text
			_currentTextBlockIndex++; 
			_currentTextBlock = _textBlocks[_currentTextBlockIndex][TEXT]; // set the text
			charIcon.gotoAndStop(_textBlocks[_currentTextBlockIndex][SPEAKER]); // set the character icon
			addEventListener(Event.ENTER_FRAME, updateText); // start updating the text
			addEventListener(MouseEvent.CLICK, fillText);
		}
		
	}

}