'DECLARATIONS
'============
Dim strGameEXEDir 
dim strGameEXEDirReplace
Dim strGameDUMPSVSDir 
Dim strGameDUMPSPSDir 
Dim strHelixFixVSDir 
Dim strHelixFixPSDir 
dim strVPMShadersDir
Dim objFSO 
Dim objGameExeFolder 
Dim objGameDUMPSVSFolder 
Dim objGameDUMPSPSFolder 
Dim objHelixFixFolder 
Dim objGameShaderFiles 
Dim objHelixFixShaderFiles 
Dim objGameShaderFile 
Dim objHelixFixShaderFile 
Dim objHelixFixShaderFile_Fixed 
Dim objGameVSFile 
Dim objGamePSFile 
Dim objGameShaderOverrideFolder 
Dim objGameVSFolder 
Dim objGamePSFolder 
Dim strGameShaderFileContents 
Dim strHelixFixShaderFileContents 
Dim strHelixFixShaderFile_FixedContents 
Dim strHelixCRC 
Dim strGameCRC 
Dim objTextStream 
Dim strHelixFixIniFolder 
Dim strHelixFixIniVSFolder 
Dim strHelixFixIniPSFolder 
Dim strGameIniFolder 
Dim objHelixFixIniFolder 
Dim objHelixFixIniVSFolder 
Dim objHelixFixIniPSFolder 
Dim objGameIniFolder 
dim objVPMShadersFolder
Dim objHelixFixIniFile 
Dim objGameIniFile 
Dim objTextStreamGame 
Dim objTextStreamHelix 
Dim strLineHelix 
Dim strLineGame 
Dim objGameShader 
Dim objHelixShader 
Dim strGameShaderContents 
Dim strHelixShaderContents 
Dim iniFile, outFile, strS    
Dim strHelixFixDLLDir 
Dim objHelixDLLFolder 
Dim objDebugFile 
dim objVPMShaderFiles
dim objVPMShaderFile
dim strVPMShaderFileContents

'SET UP DIRECTORIES ETC
'======================

Set objFSO = CreateObject("Scripting.FileSystemObject")
Set iniFile = objFSO.OpenTextFile("DOS_3DFix.ini")
set outFile = objFSO.CreateTextFile("DOS_3DFix_LOG.txt", true)

outFile.WriteLine ("READ DIRECTORY INI FILE")
outFile.WriteLine ("=======================")

strS = iniFile.ReadLine
strGameEXEDir = iniFile.ReadLine
outFile.WriteLine ("Game exe dir = " & strGameEXEDir)
strS = iniFile.ReadLine
strGameDUMPSVSDir = iniFile.ReadLine
outFile.WriteLine ("Game Shader VS Dir = " & strGameDUMPSVSDir)
strS = iniFile.ReadLine
strGameDUMPSPSDir = iniFile.ReadLine
outFile.WriteLine ("Game Shader PS Dir = " & strGameDUMPSPSDir)
strS = iniFile.ReadLine
strHelixFixVSDir = iniFile.ReadLine
outFile.WriteLine ("Helix Fix VS Dir = " & strHelixFixVSDir)
strS = iniFile.ReadLine
strHelixFixPSDir = iniFile.ReadLine
outFile.WriteLine ("Helix Fix PS Dir = " & strHelixFixPSDir)
strS = iniFile.ReadLine
strHelixFixIniFolder = iniFile.ReadLine
outFile.WriteLine ("Helix Fix Ini Dir = " & strHelixFixIniFolder)
strS = iniFile.ReadLine
strHelixFixIniVSFolder = iniFile.ReadLine
outFile.WriteLine ("Helix Fix Ini VS Dir = " & strHelixFixIniVSFolder)
strS = iniFile.ReadLine
strHelixFixIniPSFolder = iniFile.ReadLine
outFile.WriteLine ("Helix Fix Ini PS Dir = " & strHelixFixIniPSFolder)
strS = iniFile.ReadLine
strGameIniFolder = iniFile.ReadLine
outFile.WriteLine ("Game Ini folder = " & strGameIniFolder)
strS = iniFile.ReadLine
strHelixFixDLLDir = iniFile.ReadLine
outFile.WriteLine ("Helix DLL Folder = " & strHelixFixDLLDir)
strS = iniFile.ReadLine
strVPMShadersDir = iniFile.ReadLine
outFile.WriteLine ("VPM SHaders Dir = " & strVPMShadersDir)
iniFile.Close

'Get game exe and dumps directories
Set objGameExeFolder = objFSO.GetFolder(strGameEXEDir)
Set objGameDUMPSVSFolder = objFSO.GetFolder(strGameDUMPSVSDir)
Set objGameDUMPSPSFolder = objFSO.GetFolder(strGameDUMPSPSDir)
Set objGameShaderOverrideFolder = objGameExeFolder.SubFolders.Add("ShaderOverride")
Set objGameVSFolder = objGameShaderOverrideFolder.SubFolders.Add("VertexShaders")
Set objGamePSFolder = objGameShaderOverrideFolder.SubFolders.Add("PixelShaders")

strGameEXEDirReplace = "D:\Steam\steamapps\common\Divinity - Original Sin\Shipping"

'PROCESS VERTEX SHADERS
'======================
outFile.WriteLine (vbCRLF & "PROCESS VERTEX SHADERS")
outFile.WriteLine ("======================")

'Get base and VS folders
Set objHelixFixFolder = objFSO.GetFolder(strHelixFixVSDir)  'VERTEX
Set objHelixFixShaderFiles = objHelixFixFolder.Files

'Loop through each file in the original fix package
For Each objHelixFixShaderFile In objHelixFixShaderFiles
	
	'Check its not a 'fixed version'
	If InStr(1, objHelixFixShaderFile.Name, "_fixed") = 0 Then
		'Get the 8-char stem
		strHelixCRC = fstrGetCRC(objHelixFixShaderFile.Name)
	
		'Get its contents
		Set objTextStream = objHelixFixShaderFile.OpenAsTextStream(1)
		strHelixFixShaderFileContents = fstrStripOutHashLines(objTextStream, strGameEXEDir, strGameEXEDirReplace)  'replace hashlines
		objTextStream.Close
		
		'Now Loop through the VS shaders in the new game location and find the one with the same contents
		Set objGameShaderFiles = objGameDUMPSVSFolder.Files   'VERTEX
		For Each objGameShaderFile In objGameShaderFiles
			'Get its contents
			Set objTextStream = objGameShaderFile.OpenAsTextStream(1)
			strGameShaderFileContents = fstrStripOutHashLines(objTextStream, strGameEXEDir, strGameEXEDirReplace)  'replace hashlines
			objTextStream.Close
			'Set objTextStream = objGameShaderFile.OpenAsTextStream(1)
			'strGameShaderFileContents = objTextStream.ReadAll
			'objTextStream.Close
			
			'Check if its the same as the source file
			If strHelixFixShaderFileContents = strGameShaderFileContents Then
				'They are the same so:
									
				'1. Create a new version of the game shader in ShaderOverride with the same name as the existing game shader file
				strGameCRC = fstrGetCRC(objGameShaderFile.Name)
				objGameShaderFile.Copy objGameVSFolder.Path & "\" & objGameShaderFile.Name       'VERTEX
				Set objGameVSFile = objGameVSFolder.Files(objGameShaderFile.Name)
				
				'2. Get the Fix file with the same name as the current fix file but with the "_fixed" in it
				Set objHelixFixShaderFile_Fixed = objHelixFixShaderFiles.Item(strHelixCRC & "_fixed.txt")
				
				'3. Get the contents of the above fix file and write to the new game shader in the Shaderoverride
				Set objTextStreamHelix = objHelixFixShaderFile_Fixed.OpenAsTextStream(1)
				Set objTextStreamGame = objGameVSFile.OpenAsTextStream(2)
				While Not objTextStreamHelix.AtEndOfStream
					strLineHelix = objTextStreamHelix.ReadLine
					'If InStr(strLineHelix, "#") = 0 Then 'does not have a #line
						objTextStreamGame.WriteLine strLineHelix
					'End If
				Wend
				objTextStreamGame.Close
				objTextStreamHelix.Close
				
				'5. Write out summary					
				strS = "VS" & vbTab & strHelixCRC & vbTab & strGameCRC
				outFile.WriteLine(strS)
				'Stop loop
				Exit For
			End If
			
		Next 'objGameShaderFile

	End If
Next 'objHelixFixShaderFile

'PROCESS PIXEL SHADERS
'======================
outFile.WriteLine (vbCRLF & "PROCESS PIXEL SHADERS")
outFile.WriteLine ("=====================")

'Get base and PS folders
Set objHelixFixFolder = objFSO.GetFolder(strHelixFixPSDir)  'PIXEL
Set objHelixFixShaderFiles = objHelixFixFolder.Files

'Loop through each file in the original fix package
For Each objHelixFixShaderFile In objHelixFixShaderFiles
	
	'Check its not a 'fixed version'
	If InStr(1, objHelixFixShaderFile.Name, "_fixed") = 0 Then
		'Get the 8-char stem
		strHelixCRC = fstrGetCRC(objHelixFixShaderFile.Name)
	
		'Get its contents
		Set objTextStream = objHelixFixShaderFile.OpenAsTextStream(1)
		strHelixFixShaderFileContents = fstrStripOutHashLines(objTextStream, strGameEXEDir, strGameEXEDirReplace)
		objTextStream.Close
		
		'Now Loop through the VS shaders in the new game location and find the one with the same contents
		Set objGameShaderFiles = objGameDUMPSPSFolder.Files   'PIXEL
		For Each objGameShaderFile In objGameShaderFiles
			'Get its contents
			Set objTextStream = objGameShaderFile.OpenAsTextStream(1)
			strGameShaderFileContents = fstrStripOutHashLines(objTextStream, strGameEXEDir, strGameEXEDirReplace)
			objTextStream.Close
			'Set objTextStream = objGameShaderFile.OpenAsTextStream(1)
			'strGameShaderFileContents = objTextStream.ReadAll
			'objTextStream.Close

			'Check if its the same as the source file
			If strHelixFixShaderFileContents = strGameShaderFileContents Then
				'They are the same so:
									
				'1. Create a new version of the game shader in ShaderOverride with the same name as the existing game shader file
				strGameCRC = fstrGetCRC(objGameShaderFile.Name)
				objGameShaderFile.Copy objGamePSFolder.Path & "\" & objGameShaderFile.Name
				Set objGamePSFile = objGamePSFolder.Files(objGameShaderFile.Name)
				
				'2. Get the Fix file with the same name as the current fix file but with the "_fixed" in it
				Set objHelixFixShaderFile_Fixed = objHelixFixShaderFiles.Item(strHelixCRC & "_fixed.txt")
				
				'3. Get the contents of the above fix file and write to the new game shader in the Shaderoverride
				Set objTextStreamHelix = objHelixFixShaderFile_Fixed.OpenAsTextStream(1)
				Set objTextStreamGame = objGamePSFile.OpenAsTextStream(2)
				While Not objTextStreamHelix.AtEndOfStream
					strLineHelix = objTextStreamHelix.ReadLine
					'If InStr(strLineHelix, "#") = 0 Then 'does not have a #line
						objTextStreamGame.WriteLine strLineHelix
					'End If
				Wend
				objTextStreamGame.Close
				objTextStreamHelix.Close
				
				'5. Write out summary				
				strS = "PS" & vbTab & strHelixCRC & vbTab & strGameCRC
				outFile.WriteLine(strS)
				'Stop loop
				Exit For
			End If
			
		Next 'objGameShaderFile

	End If
Next 'objHelixFixShaderFile

'COPY THE VPM SHADERS FILES
'==========================
outFile.WriteLine (vbCRLF & "PROCESS VPM SHADERS")
outFile.WriteLine ("========================")

Set objVPMShadersFolder = objFSO.GetFolder(strVPMShadersDir)
Set objVPMShaderFiles = objVPMShadersFolder.Files

'Loop through each file in the VPMShaders directory
' - get each file
' - find the equivalent file in the game dumps folder
' - get its name
' - copy the file across
For Each objVPMShaderFile In objVPMShaderFiles
	
	'Get the 8-char stem
	strHelixCRC = fstrGetCRC(objVPMShaderFile.Name)

	'Get its contents
	Set objTextStreamHelix = objVPMShaderFile.OpenAsTextStream(1)
	strVPMShaderFileContents = fstrStripOutHashLines(objTextStreamHelix, strGameEXEDir, strGameEXEDirReplace)
	REM objTextStream.Close
	
	'Now Loop through the VS shaders in the new game location and find the one with the same contents
	Set objGameShaderFiles = objGameDUMPSVSFolder.Files   'VERTEX
	For Each objGameShaderFile In objGameShaderFiles
		'Get its contents
		Set objTextStream = objGameShaderFile.OpenAsTextStream(1)
		strGameShaderFileContents = fstrStripOutHashLines(objTextStream, strGameEXEDir, strGameEXEDirReplace)
		objTextStream.Close

		'Check if its the same as the source file
		If strVPMShaderFileContents = strGameShaderFileContents Then
			'They are the same so:
								
			'1. Create a new version of the game shader in ShaderOverride with the same name as the existing game shader file in Dumps folder
			strGameCRC = fstrGetCRC(objGameShaderFile.Name)
			objGameShaderFile.Copy objGameVSFolder.Path & "\" & objGameShaderFile.Name       'VERTEX
			Set objGameVSFile = objGameVSFolder.Files(objGameShaderFile.Name)
			
			REM '2. Get the Fix file with the same name as the current fix file but with the "_fixed" in it
			REM Set objHelixFixShaderFile_Fixed = objHelixFixShaderFiles.Item(strHelixCRC & "_fixed.txt")
			
			REM '3. Get the contents of the above fix file and write to the new game shader in the Shaderoverride
			REM Set objTextStreamHelix = objHelixFixShaderFile_Fixed.OpenAsTextStream(1)
			REM Set objTextStreamGame = objGameVSFile.OpenAsTextStream(2)
			REM While Not objTextStreamHelix.AtEndOfStream
				REM strLineHelix = objTextStreamHelix.ReadLine
				REM If InStr(strLineHelix, "#") = 0 Then 'does not have a #line
					REM objTextStreamGame.WriteLine strLineHelix
				REM End If
			REM Wend
			REM objTextStreamGame.Close
			objTextStreamHelix.Close
			
			'5. Write out summary					
			strS = "VS" & vbTab & strHelixCRC & vbTab & strGameCRC
			outFile.WriteLine(strS)
			'Stop loop
			Exit For
		End If
		
	Next 

Next 


'PROCESS DX9SETTINGS.INI FILE
'============================
outFile.WriteLine (vbCRLF & "PROCESS DX9SETTINGS FILE")
outFile.WriteLine ("========================")

'FIND AND REPLACE ALL [VSXXXXXXXX] AND [PSXXXXXXXX]
   
Set objHelixFixIniFolder = objFSO.GetFolder(strHelixFixIniFolder)
Set objHelixFixIniVSFolder = objFSO.GetFolder(strHelixFixIniVSFolder)
Set objHelixFixIniPSFolder = objFSO.GetFolder(strHelixFixIniPSFolder)
Set objGameIniFolder = objFSO.GetFolder(strGameIniFolder)

Set objHelixFixIniFile = objHelixFixIniFolder.Files("DX9Settings.ini")
objGameIniFolder.CreateTextFile "DX9Settings.ini"
Set objGameIniFile = objGameIniFolder.Files("DX9Settings.ini")

Set objTextStreamHelix = objHelixFixIniFile.OpenAsTextStream(1)
Set objTextStreamGame = objGameIniFile.OpenAsTextStream(2)

on error resume next

While Not objTextStreamHelix.AtEndOfStream   'Read from original setting file
	strLineHelix = objTextStreamHelix.ReadLine
	strLineGame = strLineHelix
	
	'Check "[VS" statements
	If InStr(1, strLineHelix, "[VS") Then
		strHelixCRC = Mid(strLineHelix, InStr(1, strLineHelix, "[VS") + 3, 8)
		'strip off leading 0 as the files don't have these  ***NOTE may need to check for filename with and without " " i.e. spaces in the name, as this sometimes happens, although not for DDC or the latest dll
		REM If Left(strCRC, 1) = "0" Then strCRC = Right(strCRC, 7)
		REM If Left(strCRC, 1) = "0" Then strCRC = Right(strCRC, 6)
		REM If Left(strCRC, 1) = "0" Then strCRC = Right(strCRC, 5)
		
		'find the equivalent shader in the dumps folder
		'1. Get Orig shader
		Set objHelixShader = objHelixFixIniVSFolder.Files(strHelixCRC & ".txt")
		
		if Err > 0 then
			Err.clear
		else
		
			Set objTextStream = objHelixShader.OpenAsTextStream(1)
			strHelixShaderContents = fstrStripOutHashLines(objTextStream, strGameEXEDir, strGameEXEDirReplace)
			objTextStream.Close
			
			'2. Find shader in game dir -> strGameCRC
			strGameCRC = fstrFindGameShaderCRC(objGameDUMPSVSFolder, strHelixShaderContents, strGameEXEDir, strGameEXEDirReplace)
			
			'3. Replace strHelixCRC in strLine Helix with strGameCRC and write to Game Ini file
			strLineGame = Replace(strLineGame, strHelixCRC, strGameCRC)

			strS = "VS" & vbTab & strHelixCRC & vbTab & strGameCRC
			outFile.WriteLine(strS)			
		
		end if
		
	'Check "[PS" statements
	ElseIf InStr(1, strLineHelix, "[PS") Then
		strHelixCRC = Mid(strLineHelix, InStr(1, strLineHelix, "[PS") + 3, 8)
		'strip off leading 0 as the files don't have these  ***NOTE may need to check for filename with and without " " i.e. spaces in the name, as this sometimes happens, although not for DDC or the latest dll
		If Left(strCRC, 1) = "0" Then strCRC = Right(strCRC, 7)
		If Left(strCRC, 1) = "0" Then strCRC = Right(strCRC, 6)
		If Left(strCRC, 1) = "0" Then strCRC = Right(strCRC, 5)
		
		'find the equivalent shader in the dumps folder
		'1. Get Orig shader
		Set objHelixShader = objHelixFixIniPSFolder.Files(strHelixCRC & ".txt")
		Set objTextStream = objHelixShader.OpenAsTextStream(1)
		strHelixShaderContents = fstrStripOutHashLines(objTextStream, strGameEXEDir, strGameEXEDirReplace)
		objTextStream.Close
		
		'2. Find shader in game dir -> strGameCRC
		strGameCRC = fstrFindGameShaderCRC(objGameDUMPSPSFolder, strHelixShaderContents, strGameEXEDir, strGameEXEDirReplace)
		
		'3. Replace strHelixCRC in strLine Helix with strGameCRC and write to Game Ini file
		strLineGame = Replace(strLineGame, strHelixCRC, strGameCRC)

		strS = "PS" & vbTab & strHelixCRC & vbTab & strGameCRC
		outFile.WriteLine(strS)	
		
	End If
	
	'Write the game line out to the file
	objTextStreamGame.WriteLine strLineGame
	
Wend
    
REM 'COPY RELEASE DLL
REM '================
outFile.WriteLine (vbCRLF & "COPY DLL")
outFile.WriteLine ("========")
    
Set objHelixDLLFolder = objFSO.GetFolder(strHelixFixDLLDir)
Set objDebugFile = objHelixDLLFolder.Files("d3d9_release.dll")
objDebugFile.Copy objGameExeFolder.Path & "\d3d9.dll"

outFile.WriteLine ("DONE")

MsgBox "Completed Divinity Dragon Commander 3D Vision Helixmod Patch."

'===================================================================
Private Function fstrFindGameShaderCRC(objGameShaderFiles, strHelixShaderContents, strGameEXEDir, strGameEXEDirReplace) 
    Dim objGameShaderFile 
    Dim objTextStream 
    Dim strGameShaderFileContents 
    For Each objGameShaderFile In objGameShaderFiles.Files
        'Get its contents
        Set objTextStream = objGameShaderFile.OpenAsTextStream(1)
        strGameShaderFileContents = fstrStripOutHashLines(objTextStream, strGameEXEDir, strGameEXEDirReplace)
        objTextStream.Close
        'Check if its the same as the source file
        If strHelixShaderContents = strGameShaderFileContents Then
            strGameCRC = fstrGetCRC(objGameShaderFile.Name)
            'Stop loop
            Exit For
        End If
    Next 'objGameShaderFile
    fstrFindGameShaderCRC = strGameCRC
End Function


Private Function fstrStripOutHashLines(objHelixFixShaderFile, strGameEXEDir, strGameEXEDirReplace) 
'Strip out "#" comment lines if they contain reference to the installation directory
    Dim strLine 
    Dim strReturn 
    strReturn = ""
    While Not objHelixFixShaderFile.AtEndOfStream
        strLine = objHelixFixShaderFile.ReadLine
        If InStr(1, strLine, """") > 0 Then
			if InStr(1, strLine, strGameEXEDir) > 0 then
				strLine = Replace(strLine, strGameEXEDir, strGameEXEDirReplace, 1)    'Left(strLine, InStr(1, strLine, """")) & strGameEXEDirReplace & """"
			End If
        End If
        strReturn = strReturn + strLine
    Wend
    fstrStripOutHashLines = strReturn
End Function

Private Function fstrGetCRC(ByVal strFileName ) 
    Dim strCRC 
    strCRC = Mid(strFileName, 1, InStr(1, strFileName, ".") - 1)
    If InStr(1, strCRC, "_") > 0 Then
        strCRC = Mid(strCRC, 1, InStr(1, strCRC, "_") - 1)
    End If
    fstrGetCRC = strCRC
End Function


