/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.ui;

import com.nastel.heapdetective.jvm.JvmHeapReferenceInfo;
import com.nastel.heapdetective.jvm.JvmObjectInfo;
import com.nastel.heapdetective.ui.HeapObjectTreeModel;
import com.nastel.heapdetective.ui.HeapObjectTreeNode;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;

public class ObjectTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1858471140843254824L;
    private NumberFormat valFmt = NumberFormat.getIntegerInstance();

    public ObjectTreeCellRenderer() {
        this.valFmt.setGroupingUsed(true);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel cmp = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        TreeModel mdl = tree.getModel();
        if (mdl instanceof HeapObjectTreeModel && value instanceof HeapObjectTreeNode) {
            HeapObjectTreeModel objTreeModel = (HeapObjectTreeModel)mdl;
            Object nodeObj = objTreeModel.getNodeObject((HeapObjectTreeNode)value);
            JvmObjectInfo objInfo = null;
            if (nodeObj instanceof JvmObjectInfo) {
                objInfo = (JvmObjectInfo)nodeObj;
            } else if (nodeObj instanceof JvmHeapReferenceInfo) {
                objInfo = ((JvmHeapReferenceInfo)nodeObj).getReferee();
            }
            if (objInfo != null) {
                long size = objInfo.getRetainedSize();
                if (size < 0L) {
                    size = objInfo.getSize();
                }
                this.setText("<html>" + value + "  <font size=-2>(" + this.valFmt.format(size) + " bytes)</font></html>");
            }
        }
        return cmp;
    }
}

