/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.ui;

import com.nastel.heapdetective.jvm.JvmArrayElmtHeapRefInfo;
import com.nastel.heapdetective.jvm.JvmArrayHeapObjectInfo;
import com.nastel.heapdetective.jvm.JvmClassInfo;
import com.nastel.heapdetective.jvm.JvmFieldHeapRefInfo;
import com.nastel.heapdetective.jvm.JvmFieldInfo;
import com.nastel.heapdetective.jvm.JvmHeapReferenceInfo;
import com.nastel.heapdetective.jvm.JvmLocalHeapRefInfo;
import com.nastel.heapdetective.jvm.JvmObjectInfo;
import com.nastel.heapdetective.jvm.JvmThreadInfo;
import com.nastel.heapdetective.ui.ArrayElementRange;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class HeapObjectTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3678608097499236037L;
    protected JTable table;
    protected int rowCount;
    protected String[][] tblData;
    protected boolean isArray;
    private NumberFormat valFmt = NumberFormat.getIntegerInstance();

    public HeapObjectTableModel() {
        this.valFmt.setGroupingUsed(true);
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    public void setObject(Object result) {
        if (result == null || result instanceof ArrayElementRange) {
            this.clear();
        } else {
            JvmObjectInfo objInfo = null;
            JvmHeapReferenceInfo refInfo = null;
            if (result instanceof JvmObjectInfo) {
                objInfo = (JvmObjectInfo)result;
            } else if (result instanceof JvmHeapReferenceInfo) {
                refInfo = (JvmHeapReferenceInfo)result;
                objInfo = refInfo.getReferee();
            }
            this.rowCount = 1;
            if (objInfo instanceof JvmThreadInfo) {
                this.rowCount += 2;
            }
            this.isArray = objInfo instanceof JvmArrayHeapObjectInfo;
            if (this.isArray) {
                ++this.rowCount;
            }
            if (objInfo.getSize() != -1L) {
                ++this.rowCount;
            }
            if (objInfo.getRetainedSize() != -1L) {
                ++this.rowCount;
            }
            if (objInfo.getTotalSize() != -1L) {
                ++this.rowCount;
            }
            if (objInfo.getRefereesCount() != -1) {
                ++this.rowCount;
            }
            if (objInfo.getReferrersCount() != -1) {
                ++this.rowCount;
            }
            if (refInfo != null) {
                switch (refInfo.getKind()) {
                    case FIELD: {
                        this.rowCount += 2;
                        break;
                    }
                    case STATIC_FIELD: {
                        ++this.rowCount;
                        break;
                    }
                    case ARRAY_ELEMENT: {
                        ++this.rowCount;
                        break;
                    }
                    case STACK_LOCAL: {
                        this.rowCount += 2;
                    }
                }
            }
            this.tblData = new String[this.rowCount][2];
            int row = 0;
            this.tblData[row][0] = "Type";
            this.tblData[row][1] = objInfo instanceof JvmClassInfo ? "Class Reference" : (objInfo instanceof JvmThreadInfo ? "Thread Reference" : "Object Instance");
            ++row;
            if (objInfo instanceof JvmThreadInfo) {
                JvmThreadInfo threadInfo = (JvmThreadInfo)objInfo;
                this.tblData[row][0] = "Thread Name";
                this.tblData[row][1] = threadInfo.getName();
                this.tblData[++row][0] = "Thread ID";
                this.tblData[row][1] = String.valueOf(threadInfo.getJvmId());
                ++row;
            }
            if (this.isArray) {
                this.tblData[row][0] = "Array Length";
                this.tblData[row][1] = this.valFmt.format(((JvmArrayHeapObjectInfo)objInfo).getLength());
                ++row;
            }
            if (objInfo.getSize() != -1L) {
                this.tblData[row][0] = "Size";
                this.tblData[row][1] = String.valueOf(this.valFmt.format(objInfo.getSize())) + " bytes";
                ++row;
            }
            if (objInfo.getRetainedSize() != -1L) {
                this.tblData[row][0] = "Retained Size";
                this.tblData[row][1] = String.valueOf(this.valFmt.format(objInfo.getRetainedSize())) + " bytes";
                ++row;
            }
            if (objInfo.getTotalSize() != -1L) {
                this.tblData[row][0] = "Total Size";
                this.tblData[row][1] = String.valueOf(this.valFmt.format(objInfo.getTotalSize())) + " bytes";
                ++row;
            }
            if (objInfo.getReferrersCount() != -1) {
                this.tblData[row][0] = "References To";
                this.tblData[row][1] = this.valFmt.format(objInfo.getReferrersCount());
                ++row;
            }
            if (objInfo.getRefereesCount() != -1) {
                this.tblData[row][0] = "Objects Referred To";
                this.tblData[row][1] = this.valFmt.format(objInfo.getRefereesCount());
                ++row;
            }
            if (refInfo != null) {
                JvmFieldInfo fieldInfo = null;
                switch (refInfo.getKind()) {
                    case FIELD: {
                        fieldInfo = ((JvmFieldHeapRefInfo)refInfo).getFieldInfo();
                        this.tblData[row][0] = "Field Name";
                        this.tblData[row][1] = fieldInfo.getName();
                        this.tblData[++row][0] = "Defined in";
                        this.tblData[row][1] = fieldInfo.getDefiningClass();
                        ++row;
                        break;
                    }
                    case STATIC_FIELD: {
                        this.tblData[row][0] = "Field Name";
                        this.tblData[row][1] = ((JvmFieldHeapRefInfo)refInfo).getFieldName();
                        ++row;
                        break;
                    }
                    case ARRAY_ELEMENT: {
                        this.tblData[row][0] = "Array Element Index";
                        this.tblData[row][1] = String.valueOf(((JvmArrayElmtHeapRefInfo)refInfo).getIndex());
                        ++row;
                        break;
                    }
                    case JNI_LOCAL: {
                        this.tblData[row][0] = "Method Name";
                        this.tblData[row][1] = ((JvmLocalHeapRefInfo)refInfo).getMethodName();
                        ++row;
                        break;
                    }
                    case STACK_LOCAL: {
                        this.tblData[row][0] = "Method Name";
                        this.tblData[row][1] = ((JvmLocalHeapRefInfo)refInfo).getMethodName();
                        this.tblData[++row][0] = "Local Variable Name";
                        this.tblData[row][1] = ((JvmLocalHeapRefInfo)refInfo).getLocalVarName();
                        ++row;
                    }
                }
            }
            this.fireTableStructureChanged();
        }
        this.table.getColumnModel().getColumn(0).setPreferredWidth((int)(0.33 * (double)this.table.getWidth()));
        this.table.getColumnModel().getColumn(1).setPreferredWidth((int)(0.67 * (double)this.table.getWidth()));
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        return column == 0 ? "Item" : "Value";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.tblData != null ? this.tblData[rowIndex][columnIndex] : "";
    }

    public void clear() {
        this.rowCount = 0;
        this.tblData = null;
        this.isArray = false;
        this.fireTableStructureChanged();
    }
}

