/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.ui;

import com.nastel.heapdetective.jvm.JvmArrayElmtHeapRefInfo;
import com.nastel.heapdetective.jvm.JvmFieldHeapRefInfo;
import com.nastel.heapdetective.jvm.JvmHeapReferenceInfo;
import com.nastel.heapdetective.jvm.JvmLocalHeapRefInfo;
import com.nastel.heapdetective.jvm.JvmMethodInfo;
import com.nastel.heapdetective.jvm.JvmMethodLocalVarInfo;
import com.nastel.heapdetective.jvm.JvmObjectInfo;
import com.nastel.heapdetective.jvm.JvmThreadInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class HeapObjRefTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = -3308783415135585354L;
    protected DefaultMutableTreeNode rootNode;
    protected ArrayList<RefNodeObject> objNodes;

    public HeapObjRefTreeModel(String rootLabel) {
        super(new DefaultMutableTreeNode(rootLabel));
        this.rootNode = (DefaultMutableTreeNode)this.root;
        this.objNodes = new ArrayList();
    }

    public void setObject(JvmObjectInfo obj) {
        if (obj == null) {
            this.clear();
        } else {
            this.buildTree(this.rootNode, obj.getReferrers());
        }
    }

    protected void buildTree(DefaultMutableTreeNode node, Collection<JvmHeapReferenceInfo> heapRefs) {
        node.removeAllChildren();
        this.objNodes.clear();
        for (JvmHeapReferenceInfo refInfo : heapRefs) {
            Object heapObj = refInfo.getReferrer();
            if (heapObj == null) {
                heapObj = "Heap Roots";
            }
            DefaultMutableTreeNode objNode = null;
            int n = 0;
            while (n < this.objNodes.size()) {
                if (this.objNodes.get(n).equals(heapObj)) {
                    objNode = this.objNodes.get((int)n).node;
                    break;
                }
                ++n;
            }
            if (objNode == null) {
                RefNodeObject objNodeInfo = new RefNodeObject(heapObj);
                this.objNodes.add(objNodeInfo);
                objNodeInfo.node = objNode = new DefaultMutableTreeNode(objNodeInfo);
                node.add(objNode);
            }
            DefaultMutableTreeNode refNode = new DefaultMutableTreeNode((Object)refInfo.getKind());
            objNode.add(refNode);
            JvmMethodInfo mthdInfo = null;
            JvmThreadInfo threadInfo = null;
            switch (refInfo.getKind()) {
                case FIELD: 
                case STATIC_FIELD: {
                    refNode.add(new DefaultMutableTreeNode("Field: " + ((JvmFieldHeapRefInfo)refInfo).getFieldName()));
                    break;
                }
                case ARRAY_ELEMENT: {
                    refNode.add(new DefaultMutableTreeNode("Index: " + ((JvmArrayElmtHeapRefInfo)refInfo).getIndex()));
                    break;
                }
                case THREAD: {
                    threadInfo = (JvmThreadInfo)refInfo.getReferee();
                    refNode.add(new DefaultMutableTreeNode("Thread: " + threadInfo.getName() + " (TID: " + threadInfo.getJvmId() + ")"));
                    break;
                }
                case STACK_LOCAL: 
                case JNI_LOCAL: {
                    threadInfo = ((JvmLocalHeapRefInfo)refInfo).getThreadInfo();
                    mthdInfo = ((JvmLocalHeapRefInfo)refInfo).getMethodInfo();
                    refNode.add(new DefaultMutableTreeNode("Thread: " + threadInfo.getName() + " (TID: " + threadInfo.getJvmId() + ")"));
                    if (mthdInfo == null) break;
                    refNode.add(new DefaultMutableTreeNode("Method: " + mthdInfo));
                    JvmMethodLocalVarInfo lvarInfo = mthdInfo.getLocalVar(((JvmLocalHeapRefInfo)refInfo).getSlot());
                    if (lvarInfo == null) break;
                    refNode.add(new DefaultMutableTreeNode("Variable: " + lvarInfo));
                }
            }
        }
        this.nodeStructureChanged(node);
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.objNodes.clear();
        this.nodeStructureChanged(this.rootNode);
    }

    protected class RefNodeObject {
        public Object objInfo;
        public DefaultMutableTreeNode node;

        RefNodeObject(Object obj) {
            this.objInfo = obj;
        }

        public int hashCode() {
            return this.objInfo.hashCode();
        }

        public boolean equals(Object obj) {
            return this.objInfo.equals(obj);
        }

        public String toString() {
            if (this.objInfo instanceof JvmObjectInfo) {
                return ((JvmObjectInfo)this.objInfo).getClassInfo().toString();
            }
            return this.objInfo.toString();
        }
    }
}

