/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.ui;

import com.nastel.heapdetective.ui.HeapClassTableModel;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ClassTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 715792758961084242L;
    private NumberFormat valFmt = NumberFormat.getIntegerInstance();
    private NumberFormat pctFmt;

    public ClassTableCellRenderer() {
        this.valFmt.setGroupingUsed(true);
        this.pctFmt = NumberFormat.getPercentInstance();
        this.pctFmt.setMinimumFractionDigits(1);
        this.pctFmt.setMaximumFractionDigits(1);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel cmp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (column > 0) {
            row = table.convertRowIndexToModel(row);
            HeapClassTableModel mdl = (HeapClassTableModel)table.getModel();
            Object cellVal = mdl.getValueAt(row, column);
            if (cellVal instanceof Number) {
                double percent = mdl.getValuePercentage(row, column);
                if (percent >= 0.0) {
                    cmp.setText("<html>" + this.valFmt.format(cellVal) + "  <font size=-2>(" + this.pctFmt.format(percent) + ")</font></html>");
                } else {
                    cmp.setText(this.valFmt.format(cellVal));
                }
            }
        }
        return cmp;
    }
}

