/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class AboutDialog
extends JDialog
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = -2857018751870338340L;
    private static final String NASTEL_URL = "http://www.nastel.com";
    private static final String INFO_URL = "http://www.nastel.com/solutions/by-technology/application-servers/autopilot-heap-detective.html";
    protected JLabel lblNastelUrl;
    protected JLabel lblLearnMore;
    protected JButton btnClose;

    public AboutDialog(JFrame parent) {
        this.setName("aphdAboutDialog");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setBounds(100, 100, 540, 720);
        this.setTitle("AutoPilot\u00ae Heap Detective\u2122");
        this.setLocationRelativeTo(parent);
        this.setIconImage(parent.getIconImage());
        JPanel pnlLogo = new JPanel();
        pnlLogo.setBackground(Color.WHITE);
        this.getContentPane().add((Component)pnlLogo, "North");
        pnlLogo.setLayout(new BorderLayout(0, 2));
        JLabel lblLogo = new JLabel("");
        lblLogo.setHorizontalAlignment(0);
        lblLogo.setIcon(new ImageIcon(AboutDialog.class.getResource("/com/nastel/heapdetective/ui/images/aphd-logo.png")));
        pnlLogo.add((Component)lblLogo, "Center");
        JSeparator separator = new JSeparator();
        pnlLogo.add((Component)separator, "South");
        JPanel pnlInfo = new JPanel();
        this.getContentPane().add((Component)pnlInfo, "Center");
        GridBagLayout gbl_pnlInfo = new GridBagLayout();
        int[] nArray = new int[6];
        nArray[0] = 20;
        nArray[1] = 80;
        nArray[4] = 20;
        gbl_pnlInfo.columnWidths = nArray;
        int[] nArray2 = new int[12];
        nArray2[0] = 10;
        nArray2[4] = 20;
        nArray2[9] = 20;
        gbl_pnlInfo.rowHeights = nArray2;
        gbl_pnlInfo.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_pnlInfo.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        pnlInfo.setLayout(gbl_pnlInfo);
        JLabel lblTitle = new JLabel("AutoPilot\u00ae Heap Detective\u2122");
        lblTitle.setFont(new Font("Tahoma", 1, 12));
        GridBagConstraints gbc_lblTitle = new GridBagConstraints();
        gbc_lblTitle.insets = new Insets(0, 0, 5, 5);
        gbc_lblTitle.gridwidth = 3;
        gbc_lblTitle.anchor = 17;
        gbc_lblTitle.gridx = 1;
        gbc_lblTitle.gridy = 1;
        pnlInfo.add((Component)lblTitle, gbc_lblTitle);
        JLabel lblVersion = new JLabel("Version 1.0");
        lblVersion.setFont(new Font("Tahoma", 1, 11));
        GridBagConstraints gbc_lblVersion = new GridBagConstraints();
        gbc_lblVersion.insets = new Insets(0, 0, 5, 5);
        gbc_lblVersion.anchor = 17;
        gbc_lblVersion.gridwidth = 3;
        gbc_lblVersion.gridx = 1;
        gbc_lblVersion.gridy = 2;
        pnlInfo.add((Component)lblVersion, gbc_lblVersion);
        JLabel lblCopyright = new JLabel("Copyright \u00a9 2012 Nastel Technologies, Inc.  All rights reserved.");
        lblCopyright.setFont(new Font("Tahoma", 0, 11));
        GridBagConstraints gbc_lblCopyright = new GridBagConstraints();
        gbc_lblCopyright.insets = new Insets(0, 0, 5, 5);
        gbc_lblCopyright.gridwidth = 3;
        gbc_lblCopyright.anchor = 17;
        gbc_lblCopyright.gridx = 1;
        gbc_lblCopyright.gridy = 3;
        pnlInfo.add((Component)lblCopyright, gbc_lblCopyright);
        JSeparator separator_1 = new JSeparator();
        GridBagConstraints gbc_separator_1 = new GridBagConstraints();
        gbc_separator_1.fill = 2;
        gbc_separator_1.anchor = 17;
        gbc_separator_1.gridwidth = 3;
        gbc_separator_1.insets = new Insets(0, 0, 5, 5);
        gbc_separator_1.gridx = 1;
        gbc_separator_1.gridy = 4;
        pnlInfo.add((Component)separator_1, gbc_separator_1);
        JLabel lblJvmInfo = new JLabel(String.format("Java version: %s (%s)", System.getProperty("java.version"), System.getProperty("java.vm.name")));
        GridBagConstraints gbc_lblJvmInfo = new GridBagConstraints();
        gbc_lblJvmInfo.gridwidth = 3;
        gbc_lblJvmInfo.anchor = 17;
        gbc_lblJvmInfo.insets = new Insets(0, 0, 5, 5);
        gbc_lblJvmInfo.gridx = 1;
        gbc_lblJvmInfo.gridy = 5;
        pnlInfo.add((Component)lblJvmInfo, gbc_lblJvmInfo);
        JLabel lblJvmVendor = new JLabel("Jvm vendor: " + System.getProperty("java.vendor"));
        GridBagConstraints gbc_lblJvmVendor = new GridBagConstraints();
        gbc_lblJvmVendor.anchor = 17;
        gbc_lblJvmVendor.gridwidth = 3;
        gbc_lblJvmVendor.insets = new Insets(0, 0, 5, 5);
        gbc_lblJvmVendor.gridx = 1;
        gbc_lblJvmVendor.gridy = 6;
        pnlInfo.add((Component)lblJvmVendor, gbc_lblJvmVendor);
        JLabel lblOsInfo = new JLabel(String.format("OS Type: %s, %s   CPU count: %d", System.getProperty("os.name"), System.getProperty("os.arch"), Runtime.getRuntime().availableProcessors()));
        GridBagConstraints gbc_lblOsInfo = new GridBagConstraints();
        gbc_lblOsInfo.gridwidth = 3;
        gbc_lblOsInfo.anchor = 17;
        gbc_lblOsInfo.insets = new Insets(0, 0, 5, 5);
        gbc_lblOsInfo.gridx = 1;
        gbc_lblOsInfo.gridy = 7;
        pnlInfo.add((Component)lblOsInfo, gbc_lblOsInfo);
        JLabel lblHeapInfo = new JLabel(String.format("Java Heap: Max=%,d KB   Total=%,d KB   Free=%,d KB", Runtime.getRuntime().maxMemory() / 1024L, Runtime.getRuntime().totalMemory() / 1024L, Runtime.getRuntime().freeMemory() / 1024L));
        GridBagConstraints gbc_lblHeapInfo = new GridBagConstraints();
        gbc_lblHeapInfo.anchor = 17;
        gbc_lblHeapInfo.gridwidth = 3;
        gbc_lblHeapInfo.insets = new Insets(0, 0, 5, 5);
        gbc_lblHeapInfo.gridx = 1;
        gbc_lblHeapInfo.gridy = 8;
        pnlInfo.add((Component)lblHeapInfo, gbc_lblHeapInfo);
        JSeparator separator_2 = new JSeparator();
        GridBagConstraints gbc_separator_2 = new GridBagConstraints();
        gbc_separator_2.fill = 2;
        gbc_separator_2.anchor = 17;
        gbc_separator_2.gridwidth = 3;
        gbc_separator_2.insets = new Insets(0, 0, 5, 5);
        gbc_separator_2.gridx = 1;
        gbc_separator_2.gridy = 9;
        pnlInfo.add((Component)separator_2, gbc_separator_2);
        JLabel lblVisitUsOnline = new JLabel("Visit us online:");
        GridBagConstraints gbc_lblVisitUsOnline = new GridBagConstraints();
        gbc_lblVisitUsOnline.anchor = 17;
        gbc_lblVisitUsOnline.insets = new Insets(0, 0, 0, 5);
        gbc_lblVisitUsOnline.gridx = 1;
        gbc_lblVisitUsOnline.gridy = 10;
        pnlInfo.add((Component)lblVisitUsOnline, gbc_lblVisitUsOnline);
        this.lblNastelUrl = new JLabel("<html><u>http://www.nastel.com</u></html>");
        this.lblNastelUrl.setForeground(Color.BLUE);
        this.lblNastelUrl.setCursor(Cursor.getPredefinedCursor(12));
        this.lblNastelUrl.addMouseListener(this);
        GridBagConstraints gbc_lblNastelUrl = new GridBagConstraints();
        gbc_lblNastelUrl.anchor = 17;
        gbc_lblNastelUrl.insets = new Insets(0, 0, 0, 5);
        gbc_lblNastelUrl.gridx = 2;
        gbc_lblNastelUrl.gridy = 10;
        pnlInfo.add((Component)this.lblNastelUrl, gbc_lblNastelUrl);
        this.lblLearnMore = new JLabel("<html><u>Learn more about Heap Detective...</u></html>");
        this.lblLearnMore.setForeground(Color.BLUE);
        this.lblLearnMore.setCursor(Cursor.getPredefinedCursor(12));
        this.lblLearnMore.addMouseListener(this);
        GridBagConstraints gbc_lblLearnMore = new GridBagConstraints();
        gbc_lblLearnMore.insets = new Insets(0, 0, 0, 5);
        gbc_lblLearnMore.gridx = 3;
        gbc_lblLearnMore.gridy = 10;
        pnlInfo.add((Component)this.lblLearnMore, gbc_lblLearnMore);
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        this.btnClose = new JButton("Close");
        this.btnClose.addActionListener(this);
        panel.add(this.btnClose);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnClose) {
            this.setVisible(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String url = null;
        if (e.getSource() == this.lblNastelUrl) {
            url = NASTEL_URL;
        } else if (e.getSource() == this.lblLearnMore) {
            url = INFO_URL;
        }
        try {
            if (url != null) {
                Desktop.getDesktop().browse(URI.create(url));
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Failed launching browser:\n" + ioe, this.getTitle(), 0);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

