/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.jvm;

import com.nastel.heapdetective.jvm.JvmClassInfo;
import com.nastel.heapdetective.jvm.JvmHeapReferenceInfo;
import com.nastel.heapdetective.jvm.JvmInfoComparator;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SortOrder;

public abstract class JvmObjectInfo {
    protected long tag;
    protected long size = -1L;
    protected boolean heapRoot = false;
    protected ArrayList<JvmHeapReferenceInfo> referrers;
    protected ArrayList<JvmHeapReferenceInfo> referees;

    public abstract JvmClassInfo getClassInfo();

    public abstract long getRetainedSize();

    public abstract long getTotalSize();

    public abstract void printHierarchy(PrintWriter var1, int var2);

    public long getTag() {
        return this.tag;
    }

    public void setTag(long tag) {
        this.tag = tag;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean isHeapRoot() {
        return this.heapRoot;
    }

    public void setHeapRoot(boolean heapRoot) {
        this.heapRoot = heapRoot;
    }

    public int getReferrersCount() {
        return this.referrers == null ? 0 : this.referrers.size();
    }

    public int getRefereesCount() {
        return this.referees == null ? 0 : this.referees.size();
    }

    public void addReferrer(JvmHeapReferenceInfo heapRef) {
        if (this.referrers == null) {
            this.referrers = new ArrayList();
        }
        this.referrers.add(heapRef);
    }

    public void addReferee(JvmHeapReferenceInfo heapRef) {
        if (this.referees == null) {
            this.referees = new ArrayList();
        }
        this.referees.add(heapRef);
    }

    public ArrayList<JvmHeapReferenceInfo> getReferrers() {
        return this.referrers;
    }

    public ArrayList<JvmHeapReferenceInfo> getReferees() {
        return this.referees;
    }

    public int hashCode() {
        return (int)(this.tag ^ this.tag >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof JvmObjectInfo) {
            return ((JvmObjectInfo)obj).getTag() == this.getTag();
        }
        return false;
    }

    public String toString() {
        return super.toString();
    }

    public static void sortByRetainedSize(List<JvmObjectInfo> objects, SortOrder order) {
        Collections.sort(objects, new RetainedSizeComparator(order));
    }

    public static void sortBySize(List<JvmObjectInfo> objects, SortOrder order) {
        Collections.sort(objects, new SizeComparator(order));
    }

    public static class RetainedSizeComparator
    extends JvmInfoComparator {
        public RetainedSizeComparator(SortOrder order) {
            super(order);
        }

        @Override
        public int compare(JvmObjectInfo o1, JvmObjectInfo o2) {
            return RetainedSizeComparator.compareValues(this.order, o1.getRetainedSize(), o2.getRetainedSize());
        }
    }

    public static class SizeComparator
    extends JvmInfoComparator {
        public SizeComparator(SortOrder order) {
            super(order);
        }

        @Override
        public int compare(JvmObjectInfo o1, JvmObjectInfo o2) {
            return SizeComparator.compareValues(this.order, o1.getSize(), o2.getSize());
        }
    }
}

