/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.jvm;

import com.nastel.heapdetective.jvm.JvmClassInfo;
import com.nastel.heapdetective.jvm.JvmMethodLocalVarInfo;
import java.io.PrintWriter;
import java.util.ArrayList;

public class JvmMethodInfo {
    protected long tag;
    protected String name;
    protected String signature;
    protected JvmClassInfo classInfo;
    protected ArrayList<JvmMethodLocalVarInfo> localVars;

    public long getTag() {
        return this.tag;
    }

    public void setTag(long tag) {
        this.tag = tag;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public JvmClassInfo getClassInfo() {
        return this.classInfo;
    }

    public void setClassInfo(JvmClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public void setLocalVarCount(int varCount) {
        if (varCount > 0) {
            this.localVars = new ArrayList(varCount);
        }
    }

    public void addLocalVar(JvmMethodLocalVarInfo varInfo) {
        if (this.localVars == null) {
            this.localVars = new ArrayList();
        }
        this.localVars.add(varInfo);
    }

    public JvmMethodLocalVarInfo getLocalVar(int slot) {
        if (this.localVars == null) {
            return null;
        }
        for (JvmMethodLocalVarInfo lvarInfo : this.localVars) {
            if (lvarInfo.getSlot() != slot) continue;
            return lvarInfo;
        }
        return null;
    }

    public int hashCode() {
        return (int)(this.tag ^ this.tag >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof JvmMethodInfo) {
            return ((JvmMethodInfo)obj).getTag() == this.getTag();
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.name) + this.signature;
    }

    public void printHierarchy(PrintWriter output, int level) {
        output.format("%" + level + "s%s: name=%s, tag=%s, sig=%s", " ", this.getClass().getName(), this.name, Long.toHexString(this.tag), this.signature);
        for (JvmMethodLocalVarInfo lvarInfo : this.localVars) {
            lvarInfo.printHierarchy(output, level + 1);
        }
    }
}

