/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.jvm;

import com.nastel.heapdetective.jvm.JvmClassInfo;
import com.nastel.heapdetective.jvm.JvmHeapReferenceInfo;
import com.nastel.heapdetective.jvm.JvmHeapReferenceKind;
import com.nastel.heapdetective.jvm.JvmMethodInfo;
import com.nastel.heapdetective.jvm.JvmMethodLocalVarInfo;
import com.nastel.heapdetective.jvm.JvmThreadInfo;

public class JvmLocalHeapRefInfo
extends JvmHeapReferenceInfo {
    protected JvmThreadInfo threadInfo;
    protected int depth;
    protected long method;
    protected int slot = -1;

    public JvmLocalHeapRefInfo(JvmHeapReferenceKind kind) {
        super(kind);
    }

    public JvmThreadInfo getThreadInfo() {
        return this.threadInfo;
    }

    public void setThreadInfo(JvmThreadInfo threadInfo) {
        this.threadInfo = threadInfo;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public long getMethod() {
        return this.method;
    }

    public void setMethod(long method) {
        this.method = method;
    }

    public JvmMethodInfo getMethodInfo() {
        if (this.threadInfo == null || this.method == 0L) {
            return null;
        }
        JvmClassInfo classInfo = this.threadInfo.getClassInfo();
        if (classInfo != null) {
            return classInfo.getMethod(this.method);
        }
        return null;
    }

    public String getMethodName() {
        JvmMethodInfo mthdInfo = this.getMethodInfo();
        return mthdInfo == null ? null : mthdInfo.getName();
    }

    public JvmMethodLocalVarInfo getLocalVarInfo() {
        if (this.slot < 0) {
            return null;
        }
        JvmMethodInfo mthdInfo = this.getMethodInfo();
        return mthdInfo == null ? null : mthdInfo.getLocalVar(this.slot);
    }

    public String getLocalVarName() {
        JvmMethodLocalVarInfo varInfo = this.getLocalVarInfo();
        return varInfo == null ? null : varInfo.getName();
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    @Override
    public int hashCode() {
        return (int)((long)(this.threadInfo == null ? 0 : this.threadInfo.hashCode()) ^ (this.method ^ this.method >>> 32) + (long)this.depth);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JvmLocalHeapRefInfo) {
            JvmLocalHeapRefInfo other = (JvmLocalHeapRefInfo)obj;
            if (this.threadInfo == null && other.threadInfo != null) {
                return false;
            }
            if (this.threadInfo != null && !this.threadInfo.equals(other.threadInfo)) {
                return false;
            }
            return other.method == this.method && other.depth == this.depth;
        }
        return false;
    }

    @Override
    public String toString() {
        JvmMethodInfo mthdInfo = this.getMethodInfo();
        JvmMethodLocalVarInfo lvarInfo = this.getLocalVarInfo();
        String str = "Thread: " + (this.threadInfo == null ? "?" : this.threadInfo.getName()) + ", Method: " + (mthdInfo == null ? "?" : mthdInfo.getName());
        if (lvarInfo != null) {
            str = String.valueOf(str) + ", Local Var: " + lvarInfo.getName();
        }
        return String.valueOf(str) + " (" + this.referee.getClassInfo().getName() + ")";
    }
}

