/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.jvm;

import com.nastel.heapdetective.jvm.JvmClassInfo;
import com.nastel.heapdetective.jvm.JvmFieldInfo;
import com.nastel.heapdetective.jvm.JvmHeapReferenceInfo;
import com.nastel.heapdetective.jvm.JvmHeapReferenceKind;

public class JvmIndexHeapRefInfo
extends JvmHeapReferenceInfo {
    protected int index;

    public JvmIndexHeapRefInfo(JvmHeapReferenceKind kind) {
        super(kind);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.index;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof JvmIndexHeapRefInfo && ((JvmIndexHeapRefInfo)obj).index == this.index;
    }

    @Override
    public String toString() {
        JvmClassInfo classInfo = this.referee.getClassInfo();
        JvmFieldInfo fieldInfo = null;
        String str = "";
        switch (this.getKind()) {
            case FIELD: 
            case STATIC_FIELD: {
                fieldInfo = this.referrer.getClassInfo().getField(this.index);
                String string = str = this.getKind() == JvmHeapReferenceKind.STATIC_FIELD ? "Static Field: " : "Field: ";
                if (fieldInfo == null) {
                    str = String.valueOf(str) + "?";
                    break;
                }
                str = String.valueOf(str) + fieldInfo.getName();
                break;
            }
            case ARRAY_ELEMENT: {
                str = "[" + this.index + "]";
                break;
            }
            default: {
                str = super.toString();
            }
        }
        str = String.valueOf(str) + " (" + classInfo + ")";
        return str;
    }
}

