/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.client;

import com.nastel.heapdetective.client.AgentSnapshotResult;
import com.nastel.heapdetective.jvm.JvmHeapObjectInfo;
import com.nastel.heapdetective.jvm.JvmHeapReferenceInfo;
import com.nastel.heapdetective.jvm.JvmObjectInfo;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Stack;

public class Dominators {
    protected JvmObjectInfo[] nodes;
    protected BitSet[] succ;
    protected BitSet[] pred;
    protected BitSet[] bucket;
    protected int[] parent;
    protected int[] ancestor;
    protected int[] vertex;
    protected int[] label;
    protected int[] semi;
    protected int[] dom;
    protected int rootIndex;
    protected int nodeIndex;
    protected AgentSnapshotResult snapshot;
    protected long baseObjTag;

    public Dominators(AgentSnapshotResult snapshot, long baseTag) {
        BitSet rootSucc;
        this.snapshot = snapshot;
        this.baseObjTag = baseTag;
        Collection<JvmObjectInfo> heapObjs = snapshot.getHeapObjects();
        this.rootIndex = heapObjs.size() + 1;
        int listSize = this.rootIndex + 1;
        this.nodes = new JvmObjectInfo[listSize];
        this.succ = new BitSet[listSize];
        this.pred = new BitSet[listSize];
        this.bucket = new BitSet[listSize];
        this.parent = new int[listSize];
        this.ancestor = new int[listSize];
        this.vertex = new int[listSize];
        this.label = new int[listSize];
        this.semi = new int[listSize];
        this.succ[this.rootIndex] = rootSucc = new BitSet(listSize);
        this.pred[this.rootIndex] = new BitSet(listSize);
        this.bucket[this.rootIndex] = new BitSet(listSize);
        for (JvmObjectInfo heapObj : heapObjs) {
            int nodeIndex = this.getObjectIndex(heapObj.getTag());
            BitSet nodeSucc = new BitSet(listSize);
            ArrayList<JvmHeapReferenceInfo> referees = heapObj.getReferees();
            for (JvmHeapReferenceInfo ref : referees) {
                JvmObjectInfo obj = ref.getReferee();
                if (obj == null) continue;
                int objIndex = this.getObjectIndex(obj.getTag());
                nodeSucc.set(objIndex);
                if (!obj.isHeapRoot()) continue;
                rootSucc.set(objIndex);
            }
            this.nodes[nodeIndex] = heapObj;
            this.succ[nodeIndex] = nodeSucc;
            this.pred[nodeIndex] = new BitSet(listSize);
            this.bucket[nodeIndex] = new BitSet(listSize);
        }
    }

    public void generate() {
        int w;
        this.nodeIndex = 0;
        this.depthFirstSearch(this.rootIndex);
        int i = this.rootIndex;
        while (i >= 2) {
            int u;
            w = this.vertex[i];
            BitSet bs = this.pred[w];
            int v = bs.nextSetBit(0);
            while (v >= 0) {
                u = this.eval(i);
                if (this.semi[u] < this.semi[w]) {
                    this.semi[w] = this.semi[u];
                }
                v = bs.nextSetBit(v + 1);
            }
            this.bucket[this.vertex[this.semi[w]]].set(w);
            this.link(this.parent[w], w);
            bs = this.bucket[this.parent[w]];
            v = bs.nextSetBit(0);
            while (v >= 0) {
                this.bucket[this.parent[w]].clear(v);
                u = this.eval(v);
                this.dom[v] = this.semi[u] < this.semi[v] ? u : this.parent[w];
                v = bs.nextSetBit(v + 1);
            }
            --i;
        }
        i = 2;
        while (i <= this.rootIndex) {
            w = this.vertex[i];
            if (this.dom[w] != this.vertex[this.semi[w]]) {
                this.dom[w] = this.dom[this.dom[w]];
            }
            ++i;
        }
        this.dom[this.rootIndex] = 0;
    }

    protected void depthFirstSearch(int v) {
        this.semi[v] = ++this.nodeIndex;
        this.vertex[this.nodeIndex] = v;
        this.label[v] = v;
        this.ancestor[v] = 0;
        BitSet bs = this.succ[v];
        int w = bs.nextSetBit(0);
        while (w >= 0) {
            if (this.semi[w] == 0) {
                this.parent[w] = v;
                this.depthFirstSearch(v);
            }
            this.pred[w].set(v);
            w = bs.nextSetBit(w + 1);
        }
    }

    protected void compress(int v) {
        if (this.ancestor[this.ancestor[v]] != 0) {
            this.compress(this.ancestor[v]);
            if (this.semi[this.label[this.ancestor[v]]] < this.semi[this.label[v]]) {
                this.label[v] = this.label[this.ancestor[v]];
            }
            this.ancestor[v] = this.ancestor[this.ancestor[v]];
        }
    }

    protected int eval(int v) {
        if (this.ancestor[v] == 0) {
            return v;
        }
        this.compress(v);
        return this.label[v];
    }

    protected void link(int v, int w) {
        this.ancestor[w] = v;
    }

    protected int getObjectIndex(long tag) {
        return (int)(tag - this.baseObjTag + 1L);
    }

    protected long getObjectTag(int index) {
        return (int)((long)index + this.baseObjTag - 1L);
    }

    public void computeRetainedSizes() {
        Stack<JvmHeapObjectInfo> objStack = new Stack<JvmHeapObjectInfo>();
        int i = 1;
        while (i < this.rootIndex) {
            JvmObjectInfo objInfo = this.snapshot.getHeapObject(this.getObjectTag(i));
            if (objInfo instanceof JvmHeapObjectInfo) {
                JvmHeapObjectInfo heapObj = (JvmHeapObjectInfo)objInfo;
                objStack.push(heapObj);
                while (!objStack.isEmpty()) {
                    JvmHeapObjectInfo jvmHeapObjectInfo = (JvmHeapObjectInfo)objStack.pop();
                }
                heapObj.setRetainedSize(heapObj.getRetainedSize() + heapObj.getSize());
            }
            ++i;
        }
    }
}

