/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.client;

import com.nastel.heapdetective.client.AgentCommandType;
import com.nastel.heapdetective.client.AgentResult;
import com.nastel.heapdetective.jvm.JvmClassInfo;
import com.nastel.heapdetective.jvm.JvmHeapObjectInfo;
import com.nastel.heapdetective.jvm.JvmObjectInfo;
import com.nastel.heapdetective.jvm.JvmThreadInfo;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class AgentSnapshotResult
extends AgentResult {
    protected long lastJvmUpdate;
    protected HashMap<Long, JvmClassInfo> classes;
    protected HashMap<Long, JvmThreadInfo> threads;
    protected HashMap<Long, JvmObjectInfo> heapObjects;
    protected HashMap<Long, JvmObjectInfo> heapRoots;
    protected TreeMap<String, Object> metrics = new TreeMap();
    protected long totalInstanceCount;
    protected long totalHeapSize;
    protected int totalHeapRefs;
    protected int totalHeapRoots;
    protected long baseObjTag = Long.MAX_VALUE;

    public AgentSnapshotResult() {
        super(AgentCommandType.SNAPSHOT);
    }

    public long getLastJvmUpdate() {
        return this.lastJvmUpdate;
    }

    public void setLastJvmUpdate(long lastJvmUpdate) {
        this.lastJvmUpdate = lastJvmUpdate;
    }

    public void setClassCount(int numClasses) {
        if (this.classes == null) {
            this.classes = new HashMap(numClasses);
        }
    }

    public int getClassCount() {
        return this.classes == null ? 0 : this.classes.size();
    }

    public JvmClassInfo getClassInfo(long tag) {
        return this.classes == null ? null : this.classes.get(tag);
    }

    public void addClass(JvmClassInfo classInfo) {
        if (this.classes == null) {
            this.classes = new HashMap();
        }
        if (classInfo.getTag() != 0L) {
            this.classes.put(classInfo.getTag(), classInfo);
            this.totalInstanceCount += (long)classInfo.getTotalInstances();
            this.totalHeapSize += classInfo.getTotalSize();
        }
    }

    public Collection<JvmClassInfo> getClasses() {
        return this.classes == null ? null : this.classes.values();
    }

    public void setThreadCount(int numThreads) {
        if (this.threads == null) {
            this.threads = new HashMap(numThreads);
        }
    }

    public int getThreadCount() {
        return this.threads == null ? 0 : this.threads.size();
    }

    public JvmThreadInfo getThread(long tag) {
        return this.threads == null ? null : this.threads.get(tag);
    }

    public void addThread(JvmThreadInfo thread) {
        if (this.threads == null) {
            this.threads = new HashMap();
        }
        if (thread.getTag() != 0L) {
            this.threads.put(thread.getTag(), thread);
        }
    }

    public Collection<JvmThreadInfo> getThreads() {
        return this.threads == null ? null : this.threads.values();
    }

    public long getTotalInstanceCount() {
        return this.totalInstanceCount;
    }

    public long getTotalHeapSize() {
        return this.totalHeapSize;
    }

    public void setHeapObjectCount(int objCount) {
        if (this.heapObjects == null) {
            this.heapObjects = new HashMap(objCount);
        }
    }

    public void addHeapObject(JvmHeapObjectInfo heapObj) {
        if (this.heapObjects == null) {
            this.heapObjects = new HashMap();
        }
        this.heapObjects.put(heapObj.getTag(), heapObj);
        if (heapObj.getTag() < this.baseObjTag) {
            this.baseObjTag = heapObj.getTag();
        }
    }

    public JvmObjectInfo getHeapObject(long tag) {
        return this.heapObjects == null ? null : this.heapObjects.get(tag);
    }

    public Collection<JvmObjectInfo> getHeapObjects() {
        return this.heapObjects == null ? null : this.heapObjects.values();
    }

    public long getBaseObjTag() {
        return this.baseObjTag;
    }

    public int getTotalHeapRoots() {
        return this.totalHeapRoots;
    }

    public void setHeapRootCount(int totalHeapRoots) {
        this.totalHeapRoots = totalHeapRoots;
    }

    public JvmObjectInfo getObject(long tag) {
        JvmObjectInfo obj = this.getHeapObject(tag);
        if (obj != null) {
            return obj;
        }
        obj = this.getClassInfo(tag);
        if (obj != null) {
            return obj;
        }
        return this.getThread(tag);
    }

    public void addHeapRoot(JvmObjectInfo rootObj) {
        if (this.heapRoots == null) {
            this.heapRoots = new HashMap(this.totalHeapRoots);
        }
        this.heapRoots.put(rootObj.getTag(), rootObj);
        rootObj.setHeapRoot(true);
    }

    public Collection<JvmObjectInfo> getHeapRoots() {
        return this.heapRoots == null ? null : this.heapRoots.values();
    }

    public void setTotalHeapRefs(int totalHeapRefs) {
        this.totalHeapRefs = totalHeapRefs;
    }

    public int getTotalHeapRefs() {
        return this.totalHeapRefs;
    }

    public void addMetric(String prop, Object value) {
        String propType = null;
        if (prop.startsWith("$")) {
            propType = prop.substring(0, 3);
            prop = prop.substring(3);
        }
        if ("$L$".equals(propType)) {
            this.metrics.put(prop, Long.parseLong(value.toString()));
        } else if ("$I$".equals(propType)) {
            this.metrics.put(prop, Integer.parseInt(value.toString()));
        } else if ("$T$".equals(propType)) {
            long ts = Long.parseLong(value.toString());
            if (ts == 0L) {
                this.metrics.put(prop, "");
            } else {
                this.metrics.put(prop, new Date(ts));
            }
        } else {
            this.metrics.put(prop, value);
        }
    }

    public Object getMetric(String prop) {
        return this.metrics.get(prop);
    }

    public Set<Map.Entry<String, Object>> getAllMetrics() {
        return this.metrics.entrySet();
    }

    public void printHierarchy(PrintWriter output) {
        output.println("\nComplete Class Info:");
        Collection<JvmClassInfo> allClasses = this.getClasses();
        for (JvmClassInfo classInfo : allClasses) {
            classInfo.printHierarchy(output, 0);
        }
        output.println("\nComplete Thread Info:");
        Collection<JvmThreadInfo> allThreads = this.getThreads();
        for (JvmThreadInfo classInfo : allThreads) {
            classInfo.printHierarchy(output, 0);
        }
        Collection<JvmObjectInfo> allObjs = this.getHeapObjects();
        if (allObjs != null) {
            output.println("\nHeap Object Instances:");
            for (JvmObjectInfo objInfo : allObjs) {
                if (!(objInfo instanceof JvmHeapObjectInfo)) continue;
                objInfo.printHierarchy(output, 0);
            }
        }
    }
}

