/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.client;

import com.nastel.heapdetective.client.AgentCommandType;
import com.nastel.heapdetective.client.AgentResult;
import java.util.ArrayList;

public class AgentResponse {
    protected boolean last = true;
    protected int status = 1;
    protected String errorMsg = null;
    protected ArrayList<AgentResult> results = new ArrayList(AgentCommandType.getDisplayNames().length);

    public void resetStatus() {
        this.status = 1;
        this.errorMsg = null;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public void clearResults() {
        this.results.clear();
    }

    public int resultCount() {
        return this.results.size();
    }

    public void addResult(AgentResult result) {
        this.results.add(result);
    }

    public void setResult(AgentResult result) {
        if (result == null) {
            return;
        }
        int r = 0;
        while (r < this.results.size()) {
            if (this.results.get(r).getCommand() == result.getCommand()) {
                this.results.set(r, result);
                return;
            }
            ++r;
        }
        this.addResult(result);
    }

    public AgentResult getResult(AgentCommandType command) {
        int r = 0;
        while (r < this.results.size()) {
            AgentResult result = this.results.get(r);
            if (result.getCommand() == command) {
                return result;
            }
            ++r;
        }
        return null;
    }

    public AgentResult removeResult(AgentCommandType command) {
        AgentResult res = null;
        int r = 0;
        while (r < this.results.size()) {
            AgentResult result = this.results.get(r);
            if (result.getCommand() == command) {
                this.results.remove(r);
                res = result;
                break;
            }
            ++r;
        }
        return res;
    }

    public AgentResult getResult(int index) {
        return index < 0 || index >= this.resultCount() ? null : this.results.get(index);
    }
}

