/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.client;

import com.nastel.heapdetective.client.AgentCommandType;
import com.nastel.heapdetective.client.AgentResponse;
import com.nastel.heapdetective.client.xml.AgentResponseParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class AgentConnection
extends Socket {
    protected String host;
    protected int port;
    protected PrintWriter out;
    protected BufferedReader in;
    protected AgentResponseParser respParser;

    public AgentConnection(String agentHost, int agentPort) throws UnknownHostException, IOException, ParserConfigurationException, SAXException {
        super(agentHost, agentPort);
        this.host = agentHost;
        this.port = agentPort;
        this.out = new PrintWriter(this.getOutputStream(), true);
        this.in = new BufferedReader(new InputStreamReader(this.getInputStream()));
        this.respParser = new AgentResponseParser();
    }

    protected String buildCommandString(long cmdTag, AgentCommandType ... commands) {
        StringBuilder cmdBuf = new StringBuilder();
        cmdBuf.append("<").append("aphd-cmd").append(" ").append("tag").append("=\"").append(cmdTag).append("\">");
        AgentCommandType[] agentCommandTypeArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            AgentCommandType command = agentCommandTypeArray[n2];
            cmdBuf.append("<").append("cmd").append(" ").append("name").append("=\"").append((Object)command).append("\"/>");
            ++n2;
        }
        cmdBuf.append("</").append("aphd-cmd").append(">");
        return cmdBuf.toString();
    }

    public AgentResponse issueCommand(AgentResponse response, AgentCommandType command) throws IOException, SAXException {
        this.sendCommand(this.buildCommandString(System.currentTimeMillis(), command));
        do {
            String responseStr = this.readResponse();
            this.respParser.parse(response, responseStr, null);
        } while (!response.isLast());
        return response;
    }

    public AgentResponse issueCommand(AgentCommandType command) throws IOException, SAXException {
        return this.issueCommand(new AgentResponse(), command);
    }

    protected void sendCommand(String cmdXml) throws IOException {
        this.out.println(cmdXml);
    }

    protected void sendAbort() throws IOException {
        this.sendCommand("<ABORT>");
    }

    protected String readResponse() throws IOException {
        return this.in.readLine();
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
    }

    @Override
    public String toString() {
        return String.valueOf(this.host) + ":" + this.port;
    }
}

