/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.ui;

import com.nastel.heapdetective.client.AgentCommandType;
import com.nastel.heapdetective.client.AgentResponse;
import com.nastel.heapdetective.client.AgentRuntimeResult;
import com.nastel.heapdetective.client.AgentSnapshotResult;
import com.nastel.heapdetective.jvm.JvmClassInfo;
import com.nastel.heapdetective.ui.ClassHistoryInfo;
import java.util.Collection;
import java.util.HashMap;

public class SavedSnapshot {
    protected int totalClasses;
    protected int totalThreads;
    protected long totalHeapSize;
    protected long freeHeapSize;
    protected long totalInstanceCount;
    protected int totalHeapRefs;
    protected long snapshotTime;
    protected HashMap<String, ClassHistoryInfo> classResults;

    public SavedSnapshot(AgentResponse response) {
        AgentRuntimeResult runtime = (AgentRuntimeResult)response.getResult(AgentCommandType.RUNTIME);
        AgentSnapshotResult snapshot = (AgentSnapshotResult)response.getResult(AgentCommandType.SNAPSHOT);
        this.totalClasses = runtime.getTotalClasses();
        this.totalThreads = runtime.getTotalThreads();
        this.totalHeapSize = runtime.getTotalHeapSize();
        this.freeHeapSize = runtime.getFreeHeapSize();
        this.snapshotTime = snapshot.getLastJvmUpdate();
        this.totalInstanceCount = snapshot.getTotalInstanceCount();
        this.totalHeapRefs = snapshot.getTotalHeapRefs();
        Collection<JvmClassInfo> classes = snapshot.getClasses();
        this.classResults = new HashMap(classes.size());
        for (JvmClassInfo classInfo : classes) {
            this.classResults.put(classInfo.getName(), new ClassHistoryInfo(classInfo.getTotalSize(), classInfo.getTotalInstances()));
        }
    }

    public int getTotalClasses() {
        return this.totalClasses;
    }

    public int getTotalThreads() {
        return this.totalThreads;
    }

    public long getTotalHeapSize() {
        return this.totalHeapSize;
    }

    public long getFreeHeapSize() {
        return this.freeHeapSize;
    }

    public long getTotalInstanceCount() {
        return this.totalInstanceCount;
    }

    public long getTotalHeapRefs() {
        return this.totalHeapRefs;
    }

    public long getSnapshotTime() {
        return this.snapshotTime;
    }

    public ClassHistoryInfo getClassInfo(String className) {
        return this.classResults.get(className);
    }
}

