/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.ui;

import com.nastel.heapdetective.client.AgentCommandType;
import com.nastel.heapdetective.client.AgentConnection;
import com.nastel.heapdetective.client.AgentResponse;
import com.nastel.heapdetective.client.AgentResult;
import com.nastel.heapdetective.client.AgentRuntimeResult;
import com.nastel.heapdetective.client.AgentSnapshotResult;
import com.nastel.heapdetective.client.AgentSystemPropsResult;
import com.nastel.heapdetective.client.ResponseTagMismatchException;
import com.nastel.heapdetective.jvm.JvmArrayHeapObjectInfo;
import com.nastel.heapdetective.jvm.JvmClassInfo;
import com.nastel.heapdetective.jvm.JvmHeapObjectInfo;
import com.nastel.heapdetective.jvm.JvmHeapReferenceInfo;
import com.nastel.heapdetective.jvm.JvmObjectInfo;
import com.nastel.heapdetective.ui.AboutDialog;
import com.nastel.heapdetective.ui.AgentConnectionDialog;
import com.nastel.heapdetective.ui.AgentProgressMonitor;
import com.nastel.heapdetective.ui.ClassComboBoxModel;
import com.nastel.heapdetective.ui.ClassTableCellRenderer;
import com.nastel.heapdetective.ui.HeapClassTableModel;
import com.nastel.heapdetective.ui.HeapObjRefTreeModel;
import com.nastel.heapdetective.ui.HeapObjectTableModel;
import com.nastel.heapdetective.ui.HeapObjectTreeModel;
import com.nastel.heapdetective.ui.HeapObjectTreeNode;
import com.nastel.heapdetective.ui.HistoryRowHeaderModel;
import com.nastel.heapdetective.ui.HistorySortOrder;
import com.nastel.heapdetective.ui.HistoryTableCellRenderer;
import com.nastel.heapdetective.ui.HistoryTableModel;
import com.nastel.heapdetective.ui.HistoryValueType;
import com.nastel.heapdetective.ui.ObjectTreeCellRenderer;
import com.nastel.heapdetective.ui.ObjectViewType;
import com.nastel.heapdetective.ui.SavedSnapshot;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.ProgressMonitor;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class MainWindow
implements ActionListener,
MouseListener,
TreeSelectionListener,
TreeWillExpandListener,
PropertyChangeListener,
KeyListener {
    public static final String WIN_TITLE = "AutoPilot\u00ae Heap Detective\u2122";
    private JFrame winFrame;
    private JMenuBar menuBar;
    private JMenuItem mntmOpen;
    private JMenuItem mntmClose;
    private JMenuItem mntmExit;
    private JMenuItem mntmSnapshot;
    private JMenuItem mntmPerformGc;
    private JMenuItem mntmRefreshSummary;
    private ButtonGroup viewMenuGroup;
    private JRadioButtonMenuItem rdbtnmntmSummary;
    private JRadioButtonMenuItem rdbtnmntmHeapUsage;
    private JMenu mnWindow;
    private ButtonGroup activeWindowMenuItems;
    private JMenuItem mntmAbout;
    private JToolBar toolBar;
    private JButton tbOpen;
    private JButton tbClose;
    private JButton tbPerformGc;
    private JButton tbSnapshot;
    private JButton tbRefreshSummary;
    private JPanel iconBarPanel;
    private ButtonGroup viewButtonGroup;
    private JToggleButton btnSummaryView;
    private JToggleButton btnHeapUsageView;
    private JPanel pnlMain;
    private JSplitPane paneSummary;
    private JScrollPane paneOverview;
    private JTextPane txtOverview;
    private JTabbedPane paneSummaryStats;
    private JPanel pnlSystemProps;
    private JScrollPane paneSystemProps;
    private JTextPane txtSystemProps;
    private JPanel pnlAgentMetrics;
    private JScrollPane paneAgentMetrics;
    private JTextPane txtAgentMetrics;
    private JPanel pnlHeap;
    private JPanel pnlHeapBlank;
    private JButton btnHeapBlank;
    private JLabel lblHeapBlank;
    private JTabbedPane paneHeap;
    private JPanel pnlHeapClass;
    private JComboBox cmbHeapClassFilter;
    private JTable tblHeapClassUsage;
    private HeapClassTableModel tblHeapClassUsageModel;
    private ClassTableCellRenderer tblHeapClassUsageCellRenderer;
    private JPanel pnlHeapObject;
    private JPanel pnlHeapObjectType;
    private JLabel lblHeapObjectFilter;
    private JComboBox cmbHeapObjectFilter;
    private JLabel lblHeapObjectCount;
    private JTextField txtHeapObjectCount;
    private JLabel lblHeapObjectClassFilter;
    private JComboBox cmbHeapObjectClassFilter;
    private JButton btnHeapObjectRefresh;
    private JSplitPane paneHeapObjectUsage;
    private JScrollPane paneHeapObjectTree;
    private JTree treeHeapObjects;
    private HeapObjectTreeModel treeHeapObjectsModel;
    private JSplitPane paneHeapObjectInfo;
    private JScrollPane paneHeapObjectData;
    private JTable tblHeapObjectData;
    private HeapObjectTableModel tblHeapObjectDataModel;
    private JScrollPane paneHeapObjectRef;
    private JTree treeHeapObjRefs;
    private HeapObjRefTreeModel treeHeapObjRefsModel;
    private JPanel pnlHistory;
    private JPanel pnlHistoryFilter;
    private JLabel lblHistorySortOrder;
    private JComboBox cmbHistorySortOrder;
    private JLabel lblHistoryValueType;
    private JComboBox cmbHistoryValueType;
    private JButton btnHistoryRefresh;
    private JScrollPane paneHistory;
    private JTable tblHistory;
    private HistoryTableModel tblHistoryModel;
    private JTable tblHistoryRowHeader;
    private HistoryRowHeaderModel tblHistoryRowHeaderModel;
    private HistoryTableCellRenderer tblHistoryCellRenderer;
    private JPanel pnlStatusBar;
    private JPanel pnlStatusBar1;
    private JPanel pnlStatusBar2;
    private JLabel lblStatusBar1;
    private JLabel lblStatusBar2;
    private JPanel pnlStatusBar3;
    private JLabel lblStatusBar3;
    private JPanel pnlStatusBar4;
    private JLabel lblStatusBar4;
    private JButton btnSnapshot;
    private ImageIcon icnNastel;
    private ImageIcon icnSnapshot16x16;
    private ImageIcon icnGc16x16;
    private ImageIcon icnOpen16x16;
    private ImageIcon icnClose16x16;
    private ImageIcon icnRefresh16x16;
    private ImageIcon icnApply16x16;
    private ImageIcon icnSnapshot24x24;
    private ImageIcon icnGc24x24;
    private ImageIcon icnOpen24x24;
    private ImageIcon icnClose24x24;
    private ImageIcon icnRefresh24x24;
    private ImageIcon icnSummary48x48;
    private ImageIcon icnHeap48x48;
    private ImageIcon icnOpen48x48;
    private ImageIcon icnSnapshot48x48;
    private JPopupMenu mnClassPopup;
    private JMenuItem mntmAllInstances;
    private JMenuItem mntmTopInstances;
    private SimpleDateFormat dateFormat;
    private NumberFormat numberFormat;
    private ActiveAgent activeAgent;
    private ArrayList<ActiveAgent> activeConnections;
    private boolean componentEventsEnabled;
    private ProgressMonitor progressMon = null;
    private AgentCommandProcessor cmdProcessor = null;
    private AgentCommandWatcher cmdWatcher = null;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MainWindow window = new MainWindow();
                    window.winFrame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public MainWindow() throws Exception {
        EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        queue.push(new EventQueueProxy());
        this.initialize();
    }

    private void initialize() throws Exception {
        this.activeConnections = new ArrayList();
        this.dateFormat = new SimpleDateFormat("EEE d MMM yyyy HH:mm:ss");
        this.numberFormat = NumberFormat.getIntegerInstance();
        this.numberFormat.setGroupingUsed(true);
        this.icnNastel = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/nastel-icon-16x16.png"));
        this.icnSnapshot16x16 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/snapshot-16x16.png"));
        this.icnGc16x16 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/gc-16x16.png"));
        this.icnOpen16x16 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/open-16x16.png"));
        this.icnClose16x16 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/close-16x16.png"));
        this.icnRefresh16x16 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/refresh-16x16.png"));
        this.icnApply16x16 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/apply-16x16.png"));
        this.icnSnapshot24x24 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/snapshot-24x24.png"));
        this.icnGc24x24 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/gc-24x24.png"));
        this.icnOpen24x24 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/open-24x24.png"));
        this.icnClose24x24 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/close-24x24.png"));
        this.icnRefresh24x24 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/refresh-24x24.png"));
        this.icnSummary48x48 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/summary-48x48.png"));
        this.icnHeap48x48 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/heapstats-48x48.png"));
        this.icnOpen48x48 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/open-48x48.png"));
        this.icnSnapshot48x48 = new ImageIcon(MainWindow.class.getResource("/com/nastel/heapdetective/ui/images/snapshot-48x48.png"));
        this.winFrame = new JFrame();
        this.winFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                MainWindow.this.fillControls();
                MainWindow.this.openAgentConnection();
                MainWindow.this.componentEventsEnabled = true;
            }
        });
        this.winFrame.setTitle(WIN_TITLE);
        this.winFrame.setBounds(100, 100, 1000, 700);
        this.winFrame.setDefaultCloseOperation(3);
        this.winFrame.setIconImage(this.icnNastel.getImage());
        this.createMenuBar();
        this.createToolbar();
        this.createIconBar();
        this.createMainPanel();
        this.createStatusBar();
        this.createClassPopupMenu();
        this.btnSummaryView.setSelected(true);
    }

    private void createMenuBar() {
        this.menuBar = new JMenuBar();
        this.winFrame.setJMenuBar(this.menuBar);
        JMenu mnFile = new JMenu("File");
        this.menuBar.add(mnFile);
        this.mntmOpen = new JMenuItem("Open...");
        this.mntmOpen.setIcon(this.icnOpen16x16);
        this.mntmOpen.setToolTipText("Open new JVM Agent session");
        this.mntmOpen.addActionListener(this);
        mnFile.add(this.mntmOpen);
        this.mntmClose = new JMenuItem("Close");
        this.mntmClose.setIcon(this.icnClose16x16);
        this.mntmClose.setToolTipText("Close session with current JVM Agent");
        this.mntmClose.addActionListener(this);
        mnFile.add(this.mntmClose);
        mnFile.addSeparator();
        this.mntmExit = new JMenuItem("Exit");
        this.mntmExit.addActionListener(this);
        mnFile.add(this.mntmExit);
        JMenu mnEdit = new JMenu("Edit");
        this.menuBar.add(mnEdit);
        this.mntmSnapshot = new JMenuItem("New Snapshot");
        this.mntmSnapshot.setIcon(this.icnSnapshot16x16);
        this.mntmSnapshot.setToolTipText("Take new JVM snapshot");
        this.mntmSnapshot.addActionListener(this);
        mnEdit.add(this.mntmSnapshot);
        this.mntmPerformGc = new JMenuItem("Run GC");
        this.mntmPerformGc.setIcon(this.icnGc16x16);
        this.mntmPerformGc.setToolTipText("Perform Garbage Collection");
        this.mntmPerformGc.addActionListener(this);
        mnEdit.add(this.mntmPerformGc);
        mnEdit.addSeparator();
        this.mntmRefreshSummary = new JMenuItem("Refresh Summary");
        this.mntmRefreshSummary.setIcon(this.icnRefresh16x16);
        this.mntmRefreshSummary.setToolTipText("Refresh Summary Information");
        this.mntmRefreshSummary.addActionListener(this);
        mnEdit.add(this.mntmRefreshSummary);
        JMenu mnView = new JMenu("View");
        this.menuBar.add(mnView);
        this.rdbtnmntmSummary = new JRadioButtonMenuItem("Summary");
        this.rdbtnmntmSummary.addActionListener(this);
        mnView.add(this.rdbtnmntmSummary);
        this.rdbtnmntmHeapUsage = new JRadioButtonMenuItem("Heap Usage");
        this.rdbtnmntmHeapUsage.addActionListener(this);
        mnView.add(this.rdbtnmntmHeapUsage);
        this.viewMenuGroup = new ButtonGroup();
        this.viewMenuGroup.add(this.rdbtnmntmSummary);
        this.viewMenuGroup.add(this.rdbtnmntmHeapUsage);
        this.mnWindow = new JMenu("Window");
        this.menuBar.add(this.mnWindow);
        this.activeWindowMenuItems = new ButtonGroup();
        JMenu mnHelp = new JMenu("Help");
        this.menuBar.add(mnHelp);
        this.mntmAbout = new JMenuItem("About");
        this.mntmAbout.addActionListener(this);
        mnHelp.add(this.mntmAbout);
    }

    private void createToolbar() {
        this.toolBar = new JToolBar();
        this.winFrame.getContentPane().add((Component)this.toolBar, "North");
        this.tbOpen = new JButton(this.icnOpen24x24);
        this.tbOpen.setToolTipText(this.mntmOpen.getToolTipText());
        this.tbOpen.addActionListener(this);
        this.toolBar.add(this.tbOpen);
        this.tbClose = new JButton(this.icnClose24x24);
        this.tbClose.setToolTipText(this.mntmClose.getToolTipText());
        this.tbClose.addActionListener(this);
        this.toolBar.add(this.tbClose);
        this.toolBar.addSeparator();
        this.tbSnapshot = new JButton(this.icnSnapshot24x24);
        this.tbSnapshot.setToolTipText(this.mntmSnapshot.getToolTipText());
        this.tbSnapshot.addActionListener(this);
        this.toolBar.add(this.tbSnapshot);
        this.tbPerformGc = new JButton(this.icnGc24x24);
        this.tbPerformGc.setToolTipText(this.mntmPerformGc.getToolTipText());
        this.tbPerformGc.addActionListener(this);
        this.toolBar.add(this.tbPerformGc);
        this.toolBar.addSeparator();
        this.tbRefreshSummary = new JButton(this.icnRefresh24x24);
        this.tbRefreshSummary.setToolTipText(this.mntmRefreshSummary.getToolTipText());
        this.tbRefreshSummary.addActionListener(this);
        this.toolBar.add(this.tbRefreshSummary);
    }

    private void createIconBar() {
        this.iconBarPanel = new JPanel();
        this.iconBarPanel.setMaximumSize(new Dimension(100, Short.MAX_VALUE));
        this.iconBarPanel.setMinimumSize(new Dimension(103, 10));
        this.iconBarPanel.setPreferredSize(new Dimension(103, 10));
        this.iconBarPanel.setBorder(new BevelBorder(1, null, null, null, null));
        this.winFrame.getContentPane().add((Component)this.iconBarPanel, "West");
        GridBagLayout gbl_iconBarPanel = new GridBagLayout();
        int[] nArray = new int[2];
        nArray[0] = 90;
        gbl_iconBarPanel.columnWidths = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 40;
        nArray2[1] = 40;
        gbl_iconBarPanel.rowHeights = nArray2;
        gbl_iconBarPanel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_iconBarPanel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.iconBarPanel.setLayout(gbl_iconBarPanel);
        this.btnSummaryView = new JToggleButton("Summary");
        this.btnSummaryView.setBorder(new BevelBorder(0, null, null, null, null));
        this.btnSummaryView.setFont(new Font("Tahoma", 1, 11));
        this.btnSummaryView.setContentAreaFilled(false);
        this.btnSummaryView.setIconTextGap(2);
        this.btnSummaryView.setHorizontalTextPosition(0);
        this.btnSummaryView.setVerticalTextPosition(3);
        this.btnSummaryView.setIcon(this.icnSummary48x48);
        this.btnSummaryView.setPreferredSize(new Dimension(100, 72));
        this.btnSummaryView.setMinimumSize(new Dimension(100, 72));
        this.btnSummaryView.setMaximumSize(new Dimension(100, 72));
        this.btnSummaryView.addActionListener(this);
        GridBagConstraints gbc_btnSummary = new GridBagConstraints();
        gbc_btnSummary.fill = 1;
        gbc_btnSummary.insets = new Insets(0, 0, 5, 0);
        gbc_btnSummary.gridx = 0;
        gbc_btnSummary.gridy = 0;
        this.iconBarPanel.add((Component)this.btnSummaryView, gbc_btnSummary);
        this.btnHeapUsageView = new JToggleButton("Heap Usage");
        this.btnHeapUsageView.setBorder(new BevelBorder(0, null, null, null, null));
        this.btnHeapUsageView.setFont(new Font("Tahoma", 1, 11));
        this.btnHeapUsageView.setContentAreaFilled(false);
        this.btnHeapUsageView.setIconTextGap(2);
        this.btnHeapUsageView.setHorizontalTextPosition(0);
        this.btnHeapUsageView.setVerticalTextPosition(3);
        this.btnHeapUsageView.setIcon(this.icnHeap48x48);
        this.btnHeapUsageView.setPreferredSize(new Dimension(100, 72));
        this.btnHeapUsageView.setMinimumSize(new Dimension(100, 72));
        this.btnHeapUsageView.setMaximumSize(new Dimension(100, 72));
        this.btnHeapUsageView.addActionListener(this);
        GridBagConstraints gbc_btnHeapUsageView = new GridBagConstraints();
        gbc_btnHeapUsageView.fill = 1;
        gbc_btnHeapUsageView.gridx = 0;
        gbc_btnHeapUsageView.gridy = 1;
        this.iconBarPanel.add((Component)this.btnHeapUsageView, gbc_btnHeapUsageView);
        this.viewButtonGroup = new ButtonGroup();
        this.viewButtonGroup.add(this.btnSummaryView);
        this.viewButtonGroup.add(this.btnHeapUsageView);
    }

    private void createMainPanel() {
        this.pnlMain = new JPanel();
        this.pnlMain.setBorder(new BevelBorder(1, null, null, null, null));
        this.winFrame.getContentPane().add((Component)this.pnlMain, "Center");
        this.pnlMain.setLayout(new CardLayout(0, 0));
        this.pnlMain.add((Component)this.createSummaryPanel(), this.btnSummaryView.getText());
        this.pnlMain.add((Component)this.createHeapPanel(), this.btnHeapUsageView.getText());
    }

    private JComponent createSummaryPanel() {
        this.txtOverview = new JTextPane();
        this.txtOverview.setEditable(false);
        this.paneOverview = new JScrollPane(this.txtOverview);
        this.paneOverview.setPreferredSize(new Dimension(8, 160));
        this.paneSummaryStats = new JTabbedPane(1);
        this.paneSummaryStats.setFont(new Font("Tahoma", 1, 11));
        this.pnlSystemProps = new JPanel();
        this.pnlSystemProps.setLayout(new BorderLayout(0, 0));
        this.paneSummaryStats.addTab("System Properties", null, this.pnlSystemProps, null);
        this.txtSystemProps = new JTextPane();
        this.txtSystemProps.setEditable(false);
        this.paneSystemProps = new JScrollPane(this.txtSystemProps);
        this.pnlSystemProps.add(this.paneSystemProps);
        this.pnlAgentMetrics = new JPanel();
        this.pnlAgentMetrics.setLayout(new BorderLayout(0, 0));
        this.paneSummaryStats.addTab("Agent Metrics", null, this.pnlAgentMetrics, null);
        this.txtAgentMetrics = new JTextPane();
        this.txtAgentMetrics.setEditable(false);
        this.paneAgentMetrics = new JScrollPane(this.txtAgentMetrics);
        this.pnlAgentMetrics.add(this.paneAgentMetrics);
        this.paneSummary = new JSplitPane(0, this.paneOverview, this.paneSummaryStats);
        this.paneSummary.setPreferredSize(new Dimension(457, 300));
        this.paneSummary.setMinimumSize(new Dimension(105, 130));
        this.paneSummary.setOneTouchExpandable(true);
        this.paneSummary.setResizeWeight(0.2);
        return this.paneSummary;
    }

    private JComponent createHeapPanel() {
        this.pnlHeap = new JPanel();
        this.pnlHeap.setLayout(new CardLayout(0, 0));
        this.pnlHeapBlank = new JPanel();
        this.pnlHeapBlank.setName("Blank_Heap_Panel");
        GridBagLayout gbl_pnlHeapBlank = new GridBagLayout();
        int[] nArray = new int[2];
        nArray[0] = 244;
        gbl_pnlHeapBlank.columnWidths = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 23;
        gbl_pnlHeapBlank.rowHeights = nArray2;
        gbl_pnlHeapBlank.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_pnlHeapBlank.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.pnlHeapBlank.setLayout(gbl_pnlHeapBlank);
        this.lblHeapBlank = new JLabel("No Snapshot Available - Press image below to take a snapshot");
        this.lblHeapBlank.setBorder(new EmptyBorder(0, 0, 20, 0));
        this.lblHeapBlank.setAlignmentX(0.5f);
        this.lblHeapBlank.setHorizontalAlignment(0);
        GridBagConstraints gbc_lbl = new GridBagConstraints();
        gbc_lbl.fill = 1;
        gbc_lbl.gridwidth = 0;
        gbc_lbl.gridheight = 0;
        gbc_lbl.gridx = 0;
        gbc_lbl.gridy = 0;
        this.pnlHeapBlank.add((Component)this.lblHeapBlank, gbc_lbl);
        this.btnHeapBlank = new JButton(this.icnSnapshot48x48);
        this.btnHeapBlank.setBorder(new EmptyBorder(20, 0, 0, 0));
        this.btnHeapBlank.setContentAreaFilled(false);
        this.btnHeapBlank.setAlignmentX(0.5f);
        this.btnHeapBlank.setToolTipText(this.tbSnapshot.getToolTipText());
        this.btnHeapBlank.addActionListener(this);
        GridBagConstraints gbc_btnNewButton = new GridBagConstraints();
        gbc_btnNewButton.gridwidth = 0;
        gbc_btnNewButton.gridheight = 0;
        gbc_btnNewButton.gridx = 0;
        gbc_btnNewButton.gridy = 1;
        this.pnlHeapBlank.add((Component)this.btnHeapBlank, gbc_btnNewButton);
        this.paneHeap = new JTabbedPane(1);
        this.paneHeap.setFont(new Font("Tahoma", 1, 11));
        this.paneHeap.setName("Main_Heap_Panel");
        this.paneHeap.addTab("Class", null, this.createHeapClassPanel(), null);
        this.paneHeap.addTab("Object", null, this.createHeapObjectPanel(), null);
        this.paneHeap.addTab("History", null, this.createHeapHistoryPanel(), null);
        this.pnlHeap.add((Component)this.paneHeap, this.paneHeap.getName());
        this.pnlHeap.add((Component)this.pnlHeapBlank, this.pnlHeapBlank.getName());
        return this.pnlHeap;
    }

    private JComponent createHeapClassPanel() {
        this.pnlHeapClass = new JPanel();
        this.pnlHeapClass.setBorder(new BevelBorder(1, null, null, null, null));
        this.pnlHeapClass.setLayout(new BorderLayout(0, 0));
        JPanel pnlHeapClassType = new JPanel();
        pnlHeapClassType.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.pnlHeapClass.add((Component)pnlHeapClassType, "North");
        GridBagLayout gbl_pnlHeapClassType = new GridBagLayout();
        gbl_pnlHeapClassType.columnWidths = new int[]{70, 180, 70, 80, 100};
        int[] nArray = new int[2];
        nArray[0] = 26;
        gbl_pnlHeapClassType.rowHeights = nArray;
        gbl_pnlHeapClassType.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0};
        gbl_pnlHeapClassType.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        pnlHeapClassType.setLayout(gbl_pnlHeapClassType);
        JLabel lblHeapClassFilter = new JLabel("Class Filter:");
        lblHeapClassFilter.setSize(new Dimension(103, 14));
        GridBagConstraints gbc_lblHeapClassFilter = new GridBagConstraints();
        gbc_lblHeapClassFilter.anchor = 13;
        gbc_lblHeapClassFilter.insets = new Insets(0, 0, 0, 5);
        gbc_lblHeapClassFilter.gridx = 0;
        gbc_lblHeapClassFilter.gridy = 0;
        pnlHeapClassType.add((Component)lblHeapClassFilter, gbc_lblHeapClassFilter);
        this.cmbHeapClassFilter = new JComboBox();
        this.cmbHeapClassFilter.setEditable(true);
        this.cmbHeapClassFilter.setPreferredSize(new Dimension(150, 20));
        this.cmbHeapClassFilter.setMinimumSize(new Dimension(100, 20));
        lblHeapClassFilter.setLabelFor(this.cmbHeapClassFilter);
        this.cmbHeapClassFilter.addActionListener(this);
        GridBagConstraints gbc_cmbHeapClassFilter = new GridBagConstraints();
        gbc_cmbHeapClassFilter.gridwidth = 4;
        gbc_cmbHeapClassFilter.insets = new Insets(0, 0, 0, 5);
        gbc_cmbHeapClassFilter.fill = 2;
        gbc_cmbHeapClassFilter.gridx = 1;
        gbc_cmbHeapClassFilter.gridy = 0;
        pnlHeapClassType.add((Component)this.cmbHeapClassFilter, gbc_cmbHeapClassFilter);
        this.tblHeapClassUsageModel = new HeapClassTableModel();
        this.tblHeapClassUsage = new JTable(this.tblHeapClassUsageModel);
        this.tblHeapClassUsage.addMouseListener(this);
        this.tblHeapClassUsage.setIntercellSpacing(new Dimension(3, 3));
        this.tblHeapClassUsage.setAutoCreateRowSorter(true);
        this.tblHeapClassUsageCellRenderer = new ClassTableCellRenderer();
        this.tblHeapClassUsageCellRenderer.setHorizontalAlignment(4);
        this.tblHeapClassUsage.setDefaultRenderer(Long.class, this.tblHeapClassUsageCellRenderer);
        ((DefaultTableCellRenderer)this.tblHeapClassUsage.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        this.tblHeapClassUsageModel.setTable(this.tblHeapClassUsage);
        JScrollPane paneHeapClassUsage = new JScrollPane(this.tblHeapClassUsage);
        paneHeapClassUsage.setPreferredSize(new Dimension(450, 200));
        paneHeapClassUsage.setHorizontalScrollBarPolicy(31);
        this.pnlHeapClass.add((Component)paneHeapClassUsage, "Center");
        return this.pnlHeapClass;
    }

    private JComponent createHeapObjectPanel() {
        this.pnlHeapObject = new JPanel();
        this.pnlHeapObject.setBorder(new BevelBorder(1, null, null, null, null));
        this.pnlHeapObject.setLayout(new BorderLayout(0, 0));
        this.pnlHeapObjectType = new JPanel();
        this.pnlHeapObjectType.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.pnlHeapObject.add((Component)this.pnlHeapObjectType, "North");
        GridBagLayout gbl_pnlHeapObjectType = new GridBagLayout();
        int[] nArray = new int[6];
        nArray[0] = 70;
        nArray[1] = 185;
        nArray[2] = 70;
        nArray[3] = 60;
        nArray[4] = 100;
        gbl_pnlHeapObjectType.columnWidths = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 26;
        gbl_pnlHeapObjectType.rowHeights = nArray2;
        gbl_pnlHeapObjectType.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gbl_pnlHeapObjectType.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.pnlHeapObjectType.setLayout(gbl_pnlHeapObjectType);
        this.lblHeapObjectFilter = new JLabel("Object Filter:");
        GridBagConstraints gbc_lblObjectFilter = new GridBagConstraints();
        gbc_lblObjectFilter.anchor = 13;
        gbc_lblObjectFilter.insets = new Insets(0, 0, 5, 5);
        gbc_lblObjectFilter.gridx = 0;
        gbc_lblObjectFilter.gridy = 0;
        this.pnlHeapObjectType.add((Component)this.lblHeapObjectFilter, gbc_lblObjectFilter);
        this.cmbHeapObjectFilter = new JComboBox<String>(ObjectViewType.getDisplayNames());
        this.cmbHeapObjectFilter.setMaximumSize(new Dimension(180, 20));
        this.cmbHeapObjectFilter.setMinimumSize(new Dimension(180, 18));
        this.cmbHeapObjectFilter.setPreferredSize(new Dimension(180, 20));
        this.lblHeapObjectFilter.setLabelFor(this.cmbHeapObjectFilter);
        this.cmbHeapObjectFilter.addActionListener(this);
        GridBagConstraints gbc_cmbObjectFilter = new GridBagConstraints();
        gbc_cmbObjectFilter.anchor = 17;
        gbc_cmbObjectFilter.insets = new Insets(0, 0, 5, 5);
        gbc_cmbObjectFilter.gridx = 1;
        gbc_cmbObjectFilter.gridy = 0;
        this.pnlHeapObjectType.add((Component)this.cmbHeapObjectFilter, gbc_cmbObjectFilter);
        this.lblHeapObjectCount = new JLabel("Count:");
        GridBagConstraints gbc_lblHeapObjectCount = new GridBagConstraints();
        gbc_lblHeapObjectCount.anchor = 13;
        gbc_lblHeapObjectCount.insets = new Insets(0, 0, 5, 5);
        gbc_lblHeapObjectCount.gridx = 2;
        gbc_lblHeapObjectCount.gridy = 0;
        this.pnlHeapObjectType.add((Component)this.lblHeapObjectCount, gbc_lblHeapObjectCount);
        this.txtHeapObjectCount = new JTextField();
        this.txtHeapObjectCount.setText("10");
        this.txtHeapObjectCount.setColumns(10);
        this.txtHeapObjectCount.addActionListener(this);
        this.txtHeapObjectCount.addKeyListener(this);
        this.lblHeapObjectCount.setLabelFor(this.txtHeapObjectCount);
        GridBagConstraints gbc_txtHeapObjectCount = new GridBagConstraints();
        gbc_txtHeapObjectCount.anchor = 17;
        gbc_txtHeapObjectCount.insets = new Insets(0, 0, 5, 5);
        gbc_txtHeapObjectCount.gridx = 3;
        gbc_txtHeapObjectCount.gridy = 0;
        this.pnlHeapObjectType.add((Component)this.txtHeapObjectCount, gbc_txtHeapObjectCount);
        this.btnHeapObjectRefresh = new JButton("Apply");
        this.btnHeapObjectRefresh.setMargin(new Insets(2, 10, 2, 10));
        this.btnHeapObjectRefresh.setIcon(this.icnApply16x16);
        this.btnHeapObjectRefresh.setToolTipText("Refresh display, applying current filters");
        this.btnHeapObjectRefresh.addActionListener(this);
        GridBagConstraints gbc_btnHeapObjectRefresh = new GridBagConstraints();
        gbc_btnHeapObjectRefresh.anchor = 13;
        gbc_btnHeapObjectRefresh.insets = new Insets(0, 0, 5, 0);
        gbc_btnHeapObjectRefresh.gridx = 4;
        gbc_btnHeapObjectRefresh.gridy = 0;
        this.pnlHeapObjectType.add((Component)this.btnHeapObjectRefresh, gbc_btnHeapObjectRefresh);
        this.lblHeapObjectClassFilter = new JLabel("Class Filter:");
        this.lblHeapObjectClassFilter.setSize(new Dimension(103, 14));
        GridBagConstraints gbc_lblHeapObjectClassFilter = new GridBagConstraints();
        gbc_lblHeapObjectClassFilter.anchor = 13;
        gbc_lblHeapObjectClassFilter.insets = new Insets(0, 0, 0, 5);
        gbc_lblHeapObjectClassFilter.gridx = 0;
        gbc_lblHeapObjectClassFilter.gridy = 1;
        this.pnlHeapObjectType.add((Component)this.lblHeapObjectClassFilter, gbc_lblHeapObjectClassFilter);
        this.cmbHeapObjectClassFilter = new JComboBox();
        this.cmbHeapObjectClassFilter.setEditable(true);
        this.cmbHeapObjectClassFilter.setPreferredSize(new Dimension(120, 20));
        this.cmbHeapObjectClassFilter.setMinimumSize(new Dimension(100, 20));
        this.cmbHeapObjectClassFilter.addActionListener(this);
        this.cmbHeapObjectClassFilter.getEditor().getEditorComponent().addKeyListener(this);
        GridBagConstraints gbc_cmbHeapObjectClassFilter = new GridBagConstraints();
        gbc_cmbHeapObjectClassFilter.gridwidth = 4;
        gbc_cmbHeapObjectClassFilter.fill = 2;
        gbc_cmbHeapObjectClassFilter.gridx = 1;
        gbc_cmbHeapObjectClassFilter.gridy = 1;
        this.pnlHeapObjectType.add((Component)this.cmbHeapObjectClassFilter, gbc_cmbHeapObjectClassFilter);
        this.treeHeapObjectsModel = new HeapObjectTreeModel("Heap Objects");
        this.treeHeapObjects = new JTree(this.treeHeapObjectsModel);
        this.treeHeapObjects.addTreeWillExpandListener(this);
        this.treeHeapObjects.addTreeSelectionListener(this);
        this.treeHeapObjects.setBorder(null);
        this.treeHeapObjects.setCellRenderer(new ObjectTreeCellRenderer());
        this.paneHeapObjectTree = new JScrollPane(this.treeHeapObjects);
        ToolTipManager.sharedInstance().registerComponent(this.treeHeapObjects);
        this.tblHeapObjectDataModel = new HeapObjectTableModel();
        this.tblHeapObjectData = new JTable(this.tblHeapObjectDataModel);
        this.tblHeapObjectDataModel.setTable(this.tblHeapObjectData);
        this.tblHeapObjectData.getTableHeader().setFont(new Font("Tahoma", 1, 11));
        ((DefaultTableCellRenderer)this.tblHeapObjectData.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        this.paneHeapObjectData = new JScrollPane(this.tblHeapObjectData);
        this.treeHeapObjRefsModel = new HeapObjRefTreeModel("References To");
        this.treeHeapObjRefs = new JTree(this.treeHeapObjRefsModel);
        this.treeHeapObjRefs.addTreeWillExpandListener(this);
        this.treeHeapObjRefs.addTreeSelectionListener(this);
        this.treeHeapObjRefs.setBorder(null);
        this.paneHeapObjectRef = new JScrollPane(this.treeHeapObjRefs);
        ToolTipManager.sharedInstance().registerComponent(this.treeHeapObjRefs);
        this.paneHeapObjectInfo = new JSplitPane(0, this.paneHeapObjectData, this.paneHeapObjectRef);
        this.paneHeapObjectInfo.setResizeWeight(0.4);
        this.paneHeapObjectInfo.setOneTouchExpandable(true);
        this.paneHeapObjectUsage = new JSplitPane(1, this.paneHeapObjectTree, this.paneHeapObjectInfo);
        this.paneHeapObjectUsage.setResizeWeight(0.6);
        this.paneHeapObjectUsage.setOneTouchExpandable(true);
        this.pnlHeapObject.add((Component)this.paneHeapObjectUsage, "Center");
        this.cmbHeapObjectFilter.setSelectedIndex(ObjectViewType.TOP_OBJECTS_RETAINED_SIZE.ordinal());
        return this.pnlHeapObject;
    }

    private JComponent createHeapHistoryPanel() {
        this.pnlHistory = new JPanel();
        this.pnlHistory.setLayout(new BorderLayout(0, 0));
        this.pnlHistoryFilter = new JPanel();
        this.pnlHistory.add((Component)this.pnlHistoryFilter, "North");
        GridBagLayout gbl_pnlHistoryFilter = new GridBagLayout();
        int[] nArray = new int[7];
        nArray[1] = 150;
        nArray[2] = 10;
        nArray[4] = 150;
        gbl_pnlHistoryFilter.columnWidths = nArray;
        gbl_pnlHistoryFilter.rowHeights = new int[3];
        gbl_pnlHistoryFilter.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_pnlHistoryFilter.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.pnlHistoryFilter.setLayout(gbl_pnlHistoryFilter);
        this.lblHistorySortOrder = new JLabel("Sort Classes By:");
        GridBagConstraints gbc_lblHistorySortOrder = new GridBagConstraints();
        gbc_lblHistorySortOrder.anchor = 13;
        gbc_lblHistorySortOrder.insets = new Insets(0, 0, 5, 5);
        gbc_lblHistorySortOrder.gridx = 0;
        gbc_lblHistorySortOrder.gridy = 0;
        this.pnlHistoryFilter.add((Component)this.lblHistorySortOrder, gbc_lblHistorySortOrder);
        this.cmbHistorySortOrder = new JComboBox<String>(HistorySortOrder.getDisplayNames());
        this.cmbHistorySortOrder.addActionListener(this);
        GridBagConstraints gbc_cmbHistorySortOrder = new GridBagConstraints();
        gbc_cmbHistorySortOrder.fill = 2;
        gbc_cmbHistorySortOrder.anchor = 17;
        gbc_cmbHistorySortOrder.insets = new Insets(0, 0, 5, 5);
        gbc_cmbHistorySortOrder.gridx = 1;
        gbc_cmbHistorySortOrder.gridy = 0;
        this.pnlHistoryFilter.add((Component)this.cmbHistorySortOrder, gbc_cmbHistorySortOrder);
        this.lblHistoryValueType = new JLabel("Use Value:");
        GridBagConstraints gbc_lblHistoryValueType = new GridBagConstraints();
        gbc_lblHistoryValueType.anchor = 13;
        gbc_lblHistoryValueType.insets = new Insets(0, 0, 5, 5);
        gbc_lblHistoryValueType.gridx = 3;
        gbc_lblHistoryValueType.gridy = 0;
        this.pnlHistoryFilter.add((Component)this.lblHistoryValueType, gbc_lblHistoryValueType);
        this.cmbHistoryValueType = new JComboBox<String>(HistoryValueType.getDisplayNames());
        this.cmbHistoryValueType.addActionListener(this);
        GridBagConstraints gbc_cmbHistoryValueType = new GridBagConstraints();
        gbc_cmbHistoryValueType.anchor = 17;
        gbc_cmbHistoryValueType.insets = new Insets(0, 0, 5, 5);
        gbc_cmbHistoryValueType.fill = 2;
        gbc_cmbHistoryValueType.gridx = 4;
        gbc_cmbHistoryValueType.gridy = 0;
        this.pnlHistoryFilter.add((Component)this.cmbHistoryValueType, gbc_cmbHistoryValueType);
        this.btnHistoryRefresh = new JButton("Apply");
        this.btnHistoryRefresh.setMargin(new Insets(2, 10, 2, 10));
        this.btnHistoryRefresh.setIcon(this.icnApply16x16);
        this.btnHistoryRefresh.setToolTipText("Refresh display, applying current filters");
        this.btnHistoryRefresh.addActionListener(this);
        GridBagConstraints gbc_btnHistoryRefresh = new GridBagConstraints();
        gbc_btnHistoryRefresh.anchor = 13;
        gbc_btnHistoryRefresh.insets = new Insets(0, 0, 5, 5);
        gbc_btnHistoryRefresh.gridx = 6;
        gbc_btnHistoryRefresh.gridy = 0;
        this.pnlHistoryFilter.add((Component)this.btnHistoryRefresh, gbc_btnHistoryRefresh);
        this.tblHistoryModel = new HistoryTableModel();
        this.tblHistory = new JTable(this.tblHistoryModel);
        this.tblHistoryModel.setTable(this.tblHistory);
        this.tblHistory.setAutoResizeMode(0);
        this.tblHistory.setPreferredScrollableViewportSize(new Dimension(450, 200));
        this.tblHistoryCellRenderer = new HistoryTableCellRenderer();
        this.tblHistoryCellRenderer.setHorizontalAlignment(4);
        this.tblHistory.addMouseListener(this);
        this.tblHistory.setDefaultRenderer(this.tblHistoryModel.getColumnClass(0), this.tblHistoryCellRenderer);
        this.tblHistory.getTableHeader().setFont(new Font("Tahoma", 1, 11));
        ((DefaultTableCellRenderer)this.tblHistory.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        this.tblHistoryRowHeaderModel = new HistoryRowHeaderModel(this.tblHistoryModel);
        this.tblHistoryRowHeader = new JTable(this.tblHistoryRowHeaderModel){
            private static final long serialVersionUID = -2443701241554694769L;

            @Override
            public String getToolTipText(MouseEvent e) {
                int column;
                int row = this.rowAtPoint(e.getPoint());
                Object value = this.getValueAt(row, column = this.columnAtPoint(e.getPoint()));
                return value == null ? null : value.toString();
            }
        };
        this.tblHistoryRowHeader.setAutoResizeMode(4);
        this.tblHistoryRowHeader.setPreferredScrollableViewportSize(new Dimension(350, 200));
        this.tblHistoryRowHeader.getTableHeader().setReorderingAllowed(false);
        this.tblHistoryRowHeader.setRowHeight(this.tblHistory.getRowHeight());
        this.tblHistoryRowHeader.getTableHeader().setFont(new Font("Tahoma", 1, 11));
        this.tblHistoryRowHeader.addMouseListener(this);
        this.tblHistoryRowHeader.setSelectionModel(this.tblHistory.getSelectionModel());
        LookAndFeel.installColorsAndFont(this.tblHistoryRowHeader, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        this.paneHistory = new JScrollPane(this.tblHistory);
        this.paneHistory.setPreferredSize(new Dimension(450, 200));
        this.paneHistory.setRowHeaderView(this.tblHistoryRowHeader);
        this.paneHistory.setCorner("UPPER_LEFT_CORNER", this.tblHistoryRowHeader.getTableHeader());
        this.pnlHistory.add(this.paneHistory);
        return this.pnlHistory;
    }

    private void createStatusBar() {
        this.pnlStatusBar = new JPanel();
        this.winFrame.getContentPane().add((Component)this.pnlStatusBar, "South");
        this.pnlStatusBar.setPreferredSize(new Dimension(256, 23));
        this.pnlStatusBar.setBorder(new BevelBorder(0, null, null, null, null));
        this.pnlStatusBar.setMinimumSize(new Dimension(256, 23));
        GridBagLayout gbl_pnlStatusBar = new GridBagLayout();
        int[] nArray = new int[5];
        nArray[0] = 130;
        nArray[1] = 150;
        nArray[2] = 300;
        nArray[3] = 235;
        gbl_pnlStatusBar.columnWidths = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 14;
        gbl_pnlStatusBar.rowHeights = nArray2;
        gbl_pnlStatusBar.columnWeights = new double[]{0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_pnlStatusBar.rowWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        this.pnlStatusBar.setLayout(gbl_pnlStatusBar);
        this.pnlStatusBar1 = new JPanel();
        this.pnlStatusBar1.setPreferredSize(new Dimension(130, 23));
        this.pnlStatusBar1.setMinimumSize(new Dimension(130, 23));
        this.pnlStatusBar1.setMaximumSize(new Dimension(130, 23));
        this.pnlStatusBar1.setBorder(new BevelBorder(1, null, null, null, null));
        GridBagConstraints gbc_pnlStatusBar1 = new GridBagConstraints();
        gbc_pnlStatusBar1.fill = 1;
        gbc_pnlStatusBar1.insets = new Insets(0, 0, 0, 2);
        gbc_pnlStatusBar1.gridx = 0;
        gbc_pnlStatusBar1.gridy = 0;
        this.pnlStatusBar.add((Component)this.pnlStatusBar1, gbc_pnlStatusBar1);
        this.pnlStatusBar1.setLayout(new BorderLayout(0, 0));
        this.lblStatusBar1 = new JLabel("Loaded Classes:");
        this.lblStatusBar1.setBorder(new EmptyBorder(0, 2, 0, 0));
        this.lblStatusBar1.setPreferredSize(new Dimension(78, 18));
        this.lblStatusBar1.setMinimumSize(new Dimension(78, 18));
        this.lblStatusBar1.setMaximumSize(new Dimension(78, 18));
        this.pnlStatusBar1.add((Component)this.lblStatusBar1, "Center");
        this.pnlStatusBar2 = new JPanel();
        this.pnlStatusBar2.setPreferredSize(new Dimension(150, 23));
        this.pnlStatusBar2.setMinimumSize(new Dimension(150, 23));
        this.pnlStatusBar2.setMaximumSize(new Dimension(150, 23));
        this.pnlStatusBar2.setBorder(new BevelBorder(1, null, null, null, null));
        GridBagConstraints gbc_pnlStatusBar2 = new GridBagConstraints();
        gbc_pnlStatusBar2.fill = 1;
        gbc_pnlStatusBar2.insets = new Insets(0, 0, 0, 2);
        gbc_pnlStatusBar2.gridx = 1;
        gbc_pnlStatusBar2.gridy = 0;
        this.pnlStatusBar.add((Component)this.pnlStatusBar2, gbc_pnlStatusBar2);
        this.pnlStatusBar2.setLayout(new BorderLayout(0, 0));
        this.lblStatusBar2 = new JLabel("Active Objects:");
        this.lblStatusBar2.setBorder(new EmptyBorder(0, 2, 0, 0));
        this.pnlStatusBar2.add(this.lblStatusBar2);
        this.pnlStatusBar3 = new JPanel();
        this.pnlStatusBar3.setPreferredSize(new Dimension(300, 23));
        this.pnlStatusBar3.setMinimumSize(new Dimension(10, 23));
        this.pnlStatusBar3.setBorder(new BevelBorder(1, null, null, null, null));
        GridBagConstraints gbc_pnlStatusBar3 = new GridBagConstraints();
        gbc_pnlStatusBar3.insets = new Insets(0, 0, 0, 2);
        gbc_pnlStatusBar3.fill = 1;
        gbc_pnlStatusBar3.gridx = 2;
        gbc_pnlStatusBar3.gridy = 0;
        this.pnlStatusBar.add((Component)this.pnlStatusBar3, gbc_pnlStatusBar3);
        this.pnlStatusBar3.setLayout(new BorderLayout(0, 0));
        this.lblStatusBar3 = new JLabel("Total Threads");
        this.lblStatusBar3.setBorder(new EmptyBorder(0, 2, 0, 0));
        this.pnlStatusBar3.add((Component)this.lblStatusBar3, "North");
        this.pnlStatusBar4 = new JPanel();
        this.pnlStatusBar4.setMaximumSize(new Dimension(200, 23));
        this.pnlStatusBar4.setPreferredSize(new Dimension(200, 23));
        this.pnlStatusBar4.setMinimumSize(new Dimension(200, 23));
        this.pnlStatusBar4.setBorder(new BevelBorder(1, null, null, null, null));
        GridBagConstraints gbc_pnlStatusBar4 = new GridBagConstraints();
        gbc_pnlStatusBar4.fill = 2;
        gbc_pnlStatusBar4.gridx = 3;
        gbc_pnlStatusBar4.gridy = 0;
        this.pnlStatusBar.add((Component)this.pnlStatusBar4, gbc_pnlStatusBar4);
        GridBagLayout gbl_pnlStatusBar4 = new GridBagLayout();
        int[] nArray3 = new int[3];
        nArray3[0] = 180;
        nArray3[1] = 18;
        gbl_pnlStatusBar4.columnWidths = nArray3;
        int[] nArray4 = new int[2];
        nArray4[0] = 16;
        gbl_pnlStatusBar4.rowHeights = nArray4;
        gbl_pnlStatusBar4.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gbl_pnlStatusBar4.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.pnlStatusBar4.setLayout(gbl_pnlStatusBar4);
        this.lblStatusBar4 = new JLabel("Last Snapshot:");
        this.lblStatusBar4.setBorder(new EmptyBorder(0, 2, 0, 0));
        this.lblStatusBar4.setMinimumSize(new Dimension(185, 18));
        this.lblStatusBar4.setPreferredSize(new Dimension(185, 18));
        this.lblStatusBar4.setMaximumSize(new Dimension(185, 18));
        this.lblStatusBar4.setHorizontalAlignment(2);
        GridBagConstraints gbc_lblStatusBar4 = new GridBagConstraints();
        gbc_lblStatusBar4.fill = 2;
        gbc_lblStatusBar4.anchor = 17;
        gbc_lblStatusBar4.gridx = 0;
        gbc_lblStatusBar4.gridy = 0;
        this.pnlStatusBar4.add((Component)this.lblStatusBar4, gbc_lblStatusBar4);
        this.btnSnapshot = new JButton(this.icnSnapshot16x16);
        this.btnSnapshot.setMinimumSize(new Dimension(18, 18));
        this.btnSnapshot.setMaximumSize(new Dimension(18, 18));
        this.btnSnapshot.addActionListener(this);
        this.btnSnapshot.setPreferredSize(new Dimension(18, 18));
        this.btnSnapshot.setToolTipText(this.tbSnapshot.getToolTipText());
        GridBagConstraints gbc_btnRefresh = new GridBagConstraints();
        gbc_btnRefresh.anchor = 13;
        gbc_btnRefresh.gridx = 1;
        gbc_btnRefresh.gridy = 0;
        this.pnlStatusBar4.add((Component)this.btnSnapshot, gbc_btnRefresh);
    }

    private void createClassPopupMenu() {
        this.mnClassPopup = new JPopupMenu("Class");
        this.mntmAllInstances = new JMenuItem("Show All Instances");
        this.mntmAllInstances.addActionListener(this);
        this.mnClassPopup.add(this.mntmAllInstances);
        this.mntmTopInstances = new JMenuItem("Show Top Instances");
        this.mntmTopInstances.addActionListener(this);
        this.mnClassPopup.add(this.mntmTopInstances);
    }

    private void activateView(Object control) {
        CardLayout viewDeck = (CardLayout)this.pnlMain.getLayout();
        if (control == this.rdbtnmntmSummary || control == this.btnSummaryView) {
            this.btnSummaryView.setSelected(true);
            this.rdbtnmntmSummary.setSelected(true);
            viewDeck.show(this.pnlMain, this.btnSummaryView.getText());
        } else if (control == this.rdbtnmntmHeapUsage || control == this.btnHeapUsageView) {
            this.btnHeapUsageView.setSelected(true);
            this.rdbtnmntmHeapUsage.setSelected(true);
            viewDeck.show(this.pnlMain, this.btnHeapUsageView.getText());
        }
        this.fillControls();
    }

    private void fillStatusBar(AgentResponse response) {
        AgentSnapshotResult snapshot;
        AgentRuntimeResult runtime;
        AgentRuntimeResult agentRuntimeResult = runtime = response != null ? (AgentRuntimeResult)response.getResult(AgentCommandType.RUNTIME) : null;
        if (runtime == null) {
            this.lblStatusBar1.setText("");
            this.lblStatusBar2.setText("");
            this.lblStatusBar3.setText("");
        } else {
            long usedHeap = runtime.getTotalHeapSize() - runtime.getFreeHeapSize();
            int heapPct = (int)((double)usedHeap / (double)runtime.getTotalHeapSize() * 100.0);
            this.lblStatusBar1.setText("Loaded Classes: " + this.numberFormat.format(runtime.getTotalClasses()));
            this.lblStatusBar2.setText("Total Threads: " + this.numberFormat.format(runtime.getTotalThreads()));
            this.lblStatusBar3.setText("Heap Usage: " + this.numberFormat.format(usedHeap) + "/" + this.numberFormat.format(runtime.getTotalHeapSize()) + "  (" + heapPct + "%)");
        }
        AgentSnapshotResult agentSnapshotResult = snapshot = response != null ? (AgentSnapshotResult)response.getResult(AgentCommandType.SNAPSHOT) : null;
        if (snapshot == null) {
            this.lblStatusBar4.setText("Last Snapshot: <NOT-AVAILABLE>");
        } else {
            this.lblStatusBar4.setText("Last Snapshot: " + this.dateFormat.format(new Date(snapshot.getLastJvmUpdate())));
        }
    }

    private void fillHeapClassControls(boolean reset) {
        AgentResponse response;
        AgentResponse agentResponse = response = this.activeAgent == null ? null : this.activeAgent.response;
        if (response == null) {
            this.tblHeapClassUsageModel.clear();
            this.cmbHeapClassFilter.setModel(new ClassComboBoxModel(new String[0]));
        } else {
            if (reset || this.cmbHeapClassFilter.getItemCount() == 0) {
                this.cmbHeapClassFilter.setSelectedIndex(-1);
                if (this.activeAgent.classes == null) {
                    this.cmbHeapClassFilter.setModel(new ClassComboBoxModel(new String[0]));
                } else {
                    this.cmbHeapClassFilter.setModel(new ClassComboBoxModel(this.activeAgent.classes));
                }
            }
            this.tblHeapClassUsageModel.setResults((AgentSnapshotResult)response.getResult(AgentCommandType.SNAPSHOT), this.activeAgent.classes, this.activeAgent.classFilter);
            Dimension headerSize = this.tblHeapClassUsage.getTableHeader().getPreferredSize();
            headerSize.height = 18;
            this.tblHeapClassUsage.getTableHeader().setPreferredSize(headerSize);
            int c = 0;
            while (c < this.tblHeapClassUsage.getColumnCount()) {
                this.tblHeapClassUsage.getColumnModel().getColumn(c).setPreferredWidth((int)(this.tblHeapClassUsageModel.getColumnWidthWeight(c) * (double)this.tblHeapClassUsage.getWidth()));
                ++c;
            }
        }
        this.cmbHeapClassFilter.getEditor().setItem(this.activeAgent == null ? null : this.activeAgent.classFilter);
    }

    private void fillHeapObjectControls(boolean reset) {
        this.btnHeapObjectRefresh.setEnabled(false);
        ObjectViewType viewType = ObjectViewType.TOP_OBJECTS_RETAINED_SIZE;
        AgentSnapshotResult res = null;
        if (this.activeAgent != null && this.activeAgent.response != null) {
            res = (AgentSnapshotResult)this.activeAgent.response.getResult(AgentCommandType.SNAPSHOT);
        }
        if (res == null) {
            if (this.activeAgent != null) {
                this.activeAgent.objClassFilter = null;
            }
            this.cmbHeapObjectClassFilter.setModel(new ClassComboBoxModel(new String[0]));
            this.treeHeapObjRefsModel.clear();
            this.treeHeapObjectsModel.clear();
            this.tblHeapClassUsageModel.clear();
            this.tblHeapObjectDataModel.clear();
            this.cmbHeapObjectFilter.setSelectedItem(ObjectViewType.getDisplayName(viewType));
        } else {
            if (this.activeAgent.classes == null) {
                this.activeAgent.objClassFilter = null;
                this.cmbHeapObjectClassFilter.setModel(new ClassComboBoxModel(new String[0]));
                this.treeHeapObjectsModel.setResults(null, null, 0);
                this.cmbHeapObjectFilter.setSelectedItem(ObjectViewType.getDisplayName(viewType));
            } else {
                Object classFilter;
                Object object = classFilter = this.activeAgent.objClassFilter != null ? this.activeAgent.objClassFilter : this.activeAgent.classFilter;
                if (reset || this.cmbHeapObjectClassFilter.getItemCount() == 0) {
                    this.cmbHeapObjectClassFilter.setModel(new ClassComboBoxModel(this.activeAgent.classes));
                    this.cmbHeapObjectClassFilter.getEditor().setItem(classFilter);
                }
                if (this.activeAgent.heapObjs != null) {
                    if (this.cmbHeapObjectFilter.getSelectedIndex() >= 0) {
                        viewType = ObjectViewType.toEnum(this.cmbHeapObjectFilter.getSelectedIndex());
                    }
                    this.cmbHeapObjectFilter.setSelectedItem(ObjectViewType.getDisplayName(viewType));
                    int count = 0;
                    if (viewType != ObjectViewType.ALL_OBJECTS) {
                        String countStr = this.txtHeapObjectCount.getText().trim();
                        count = countStr.length() == 0 ? 0 : Integer.parseInt(countStr);
                    }
                    ArrayList<JvmObjectInfo> objs = viewType == ObjectViewType.ROOT_OBJECTS ? new ArrayList<JvmObjectInfo>(res.getHeapRoots()) : this.activeAgent.heapObjs;
                    if (viewType == ObjectViewType.TOP_OBJECTS_SHALLOW_SIZE) {
                        JvmHeapObjectInfo.sortBySize(objs, SortOrder.DESCENDING);
                    } else {
                        JvmHeapObjectInfo.sortByRetainedSize(objs, SortOrder.DESCENDING);
                    }
                    this.treeHeapObjectsModel.setResults(objs, classFilter, count);
                }
                this.cmbHeapObjectClassFilter.setSelectedItem(classFilter);
            }
            this.tblHeapObjectDataModel.setObject(null);
            this.treeHeapObjRefsModel.setObject(null);
            this.treeHeapObjects.expandRow(0);
        }
        this.txtHeapObjectCount.setEnabled(viewType != ObjectViewType.ALL_OBJECTS);
    }

    private void fillHeapHistoryControls(boolean reset) {
        this.btnHistoryRefresh.setEnabled(false);
        if (this.activeAgent == null || this.activeAgent.response == null) {
            this.tblHistoryModel.setResults(null, null, null);
        } else if (this.activeAgent.savedInfo != null && this.activeAgent.classes != null) {
            this.tblHistoryModel.setSortOrder(HistorySortOrder.toEnum(this.cmbHistorySortOrder.getSelectedIndex()));
            this.tblHistoryModel.setValueType(HistoryValueType.toEnum(this.cmbHistoryValueType.getSelectedIndex()));
            if (reset) {
                this.tblHistoryModel.setResults(this.activeAgent.savedInfo, this.activeAgent.response, this.activeAgent.classes);
            } else {
                this.tblHistoryModel.applyFilters();
            }
            FontMetrics headerFontMetrics = this.tblHistory.getTableHeader().getFontMetrics(this.tblHistory.getTableHeader().getFont());
            int c = 0;
            while (c < this.tblHistoryModel.getColumnCount()) {
                TableColumn col = this.tblHistory.getColumnModel().getColumn(c);
                String headerText = col.getHeaderValue().toString();
                int dfltWidth = headerFontMetrics.stringWidth(headerText) + 10;
                col.setMinWidth(dfltWidth);
                if (c > 0 && (dfltWidth = this.tblHistoryModel.getColumnWidth(c)) == 0) {
                    int r = 0;
                    while (r < this.tblHistoryModel.getRowCount()) {
                        Component rendererComponent = this.tblHistoryCellRenderer.getTableCellRendererComponent(this.tblHistory, this.tblHistoryModel.getValueAt(r, c), false, false, r, c);
                        int width = (int)rendererComponent.getPreferredSize().getWidth() + 10;
                        if (width > dfltWidth) {
                            dfltWidth = width;
                        }
                        ++r;
                    }
                }
                col.setPreferredWidth(dfltWidth);
                this.tblHistoryModel.setColumnWidth(c, dfltWidth);
                ++c;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainWindow.this.tblHistory.scrollRectToVisible(new Rectangle(MainWindow.this.tblHistory.getCellRect(0, MainWindow.this.tblHistoryModel.getColumnCount() - 1, true)));
                }
            });
        }
    }

    private void fillHeapControls() {
        CardLayout viewDeck = (CardLayout)this.pnlHeap.getLayout();
        if (this.activeAgent == null || this.activeAgent.response.getResult(AgentCommandType.SNAPSHOT) == null) {
            viewDeck.show(this.pnlHeap, this.pnlHeapBlank.getName());
            if (this.activeAgent == null) {
                this.lblHeapBlank.setText("No Snapshot Available - Press image below to connect to JVM Agent");
                this.btnHeapBlank.setIcon(this.icnOpen48x48);
            } else {
                this.lblHeapBlank.setText("No Snapshot Available - Press image below to take a snapshot");
                this.btnHeapBlank.setIcon(this.icnSnapshot48x48);
            }
        } else {
            viewDeck.show(this.pnlHeap, this.paneHeap.getName());
            this.fillHeapClassControls(true);
            this.fillHeapObjectControls(true);
            this.fillHeapHistoryControls(true);
        }
    }

    private void fillSummaryControls() {
        this.txtOverview.setText("");
        this.txtSystemProps.setText("");
        this.txtAgentMetrics.setText("");
        if (this.activeAgent != null && this.activeAgent.response != null) {
            Style bold;
            StyledDocument doc;
            AgentRuntimeResult runtime = (AgentRuntimeResult)this.activeAgent.response.getResult(AgentCommandType.RUNTIME);
            AgentSystemPropsResult props = (AgentSystemPropsResult)this.activeAgent.response.getResult(AgentCommandType.SYSTEM_PROPS);
            AgentSnapshotResult snapshot = (AgentSnapshotResult)this.activeAgent.response.getResult(AgentCommandType.SNAPSHOT);
            if (runtime != null) {
                doc = this.txtOverview.getStyledDocument();
                bold = doc.addStyle("Bold", null);
                StyleConstants.setBold(bold, true);
                Style title = doc.addStyle("LargeBold", null);
                StyleConstants.setBold(title, true);
                StyleConstants.setUnderline(title, true);
                StyleConstants.setFontSize(title, StyleConstants.getFontSize(title) + 2);
                try {
                    doc.insertString(doc.getLength(), "Overview\n", title);
                    doc.insertString(doc.getLength(), "\nLast Summary Update: ", bold);
                    doc.insertString(doc.getLength(), this.dateFormat.format(new Date(runtime.getLastUpdate())), null);
                    doc.insertString(doc.getLength(), "\nAvailable Processors:   ", bold);
                    doc.insertString(doc.getLength(), this.numberFormat.format(runtime.getAvailableProcessors()), null);
                    doc.insertString(doc.getLength(), "\nLoaded Classes:   ", bold);
                    doc.insertString(doc.getLength(), this.numberFormat.format(runtime.getTotalClasses()), null);
                    doc.insertString(doc.getLength(), "\nTotal Threads:   ", bold);
                    doc.insertString(doc.getLength(), this.numberFormat.format(runtime.getTotalThreads()), null);
                    doc.insertString(doc.getLength(), "\n", null);
                    doc.insertString(doc.getLength(), "\nMaximum Heap Size:   ", bold);
                    doc.insertString(doc.getLength(), String.valueOf(this.numberFormat.format(runtime.getMaxHeapSize() / 1024L)) + " KB", null);
                    doc.insertString(doc.getLength(), "\nTotal Heap Memory:   ", bold);
                    doc.insertString(doc.getLength(), String.valueOf(this.numberFormat.format(runtime.getTotalHeapSize() / 1024L)) + " KB", null);
                    doc.insertString(doc.getLength(), "\nFree Heap Memory:   ", bold);
                    doc.insertString(doc.getLength(), String.valueOf(this.numberFormat.format(runtime.getFreeHeapSize() / 1024L)) + " KB", null);
                    if (snapshot != null) {
                        doc.insertString(doc.getLength(), "\n", null);
                        doc.insertString(doc.getLength(), "\nLast Snapshot Time: ", bold);
                        doc.insertString(doc.getLength(), this.dateFormat.format(new Date(snapshot.getLastJvmUpdate())), null);
                        doc.insertString(doc.getLength(), "\nTotal Heap Root Objects:   ", bold);
                        doc.insertString(doc.getLength(), this.numberFormat.format(snapshot.getTotalHeapRoots()), null);
                        doc.insertString(doc.getLength(), "\nReachable Heap Objects:   ", bold);
                        doc.insertString(doc.getLength(), this.numberFormat.format(snapshot.getTotalInstanceCount()), null);
                        doc.insertString(doc.getLength(), "\nTotal Reachable Heap Size:   ", bold);
                        doc.insertString(doc.getLength(), String.valueOf(this.numberFormat.format(snapshot.getTotalHeapSize() / 1024L)) + " KB", null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                this.txtOverview.setCaretPosition(0);
            }
            doc = this.txtSystemProps.getStyledDocument();
            bold = doc.addStyle("Bold", null);
            StyleConstants.setBold(bold, true);
            try {
                if (props != null) {
                    for (Map.Entry<String, String> entry : props.listAll()) {
                        doc.insertString(doc.getLength(), entry.getKey(), bold);
                        doc.insertString(doc.getLength(), " = ", null);
                        doc.insertString(doc.getLength(), entry.getValue(), null);
                        doc.insertString(doc.getLength(), "\n", null);
                    }
                }
            }
            catch (BadLocationException propIt) {
                // empty catch block
            }
            this.txtSystemProps.setCaretPosition(0);
            doc = this.txtAgentMetrics.getStyledDocument();
            bold = doc.addStyle("Bold", null);
            StyleConstants.setBold(bold, true);
            try {
                if (snapshot != null) {
                    for (Map.Entry<String, Object> entry : snapshot.getAllMetrics()) {
                        String propName = entry.getKey();
                        Object propValue = entry.getValue();
                        doc.insertString(doc.getLength(), propName, bold);
                        doc.insertString(doc.getLength(), " = ", null);
                        if (propValue instanceof Number) {
                            doc.insertString(doc.getLength(), this.numberFormat.format(propValue), null);
                        } else if (propValue instanceof Date) {
                            doc.insertString(doc.getLength(), this.dateFormat.format(propValue), null);
                        } else {
                            doc.insertString(doc.getLength(), propValue.toString(), null);
                        }
                        doc.insertString(doc.getLength(), "\n", null);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.txtAgentMetrics.setCaretPosition(0);
        }
    }

    private void fillControls() {
        this.winFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.mntmOpen.setEnabled(this.activeAgent == null);
            this.mntmClose.setEnabled(this.activeAgent != null);
            this.mntmSnapshot.setEnabled(this.activeAgent != null);
            this.mntmPerformGc.setEnabled(this.activeAgent != null);
            this.tbOpen.setEnabled(this.mntmOpen.isEnabled());
            this.tbClose.setEnabled(this.mntmClose.isEnabled());
            this.tbSnapshot.setEnabled(this.mntmSnapshot.isEnabled());
            this.tbPerformGc.setEnabled(this.mntmPerformGc.isEnabled());
            this.btnSnapshot.setEnabled(this.mntmSnapshot.isEnabled());
            if (this.activeAgent == null || this.activeAgent.response == null) {
                this.txtOverview.setText("");
                this.winFrame.setTitle(WIN_TITLE);
                this.fillStatusBar(null);
            } else {
                this.winFrame.setTitle("AutoPilot\u00ae Heap Detective\u2122 - " + this.activeAgent);
                this.fillStatusBar(this.activeAgent.response);
            }
            this.btnHeapUsageView.setBorderPainted(this.btnHeapUsageView.isSelected());
            this.btnSummaryView.setBorderPainted(this.btnSummaryView.isSelected());
            if (this.btnHeapUsageView.isSelected()) {
                this.fillHeapControls();
            } else {
                this.fillSummaryControls();
            }
        }
        finally {
            this.winFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void enableComponentAndChildren(JComponent comp, boolean enable) {
        Component[] components;
        Component[] componentArray = components = comp.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component child = componentArray[n2];
            if (child instanceof JComponent) {
                this.enableComponentAndChildren((JComponent)child, enable);
            }
            child.setEnabled(enable);
            ++n2;
        }
    }

    private void enableWindow(boolean enable) {
        if (enable) {
            this.winFrame.setCursor(Cursor.getDefaultCursor());
        } else {
            this.winFrame.setCursor(Cursor.getPredefinedCursor(3));
        }
        this.enableComponentAndChildren(this.menuBar, enable);
        this.enableComponentAndChildren(this.toolBar, enable);
        this.enableComponentAndChildren(this.iconBarPanel, enable);
        this.enableComponentAndChildren(this.pnlMain, enable);
    }

    private void openAgentConnection() {
        AgentConnectionDialog dialog = new AgentConnectionDialog(this.winFrame);
        dialog.setVisible(true);
        if (dialog.isOkSelected()) {
            String host = dialog.getJvmHost();
            int port = dialog.getJvmAgentPort();
            boolean doSnapshot = dialog.isTakeSnapshot();
            try {
                ActiveAgent agent = new ActiveAgent(host, port);
                this.activeConnections.add(agent);
                JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(agent.toString());
                menuItem.addActionListener(this);
                this.mnWindow.add(menuItem);
                this.activeWindowMenuItems.add(menuItem);
                agent.menuItem = menuItem;
                this.setActiveAgent(agent);
                if (doSnapshot) {
                    this.getHeapSnapshot(null);
                } else {
                    this.getSummaryInfo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.winFrame, "Failed to connect to " + host + ":" + port + "\n" + e, this.winFrame.getTitle(), 0);
            }
        }
        dialog.dispose();
    }

    private void setActiveAgent(ActiveAgent agent) {
        if (agent != this.activeAgent) {
            this.activeAgent = agent;
            if (this.activeAgent != null) {
                this.activeAgent.menuItem.setSelected(true);
            }
        }
        this.activateView(this.btnHeapUsageView.isSelected() ? this.btnHeapUsageView : this.btnSummaryView);
    }

    private void closeAgentConnection() {
        if (this.activeAgent == null) {
            return;
        }
        try {
            this.activeAgent.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.activeConnections.remove(this.activeAgent);
        this.mnWindow.remove(this.activeAgent.menuItem);
        this.activeAgent = this.activeConnections.size() > 0 ? this.activeConnections.get(0) : null;
        this.setActiveAgent(this.activeAgent);
    }

    private void processResponses(ActiveAgent agent, AgentCommandType ... commands) {
        if (this.progressMon != null) {
            this.progressMon.close();
        }
        boolean restoreSnapshot = false;
        boolean commandFailed = false;
        boolean newSnapshot = false;
        AgentCommandType[] agentCommandTypeArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            AgentCommandType cmd = agentCommandTypeArray[n2];
            if (cmd == AgentCommandType.SNAPSHOT) {
                newSnapshot = true;
                break;
            }
            ++n2;
        }
        AgentSnapshotResult snapshot = (AgentSnapshotResult)agent.response.getResult(AgentCommandType.SNAPSHOT);
        if (agent.isCancelled()) {
            restoreSnapshot = true;
            commandFailed = true;
        } else {
            int resp;
            if (agent.response.getStatus() == 0) {
                commandFailed = true;
                String reason = agent.response.getErrorMsg();
                if (reason == null) {
                    reason = "Cause not specified";
                }
                JOptionPane.showMessageDialog(this.winFrame, "Failed accessing JVM Agent:\n" + agent.response.getErrorMsg() + "\n", this.winFrame.getTitle(), 0);
                if (reason.contains("reject")) {
                    this.closeAgentConnection();
                } else {
                    restoreSnapshot = true;
                }
            } else {
                AgentCommandType[] agentCommandTypeArray2 = commands;
                int n3 = commands.length;
                n = 0;
                while (n < n3) {
                    AgentCommandType cmd = agentCommandTypeArray2[n];
                    AgentResult res = agent.response.getResult(cmd);
                    if (res != null && res.getStatus() == 0) {
                        if (!commandFailed) {
                            JOptionPane.showMessageDialog(this.winFrame, "JVM Agent command failed:\n" + res.getErrorMsg() + "\n", this.winFrame.getTitle(), 0);
                            commandFailed = true;
                        }
                        if (res == snapshot) {
                            restoreSnapshot = true;
                        }
                    }
                    ++n;
                }
            }
            if (!restoreSnapshot) {
                agent.savedSnapshot = null;
            }
            if (!commandFailed && commands[0] == AgentCommandType.PERFORM_GC && this.activeAgent != null && (resp = JOptionPane.showConfirmDialog(this.winFrame, "Garbage Collection complete.\n\nTake new snapshot?\n\n", this.winFrame.getTitle(), 0, 3)) == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainWindow.this.btnSnapshot.doClick();
                    }
                });
            }
        }
        if (restoreSnapshot) {
            this.activeAgent.restoreSnapshot();
        } else if (newSnapshot && snapshot != null && snapshot.getClassCount() > 0) {
            SavedSnapshot data = new SavedSnapshot(this.activeAgent.response);
            this.activeAgent.savedInfo.add(data);
            this.activeAgent.savedSnapshot = null;
        }
        this.enableWindow(true);
        if (!commandFailed) {
            this.fillControls();
        }
    }

    private void getSummaryInfo() {
        if (this.activeAgent != null) {
            this.activeAgent.executeCommands(AgentCommandType.RUNTIME, AgentCommandType.SYSTEM_PROPS);
        }
    }

    private void getHeapSnapshot(Component tab) {
        if (this.activeAgent == null) {
            return;
        }
        try {
            this.rdbtnmntmHeapUsage.setSelected(true);
            if (tab == null) {
                tab = this.paneHeap.getSelectedComponent();
            } else if (this.paneHeap.getSelectedComponent() != tab) {
                this.paneHeap.setSelectedComponent(tab);
            }
            if (this.activeAgent != null) {
                this.activeAgent.savedSnapshot = (AgentSnapshotResult)this.activeAgent.response.getResult(AgentCommandType.SNAPSHOT);
                this.activeAgent.executeCommands(AgentCommandType.SNAPSHOT);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.winFrame, "Internal Error:\n" + e, this.winFrame.getTitle(), 0);
        }
    }

    private void runGC() {
        if (this.activeAgent == null) {
            return;
        }
        this.activeAgent.executeCommands(AgentCommandType.PERFORM_GC);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block29: {
            if (!this.componentEventsEnabled || this.winFrame.getCursor() == Cursor.getPredefinedCursor(3)) {
                return;
            }
            this.componentEventsEnabled = false;
            try {
                try {
                    Object source = e.getSource();
                    if (source == this.mntmOpen || source == this.tbOpen) {
                        this.openAgentConnection();
                        break block29;
                    }
                    if (source == this.mntmClose || source == this.tbClose) {
                        this.closeAgentConnection();
                        break block29;
                    }
                    if (source == this.mntmExit) {
                        this.winFrame.dispose();
                        break block29;
                    }
                    if (source == this.mntmRefreshSummary || source == this.tbRefreshSummary) {
                        this.getSummaryInfo();
                        break block29;
                    }
                    if (source == this.rdbtnmntmSummary || source == this.btnSummaryView) {
                        this.activateView(source);
                        break block29;
                    }
                    if (source == this.rdbtnmntmHeapUsage || source == this.btnHeapUsageView) {
                        this.activateView(source);
                        break block29;
                    }
                    if (source == this.cmbHeapClassFilter) {
                        this.activeAgent.classFilter = this.cmbHeapClassFilter.getEditor().getItem();
                        this.fillHeapClassControls(false);
                        break block29;
                    }
                    if (source == this.cmbHeapObjectFilter) {
                        this.txtHeapObjectCount.setEnabled(this.cmbHeapObjectFilter.getSelectedItem() != ObjectViewType.ALL_OBJECTS);
                        this.btnHeapObjectRefresh.setEnabled(true);
                        break block29;
                    }
                    if (source == this.txtHeapObjectCount || source == this.cmbHeapObjectClassFilter) {
                        this.btnHeapObjectRefresh.setEnabled(true);
                        break block29;
                    }
                    if (source == this.btnHeapObjectRefresh) {
                        this.activeAgent.objClassFilter = this.cmbHeapObjectClassFilter.getEditor().getItem();
                        this.fillHeapObjectControls(false);
                        break block29;
                    }
                    if (source == this.btnHistoryRefresh) {
                        this.fillHeapHistoryControls(false);
                        break block29;
                    }
                    if (source == this.cmbHistorySortOrder || source == this.cmbHistoryValueType) {
                        this.btnHistoryRefresh.setEnabled(true);
                        break block29;
                    }
                    if (source == this.btnSnapshot || source == this.mntmSnapshot || source == this.tbSnapshot) {
                        this.getHeapSnapshot(null);
                        break block29;
                    }
                    if (source == this.btnHeapBlank) {
                        if (this.activeAgent == null) {
                            this.openAgentConnection();
                        } else {
                            this.getHeapSnapshot(null);
                        }
                        break block29;
                    }
                    if (source == this.mntmAllInstances || source == this.mntmTopInstances) {
                        this.activeAgent.objClassFilter = this.paneHeap.getSelectedComponent() == this.pnlHistory ? this.tblHistoryModel.getSelectedClass() : this.tblHeapClassUsageModel.getSelectedClass();
                        if (source == this.mntmAllInstances) {
                            this.txtHeapObjectCount.setText("0");
                            this.cmbHeapObjectFilter.setSelectedIndex(ObjectViewType.ALL_OBJECTS.ordinal());
                        } else {
                            this.cmbHeapObjectFilter.setSelectedIndex(ObjectViewType.TOP_OBJECTS_RETAINED_SIZE.ordinal());
                        }
                        this.componentEventsEnabled = true;
                        this.btnHeapUsageView.doClick();
                        this.paneHeap.setSelectedComponent(this.pnlHeapObject);
                        this.fillControls();
                        break block29;
                    }
                    if (source == this.mntmPerformGc || source == this.tbPerformGc) {
                        this.runGC();
                        break block29;
                    }
                    if (source == this.mntmAbout) {
                        AboutDialog aboutDlg = new AboutDialog(this.winFrame);
                        aboutDlg.setVisible(true);
                        break block29;
                    }
                    if (!(source instanceof JRadioButtonMenuItem)) break block29;
                    int a = 0;
                    while (a < this.activeConnections.size()) {
                        ActiveAgent conn = this.activeConnections.get(a);
                        if (conn.menuItem == source) {
                            this.setActiveAgent(conn);
                            break;
                        }
                        ++a;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(this.winFrame, "Internal Error\n" + e, this.winFrame.getTitle(), 0);
                    this.componentEventsEnabled = true;
                }
            }
            finally {
                this.componentEventsEnabled = true;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.componentEventsEnabled || this.winFrame.getCursor() == Cursor.getPredefinedCursor(3)) {
            return;
        }
        Object source = e.getSource();
        if (source == this.tblHeapClassUsage) {
            if (SwingUtilities.isRightMouseButton(e)) {
                Point p = e.getPoint();
                int row = this.tblHeapClassUsage.rowAtPoint(p);
                this.tblHeapClassUsage.getSelectionModel().setSelectionInterval(row, row);
                this.mnClassPopup.show(this.tblHeapClassUsage, p.x, p.y);
            }
        } else if ((source == this.tblHistory || source == this.tblHistoryRowHeader) && SwingUtilities.isRightMouseButton(e)) {
            JTable tbl = (JTable)source;
            Point p = e.getPoint();
            int row = tbl.rowAtPoint(p);
            tbl.getSelectionModel().setSelectionInterval(row, row);
            if (row >= this.tblHistoryModel.getClassBaseRow()) {
                this.mnClassPopup.show(tbl, p.x, p.y);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!this.componentEventsEnabled || this.winFrame.getCursor() == Cursor.getPredefinedCursor(3)) {
            return;
        }
        Object source = e.getSource();
        if (source == this.treeHeapObjects) {
            Object selNode = this.treeHeapObjects.getLastSelectedPathComponent();
            if (selNode instanceof HeapObjectTreeNode) {
                Object res = this.treeHeapObjectsModel.getNodeObject((HeapObjectTreeNode)selNode);
                this.tblHeapObjectDataModel.setObject(res);
                if (res instanceof JvmHeapReferenceInfo) {
                    this.treeHeapObjRefsModel.setObject(((JvmHeapReferenceInfo)res).getReferee());
                } else if (res instanceof JvmObjectInfo) {
                    this.treeHeapObjRefsModel.setObject((JvmObjectInfo)res);
                } else {
                    this.tblHeapObjectDataModel.setObject(null);
                    this.treeHeapObjRefsModel.setObject(null);
                }
            } else {
                this.tblHeapObjectDataModel.setObject(null);
                this.treeHeapObjRefsModel.setObject(null);
            }
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) {
        if (!this.componentEventsEnabled || this.winFrame.getCursor() == Cursor.getPredefinedCursor(3)) {
            return;
        }
        Object source = event.getSource();
        if (source == this.treeHeapObjects) {
            this.treeHeapObjectsModel.expand(event.getPath());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("progress") && this.progressMon != null) {
            if (this.progressMon.isCanceled()) {
                this.cmdProcessor.cancel(true);
            } else {
                int progress = (Integer)evt.getNewValue();
                this.progressMon.setProgress(progress);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        Object source = e.getSource();
        if (source == this.txtHeapObjectCount) {
            this.btnHeapObjectRefresh.setEnabled(true);
        } else if (source == this.cmbHeapObjectClassFilter.getEditor().getEditorComponent()) {
            this.btnHeapObjectRefresh.setEnabled(true);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyTyped(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyTyped(e);
    }

    private class ActiveAgent
    extends AgentConnection {
        public JMenuItem menuItem;
        public AgentResponse response;
        public Vector<JvmClassInfo> classes;
        public ArrayList<JvmObjectInfo> heapObjs;
        public ArrayList<SavedSnapshot> savedInfo;
        public Object classFilter;
        public Object objClassFilter;
        public boolean cancelOp;
        public long cmdTag;
        public AgentSnapshotResult savedSnapshot;

        public ActiveAgent(String agentHost, int agentPort) throws UnknownHostException, IOException, ParserConfigurationException, SAXException {
            super(agentHost, agentPort);
            this.menuItem = null;
            this.response = new AgentResponse();
            this.classes = null;
            this.heapObjs = null;
            this.savedInfo = new ArrayList();
            this.classFilter = null;
            this.objClassFilter = null;
            this.cancelOp = false;
            this.cmdTag = 0L;
            this.savedSnapshot = null;
        }

        public boolean isCancelled() {
            return this.cancelOp;
        }

        public void submitCommands(long cmdTag, AgentCommandType ... commands) throws IOException, SAXException {
            if (this.cancelOp) {
                return;
            }
            if (MainWindow.this.cmdProcessor != null) {
                MainWindow.this.cmdProcessor.updateProgress(0, "Generating Snapshot...");
            }
            this.respParser.setCmdTag(cmdTag);
            this.sendCommand(this.buildCommandString(cmdTag, commands));
            do {
                String responseStr = this.readResponse();
                try {
                    this.respParser.parse(this.response, responseStr, MainWindow.this.cmdProcessor);
                }
                catch (ResponseTagMismatchException e) {
                    this.response.setLast(false);
                }
            } while (!this.response.isLast());
        }

        public void executeCommands(AgentCommandType ... commands) {
            MainWindow.this.enableWindow(false);
            this.cancelOp = false;
            this.respParser.reset();
            this.response.resetStatus();
            this.cmdTag = System.currentTimeMillis();
            AgentCommandType[] agentCommandTypeArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                AgentCommandType command = agentCommandTypeArray[n2];
                if (command == AgentCommandType.SNAPSHOT) {
                    MainWindow.this.progressMon = new ProgressMonitor(MainWindow.this.winFrame.getContentPane(), "Taking JVM Snapshot...", "Generating Snapshot...", 0, 100);
                    MainWindow.this.progressMon.setMillisToDecideToPopup(0);
                    MainWindow.this.progressMon.setMillisToPopup(0);
                    MainWindow.this.progressMon.setProgress(0);
                    this.response.removeResult(command);
                    break;
                }
                ++n2;
            }
            MainWindow.this.cmdProcessor = new AgentCommandProcessor(this, this.cmdTag, commands);
            MainWindow.this.cmdProcessor.addPropertyChangeListener(MainWindow.this);
            MainWindow.this.cmdProcessor.execute();
            MainWindow.this.cmdWatcher = new AgentCommandWatcher(1000);
        }

        public void cancelPending() {
            block3: {
                if (!this.cancelOp) {
                    this.cancelOp = true;
                    try {
                        this.sendAbort();
                    }
                    catch (IOException e) {
                        if (MainWindow.this.cmdProcessor == null) break block3;
                        MainWindow.this.cmdProcessor.cancel(true);
                    }
                }
            }
        }

        public void processError(Throwable e) {
            boolean printTrace = true;
            if (MainWindow.this.progressMon != null) {
                MainWindow.this.progressMon.close();
                MainWindow.this.progressMon = null;
            }
            MainWindow.this.enableWindow(true);
            String errMsg = e.toString();
            int msgType = 0;
            if (e instanceof IOException || e.getCause() instanceof IOException) {
                errMsg = "Failed sending request to " + this + ":\n" + e;
                if (errMsg.contains("Connection reset") || errMsg.contains("Connection refused")) {
                    printTrace = false;
                    if (MainWindow.this.activeAgent == this) {
                        MainWindow.this.closeAgentConnection();
                    }
                }
            } else if (!(e instanceof CancellationException)) {
                Throwable exc = e.getCause();
                while (exc != null && !(exc instanceof CancellationException)) {
                    exc = exc.getCause();
                }
                if (exc != null) {
                    e = exc;
                }
            }
            if (e instanceof CancellationException || e instanceof InterruptedException) {
                errMsg = e.getCause() != null ? e.getCause().toString() : "Operation Cancelled.";
                msgType = 1;
                printTrace = false;
                this.cancelPending();
            }
            if (printTrace) {
                e.printStackTrace();
            }
            JOptionPane.showMessageDialog(MainWindow.this.winFrame, errMsg, MainWindow.this.winFrame.getTitle(), msgType);
            this.restoreSnapshot();
            MainWindow.this.fillControls();
        }

        public void restoreSnapshot() {
            if (this.savedSnapshot != null) {
                this.response.setResult(this.savedSnapshot);
                this.savedSnapshot = null;
            }
        }
    }

    class AgentCommandProcessor
    extends SwingWorker<Void, String>
    implements AgentProgressMonitor {
        protected ActiveAgent agent;
        protected AgentCommandType[] commands;
        protected long cmdTag;

        public AgentCommandProcessor(ActiveAgent agent, long cmdTag, AgentCommandType ... commands) {
            this.agent = agent;
            this.commands = commands;
            this.cmdTag = cmdTag;
        }

        @Override
        public void updateProgress(int progress, String message) {
            this.setProgress(progress);
            if (message != null && !this.isUserCancelled()) {
                this.publish(message);
            }
        }

        @Override
        public boolean isUserCancelled() {
            return this.isCancelled() || MainWindow.this.progressMon != null && MainWindow.this.progressMon.isCanceled();
        }

        @Override
        public Component getParent() {
            return MainWindow.this.winFrame;
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.setProgress(0);
            this.agent.submitCommands(this.cmdTag, this.commands);
            AgentSnapshotResult res = (AgentSnapshotResult)this.agent.response.getResult(AgentCommandType.SNAPSHOT);
            if (res != null && res.getStatus() != 0) {
                this.agent.classes = new Vector<JvmClassInfo>(res.getClasses());
                JvmClassInfo.sortByInstanceCount(this.agent.classes, SortOrder.DESCENDING);
                int i = this.agent.classes.size() - 1;
                while (i > 0) {
                    if (this.agent.classes.get(i).getTotalInstances() > 0) {
                        this.agent.classes.setSize(i + 1);
                        break;
                    }
                    --i;
                }
                JvmClassInfo.sortByClassName(this.agent.classes, SortOrder.ASCENDING);
                Collection<JvmObjectInfo> heapObjs = res.getHeapObjects();
                if (heapObjs == null) {
                    this.agent.heapObjs = null;
                } else {
                    this.agent.heapObjs = new ArrayList<JvmObjectInfo>(heapObjs);
                    int i2 = 0;
                    while (i2 < this.agent.heapObjs.size()) {
                        int progress = (int)((double)i2 / (double)this.agent.heapObjs.size() * 100.0);
                        this.updateProgress(progress, i2 == 0 ? "Computing Retained Sizes..." : null);
                        JvmObjectInfo objInfo = this.agent.heapObjs.get(i2);
                        objInfo.getRetainedSize();
                        if (objInfo instanceof JvmArrayHeapObjectInfo) {
                            ((JvmArrayHeapObjectInfo)objInfo).buildElementMap();
                        }
                        ++i2;
                    }
                }
            }
            return null;
        }

        @Override
        protected void process(List<String> chunks) {
            if (MainWindow.this.progressMon != null) {
                if (MainWindow.this.progressMon.isCanceled()) {
                    this.agent.cancelPending();
                    return;
                }
                MainWindow.this.progressMon.setNote(chunks.get(0));
                MainWindow.this.progressMon.setProgress(this.getProgress());
            }
        }

        @Override
        protected void done() {
            try {
                try {
                    this.get();
                    MainWindow.this.processResponses(this.agent, this.commands);
                }
                catch (Exception e) {
                    this.agent.processError(e);
                    if (MainWindow.this.progressMon != null) {
                        MainWindow.this.progressMon.close();
                        MainWindow.this.progressMon = null;
                    }
                    MainWindow.this.cmdWatcher.stop();
                    MainWindow.this.cmdWatcher = null;
                    MainWindow.this.cmdProcessor = null;
                }
            }
            finally {
                if (MainWindow.this.progressMon != null) {
                    MainWindow.this.progressMon.close();
                    MainWindow.this.progressMon = null;
                }
                MainWindow.this.cmdWatcher.stop();
                MainWindow.this.cmdWatcher = null;
                MainWindow.this.cmdProcessor = null;
            }
        }
    }

    class AgentCommandWatcher
    extends Timer
    implements ActionListener {
        private static final long serialVersionUID = -3768816716235420723L;

        public AgentCommandWatcher(int delay) {
            super(delay, null);
            this.addActionListener(this);
            this.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainWindow.this.progressMon != null && MainWindow.this.progressMon.isCanceled()) {
                MainWindow.this.activeAgent.cancelPending();
                this.stop();
            }
        }
    }

    class EventQueueProxy
    extends EventQueue {
        EventQueueProxy() {
        }

        @Override
        protected void dispatchEvent(AWTEvent newEvent) {
            try {
                super.dispatchEvent(newEvent);
            }
            catch (Throwable t) {
                t.printStackTrace();
                JOptionPane.showMessageDialog(null, "Internal Error:\n" + t, MainWindow.this.winFrame.getTitle(), 0);
            }
        }
    }
}

