/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.ui;

import com.nastel.heapdetective.client.AgentCommandType;
import com.nastel.heapdetective.client.AgentResponse;
import com.nastel.heapdetective.client.AgentRuntimeResult;
import com.nastel.heapdetective.client.AgentSnapshotResult;
import com.nastel.heapdetective.jvm.JvmClassInfo;
import com.nastel.heapdetective.jvm.JvmInfoComparator;
import com.nastel.heapdetective.ui.ClassHistoryInfo;
import com.nastel.heapdetective.ui.HistoryRowHeaderModel;
import com.nastel.heapdetective.ui.HistorySortOrder;
import com.nastel.heapdetective.ui.HistoryValueType;
import com.nastel.heapdetective.ui.SavedSnapshot;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;

public class HistoryTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1244206799995481600L;
    public static final int TOTAL_HEAP_SIZE_ROW = 0;
    public static final int FREE_HEAP_SIZE_ROW = 1;
    public static final int TOTAL_INSTANCES_ROW = 2;
    public static final int TOTAL_HEAP_REFS_ROW = 3;
    public static final int TOTAL_THREADS_ROW = 4;
    public static final int TOTAL_CLASSES_ROW = 5;
    public static final int CLASS_START_ROW = 7;
    protected JTable table;
    protected HistoryRowHeaderModel rowHeaderModel;
    protected ArrayList<SavedSnapshot> savedResults;
    protected AgentRuntimeResult runtime;
    protected AgentSnapshotResult snapshot;
    protected Vector<Integer> colWidths = new Vector();
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM yyyy HH:mm:ss");
    protected HistorySortOrder sortOrder = HistorySortOrder.LARGEST_VAL_CHANGE;
    protected HistoryValueType valueType = HistoryValueType.INSTANCE_SIZE;
    protected ArrayList<ClassHistoryComparer> sortedClasses;
    protected int numCols;
    protected int numRows;

    public void setTable(JTable table) {
        this.table = table;
    }

    public HistorySortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(HistorySortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public HistoryValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(HistoryValueType valueType) {
        this.valueType = valueType;
    }

    public void setResults(ArrayList<SavedSnapshot> savedResults, AgentResponse curResults, Vector<JvmClassInfo> curClasses) {
        if (curResults == null) {
            this.clear();
        } else {
            this.savedResults = savedResults;
            this.runtime = (AgentRuntimeResult)curResults.getResult(AgentCommandType.RUNTIME);
            this.snapshot = (AgentSnapshotResult)curResults.getResult(AgentCommandType.SNAPSHOT);
            this.numCols = savedResults == null ? 0 : savedResults.size();
            this.numRows = curClasses.size() + 7;
            if (this.numCols > 1) {
                SavedSnapshot curSS = savedResults.get(savedResults.size() - 1);
                SavedSnapshot priorSS = savedResults.get(savedResults.size() - 2);
                for (JvmClassInfo classInfo : curClasses) {
                    ClassHistoryInfo curVals = curSS.getClassInfo(classInfo.getName());
                    if (curVals == null) continue;
                    curVals.computeChanges(priorSS.getClassInfo(classInfo.getName()));
                }
            }
            this.sortedClasses = new ArrayList(curClasses.size());
            int i = 0;
            while (i < curClasses.size()) {
                this.sortedClasses.add(new ClassHistoryComparer(curClasses.get(i)));
                ++i;
            }
            if (this.colWidths.size() < this.numCols) {
                this.colWidths.setSize(this.numCols);
            }
            this.applyFilters();
        }
    }

    public void setRowHeaderModel(HistoryRowHeaderModel rowHeaderModel) {
        this.rowHeaderModel = rowHeaderModel;
    }

    @Override
    public int getRowCount() {
        return this.numRows;
    }

    @Override
    public int getColumnCount() {
        return this.numCols;
    }

    @Override
    public String getColumnName(int column) {
        if (this.savedResults == null || column > this.savedResults.size()) {
            return "";
        }
        return this.dateFormat.format(new Date(this.savedResults.get(column).getSnapshotTime()));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return ClassHistoryInfo.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount() || columnIndex >= this.getColumnCount() || rowIndex == 6) {
            return "";
        }
        SavedSnapshot ss = this.savedResults.get(columnIndex);
        if (ss == null) {
            return "";
        }
        switch (rowIndex) {
            case 0: {
                return ss.getTotalHeapSize();
            }
            case 1: {
                return ss.getFreeHeapSize();
            }
            case 5: {
                return ss.getTotalClasses();
            }
            case 4: {
                return ss.getTotalThreads();
            }
            case 2: {
                return ss.getTotalInstanceCount();
            }
            case 3: {
                return ss.getTotalHeapRefs();
            }
        }
        JvmClassInfo classInfo = this.getClassInfo(rowIndex);
        return classInfo == null ? "" : ss.getClassInfo(classInfo.getName());
    }

    public Object getRowHeader(int rowIndex) {
        if (rowIndex >= this.getRowCount() || rowIndex == 6) {
            return "";
        }
        switch (rowIndex) {
            case 0: {
                return "Total Heap Size (bytes)";
            }
            case 1: {
                return "Free Heap Size (bytes)";
            }
            case 5: {
                return "Total Classes";
            }
            case 4: {
                return "Total Threads";
            }
            case 2: {
                return "Total Heap Objects";
            }
            case 3: {
                return "Total Heap References";
            }
        }
        JvmClassInfo classInfo = this.getClassInfo(rowIndex);
        return classInfo == null ? "" : "Class: " + classInfo.getName();
    }

    public int getColumnWidth(int colIndex) {
        if (colIndex < 0 || colIndex >= this.numCols || this.colWidths.get(colIndex) == null) {
            return 0;
        }
        return this.colWidths.get(colIndex);
    }

    public void setColumnWidth(int colIndex, int colWidth) {
        this.colWidths.set(colIndex, colWidth);
    }

    public int getClassBaseRow() {
        return 7;
    }

    public JvmClassInfo getSelectedClass() {
        return this.getClassInfo(this.table.convertRowIndexToModel(this.table.getSelectedRow()));
    }

    public JvmClassInfo getClassInfo(int rowIndex) {
        if (rowIndex < 7 || rowIndex >= this.getRowCount() || rowIndex == 6) {
            return null;
        }
        return this.sortedClasses.get((int)(rowIndex - 7)).classInfo;
    }

    public void clear() {
        this.sortedClasses = null;
        this.savedResults = null;
        this.runtime = null;
        this.snapshot = null;
        this.numCols = 0;
        this.numRows = 0;
        this.colWidths.clear();
    }

    @Override
    public void fireTableStructureChanged() {
        super.fireTableStructureChanged();
        if (this.rowHeaderModel != null) {
            this.rowHeaderModel.fireTableStructureChanged();
        }
    }

    protected void sortHistory() {
        Collections.sort(this.sortedClasses, new Comparator<ClassHistoryComparer>(){

            @Override
            public int compare(ClassHistoryComparer o1, ClassHistoryComparer o2) {
                return o1.compareTo(o2);
            }
        });
    }

    public void applyFilters() {
        this.sortHistory();
        this.fireTableStructureChanged();
    }

    protected class ClassHistoryComparer
    implements Comparable<ClassHistoryComparer> {
        public JvmClassInfo classInfo;

        public ClassHistoryComparer(JvmClassInfo classInfo) {
            this.classInfo = classInfo;
        }

        public int hashCode() {
            return this.classInfo.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ClassHistoryComparer ? this.compareTo((ClassHistoryComparer)obj) == 0 : false;
        }

        @Override
        public int compareTo(ClassHistoryComparer o) {
            SavedSnapshot snapshot = HistoryTableModel.this.savedResults.get(HistoryTableModel.this.savedResults.size() - 1);
            JvmClassInfo cls1 = this.classInfo;
            JvmClassInfo cls2 = o.classInfo;
            if (cls1 == null || cls2 == null) {
                return 0;
            }
            if (HistoryTableModel.this.sortOrder == HistorySortOrder.CLASS_NAME) {
                return JvmInfoComparator.compareStrings(SortOrder.ASCENDING, cls1.getName(), cls2.getName());
            }
            ClassHistoryInfo v1 = snapshot.getClassInfo(cls1.getName());
            ClassHistoryInfo v2 = snapshot.getClassInfo(cls2.getName());
            if (v1 == null || v2 == null) {
                return 0;
            }
            int cmpVal = 0;
            cmpVal = HistoryTableModel.this.valueType == HistoryValueType.INSTANCE_COUNT ? (HistoryTableModel.this.sortOrder == HistorySortOrder.LARGEST_VAL_CHANGE ? v2.getInstanceChange() - v1.getInstanceChange() : (HistoryTableModel.this.sortOrder == HistorySortOrder.LARGEST_PCT_CHANGE ? JvmInfoComparator.compareValues(SortOrder.DESCENDING, v1.getInstancePctChange(), v2.getInstancePctChange()) : v2.getTotalInstances() - v1.getTotalInstances())) : (HistoryTableModel.this.sortOrder == HistorySortOrder.LARGEST_VAL_CHANGE ? JvmInfoComparator.compareValues(SortOrder.DESCENDING, v1.getSizeChange(), v2.getSizeChange()) : (HistoryTableModel.this.sortOrder == HistorySortOrder.LARGEST_PCT_CHANGE ? JvmInfoComparator.compareValues(SortOrder.DESCENDING, v1.getSizePctChange(), v2.getSizePctChange()) : JvmInfoComparator.compareValues(SortOrder.DESCENDING, v1.getTotalSize(), v2.getTotalSize())));
            if (cmpVal == 0 && HistoryTableModel.this.sortOrder != HistorySortOrder.LARGEST_VALUE) {
                cmpVal = JvmInfoComparator.compareValues(SortOrder.DESCENDING, v1.getTotalSize(), v2.getTotalSize());
            }
            return cmpVal;
        }
    }
}

