/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.ui;

import com.nastel.heapdetective.ui.ClassHistoryInfo;
import com.nastel.heapdetective.ui.HistorySortOrder;
import com.nastel.heapdetective.ui.HistoryTableModel;
import com.nastel.heapdetective.ui.HistoryValueType;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class HistoryTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -1372639006719500133L;
    private NumberFormat valFmt = NumberFormat.getIntegerInstance();

    public HistoryTableCellRenderer() {
        this.valFmt.setGroupingUsed(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel cmp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        row = table.convertRowIndexToModel(row);
        HistoryTableModel mdl = (HistoryTableModel)table.getModel();
        HistoryValueType valueType = mdl.getValueType();
        HistorySortOrder sortOrder = mdl.getSortOrder();
        long rawValue = 0L;
        long diff = 0L;
        float pctChg = 0.0f;
        if (value instanceof ClassHistoryInfo) {
            ClassHistoryInfo histValues = (ClassHistoryInfo)value;
            long l = rawValue = valueType == HistoryValueType.INSTANCE_COUNT ? (long)histValues.getTotalInstances() : histValues.getTotalSize();
            if (column > 0) {
                pctChg = valueType == HistoryValueType.INSTANCE_COUNT ? histValues.getInstancePctChange() : histValues.getSizePctChange();
                diff = valueType == HistoryValueType.INSTANCE_COUNT ? (long)histValues.getInstanceChange() : histValues.getSizeChange();
            }
        } else if (value instanceof Number) {
            rawValue = ((Number)value).longValue();
            if (column > 0) {
                long priorVal = ((Number)mdl.getValueAt(row, column - 1)).longValue();
                diff = rawValue - priorVal;
                pctChg = (float)diff / (float)priorVal * 100.0f;
            }
        } else {
            return cmp;
        }
        if (column == 0 || sortOrder == HistorySortOrder.LARGEST_VALUE) {
            cmp.setText(this.valFmt.format(rawValue));
        } else if (Float.isInfinite(pctChg) || Float.isNaN(pctChg)) {
            cmp.setText(String.format("<html>%s<font size=-2 color=red> (+)</font></html>", this.valFmt.format(rawValue)));
        } else {
            String color = null;
            if (diff == 0L) {
                color = "";
            } else if (row == 1) {
                color = diff < 0L ? "color=red" : "color=blue";
            } else {
                String string = color = diff > 0L ? "color=red" : "color=blue";
            }
            if (sortOrder == HistorySortOrder.LARGEST_PCT_CHANGE) {
                cmp.setText(String.format("<html>%s<font size=-2 %s> (%+,.2f%%)</font></html>", this.valFmt.format(rawValue), color, Float.valueOf(pctChg)));
            } else {
                cmp.setText(String.format("<html>%s<font size=-2 %s> (%+,d)</font></html>", this.valFmt.format(rawValue), color, diff));
            }
        }
        return cmp;
    }
}

