/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.ui;

import com.nastel.heapdetective.jvm.JvmArrayHeapObjectInfo;
import com.nastel.heapdetective.jvm.JvmClassInfo;
import com.nastel.heapdetective.jvm.JvmHeapReferenceInfo;
import com.nastel.heapdetective.jvm.JvmObjectInfo;
import com.nastel.heapdetective.ui.ArrayElementRange;
import com.nastel.heapdetective.ui.HeapObjectTreeNode;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class HeapObjectTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 6709454995726774144L;
    protected DefaultMutableTreeNode rootNode;

    public HeapObjectTreeModel(String rootLabel) {
        super(new DefaultMutableTreeNode(rootLabel));
        this.rootNode = (DefaultMutableTreeNode)this.root;
    }

    public void setResults(ArrayList<JvmObjectInfo> results, Object classFilter, int count) {
        if (results == null) {
            this.clear();
        } else {
            this.setNodeChildResults(this.rootNode, results, classFilter, count);
        }
    }

    public HeapObjectTreeNode getNode(TreePath path) {
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        return node instanceof HeapObjectTreeNode ? (HeapObjectTreeNode)node : null;
    }

    public Object getNodeObject(HeapObjectTreeNode node) {
        return node == null ? null : node.getUserObject();
    }

    public Object getNodeObject(TreePath path) {
        return this.getNodeObject(this.getNode(path));
    }

    public void expand(TreePath path) {
        this.expand(this.getNode(path));
    }

    public void expand(HeapObjectTreeNode node) {
        node.removeAllChildren();
        JvmObjectInfo objInfo = null;
        JvmArrayHeapObjectInfo arrayObj = null;
        ArrayElementRange elmtRange = null;
        Object nodeObj = node.getUserObject();
        int rangeLen = 0;
        int start = 0;
        int end = 0;
        if (nodeObj instanceof ArrayElementRange) {
            elmtRange = (ArrayElementRange)nodeObj;
            rangeLen = (int)Math.pow(10.0, Math.ceil(Math.log10(elmtRange.getLength()) - 2.0));
            arrayObj = elmtRange.getArrayObj();
            objInfo = arrayObj;
            start = elmtRange.getStart();
            end = elmtRange.getEnd();
        } else {
            if (nodeObj instanceof JvmObjectInfo) {
                objInfo = (JvmObjectInfo)nodeObj;
            } else if (nodeObj instanceof JvmHeapReferenceInfo) {
                objInfo = ((JvmHeapReferenceInfo)nodeObj).getReferee();
            }
            if (objInfo instanceof JvmArrayHeapObjectInfo) {
                arrayObj = (JvmArrayHeapObjectInfo)objInfo;
                if (objInfo.getRefereesCount() > 100) {
                    rangeLen = (int)Math.pow(10.0, Math.ceil(Math.log10(arrayObj.getLength()) - 2.0));
                }
                start = 0;
                end = arrayObj.getLength() - 1;
            }
        }
        if (objInfo != null) {
            if (elmtRange != null || arrayObj != null && arrayObj.getLength() > 100) {
                if (rangeLen >= 10) {
                    int i = start;
                    while (i < end) {
                        int curEnd = Math.min(i + rangeLen - 1, end);
                        if (curEnd >= arrayObj.getMinFilledIndex() && i <= arrayObj.getMaxFilledIndex()) {
                            node.add(new HeapObjectTreeNode(new ArrayElementRange(arrayObj, i, curEnd)));
                        }
                        i += rangeLen;
                    }
                } else {
                    int i = start;
                    while (i <= end) {
                        JvmHeapReferenceInfo elmtRef = arrayObj.getElement(i);
                        if (elmtRef != null) {
                            node.add(new HeapObjectTreeNode(elmtRef));
                        }
                        ++i;
                    }
                }
            } else {
                ArrayList<JvmHeapReferenceInfo> referees = objInfo.getReferees();
                if (referees != null) {
                    int i = 0;
                    while (i < referees.size()) {
                        node.add(new HeapObjectTreeNode(referees.get(i)));
                        ++i;
                    }
                }
            }
            this.nodeStructureChanged(node);
        }
    }

    protected void setNodeChildResults(DefaultMutableTreeNode node, ArrayList<JvmObjectInfo> results, Object classFilter, int count) {
        JvmClassInfo filterClass = null;
        Pattern pattern = null;
        if (classFilter != null) {
            if (classFilter instanceof JvmClassInfo) {
                filterClass = (JvmClassInfo)classFilter;
            } else if (classFilter.toString().length() > 0) {
                pattern = Pattern.compile(classFilter.toString());
            }
        }
        if (count <= 0 || count > results.size()) {
            count = results.size();
        }
        node.removeAllChildren();
        int numNodes = 0;
        int i = 0;
        while (i < results.size() && node.getChildCount() < count) {
            Matcher m;
            JvmObjectInfo obj = results.get(i);
            JvmClassInfo classInfo = obj.getClassInfo();
            if (!(filterClass != null ? filterClass != classInfo : pattern != null && !(m = pattern.matcher(classInfo.getName())).matches())) {
                node.add(new HeapObjectTreeNode(obj));
                ++numNodes;
            }
            ++i;
        }
        if (node == this.rootNode) {
            node.setUserObject("Heap Objects (" + numNodes + ")");
        }
        this.nodeStructureChanged(node);
    }

    @Override
    public boolean asksAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (!(node instanceof HeapObjectTreeNode)) {
            return super.isLeaf(node);
        }
        Object treeObj = ((HeapObjectTreeNode)node).getUserObject();
        if (treeObj instanceof JvmObjectInfo) {
            return ((JvmObjectInfo)treeObj).getRefereesCount() == 0;
        }
        return false;
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.nodeStructureChanged(this.rootNode);
    }
}

