/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.ui;

import com.nastel.heapdetective.client.AgentSnapshotResult;
import com.nastel.heapdetective.jvm.JvmClassInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;

public class HeapClassTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 6921526596834697114L;
    private static final int CLASS_NAME_COL = 0;
    private static final int INST_COUNT_COL = 1;
    private static final int TOTAL_SIZE_COL = 2;
    private static final int AVG_SIZE_COL = 3;
    protected JTable table;
    protected ArrayList<JvmClassInfo> classes;
    protected long totalInstanceCount;
    protected long totalHeapSize;

    public void setTable(JTable table) {
        this.table = table;
    }

    public void setResults(AgentSnapshotResult snapshot, Vector<JvmClassInfo> classes, Object classFilter) {
        if (snapshot == null) {
            this.clear();
        } else {
            this.totalInstanceCount = snapshot.getTotalInstanceCount();
            this.totalHeapSize = snapshot.getTotalHeapSize();
            if (classFilter == null || classFilter.toString().length() == 0) {
                this.classes = new ArrayList<JvmClassInfo>(classes);
            } else if (classFilter instanceof JvmClassInfo) {
                this.classes = new ArrayList(1);
                this.classes.add((JvmClassInfo)classFilter);
            } else {
                Pattern pattern = Pattern.compile(classFilter.toString());
                this.classes = new ArrayList();
                int i = 0;
                while (i < classes.size()) {
                    JvmClassInfo classInfo = classes.get(i);
                    Matcher m = pattern.matcher(classInfo.getName());
                    if (m.matches()) {
                        this.classes.add(classInfo);
                    }
                    ++i;
                }
            }
            this.fireTableStructureChanged();
            this.table.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(2, SortOrder.DESCENDING)));
        }
    }

    @Override
    public int getRowCount() {
        return this.classes == null ? 0 : this.classes.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "<html><b>Class</b></html>";
            }
            case 1: {
                return "<html><b>Instance Count</b></html>";
            }
            case 2: {
                return "<html><b>Total Size</b> (bytes)</html>";
            }
            case 3: {
                return "<html><b>Average Size</b> (bytes)</html>";
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? String.class : Long.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount() || columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            return "";
        }
        JvmClassInfo classInfo = this.getClassInfo(rowIndex);
        switch (columnIndex) {
            case 0: {
                return classInfo.getName();
            }
            case 1: {
                return classInfo.getTotalInstances();
            }
            case 2: {
                return classInfo.getTotalSize();
            }
            case 3: {
                return classInfo.getTotalInstances() <= 0 ? 0L : classInfo.getTotalSize() / (long)classInfo.getTotalInstances();
            }
        }
        return "";
    }

    public double getValuePercentage(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount() || columnIndex <= 0 || columnIndex >= this.getColumnCount()) {
            return -1.0;
        }
        JvmClassInfo classInfo = this.getClassInfo(rowIndex);
        if (columnIndex == 1 && this.totalInstanceCount > 0L) {
            return (double)classInfo.getTotalInstances() / (double)this.totalInstanceCount;
        }
        if (columnIndex == 2 && this.totalHeapSize > 0L) {
            return (double)classInfo.getTotalSize() / (double)this.totalHeapSize;
        }
        return -1.0;
    }

    public double getColumnWidthWeight(int columnIndex) {
        return columnIndex == 0 ? 0.55 : 0.15;
    }

    public JvmClassInfo getSelectedClass() {
        return this.getClassInfo(this.table.convertRowIndexToModel(this.table.getSelectedRow()));
    }

    public JvmClassInfo getClassInfo(int rowIndex) {
        return rowIndex < 0 || rowIndex >= this.getRowCount() ? null : this.classes.get(rowIndex);
    }

    public void clear() {
        this.classes = null;
        this.totalInstanceCount = 0L;
        this.totalHeapSize = 0L;
        this.fireTableStructureChanged();
    }
}

