/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.ui;

public class ClassHistoryInfo {
    protected long totalSize;
    protected int totalInstances;
    protected long sizeChange;
    protected int instChange;
    protected float sizePctChange;
    protected float instPctChange;

    public ClassHistoryInfo(long totalSize, int totalInstances) {
        this.totalSize = totalSize;
        this.totalInstances = totalInstances;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public int getTotalInstances() {
        return this.totalInstances;
    }

    public long getSizeChange() {
        return this.sizeChange;
    }

    public int getInstanceChange() {
        return this.instChange;
    }

    public float getSizePctChange() {
        return this.sizePctChange;
    }

    public float getInstancePctChange() {
        return this.instPctChange;
    }

    public void computeChanges(ClassHistoryInfo previous) {
        if (previous == null || previous.totalInstances == 0) {
            this.sizeChange = this.totalSize;
            this.instChange = this.totalInstances;
            this.sizePctChange = this.totalInstances == 0 ? 0.0f : Float.NaN;
            this.instPctChange = this.totalInstances == 0 ? 0.0f : Float.NaN;
        } else {
            this.sizeChange = this.totalSize - previous.totalSize;
            this.sizePctChange = (float)this.sizeChange / (float)previous.totalSize * 100.0f;
            this.instChange = this.totalInstances - previous.totalInstances;
            this.instPctChange = (float)this.instChange / (float)previous.totalInstances * 100.0f;
        }
    }

    public String toString() {
        return Long.toString(this.totalSize);
    }
}

