/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.ui;

import com.nastel.heapdetective.jvm.JvmArrayHeapObjectInfo;

public class ArrayElementRange {
    protected JvmArrayHeapObjectInfo arrayObj;
    protected int start;
    protected int end;

    public ArrayElementRange(JvmArrayHeapObjectInfo arrayRef, int start, int end) {
        this.arrayObj = arrayRef;
        this.start = start;
        this.end = end;
    }

    public JvmArrayHeapObjectInfo getArrayObj() {
        return this.arrayObj;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start + 1;
    }

    public int hashCode() {
        return this.start ^ this.end;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArrayElementRange) {
            ArrayElementRange other = (ArrayElementRange)obj;
            if (this.arrayObj == null && other.arrayObj != null) {
                return false;
            }
            if (this.arrayObj != null && other.arrayObj == null) {
                return false;
            }
            return this.start == other.start && this.end == other.end && (this.arrayObj == null || this.arrayObj.equals(other.arrayObj));
        }
        return false;
    }

    public String toString() {
        return String.format("[%d - %d]", this.start, this.end);
    }
}

