/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class AgentConnectionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 4286471590600895573L;
    private final JPanel contentPanel = new JPanel();
    private JTextField txtHost;
    private JTextField txtPort;
    private JCheckBox chckbxTakeSnapshot;
    private JButton okButton;
    private JButton cancelButton;
    private boolean okSelected;
    private String jvmHost;
    private int jvmAgentPort;
    private boolean takeSnapshot;

    public boolean showModal() {
        return this.okSelected;
    }

    public boolean isOkSelected() {
        return this.okSelected;
    }

    public String getJvmHost() {
        return this.jvmHost;
    }

    public int getJvmAgentPort() {
        return this.jvmAgentPort;
    }

    public boolean isTakeSnapshot() {
        return this.takeSnapshot;
    }

    public AgentConnectionDialog(JFrame parent) {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.setTitle("JVM Agent Connection");
        this.setBounds(100, 100, 300, 159);
        this.setIconImage(parent.getIconImage());
        this.setLocationRelativeTo(parent);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gbl_contentPanel = new GridBagLayout();
        int[] nArray = new int[3];
        nArray[0] = 48;
        nArray[1] = 86;
        gbl_contentPanel.columnWidths = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 20;
        gbl_contentPanel.rowHeights = nArray2;
        gbl_contentPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_contentPanel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gbl_contentPanel);
        JLabel lblJvmHost = new JLabel("JVM Host:");
        GridBagConstraints gbc_lblJvmHost = new GridBagConstraints();
        gbc_lblJvmHost.anchor = 17;
        gbc_lblJvmHost.insets = new Insets(0, 0, 5, 5);
        gbc_lblJvmHost.gridx = 0;
        gbc_lblJvmHost.gridy = 0;
        this.contentPanel.add((Component)lblJvmHost, gbc_lblJvmHost);
        this.txtHost = new JTextField();
        this.txtHost.setText("localhost");
        GridBagConstraints gbc_txtLocalhost = new GridBagConstraints();
        gbc_txtLocalhost.fill = 2;
        gbc_txtLocalhost.insets = new Insets(0, 0, 5, 0);
        gbc_txtLocalhost.anchor = 18;
        gbc_txtLocalhost.gridx = 1;
        gbc_txtLocalhost.gridy = 0;
        this.contentPanel.add((Component)this.txtHost, gbc_txtLocalhost);
        this.txtHost.setColumns(10);
        JLabel lblJvmAgentPort = new JLabel("JVM Agent Port:");
        GridBagConstraints gbc_lblJvmAgentPort = new GridBagConstraints();
        gbc_lblJvmAgentPort.anchor = 13;
        gbc_lblJvmAgentPort.insets = new Insets(0, 0, 5, 5);
        gbc_lblJvmAgentPort.gridx = 0;
        gbc_lblJvmAgentPort.gridy = 1;
        this.contentPanel.add((Component)lblJvmAgentPort, gbc_lblJvmAgentPort);
        this.txtPort = new JTextField();
        this.txtPort.setText("16400");
        GridBagConstraints gbc_textField = new GridBagConstraints();
        gbc_textField.anchor = 17;
        gbc_textField.insets = new Insets(0, 0, 5, 0);
        gbc_textField.fill = 2;
        gbc_textField.gridx = 1;
        gbc_textField.gridy = 1;
        this.contentPanel.add((Component)this.txtPort, gbc_textField);
        this.txtPort.setColumns(10);
        this.chckbxTakeSnapshot = new JCheckBox("Take Snapshot");
        GridBagConstraints gbc_chckbxTakeSnapshot = new GridBagConstraints();
        gbc_chckbxTakeSnapshot.anchor = 17;
        gbc_chckbxTakeSnapshot.gridx = 1;
        gbc_chckbxTakeSnapshot.gridy = 2;
        this.contentPanel.add((Component)this.chckbxTakeSnapshot, gbc_chckbxTakeSnapshot);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
        buttonPane.add(this.cancelButton);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        this.okSelected = false;
        if (source == this.okButton) {
            this.okSelected = true;
            this.jvmHost = this.txtHost.getText();
            this.takeSnapshot = this.chckbxTakeSnapshot.isSelected();
            try {
                this.jvmAgentPort = Integer.parseInt(this.txtPort.getText());
                this.setVisible(false);
            }
            catch (NumberFormatException e1) {
                JOptionPane.showMessageDialog(this, "Failed to parse port:" + e1, this.getTitle(), 0);
            }
        } else if (source == this.cancelButton) {
            this.setVisible(false);
        }
    }
}

