/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.jvm;

import com.nastel.heapdetective.jvm.JvmClassInfo;
import com.nastel.heapdetective.jvm.JvmHeapReferenceInfo;
import com.nastel.heapdetective.jvm.JvmObjectInfo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Stack;

public class JvmHeapObjectInfo
extends JvmObjectInfo {
    protected JvmClassInfo classInfo;
    protected long retainedSize = 0L;
    protected long totalSize = -1L;

    @Override
    public JvmClassInfo getClassInfo() {
        return this.classInfo;
    }

    public void setClassInfo(JvmClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public String getClassName() {
        return this.classInfo == null ? Long.toString(this.tag, 16) : this.classInfo.getName();
    }

    @Override
    public long getRetainedSize() {
        if (this.retainedSize == 0L) {
            try {
                if (this.classInfo.getName().startsWith("java.util.HashMap")) {
                    System.out.println("");
                }
                Stack<JvmHeapObjectInfo> objStack = new Stack<JvmHeapObjectInfo>();
                this.retainedSize = this.size;
                objStack.push(this);
                while (!objStack.isEmpty()) {
                    JvmHeapObjectInfo objInfo = (JvmHeapObjectInfo)objStack.pop();
                    ArrayList<JvmHeapReferenceInfo> refs = objInfo.getReferees();
                    boolean pushed = false;
                    if (refs == null) continue;
                    for (JvmHeapReferenceInfo ref : refs) {
                        JvmObjectInfo refObj = ref.getReferee();
                        if (!(refObj instanceof JvmHeapObjectInfo) || refObj.getReferrersCount() != 1) continue;
                        JvmHeapObjectInfo refHeapObj = (JvmHeapObjectInfo)refObj;
                        if (refHeapObj.retainedSize > 0L) {
                            objInfo.retainedSize += refHeapObj.retainedSize;
                            continue;
                        }
                        if (!pushed) {
                            objStack.push(objInfo);
                        }
                        refHeapObj.retainedSize = refHeapObj.size;
                        objStack.push(refHeapObj);
                        pushed = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.retainedSize;
    }

    public void setRetainedSize(long retainedSize) {
        this.retainedSize = retainedSize;
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    @Override
    public String toString() {
        if (this.classInfo == null) {
            return Long.toString(this.tag, 16);
        }
        return String.valueOf(this.classInfo.getName()) + " (" + Long.toString(this.tag, 16) + ")";
    }

    @Override
    public void printHierarchy(PrintWriter output, int level) {
        output.format("%" + level + "s%s: tag=%s, size=%s, retainsize=%s, totalsize=%s", " ", this.getClass().getName(), Long.toHexString(this.tag), Long.toString(this.size), Long.toString(this.retainedSize), Long.toString(this.totalSize));
    }
}

