/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.jvm;

import com.nastel.heapdetective.jvm.JvmFieldInfo;
import com.nastel.heapdetective.jvm.JvmHeapObjectInfo;
import com.nastel.heapdetective.jvm.JvmInfoComparator;
import com.nastel.heapdetective.jvm.JvmMethodInfo;
import com.nastel.heapdetective.jvm.JvmObjectInfo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.SortOrder;

public class JvmClassInfo
extends JvmObjectInfo {
    protected String name;
    protected long superClassTag;
    protected JvmClassInfo superClass;
    protected HashMap<Long, JvmMethodInfo> methods;
    protected JvmFieldInfo[] fields;
    protected long totalSize;
    protected int totalInstances;
    protected ArrayList<JvmHeapObjectInfo> heapObjects;

    @Override
    public JvmClassInfo getClassInfo() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getSuperClassTag() {
        return this.superClassTag;
    }

    public void setSuperClassTag(long superClassTag) {
        this.superClassTag = superClassTag;
    }

    public JvmClassInfo getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(JvmClassInfo superClass) {
        this.superClass = superClass;
    }

    public JvmMethodInfo getMethod(long mthdTag) {
        return this.methods == null ? null : this.methods.get(mthdTag);
    }

    public void addMethod(JvmMethodInfo mthd) {
        if (this.methods == null) {
            this.methods = new HashMap();
        }
        if (mthd.getTag() != 0L) {
            this.methods.put(mthd.getTag(), mthd);
        }
    }

    public void setFieldCount(int numFields) {
        this.fields = new JvmFieldInfo[numFields];
    }

    public void addField(JvmFieldInfo field) {
        if (this.fields != null && field.getIndex() >= 0 && field.getIndex() < this.fields.length) {
            this.fields[field.getIndex()] = field;
        }
    }

    public JvmFieldInfo getField(int index) {
        return this.fields == null || index < 0 || index >= this.fields.length ? null : this.fields[index];
    }

    public String getFieldName(int index) {
        JvmFieldInfo fieldInfo = this.getField(index);
        return fieldInfo == null ? "" : fieldInfo.getName();
    }

    public int getTotalInstances() {
        return this.totalInstances;
    }

    public void setTotalInstances(int totalInstances) {
        this.totalInstances = totalInstances;
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public void addInstance(JvmHeapObjectInfo heapObj) {
        if (this.heapObjects == null) {
            this.heapObjects = new ArrayList(this.totalInstances);
        }
        this.heapObjects.add(heapObj);
    }

    public void clear() {
        this.methods = null;
        this.fields = null;
        this.heapObjects = null;
    }

    @Override
    public long getRetainedSize() {
        return this.getSize();
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public void printHierarchy(PrintWriter output, int level) {
        output.format("%" + level + "s%s: name=%s, super=%s, tag=%s, size=%s, len=%s", " ", this.getClass().getName(), this.name, this.superClass, Long.toHexString(this.tag), Long.toHexString(this.size));
        JvmFieldInfo[] jvmFieldInfoArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            JvmFieldInfo field = jvmFieldInfoArray[n2];
            field.printHierarchy(output, level + 1);
            ++n2;
        }
        Collection<JvmMethodInfo> mthds = this.methods.values();
        for (JvmMethodInfo mthd : mthds) {
            mthd.printHierarchy(output, level + 1);
        }
    }

    public static void sortByClassName(Vector<JvmClassInfo> classes, SortOrder order) {
        Collections.sort(classes, new NameComparator(order));
    }

    public static void sortByInstanceCount(Vector<JvmClassInfo> classes, SortOrder order) {
        Collections.sort(classes, new InstanceCountComparator(order));
    }

    public static void sortByTotalSize(Vector<JvmClassInfo> classes, SortOrder order) {
        Collections.sort(classes, new TotalSizeComparator(order));
    }

    public static void sortBySize(Vector<JvmClassInfo> classes, SortOrder order) {
        Collections.sort(classes, new JvmObjectInfo.SizeComparator(order));
    }

    public static class InstanceCountComparator
    extends JvmInfoComparator {
        public InstanceCountComparator(SortOrder order) {
            super(order);
        }

        @Override
        public int compare(JvmObjectInfo o1, JvmObjectInfo o2) {
            return InstanceCountComparator.compareValues(this.order, ((JvmClassInfo)o1).getTotalInstances(), ((JvmClassInfo)o2).getTotalInstances());
        }
    }

    public static class NameComparator
    extends JvmInfoComparator {
        public NameComparator(SortOrder order) {
            super(order);
        }

        @Override
        public int compare(JvmObjectInfo o1, JvmObjectInfo o2) {
            return JvmInfoComparator.compareStrings(this.order, ((JvmClassInfo)o1).getName(), ((JvmClassInfo)o2).getName());
        }
    }

    public static class TotalSizeComparator
    extends JvmInfoComparator {
        public TotalSizeComparator(SortOrder order) {
            super(order);
        }

        @Override
        public int compare(JvmObjectInfo o1, JvmObjectInfo o2) {
            return TotalSizeComparator.compareValues(this.order, ((JvmClassInfo)o1).getTotalSize(), ((JvmClassInfo)o2).getTotalSize());
        }
    }
}

