/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.jvm;

import com.nastel.heapdetective.jvm.JvmArrayElmtHeapRefInfo;
import com.nastel.heapdetective.jvm.JvmHeapObjectInfo;
import com.nastel.heapdetective.jvm.JvmHeapReferenceInfo;
import java.io.PrintWriter;
import java.util.HashMap;

public class JvmArrayHeapObjectInfo
extends JvmHeapObjectInfo {
    protected int length;
    protected int minFilledIndex;
    protected int maxFilledIndex;
    protected HashMap<Integer, JvmHeapReferenceInfo> arrayElmtMap;

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getMinFilledIndex() {
        return this.minFilledIndex;
    }

    public int getMaxFilledIndex() {
        return this.maxFilledIndex;
    }

    public void buildElementMap() {
        if (this.referees == null) {
            return;
        }
        if (this.arrayElmtMap == null) {
            this.arrayElmtMap = new HashMap(this.referees.size());
        }
        this.minFilledIndex = this.length;
        this.maxFilledIndex = 0;
        for (JvmHeapReferenceInfo elmtRef : this.referees) {
            if (!(elmtRef instanceof JvmArrayElmtHeapRefInfo)) continue;
            int index = ((JvmArrayElmtHeapRefInfo)elmtRef).getIndex();
            this.minFilledIndex = Math.min(this.minFilledIndex, index);
            this.maxFilledIndex = Math.max(this.maxFilledIndex, index);
            this.arrayElmtMap.put(index, elmtRef);
        }
    }

    public JvmHeapReferenceInfo getElement(int index) {
        return this.arrayElmtMap == null ? null : this.arrayElmtMap.get(index);
    }

    @Override
    public void printHierarchy(PrintWriter output, int level) {
        super.printHierarchy(output, level);
        output.format(", len=%s", Integer.toString(this.length));
    }
}

