/*
 * Decompiled with CFR 0.152.
 */
package com.nastel.heapdetective.client.xml;

import com.nastel.heapdetective.client.AgentCommandType;
import com.nastel.heapdetective.client.AgentResponse;
import com.nastel.heapdetective.client.AgentResult;
import com.nastel.heapdetective.client.AgentRuntimeResult;
import com.nastel.heapdetective.client.AgentSnapshotResult;
import com.nastel.heapdetective.client.AgentSystemPropsResult;
import com.nastel.heapdetective.client.ResponseTagMismatchException;
import com.nastel.heapdetective.jvm.JvmArrayElmtHeapRefInfo;
import com.nastel.heapdetective.jvm.JvmArrayHeapObjectInfo;
import com.nastel.heapdetective.jvm.JvmClassInfo;
import com.nastel.heapdetective.jvm.JvmFieldHeapRefInfo;
import com.nastel.heapdetective.jvm.JvmFieldInfo;
import com.nastel.heapdetective.jvm.JvmHeapObjectInfo;
import com.nastel.heapdetective.jvm.JvmHeapReferenceInfo;
import com.nastel.heapdetective.jvm.JvmHeapReferenceKind;
import com.nastel.heapdetective.jvm.JvmIndexHeapRefInfo;
import com.nastel.heapdetective.jvm.JvmLocalHeapRefInfo;
import com.nastel.heapdetective.jvm.JvmMethodInfo;
import com.nastel.heapdetective.jvm.JvmMethodLocalVarInfo;
import com.nastel.heapdetective.jvm.JvmObjectInfo;
import com.nastel.heapdetective.jvm.JvmThreadInfo;
import com.nastel.heapdetective.ui.AgentProgressMonitor;
import java.util.concurrent.CancellationException;
import javax.swing.JOptionPane;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AgentResponseParserHandler
extends DefaultHandler {
    protected JvmClassInfo curClassInfo = null;
    protected JvmMethodInfo curMthdInfo = null;
    protected AgentResult curResult = null;
    protected AgentRuntimeResult runtimeRes = null;
    protected AgentResponse response = null;
    protected AgentProgressMonitor progressMon = null;
    protected long numHeapRefs;
    protected int skipObjsRefs;
    protected int totalHeapObjs;
    protected int totalHeapRefs;
    protected long cmdTag;
    protected String[] processChoices = new String[]{"Yes, Do Full Analysis", "Yes, But Just Summarize Usage", "No, Cancel Snapshot"};

    public void setResponse(AgentResponse response) {
        this.response = response;
    }

    public void setProgressMonitor(AgentProgressMonitor progressMon) {
        this.progressMon = progressMon;
    }

    public void setCmdTag(long cmdTag) {
        this.cmdTag = cmdTag;
    }

    public void reset() {
        this.skipObjsRefs = -1;
        this.totalHeapObjs = 0;
        this.totalHeapRefs = 0;
        this.cmdTag = 0L;
    }

    @Override
    public void startDocument() throws SAXException {
        this.curResult = null;
        this.runtimeRes = null;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.progressMon != null && this.progressMon.isUserCancelled()) {
            throw new SAXException(new CancellationException("Request cancelled by User."));
        }
        if (qName.equals("ref")) {
            this.processHeapRefElement(attributes);
        } else if (qName.equals("obj")) {
            if (this.skipObjsRefs <= 0) {
                this.processHeapObjectElement(attributes);
            }
        } else if (qName.equals("arrayobj")) {
            if (this.skipObjsRefs <= 0) {
                this.processArrayObjectElement(attributes);
            }
        } else if (qName.equals("class")) {
            this.processClassElement(attributes);
        } else if (qName.equals("field")) {
            this.processFieldElement(attributes);
        } else if (qName.equals("mthd")) {
            this.processMethodElement(attributes);
        } else if (qName.equals("lvar")) {
            this.processMethodVarElement(attributes);
        } else if (qName.equals("thread")) {
            this.processThreadElement(attributes);
        } else if (qName.equals("prop")) {
            this.processPropertyElement(attributes);
        } else if (qName.equals("cmd")) {
            this.processCommandElement(attributes);
        } else if (qName.equals("status")) {
            if (this.curResult == null) {
                this.response.setStatus(Integer.parseInt(attributes.getValue("value")));
            } else {
                this.curResult.setStatus(Integer.parseInt(attributes.getValue("value")));
            }
        } else if (qName.equals("last")) {
            this.response.setLast(Integer.parseInt(attributes.getValue("value")) != 0);
        } else if (qName.equals("error")) {
            if (this.curResult == null) {
                this.response.setErrorMsg(attributes.getValue("msg"));
            } else {
                this.curResult.setErrorMsg(attributes.getValue("msg"));
            }
        } else if (qName.equals("aphd-resp")) {
            long curCmdTag = Long.parseLong(attributes.getValue("tag"));
            if (this.cmdTag != 0L && curCmdTag != 0L && curCmdTag != this.cmdTag) {
                throw new ResponseTagMismatchException("Expected tag '" + this.cmdTag + "', received tag '" + curCmdTag + "'");
            }
            if (this.progressMon != null) {
                this.progressMon.updateProgress(0, this.numHeapRefs == 0L ? "Processing Results" : "Processing Heap References...");
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("class")) {
            this.curMthdInfo = null;
            this.curClassInfo = null;
        } else if (qName.equals("mthd")) {
            this.curMthdInfo = null;
        }
    }

    protected void processCommandElement(Attributes attributes) {
        String cmd = attributes.getValue("name");
        AgentCommandType command = null;
        try {
            command = AgentCommandType.valueOf(cmd);
        }
        catch (Exception e) {
            this.curResult = null;
            return;
        }
        if (command == AgentCommandType.SNAPSHOT) {
            this.curResult = this.response.getResult(command);
            if (this.curResult == null) {
                this.curResult = new AgentSnapshotResult();
                if (this.runtimeRes != null) {
                    ((AgentSnapshotResult)this.curResult).setClassCount(this.runtimeRes.getTotalClasses());
                    ((AgentSnapshotResult)this.curResult).setThreadCount(this.runtimeRes.getTotalThreads());
                }
                this.response.addResult(this.curResult);
            }
        } else {
            switch (command) {
                case RUNTIME: {
                    this.runtimeRes = new AgentRuntimeResult();
                    this.curResult = this.runtimeRes;
                    break;
                }
                case SYSTEM_PROPS: {
                    this.curResult = new AgentSystemPropsResult();
                    break;
                }
                default: {
                    this.curResult = new AgentResult(command);
                }
            }
            this.response.setResult(this.curResult);
        }
    }

    protected void processPropertyElement(Attributes attributes) throws SAXException {
        String propName = attributes.getValue("name");
        String propValue = attributes.getValue("value");
        if (this.curResult.getCommand() == AgentCommandType.SNAPSHOT) {
            AgentSnapshotResult res = (AgentSnapshotResult)this.curResult;
            if (propName.equals("ss-time")) {
                res.setLastJvmUpdate(Long.parseLong(propValue));
            } else if (propName.equals("total-roots")) {
                res.setHeapRootCount(Integer.parseInt(propValue));
            } else if (propName.equals("total-objs")) {
                this.totalHeapObjs = Integer.parseInt(propValue);
            } else if (propName.equals("total-refs")) {
                this.totalHeapRefs = Integer.parseInt(propValue);
                res.setTotalHeapRefs(this.totalHeapRefs);
            } else {
                res.addMetric(propName, propValue);
            }
            if (this.totalHeapObjs > 0 && this.totalHeapRefs > 0 && this.skipObjsRefs < 0) {
                int estMinSize = (int)((long)(this.totalHeapObjs + this.totalHeapRefs) * 128L / 0x100000L);
                int estMaxSize = (int)((long)(this.totalHeapObjs + this.totalHeapRefs) * 256L / 0x100000L);
                int maxHeapSize = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
                if (estMaxSize < maxHeapSize || this.progressMon == null) {
                    this.skipObjsRefs = 0;
                } else {
                    String message = String.format("Based on size of snapshot, the estimated amount of heap required by\nUI is between %d and %d MB.  Maximum available heap size is %d MB.\nIt is recommended that UI be restarted with a larger heap size.\n\nShould Heap Detective continue processing the current snapshot?\n", estMinSize, estMaxSize, maxHeapSize);
                    this.skipObjsRefs = JOptionPane.showOptionDialog(this.progressMon.getParent(), message, "AutoPilot\u00ae Heap Detective\u2122", 1, 3, null, this.processChoices, this.processChoices[1]);
                    if (this.skipObjsRefs == 2) {
                        throw new SAXException(new CancellationException("Request cancelled by User"));
                    }
                }
                if (this.skipObjsRefs == 0) {
                    res.setHeapObjectCount(this.totalHeapObjs);
                }
            }
        } else if (this.curResult.getCommand() == AgentCommandType.RUNTIME) {
            AgentRuntimeResult res = (AgentRuntimeResult)this.curResult;
            if (propName.equals("rt-time")) {
                res.setLastUpdate(Long.parseLong(propValue));
            } else if (propName.equals("cpus")) {
                res.setAvailableProcessors(Integer.parseInt(propValue));
            } else if (propName.equals("total-heap")) {
                res.setTotalHeapSize(Long.parseLong(propValue));
            } else if (propName.equals("max-heap")) {
                res.setMaxHeapSize(Long.parseLong(propValue));
            } else if (propName.equals("free-heap")) {
                res.setFreeHeapSize(Long.parseLong(propValue));
            } else if (propName.equals("total-classes")) {
                res.setTotalClasses(Integer.parseInt(propValue));
            } else if (propName.equals("total-threads")) {
                res.setTotalThreads(Integer.parseInt(propValue));
            }
        } else if (this.curResult.getCommand() == AgentCommandType.SYSTEM_PROPS) {
            AgentSystemPropsResult res = (AgentSystemPropsResult)this.curResult;
            res.add(propName, propValue);
        }
    }

    protected void processClassElement(Attributes attributes) {
        AgentSnapshotResult res = (AgentSnapshotResult)this.curResult;
        if (this.progressMon != null) {
            int progress = 0;
            int curItems = 0;
            if (this.runtimeRes != null) {
                curItems = res.getClassCount() + res.getThreadCount();
                int totalItems = this.runtimeRes.getTotalClasses() + this.runtimeRes.getTotalThreads();
                progress = (int)((double)curItems / (double)totalItems * 100.0);
            }
            this.progressMon.updateProgress(progress, curItems == 0 ? "Processing Classes..." : null);
        }
        JvmClassInfo classInfo = new JvmClassInfo();
        int i = 0;
        while (i < attributes.getLength()) {
            String attName = attributes.getQName(i);
            String attValue = attributes.getValue(i);
            if (attName.equals("clstag")) {
                classInfo.setTag(Long.parseLong(attValue, 16));
            } else if (attName.equals("name")) {
                classInfo.setName(attValue);
            } else if (attName.equals("sprclstag")) {
                classInfo.setSuperClassTag(Long.parseLong(attValue, 16));
            } else if (attName.equals("totalinst")) {
                classInfo.setTotalInstances(Integer.parseInt(attValue));
            } else if (attName.equals("totalsize")) {
                classInfo.setTotalSize(Long.parseLong(attValue));
            } else if (attName.equals("fields")) {
                classInfo.setFieldCount(Integer.parseInt(attValue));
            }
            ++i;
        }
        res.addClass(classInfo);
        this.curClassInfo = classInfo;
        this.numHeapRefs = 0L;
    }

    protected void processFieldElement(Attributes attributes) {
        JvmFieldInfo fieldInfo = new JvmFieldInfo();
        int i = 0;
        while (i < attributes.getLength()) {
            String attName = attributes.getQName(i);
            String attValue = attributes.getValue(i);
            if (attName.equals("defclass")) {
                fieldInfo.setDefiningClass(attValue);
            } else if (attName.equals("fldtag")) {
                fieldInfo.setTag(Long.parseLong(attValue, 16));
            } else if (attName.equals("name")) {
                fieldInfo.setName(attValue);
            } else if (attName.equals("index")) {
                fieldInfo.setIndex(Integer.parseInt(attValue));
            }
            ++i;
        }
        this.curClassInfo.addField(fieldInfo);
    }

    protected void processMethodElement(Attributes attributes) {
        JvmMethodInfo mthdInfo = new JvmMethodInfo();
        int i = 0;
        while (i < attributes.getLength()) {
            String attName = attributes.getQName(i);
            String attValue = attributes.getValue(i);
            if (attName.equals("mthdtag")) {
                mthdInfo.setTag(Long.parseLong(attValue, 16));
            } else if (attName.equals("name")) {
                mthdInfo.setName(attValue);
            } else if (attName.equals("sig")) {
                mthdInfo.setSignature(attValue);
            } else if (attName.equals("lvars")) {
                mthdInfo.setLocalVarCount(Integer.parseInt(attValue));
            }
            ++i;
        }
        this.curClassInfo.addMethod(mthdInfo);
        this.curMthdInfo = mthdInfo;
    }

    protected void processMethodVarElement(Attributes attributes) {
        JvmMethodLocalVarInfo varInfo = new JvmMethodLocalVarInfo();
        int i = 0;
        while (i < attributes.getLength()) {
            String attName = attributes.getQName(i);
            String attValue = attributes.getValue(i);
            if (attName.equals("name")) {
                varInfo.setName(attValue);
            } else if (attName.equals("sig")) {
                varInfo.setSignature(attValue);
            } else if (attName.equals("slot")) {
                varInfo.setSlot(Integer.parseInt(attValue));
            }
            ++i;
        }
        this.curMthdInfo.addLocalVar(varInfo);
    }

    protected void processThreadElement(Attributes attributes) {
        AgentSnapshotResult res = (AgentSnapshotResult)this.curResult;
        if (this.progressMon != null) {
            int progress = 0;
            if (this.runtimeRes != null) {
                int curItems = res.getClassCount() + res.getThreadCount();
                int totalItems = this.runtimeRes.getTotalClasses() + this.runtimeRes.getTotalThreads();
                progress = (int)((double)curItems / (double)totalItems * 100.0);
            }
            this.progressMon.updateProgress(progress, "Processing Classes...");
        }
        JvmThreadInfo threadInfo = new JvmThreadInfo();
        int i = 0;
        while (i < attributes.getLength()) {
            String attName = attributes.getQName(i);
            String attValue = attributes.getValue(i);
            if (attName.equals("thrdtag")) {
                threadInfo.setTag(Long.parseLong(attValue, 16));
            } else if (attName.equals("name")) {
                threadInfo.setName(attValue);
            } else if (attName.equals("state")) {
                threadInfo.setState(Integer.parseInt(attValue));
            }
            ++i;
        }
        res.addThread(threadInfo);
    }

    protected void processHeapRefElement(Attributes attributes) {
        AgentSnapshotResult res = (AgentSnapshotResult)this.curResult;
        if (this.progressMon != null && res.getTotalHeapRefs() > 0) {
            int progress = (int)((double)this.numHeapRefs / (double)res.getTotalHeapRefs() * 100.0);
            this.progressMon.updateProgress(progress, this.numHeapRefs == 0L ? "Processing Heap References..." : null);
        }
        JvmHeapReferenceKind refKind = JvmHeapReferenceKind.valueOf(Integer.parseInt(attributes.getValue(0)));
        JvmHeapReferenceInfo heapRef = null;
        JvmIndexHeapRefInfo indexRef = null;
        JvmLocalHeapRefInfo localRef = null;
        JvmObjectInfo refereeObj = null;
        JvmObjectInfo referrerObj = null;
        JvmThreadInfo threadInfo = null;
        long classTag = 0L;
        long threadId = 0L;
        long size = -1L;
        boolean heapRoot = false;
        switch (refKind) {
            case FIELD: 
            case STATIC_FIELD: {
                indexRef = new JvmFieldHeapRefInfo(refKind);
                heapRef = indexRef;
                break;
            }
            case ARRAY_ELEMENT: {
                indexRef = new JvmArrayElmtHeapRefInfo();
                heapRef = indexRef;
                break;
            }
            case STACK_LOCAL: 
            case JNI_LOCAL: {
                localRef = new JvmLocalHeapRefInfo(refKind);
                heapRef = localRef;
                break;
            }
            default: {
                heapRef = new JvmHeapReferenceInfo(refKind);
            }
        }
        int i = 1;
        while (i < attributes.getLength()) {
            long tag;
            String attName = attributes.getQName(i);
            String attValue = attributes.getValue(i);
            if (attName.equals("tag")) {
                tag = Long.parseLong(attValue, 16);
                refereeObj = res.getObject(tag);
                if (refereeObj != null) {
                    heapRef.setReferee(refereeObj);
                }
            } else if (attName.equals("reftag")) {
                tag = Long.parseLong(attValue, 16);
                referrerObj = res.getObject(tag);
                if (referrerObj != null) {
                    heapRef.setReferrer(referrerObj);
                }
            } else if (attName.equals("clstag")) {
                classTag = Long.parseLong(attValue, 16);
            } else if (attName.equals("size")) {
                size = Long.parseLong(attValue);
            } else if (attName.equals("index")) {
                indexRef.setIndex(Integer.parseInt(attValue));
            } else if (attName.equals("thrdtag")) {
                threadInfo = res.getThread(Long.parseLong(attValue, 16));
                if (threadInfo != null) {
                    localRef.setThreadInfo(threadInfo);
                }
            } else if (attName.equals("tid")) {
                threadId = Long.parseLong(attValue);
            } else if (attName.equals("depth")) {
                localRef.setDepth(Integer.parseInt(attValue));
            } else if (attName.equals("mthdtag")) {
                localRef.setMethod(Long.parseLong(attValue, 16));
            } else if (attName.equals("slot")) {
                localRef.setSlot(Integer.parseInt(attValue));
            } else if (attName.equals("heaproot")) {
                heapRoot = Integer.parseInt(attValue) != 0;
            }
            ++i;
        }
        if (refereeObj instanceof JvmClassInfo && size > 0L) {
            refereeObj.setSize(size);
        }
        if (refKind == JvmHeapReferenceKind.THREAD && refereeObj instanceof JvmThreadInfo) {
            JvmThreadInfo thrdInfo = (JvmThreadInfo)refereeObj;
            thrdInfo.setClassInfo(res.getClassInfo(classTag));
            thrdInfo.setSize(size);
        }
        if (localRef != null && threadInfo != null && threadId != 0L) {
            threadInfo.setJvmId(threadId);
        }
        if (this.skipObjsRefs <= 0) {
            if (referrerObj != null) {
                referrerObj.addReferee(heapRef);
            }
            if (refereeObj != null) {
                refereeObj.addReferrer(heapRef);
                if (heapRoot) {
                    res.addHeapRoot(refereeObj);
                }
            }
        }
        ++this.numHeapRefs;
    }

    protected void processHeapObjectElement(Attributes attributes) {
        AgentSnapshotResult res = (AgentSnapshotResult)this.curResult;
        JvmHeapObjectInfo heapObj = new JvmHeapObjectInfo();
        int i = 0;
        while (i < attributes.getLength()) {
            String attName = attributes.getQName(i);
            String attValue = attributes.getValue(i);
            if (attName.equals("clstag")) {
                heapObj.setClassInfo(res.getClassInfo(Long.parseLong(attValue, 16)));
            } else if (attName.equals("tag")) {
                heapObj.setTag(Long.parseLong(attValue, 16));
            } else if (attName.equals("size")) {
                heapObj.setSize(Long.parseLong(attValue, 16));
            }
            ++i;
        }
        res.addHeapObject(heapObj);
        if (heapObj.getClassInfo() != null) {
            heapObj.getClassInfo().addInstance(heapObj);
        }
    }

    protected void processArrayObjectElement(Attributes attributes) {
        AgentSnapshotResult res = (AgentSnapshotResult)this.curResult;
        JvmArrayHeapObjectInfo heapObj = new JvmArrayHeapObjectInfo();
        int i = 0;
        while (i < attributes.getLength()) {
            String attName = attributes.getQName(i);
            String attValue = attributes.getValue(i);
            if (attName.equals("clstag")) {
                heapObj.setClassInfo(res.getClassInfo(Long.parseLong(attValue, 16)));
            } else if (attName.equals("tag")) {
                heapObj.setTag(Long.parseLong(attValue, 16));
            } else if (attName.equals("size")) {
                heapObj.setSize(Long.parseLong(attValue, 16));
            } else if (attName.equals("len")) {
                heapObj.setLength(Integer.parseInt(attValue));
            }
            ++i;
        }
        res.addHeapObject(heapObj);
        if (heapObj.getClassInfo() != null) {
            heapObj.getClassInfo().addInstance(heapObj);
        }
    }
}

