<?php
/*
Plugin Name: WP Ad Slinger
Plugin URI: http://wpadslinger.com
Description: WP Ad Slinger
Version: 1.2
Author: Jay Venka
Author URI:  http://jayvenka.com
License: Copyright 2013, All rights reserved
*/
error_reporting(E_ALL ^ (E_NOTICE | E_WARNING));
require_once 'code/autoupdate.php';
$MyUpdateChecker = new PluginUpdateChecker('http://manfredekblad.net/products/wpadslinger/autoupdate.php', __FILE__, 'wpadslinger');
if(!class_exists('WP_AdSlinger'))
{
	class WP_AdSlinger
	{
		public function __construct()
		{
			register_activation_hook(__FILE__, array($this, 'run_fbads_activate'));
			add_action('admin_menu', array($this, 'fbads_addmenu'));
			add_action('admin_enqueue_scripts', array($this, 'fbads_admin_script'));
			add_action('wp_enqueue_scripts', array($this, 'fbads_wp_script'));
			add_action('admin_head', array($this, 'fbads_admin_head'));
			add_action('admin_init', array($this, 'fbads_output_buffer'));
			
			require_once("widgets/widget-fbads.php");
			add_action( 'widgets_init', array($this, 'fbads_register_widget'));

			add_action('wp_ajax_fbads_send_clickdata', array($this, 'fbads_send_clickdata_ajax'));
			add_action('wp_ajax_nopriv_fbads_send_clickdata', array($this, 'fbads_send_clickdata_ajax'));

			add_action('wp_ajax_fbads_change_status', array($this, 'fbads_change_status_ajax'));
			add_action('wp_ajax_nopriv_fbads_change_status', array($this, 'fbads_change_status_ajax'));

			add_action('wp_ajax_fbads_reset_stats', array($this, 'fbads_reset_stats_ajax'));
			add_action('wp_ajax_nopriv_fbads_reset_stats', array($this, 'fbads_reset_stats_ajax'));

			add_action('wp_ajax_fbads_getads', array($this, 'fbads_getads'));
			add_action('wp_ajax_nopriv_fbads_getads', array($this, 'fbads_getads'));

			add_action('wp_ajax_fbads_impression', array($this, 'fbads_impression'));
			add_action('wp_ajax_nopriv_fbads_impression', array($this, 'fbads_impression'));
		}

		public function fbads_output_buffer()
		{
			ob_start();
		}

		public function fbads_register_widget()
		{
			register_widget('fbads_widget');
		}

		public function fbads_admin_head()
		{
			$page = isset( $_GET['page'] ) ? $_GET['page'] : "";
			if($page == "fbads")
			{
				$upload_dir = wp_upload_dir();
				$upload_loc	= $upload_dir['baseurl']."/wpadslinger/";
			?>
			<script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery('#FBAdsUploadImages').uberuploadcropper({
						
						fineuploader: {
							multiple 	: false,
							debug 		: true,
							request		: {
								endpoint: '<?php echo plugins_url("code/upload.php", __FILE__); ?>' 
							},						
							validation	: {
								allowedExtensions: ['jpg','jpeg','png','gif']
							}
						},
						
						jcrop: {
							aspectRatio  : 1.39, 
							allowSelect  : false,
							allowResize  : true,
							setSelect    : [ 0, 0, 100, 72 ],
							minSize      : [ 0, 0 ],
							maxSize      : [ 0, 0 ]
						},
						
						folder           : '<?php echo $upload_loc; ?>',
						cropAction       : '<?php echo plugins_url("code/crop.php", __FILE__); ?>',
						onComplete       : function(e,imgs,data){

							var $PhotoPrevs = jQuery('#upload_image');
							for(var i=0,l=imgs.length; i<l; i++){
								$PhotoPrevs.val('<?php echo $upload_loc; ?>'+imgs[i].filename);
								jQuery("#fbads_preview_image_2").attr("src",'<?php echo $upload_loc; ?>'+imgs[i].filename);
							}
						}
					});

					jQuery('.fbads_status').click(function(){

						var abc 		= jQuery(this);
						var oldvalue	= jQuery('#status_'+jQuery(this).attr('data'));

						data = {
							action 		: 'fbads_change_status',
							fbads_nonce : jQuery(this).attr('nonce'),
							value 		: jQuery(this).attr('value'),
							adsid 		: jQuery(this).attr('data')
						};

						jQuery.post('<?php echo admin_url('admin-ajax.php'); ?>', data, function (response)
						{
							n_res = response.replace(0,'');
							oldvalue.html(n_res);
							if(n_res == 'Inactive')
							{
								abc.text('Activate');
								abc.attr('value', n_res);
							}
							else
							{
								abc.text('Deactivate');
								abc.attr('value', n_res);
							}
						});
						return false;
					});

					jQuery('.fbads_reset_stats').click(function(event){
						
						event.preventDefault();

						var conf 	= confirm('Are you sure?');
						var t 		= jQuery(this);
						var adsid 	= t.attr('data');

						if(conf)
						{
							datareset = {action : 'fbads_reset_stats', fbads_nonce : t.attr('nonce'), adsid : adsid};

							jQuery.post('<?php echo admin_url('admin-ajax.php'); ?>', datareset, function (response)
							{
								if(response == 'ok')
								{
									jQuery('#impressions_'+adsid).text(0);
									jQuery('#clicks_'+adsid).text(0);
									jQuery('#ctr_'+adsid).text(0);
								}
							});
						}
					});
				});
			</script>
			<?php
			}
		}

		public function fbads_admin_script()
		{
			wp_enqueue_style('fbads', plugins_url('css/fbads.css', __FILE__), false, 'screen');

			wp_enqueue_script('jquery');
			wp_enqueue_script('media-upload');
			wp_enqueue_script('thickbox');
			/*wp_enqueue_script('jquery-1.9.1', plugins_url('js/jquery-1.9.1.js', __FILE__), array('jquery'));*/
			
			wp_enqueue_script('fbads_preview', plugins_url('js/fbads_preview.js', __FILE__));
			wp_enqueue_script('jquery.colorbox-min', plugins_url('js/jquery.colorbox-min.js', __FILE__));

			wp_enqueue_script('jquery.cookie', plugins_url('js/jquery.cookie.js', __FILE__));
			
			wp_enqueue_style('thickbox');
			
			$page = isset( $_GET['page'] ) ? $_GET['page'] : "";
			if($page == "fbads")
			{
				wp_enqueue_script('fbads_mediaupload', plugins_url('js/fbads_mediaupload.js', __FILE__));
				wp_enqueue_style('jquery-impromptu', plugins_url('js/jQuery-Impromptu/jquery-impromptu.css', __FILE__), false, 'screen');
				wp_enqueue_style('fineuploader', plugins_url('js/fineuploader/fineuploader.css', __FILE__), false, 'screen');
				wp_enqueue_style('jquery.Jcrop.min', plugins_url('js/Jcrop/jquery.Jcrop.min.css', __FILE__), false, 'screen');

				wp_enqueue_script('jquery-impromptu', plugins_url('js/jQuery-Impromptu/jquery-impromptu.js', __FILE__), array('jquery'));
				wp_enqueue_script('jquery.fineuploader-3.0.min', plugins_url('js/fineuploader/jquery.fineuploader-3.0.min.js', __FILE__), array('jquery'));
				wp_enqueue_script('jquery.Jcrop.min', plugins_url('js/Jcrop/jquery.Jcrop.min.js', __FILE__), array('jquery'));
				wp_enqueue_script('jquery-uberuploadcropper', plugins_url('js/jquery-uberuploadcropper.js', __FILE__), array('jquery'));
			}
		}

		public function fbads_wp_script()
		{
			wp_enqueue_style('fbads', plugins_url('css/fbads.css', __FILE__), false, 'screen');
			wp_enqueue_script('jquery');
			wp_enqueue_script('fbads_count', plugins_url('js/fbads_count.js', __FILE__));

			wp_localize_script('fbads_count', 'fbads_vars', array(
					'fbads_nonce' 			=> wp_create_nonce('fbads-nonce'),
					'ajaxurl' 				=> admin_url('admin-ajax.php')
			));

			wp_enqueue_script('jquery.cookie', plugins_url('js/jquery.cookie.js', __FILE__));
		}

		public function fbads_addmenu()
		{
			add_menu_page('WP Ad Slinger', 'WP Ad Slinger', 'manage_options', 'fbads', array($this, 'fbadsmenupage'), plugins_url('images/ico.png',__FILE__));
		}

		public function fbadsmenupage()
		{
			?>
			<div class="wrap">
				<?php
					screen_icon('options-general');
					$tab = isset( $_GET['tab'] ) ? $_GET['tab'] : "fbads_adlist";
				?>
				<h2 class="nav-tab-wrapper">
					<a class="nav-tab <?php if($tab == "fbads_adlist") echo "nav-tab-active"; ?>" href="?page=fbads&tab=fbads_adlist">Ads</a>
				</h2>
					<?php
					require_once("code/adlist.php");
				?>
			</div>
			<?php
		}

		public function run_fbads_activate($networkwide)
		{
			global $wpdb, $switched;
			
			if(function_exists('is_multisite') && is_multisite())
			{
				if($networkwide)
				{
					$old_blog	= $wpdb->blogid;
					$blogids	= $wpdb->get_col($wpdb->prepare("SELECT blog_id FROM $wpdb->blogs"));
					foreach($blogids as $blogid)
					{
						switch_to_blog($blogid);
						$this->fbads_activate();
					}
					switch_to_blog($old_blog);
					return;
				}
			}
			$this->fbads_activate();
		}

		public function fbads_activate()
		{
			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

			global $wpdb;
			
			$sql = "CREATE TABLE " . $wpdb->prefix . "fbads_ads(
				id int(11) unsigned NOT NULL AUTO_INCREMENT,
				adname varchar(100) NOT NULL,
				adtitle varchar(100) NOT NULL,
				adsubtitle varchar(100) NOT NULL,
				addescription varchar(500) NOT NULL,
				adimage varchar(255) NOT NULL,
				active varchar(5) NOT NULL,
				targeturl varchar(200) NOT NULL,
				numviews int(11) NOT NULL,
				numclicks int(11) NOT NULL,
				PRIMARY KEY (id))";

			dbDelta($sql);
			
			$upload_dir = wp_upload_dir();
			$upload_loc	= $upload_dir['basedir']."/wpadslinger";
			if (!is_dir($upload_loc))
			{
			    wp_mkdir_p($upload_loc);
			}
		}

		public function fbads_send_clickdata_ajax()
		{
			if( !isset( $_POST['fbads_nonce'] ) || !wp_verify_nonce($_POST['fbads_nonce'], 'fbads-nonce') )
				die('Permissions check failed');

			global $wpdb;
			$table 	= $wpdb->prefix.'fbads_ads';

			if($_POST['ulog'] == 0)
			{
				$wpdb->query($wpdb->prepare("UPDATE $table SET numclicks=numclicks+1 WHERE id=%d", $_POST['adsid']));
			}
			
			exit();
		}

		public function fbads_reset_stats_ajax()
		{
			if( !isset( $_POST['fbads_nonce'] ) || !wp_verify_nonce($_POST['fbads_nonce'], 'fbads-nonce') )
				die('Permissions check failed');

			global $wpdb;
			$adsid 	= $_POST['adsid'];
			$table 	= $wpdb->prefix.'fbads_ads';
			$wpdb->query($wpdb->prepare("UPDATE $table SET numviews=%d, numclicks=%d WHERE id=%d", 0, 0, $adsid));
			echo 'ok';
			exit();
		}

		public function fbads_change_status_ajax()
		{
			if( !isset( $_POST['fbads_nonce'] ) || !wp_verify_nonce($_POST['fbads_nonce'], 'fbads-nonce') )
				die('Permissions check failed');

			$adsid = $_POST['adsid'];
			$value = $_POST['value'];

			global $wpdb;
			$table = $wpdb->prefix.'fbads_ads';
			if(empty($adsid))
				die('Invalid request. Empty Ads ID.');
			if($value == 'Active')
			{
				$wpdb->query($wpdb->prepare("UPDATE $table SET active=%s WHERE id=%d", 'off', $adsid));
				echo 'Inactive';
			}
			else
			{
				$wpdb->query($wpdb->prepare("UPDATE $table SET active=%s WHERE id=%d", 'on', $adsid));
				echo 'Active';
			}
			exit();
		}
		
		public function fbads_impression()
		{
			if( !isset( $_POST['fbads_nonce'] ) || !wp_verify_nonce($_POST['fbads_nonce'], 'fbads-nonce') )
				die('Permissions check failed');

			global $wpdb;
			$fbadsid 	= $_POST['fbads_id'];
			$cookie 	= $_POST['fbads_cookie'];
			
			if(!current_user_can('manage_options') || !is_user_logged_in())
			{
				if(empty($cookie))
				{
					$sql = "UPDATE " . $wpdb->prefix . "fbads_ads SET numviews = numviews + 1 WHERE id=" . $fbadsid;
					$wpdb->query($sql);
					echo $fbadsid;
				}
			}
			exit();
		}

		public function fbads_getads()
		{
			if( !isset( $_POST['fbads_nonce'] ) || !wp_verify_nonce($_POST['fbads_nonce'], 'fbads-nonce') )
				die('Permissions check failed');

			global $wpdb;
			$table 		= $wpdb->prefix.'fbads_ads';
			$lastid 	= $_POST["fbads_id"];
			$impression = $_POST["fbads_impression"];

			/*if(!current_user_can('manage_options') || !is_user_logged_in())
			{
				if($impression == 1)
				{
					$isbot 		= false;
					$useragent 	= $_SERVER['HTTP_USER_AGENT'];
					$botarray 	= array('googlebot', 'askjeeves', 'bingbot', 'acme-spider', 'ahoythehomepagefinder', 'Alkaline', 'anthill', 'appie');

					foreach($botarray as $bot)
					{
						if(strpos($useragent, $bot) !== false)
						{
					    	$isbot = true;
					    	break;
					   	}
					}

					if(!$isbot)
					{
						$sql = "UPDATE " . $wpdb->prefix . "fbads_ads SET numviews = numviews + 1 WHERE id=" . $lastid;
						$wpdb->query($sql);	
					}
				}
			}*/
		
			$ads 			= $wpdb->get_results("SELECT * FROM $table WHERE active='on' AND id>$lastid ORDER BY id ASC LIMIT 1");
			if(!$ads) $ads 	= $wpdb->get_results("SELECT * FROM $table WHERE active='on' ORDER BY id ASC LIMIT 1");

			if(current_user_can('manage_options') || is_user_logged_in())
			{
				$ulog = 1;
			}
			else
			{
				$ulog = 0;
			}

			foreach($ads as $ad)
			{
				echo "<div class='fbads_ad fbads_ad_".$ad->id."' data='".$ad->id."'>";
				echo "<div class='fbads_adtitle'><a target='_blank' href='" . $ad->targeturl . "' class='fbads_linkcount' data='".$ad->id."' ulog='".$ulog."'>" . $ad->adtitle . "</a></div><div class='fbads_adsubtitle'><a target='_blank' href='" . $ad->targeturl . "' class='fbads_linkcount' data='".$ad->id."' ulog='".$ulog."'>" . $ad->adsubtitle . "</a></div><div class='fbads_wrapper'><div class='fbads_image'><a target='_blank' href='" . $ad->targeturl . "' class='fbads_linkcount' data='".$ad->id."' ulog='".$ulog."'><img href='".$ad->targeturl."' src='" . $ad->adimage . "' data='".$ad->id."' ulog='".$ulog."' /></a></div><div class='fbads_description' ><a target='_blank' href='" . $ad->targeturl . "' class='fbads_linkcount' data='".$ad->id."' ulog='".$ulog."'>" . $ad->addescription . "</a></div></div>";
				echo "</tr>";
				echo "</div>";
			}
			exit();
		}
	}
}
new WP_AdSlinger();
?>