<?php
class fbads_widget extends WP_Widget 
{
	/** constructor */
    function fbads_widget() 
	{
		$widget_options = array(
			'classname' => 'fbads_widget',
			'description' => 'WP Ad Slinger'
		);
        parent::WP_Widget('fbads_fbads', __('WP Ad Slinger', 'fbads'), $widget_options);
    }
	
	/** @see WP_Widget::widget */
    function widget($args, $instance) 
	{
		global $wpdb;
        extract($args);

        $scrollads = esc_attr($instance['scrollads']);
        if(empty($scrollads)) $scrollads = 'off';

		$numberofads = esc_attr($instance['numberofads']);
		if(empty($numberofads)) $numberofads = 5;

		$scrolltime = esc_attr($instance['scrolltime']);
		if(empty($scrolltime)) $scrolltime = 2;

		$scrolltype = esc_attr($instance['scrolltype']);
		if(empty($scrolltype)) $scrolltype = "top";

		echo $before_widget;

		$sql = "SELECT * FROM " . $wpdb->prefix . "fbads_ads WHERE active='on' ORDER BY id ASC LIMIT $numberofads";
		$ads = $wpdb->get_results($sql);

		if($ads)
		{
			if(current_user_can('manage_options') || is_user_logged_in())
			{
				$ulog = 1;
			}
			else
			{
				$ulog = 0;
			}

			$fbads_displayed = "";

			foreach($ads as $ad)
			{
				echo "<div class='fbads_ad fbads_ad_".$ad->id."' data='".$ad->id."'>";
				echo "<div class='fbads_adtitle'><a target='_blank' href='" . $ad->targeturl . "' class='fbads_linkcount' data='".$ad->id."' ulog='".$ulog."'>" . $ad->adtitle . "</a></div><div class='fbads_adsubtitle'><a target='_blank' href='" . $ad->targeturl . "' class='fbads_linkcount' data='".$ad->id."' ulog='".$ulog."'>" . $ad->adsubtitle . "</a></div><div class='fbads_wrapper'><div class='fbads_image'><a target='_blank' href='" . $ad->targeturl . "' class='fbads_linkcount' data='".$ad->id."' ulog='".$ulog."'><img href='".$ad->targeturl."' src='" . $ad->adimage . "' data='".$ad->id."' ulog='".$ulog."' /></a></div><div class='fbads_description' ><a target='_blank' href='" . $ad->targeturl . "' class='fbads_linkcount' data='".$ad->id."' ulog='".$ulog."'>" . $ad->addescription . "</a></div></div>";
				echo "</tr>";
				echo "</div>";

				$fbads_displayed .= "window.fbads_id[" . $ad->id . "] = " . $ad->id . ";\n";

				/*if(!current_user_can('manage_options') || !is_user_logged_in())
				{
					$isbot 		= false;
					$useragent 	= $_SERVER['HTTP_USER_AGENT'];
					$botarray 	= array('googlebot', 'askjeeves', 'bingbot', 'acme-spider', 'ahoythehomepagefinder', 'Alkaline', 'anthill', 'appie');

					foreach($botarray as $bot)
					{
						if(strpos($useragent, $bot) !== false)
						{
					    	$isbot = true;
					    	break;
					   	}
					}

					if(!$isbot)
					{
						$sql = "UPDATE " . $wpdb->prefix . "fbads_ads SET numviews = numviews + 1 WHERE id=" . $ad->id;
						$wpdb->query($sql);	
					}
				}*/
			}

			if($scrollads == 'on')
			{
				?>
				<style type="text/css">
				/*.fbads_widget
				{
					overflow: hidden;
				}*/
				</style>
				<script type="text/javascript">
				jQuery(document).ready(function()
				{
					jQuery('.fbads_widget').each(function() {
					    					    
					    var widgetid 	= this.id;
					    window.fbads_id = new Array();

						<?php echo $fbads_displayed; ?>

						setInterval(function()
						{
							var scrolltype = '<?php echo $scrolltype; ?>';
							
							var id = 0;
							if(scrolltype == "top")
							{
								adsid 	= jQuery('.fbads_ad').attr('data');
								//id 		= jQuery(".fbads_widget").children(".fbads_ad").last().attr("data");
								id 		= jQuery('#'+widgetid).children(".fbads_ad").last().attr("data");
							}
							else
							{
								adsid 	= jQuery('.fbads_ad').attr('data');
								//id 		= jQuery(".fbads_widget").children(".fbads_ad").first().attr("data");
								id 		= jQuery('#'+widgetid).children(".fbads_ad").first().attr("data");
							}			
							
							jQuery.cookie('fbads_cookie_'+id) == undefined ? cookie = '' : cookie = jQuery.cookie('fbads_cookie_'+id);

							dataimpression	= {
								action 			: 'fbads_impression',
								fbads_nonce		: fbads_vars.fbads_nonce,
								fbads_id 		: id,
								fbads_cookie 	: cookie
							}

							jQuery.post(fbads_vars.ajaxurl, dataimpression, function (response) {
								if(response != '')
								{
									jQuery.cookie('fbads_cookie_'+id, 'yes');
								}
							});

							var impression = 1;

							if(window.fbads_id[id] == id)
							{
								impression = 0;
							}

							window.fbads_id[id] = id;
							
							data = {
								action 		: 'fbads_getads',
								fbads_nonce : fbads_vars.fbads_nonce,
								fbads_id 	: id,
								fbads_impression : impression
							};					

							jQuery.post(fbads_vars.ajaxurl, data, function (response)
							{
								if(response != 'Permissions check failed')
								{
									var scrolltype = '<?php echo $scrolltype; ?>';
									if(scrolltype == "top")
									{
										jQuery('#'+widgetid).children(".fbads_ad").first().remove();
										jQuery('#'+widgetid).append(response);
										//jQuery(".fbads_widget").children(".fbads_ad").first().remove();
										//jQuery(".fbads_widget").append(response);
									}
									else
									{
										jQuery('#'+widgetid).children(".fbads_ad").last().remove();
										jQuery('#'+widgetid).prepend(response);
										//jQuery(".fbads_widget").children(".fbads_ad").last().remove();
										//jQuery(".fbads_widget").prepend(response);
									}
								}

							});

						},<?php echo $scrolltime * 1000; ?>);
						
					});
					
				});
				</script>
			<?php
			}
		}

        echo $after_widget;
    }
	
	/** @see WP_Widget::update */
    function update($new_instance, $old_instance) 
	{

		$instance = $old_instance;

		$instance['numberofads'] = strip_tags($new_instance['numberofads']);
		$instance['scrollads'] = strip_tags($new_instance['scrollads']);
		$instance['scrolltime'] = strip_tags($new_instance['scrolltime']);
		$instance['scrolltype'] = strip_tags($new_instance['scrolltype']);

		return $instance;

    }
	
	 /** @see WP_Widget::form */
	function form($instance) 
	{	

		global $themename;
		$numberofads = esc_attr($instance['numberofads']);
		$scrollads = esc_attr($instance['scrollads']);
		$scrolltime = esc_attr($instance['scrolltime']);
		$scrolltype = esc_attr($instance['scrolltype']);

		?>
		<script type="text/javascript">
		jQuery(document).ready(function(){

			if (jQuery('.fbads_scrollads').is(':checked'))
			{
				jQuery(".fbads_hidden").show();
			}


			jQuery('.fbads_scrollads').click(function() {
			    jQuery(".fbads_hidden").toggle(this.checked);
			});

		})
		</script>
		<table>
			<tr>
				<td>Number of ads</td>
				<td>
					<select id="<?php echo $this->get_field_id('numberofads'); ?>" name="<?php echo $this->get_field_name('numberofads'); ?>">
						<option value="1" <?php if($numberofads == "1") echo " selected='selected' "; ?> >1</option>
						<option value="2" <?php if($numberofads == "2") echo " selected='selected' "; ?> >2</option>
						<option value="3" <?php if($numberofads == "3") echo " selected='selected' "; ?> >3</option>
						<option value="4" <?php if($numberofads == "4") echo " selected='selected' "; ?> >4</option>
						<option value="5" <?php if($numberofads == "5") echo " selected='selected' "; ?> >5</option>
					</select>
				</td>
			</tr>
			<tr>
				<td>Scroll ads</td>
				<td><input type="checkbox" class="fbads_scrollads" id="<?php echo $this->get_field_id('scrollads'); ?>" name="<?php echo $this->get_field_name('scrollads'); ?>" <?php if($scrollads == "on") echo " checked='checked' "; ?> /></td>
			</tr>
			</table>
			<div class="fbads_hidden" style="display:none">
			<table>
				<tr>
					<td>Scroll time</td>
					<td>
						<select id="<?php echo $this->get_field_id('scrolltime'); ?>" name="<?php echo $this->get_field_name('scrolltime'); ?>">
							<option value="1" <?php if($scrolltime == "1") echo " selected='selected' "; ?> >1</option>
							<option value="2" <?php if($scrolltime == "2") echo " selected='selected' "; ?> >2</option>
							<option value="3" <?php if($scrolltime == "3") echo " selected='selected' "; ?> >3</option>
							<option value="4" <?php if($scrolltime == "4") echo " selected='selected' "; ?> >4</option>
							<option value="5" <?php if($scrolltime == "5") echo " selected='selected' "; ?> >5</option>
							<option value="6" <?php if($scrolltime == "6") echo " selected='selected' "; ?> >6</option>
							<option value="7" <?php if($scrolltime == "7") echo " selected='selected' "; ?> >7</option>
							<option value="8" <?php if($scrolltime == "8") echo " selected='selected' "; ?> >8</option>
							<option value="9" <?php if($scrolltime == "9") echo " selected='selected' "; ?> >9</option>
							<option value="10" <?php if($scrolltime == "10") echo " selected='selected' "; ?> >10</option>
						</select> seconds
					</td>
				</tr>
				<tr>
					<td>Scroll type</td>
					<td>
						<select id="<?php echo $this->get_field_id('scrolltype'); ?>" name="<?php echo $this->get_field_name('scrolltype'); ?>">
							<option value="top" <?php if($scrolltype == "top") echo " selected='selected' "; ?> >Top</option>
							<option value="bottom" <?php if($scrolltype == "bottom") echo " selected='selected' "; ?> >Bottom</option>
						</select>
					</td>
				</tr>
			</table>
			</div>
		<?php
	}
}
?>