<?php
if(!class_exists('FBAdsTableClass'))
{
	class FBAdsTableClass extends WP_List_Table
	{
		function fbads_get_data()
		{
			global $wpdb;
		
			$table 	= $wpdb->prefix . 'fbads_ads';
			if(empty($_POST['s']))
			{
				$q		= "SELECT * FROM $table";

				if($_GET['orderby'] == 'ctr')
				{
					$orderby = 'ROUND(numclicks/numviews, 5)';
				}
				else
				{
					$orderby = !empty($_GET["orderby"]) ? $_GET["orderby"] : 'id';
				}
				
				$order 	= !empty($_GET["order"]) ? $_GET["order"] : 'DESC';
				
				if(!empty($orderby) & !empty($order)){ $q.=' ORDER BY '.$orderby.' '.$order; }
				$r		= $wpdb->get_results($q, ARRAY_A);
				
				foreach($r as $value)
				{
					$id 			= $value['id'];
					$adname 		= $value['adname'];
					$adtitle		= $value['adtitle'];
					$adsubtitle		= $value['adsubtitle'];
					$adddescription	= $value['adddescription'];
					$adimage		= $value['adimage'];
					$active 		= $value['active'] == 'on' ? 'Active' : 'Inactive';
					$nonce 			= wp_create_nonce('fbads-nonce');
					if($active == 'Active')
					{
						$linkact 	= '(<a href="#" class="fbads_status" nonce="'.$nonce.'" data="'.$id.'" value="'.$active.'">Deactivate</a>) <span class="response"></span>';
					}
					else
					{
						$linkact 	= '(<a href="#" class="fbads_status" nonce="'.$nonce.'" data="'.$id.'" value="'.$active.'">Activate</a>) <span class="response"></span>';
					}
					$resetlink 		= ' (<a href="#" class="fbads_reset_stats" nonce="'.$nonce.'" data="'.$id.'">Reset Stats</a>)';
					$targeturl		= $value['targeturl'];
					$numviews		= $value['numviews'];
					$numclicks		= $value['numclicks'];

					$array[] = array(
						'id' 		=> $id,
						'adname'	=> $adname,
						'numviews'	=> '<span id="impressions_'.$id.'">'.$numviews.'</span>',
						'numclicks'	=> '<span id="clicks_'.$id.'">'.$numclicks.'</span>',
						'ctr'		=> '<span id="ctr_'.$id.'">'.round(100*$numclicks/$numviews, 5).'</span>',
						'active'	=> '<span id="status_'.$id.'">'.$active.'</span>&nbsp;'.$linkact.$resetlink,
						'ads'		=> "<div class='fbads_ad'><div class='fbads_adtitle'><a href='" . $value['targeturl'] . "'>" . $value['adtitle'] . "</a></div><div class='fbads_adsubtitle'><a href='" . $value['targeturl'] . "'>" . $value['adsubtitle'] . "</a></div><div class='fbads_wrapper'><div class='fbads_image'><a href='" . $value['targeturl'] . "'><img src='" . $value['adimage'] . "' /></a></div><div class='fbads_description' ><a href='" . $value['targeturl'] . "'>" . $value['addescription'] . "</a></div></div></div></td>"
					);
				}
				return $array;
			}
			else
			{
				$search 	= $_POST['s'];
				$q		= "SELECT * FROM $table WHERE adname LIKE '%$search%'";
				$r		= $wpdb->get_results($q, ARRAY_A);
				
				foreach($r as $value)
				{
					$id 			= $value['id'];
					$adname 		= $value['adname'];
					$adtitle		= $value['adtitle'];
					$adsubtitle		= $value['adsubtitle'];
					$adddescription	= $value['adddescription'];
					$adimage		= $value['adimage'];
					$active 		= $value['active'] == 'on' ? 'Active' : 'Inactive';
					$nonce 			= wp_create_nonce('fbads-nonce');
					if($active == 'Active')
					{
						$linkact 	= '(<a href="#" class="fbads_status" nonce="'.$nonce.'" data="'.$id.'" value="'.$active.'">Deactivate</a>) <span class="response"></span>';
					}
					else
					{
						$linkact 	= '(<a href="#" class="fbads_status" nonce="'.$nonce.'" data="'.$id.'" value="'.$active.'">Activate</a>) <span class="response"></span>';
					}
					$resetlink 		= ' (<a href="#" class="fbads_reset_stats" nonce="'.$nonce.'" data="'.$id.'">Reset Stats</a>)';
					$targeturl		= $value['targeturl'];
					$numviews		= $value['numviews'];
					$numclicks		= $value['numclicks'];

					$array[] = array(
						'id' 		=> $id,
						'adname'	=> $adname,
						'numviews'	=> '<span id="impressions_'.$id.'">'.$numviews.'</span>',
						'numclicks'	=> '<span id="clicks_'.$id.'">'.$numclicks.'</span>',
						'ctr'		=> '<span id="ctr_'.$id.'">'.round(100*$numclicks/$numviews, 5).'</span>',
						'active'	=> '<span id="status_'.$id.'">'.$active.'</span>&nbsp;'.$linkact.$resetlink,
						'ads'		=> "<div class='fbads_ad'><div class='fbads_adtitle'><a href='" . $value['targeturl'] . "'>" . $value['adtitle'] . "</a></div><div class='fbads_adsubtitle'><a href='" . $value['targeturl'] . "'>" . $value['adsubtitle'] . "</a></div><div class='fbads_wrapper'><div class='fbads_image'><a href='" . $value['targeturl'] . "'><img src='" . $value['adimage'] . "' /></a></div><div class='fbads_description' ><a href='" . $value['targeturl'] . "'>" . $value['addescription'] . "</a></div></div></div></td>"
					);
				}
				return $array;
			}
		}
		
		function __construct()
		{
	        		global $status, $page;
	                
	        		# Set parent defaults
	        		parent::__construct( array(
	            			'singular'  	=> 'fbad',
	            			'plural'    	=> 'fbads',
	            			'ajax'     		=> false
	        		) );
	    	}
		
		function get_columns()
		{
			$columns = array(
				'id' 			=> 'SI No',
				'adname'		=> 'Ad Name',
				'ads'			=> 'Ads',
				'numviews'		=> 'Impressions',
				'numclicks'		=> 'Clicks',
				'ctr'			=> 'CTR',
				'active'			=> 'Status'
			);
			
			return $columns;
		}
		
		function get_sortable_columns()
		{
			$sortable_columns = array(
				'id'			=> array('id', false),
				'numviews'		=> array('numviews', false),
				'numclicks'		=> array('numclicks', false),
				'ctr'			=> array('ctr', false)
			);
			
			return $sortable_columns;
		}
		
		function column_default($item, $column_name)
		{
			switch($column_name)
			{
				case 'id':
				case 'adname':
				case 'ads':
				case 'numviews':
				case 'numclicks':
				case 'ctr':
				case 'active':
					return $item[$column_name];
				default:
					return print_r($item, true);
			}
		}
		
		function column_adname($item)
		{
			$actions = array(
				'edit'     	=> sprintf('<a href="?page=%s&cmd=edit&id=%d" style="visibility:visible;">Edit</a>',$_REQUEST['page'], $item['id']),
				'delete'    => sprintf('<a style="visibility:visible;" onclick="return is_delete_confirm()" href="?page=%s&cmd=delete&id=%d">Delete</a>', $_REQUEST['page'], $item['id'])
			);

			return sprintf('%1$s %2$s', $item['adname'], $this->row_actions($actions) );
		}		
		
		function prepare_items()
		{
			$columns 			= $this->get_columns();
			$hidden  			= array();
			$sortable 			= $this->get_sortable_columns();
			$this->_column_headers 	= array($columns, $hidden, $sortable);
			$per_page 			= 10;
			$current_page 		= $this->get_pagenum();
			$total_items 			= count($this->fbads_get_data());
			$this->found_data_post 	= array_slice($this->fbads_get_data(),(($current_page-1)*$per_page),$per_page);
			$this->set_pagination_args( array(
				'total_items' 	=> $total_items, 
				'per_page'    	=> $per_page
			));
			$this->items = $this->found_data_post;
		}
	}
}
?>