/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.chart.fit.CurveFitter;
import com.jidesoft.chart.fit.Polynomial;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.range.Range;
import java.awt.geom.Point2D;
import java.util.List;
import org.apache.commons.math.linear.RealMatrixImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolynomialFitter
implements CurveFitter {
    private int a;

    public PolynomialFitter(int n) {
        this.setOrder(n);
    }

    public void setOrder(int n) {
        this.a = n;
    }

    @Override
    public Polynomial performRegression(ChartModel chartModel) {
        double d2;
        int n;
        int n2;
        double[][] dArray;
        boolean bl;
        block4: {
            bl = Polynomial.b;
            dArray = new double[this.a + 1][this.a + 1];
            int n3 = 0;
            while (n3 <= this.a) {
                block5: {
                    n2 = 0;
                    if (bl) break block4;
                    for (n = v58304; n <= this.a; ++n) {
                        dArray[n3][n] = d2 = this.a(chartModel, n3 + n, 0);
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block5;
                    }
                    ++n3;
                }
                if (!bl) continue;
            }
            n2 = this.a + 1;
        }
        double[] dArray2 = new double[n2];
        for (n = 0; n <= this.a; ++n) {
            dArray2[n] = d2 = this.a(chartModel, n, 1);
            if (!bl) continue;
        }
        RealMatrixImpl realMatrixImpl = new RealMatrixImpl(dArray);
        double[] dArray3 = realMatrixImpl.solve(dArray2);
        return new Polynomial(dArray3);
    }

    @Override
    public AnnotatedChartModel performRegression(String string, ChartModel chartModel, Range<?> range, int n) {
        Polynomial polynomial = this.performRegression(chartModel);
        return this.createModel(string, polynomial, range, n);
    }

    @Override
    public AnnotatedChartModel createModel(Polynomial polynomial, Range<?> range, int n) {
        return this.createModel(null, polynomial, range, n);
    }

    @Override
    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Range<?> range, int n) {
        DefaultChartModel defaultChartModel;
        block2: {
            boolean bl = Polynomial.b;
            double d2 = range.minimum();
            double d3 = range.maximum();
            DefaultChartModel defaultChartModel2 = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
            double d4 = (d3 - d2) / (double)(n - 1);
            for (int j = 0; j < n; ++j) {
                double d5 = d2 + (double)j * d4;
                double d6 = polynomial.eval(d5);
                defaultChartModel = defaultChartModel2.addPoint(d5, d6);
                if (!bl) {
                    if (!bl) continue;
                }
                break block2;
            }
            defaultChartModel = defaultChartModel2;
        }
        return defaultChartModel;
    }

    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Double[] doubleArray) {
        DefaultChartModel defaultChartModel;
        block2: {
            boolean bl = Polynomial.b;
            DefaultChartModel defaultChartModel2 = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
            for (int j = 0; j < doubleArray.length; ++j) {
                double d2 = doubleArray[j];
                double d3 = polynomial.eval(d2);
                defaultChartModel = defaultChartModel2.addPoint(d2, d3);
                if (!bl) {
                    if (!bl) continue;
                }
                break block2;
            }
            defaultChartModel = defaultChartModel2;
        }
        return defaultChartModel;
    }

    public Polynomial performRegression(List<? extends Point2D> list) {
        return null;
    }

    private double a(ChartModel chartModel, int n, int n2) {
        double d2;
        block2: {
            boolean bl = Polynomial.b;
            double d3 = 0.0;
            for (Chartable chartable : chartModel) {
                d2 = d3 + Math.pow(chartable.getX().position(), n) * Math.pow(chartable.getY().position(), n2);
                if (!bl) {
                    d3 = d2;
                    if (!bl) continue;
                }
                break block2;
            }
            d2 = d3;
        }
        return d2;
    }
}

