/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.annotation.AutoPositionedLabel;
import com.jidesoft.chart.axis.AxisPlacement;
import com.jidesoft.chart.axis.DefaultNumericTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.axis.TickCalculator;
import com.jidesoft.chart.model.IdentityTransform;
import com.jidesoft.chart.model.InvertibleTransform;
import com.jidesoft.chart.render.AxisRenderer;
import com.jidesoft.chart.render.NoAxisRenderer;
import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import com.jidesoft.range.TimeRange;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis
implements PropertyChangeListener {
    private static final AxisPlacement a = AxisPlacement.LEADING;
    public static final String PROPERTY_TICKS = "ticks";
    public static final String PROPERTY_RANGE = "range";
    public static final String PROPERTY_UPDATE_OTHER_AXES = "updateOtherAxes";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_TICK_CALCULATOR = "tickCalculator";
    public static final String PROPERTY_AXIS_COLOR = "axisColor";
    private static final Logger b = Logger.getLogger(Axis.class.getName());
    private Range<?> c;
    private TickCalculator d;
    private AutoPositionedLabel e;
    private PropertyChangeSupport f;
    private AxisPlacement g;
    private boolean h;
    private AxisRenderer i;
    private Tick[] j;
    private boolean k;
    private boolean l;
    private Integer m;
    private double n;
    private Color o;
    private Range<Double> p;
    private boolean q;
    private double r;
    private InvertibleTransform<Double> s;
    public static boolean u;

    public Axis() {
        this.c = null;
        this.d = new DefaultNumericTickCalculator();
        this.e = null;
        this.f = new PropertyChangeSupport(this);
        this.h = true;
        this.i = new NoAxisRenderer();
        this.k = true;
        this.l = true;
        this.m = null;
        this.n = 0.0;
        this.p = null;
        this.q = false;
        this.s = new IdentityTransform<Double>();
        this.setRange(new NumericRange(0.0, 1.0));
        this.setPlacement(a);
    }

    public Axis(String string) {
        this(new AutoPositionedLabel(string));
    }

    public Axis(AutoPositionedLabel autoPositionedLabel) {
        this();
        this.setLabel(autoPositionedLabel);
    }

    public Axis(double d2, double d3) {
        this(new NumericRange(d2, d3));
    }

    public Axis(Range<?> range) {
        this.c = null;
        this.d = new DefaultNumericTickCalculator();
        this.e = null;
        this.f = new PropertyChangeSupport(this);
        this.h = true;
        this.i = new NoAxisRenderer();
        this.k = true;
        this.l = true;
        this.m = null;
        this.n = 0.0;
        this.p = null;
        this.q = false;
        this.s = new IdentityTransform<Double>();
        if (!u) {
            if (range == null) {
                throw new IllegalArgumentException("Cannot set a range of null!");
            }
            this.setRange(range);
            this.setPlacement(a);
        }
    }

    public Axis(Range<?> range, String string) {
        boolean bl = u;
        this.c = null;
        this.d = new DefaultNumericTickCalculator();
        this.e = null;
        this.f = new PropertyChangeSupport(this);
        this.h = true;
        this.i = new NoAxisRenderer();
        this.k = true;
        this.l = true;
        this.m = null;
        this.n = 0.0;
        this.p = null;
        this.q = false;
        this.s = new IdentityTransform<Double>();
        if (!bl) {
            if (range == null) {
                throw new IllegalArgumentException("Cannot set a range of null!");
            }
            this.setRange(range);
            this.setLabel(new AutoPositionedLabel(string));
            this.setPlacement(a);
        }
        if (Chart.ib) {
            u = !bl;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.f.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.f.addPropertyChangeListener(propertyChangeListener);
    }

    public TickCalculator getTickCalculator() {
        return this.d;
    }

    public void setTickCalculator(TickCalculator tickCalculator) {
        block6: {
            TickCalculator tickCalculator2;
            TickCalculator tickCalculator3;
            block5: {
                boolean bl = u;
                tickCalculator2 = tickCalculator3 = this.d;
                if (bl) break block5;
                if (tickCalculator2 != null) {
                    tickCalculator3.removePropertyChangeListener(this);
                }
                this.d = tickCalculator;
                if (bl) break block6;
                tickCalculator2 = tickCalculator;
            }
            if (tickCalculator2 != null) {
                tickCalculator.addPropertyChangeListener(this);
            }
            this.j = null;
            this.f.firePropertyChange(PROPERTY_TICK_CALCULATOR, tickCalculator3, tickCalculator);
        }
    }

    public AxisRenderer getAxisRenderer() {
        return this.i;
    }

    public double getTickLabelRotation() {
        return this.n;
    }

    public void setTickLabelRotation(double d2) {
        this.n = d2;
    }

    public boolean isVisible() {
        return this.k;
    }

    public void setVisible(boolean bl) {
        this.k = bl;
    }

    public boolean isLabelVisible() {
        return this.l;
    }

    public void setLabelVisible(boolean bl) {
        this.l = bl;
    }

    public Integer getLabelWidth() {
        return this.m;
    }

    public void setLabelWidth(Integer n) {
        this.m = n;
    }

    /*
     * Unable to fully structure code
     */
    public int labelWidth(Graphics var1_1, Font var2_2, Orientation var3_3) {
        block35: {
            block34: {
                var16_4 = Axis.u;
                v0 = this;
                if (!var16_4) {
                    if (!v0.k) {
                        return 0;
                    }
                    v0 = this;
                }
                if (!var16_4) {
                    if (v0.m != null) {
                        return this.m;
                    }
                    v0 = this;
                }
                var4_5 = v0.getTicks();
                v1 = var1_1;
                if (!var16_4) {
                    if (v1 == null) {
                        throw new IllegalArgumentException("Graphics instance cannot be null");
                    }
                    v1 = var1_1;
                }
                v2 = var2_2;
                if (!var16_4) {
                    v2 = v2 == null ? var1_1.getFont() : var2_2;
                }
                var5_6 = v1.getFontMetrics(v2);
                var6_7 = var1_1.getFontMetrics(var1_1.getFont());
                v3 = var5_6;
                if (var16_4) break block34;
                if (v3 != null) break block35;
                v3 = var6_7;
            }
            var5_6 = v3;
        }
        v4 = var3_3;
        v5 = Orientation.vertical;
        if (!var16_4) {
            if (v4 == v5) {
                block32: {
                    var7_8 = 0;
                    var8_10 = var4_5;
                    var9_11 = var8_10.length;
                    var10_13 = 0;
                    while (var10_13 < var9_11) {
                        var11_15 = var8_10[var10_13];
                        v6 = (int)Axis.t;
                        if (!var16_4) {
                            if (v6 == 0) {
                                v7 = var11_15;
                                if (!var16_4) {
                                    if (v7 == null) {
                                        throw new AssertionError((Object)"Ticks cannot be null!");
                                    } else {
                                        ** GOTO lbl-1000
                                    }
                                }
                            } else lbl-1000:
                            // 3 sources

                            {
                                v7 = var11_15;
                            }
                            var12_17 = v7.getLabel();
                            var13_19 = var5_6.stringWidth(var12_17);
                            if (!var16_4) {
                                if (var13_19 > var7_8) {
                                    var7_8 = var13_19;
                                }
                                ++var10_13;
                            }
                            if (!var16_4) continue;
                        }
                        break block32;
                    }
                    v6 = var7_8 + var6_7.getHeight();
                }
                return v6;
            }
            v4 = var3_3;
            v5 = Orientation.horizontal;
        }
        if (v4 == v5) {
            block33: {
                var7_9 = this.getTickLabelRotation();
                cfr_temp_0 = var7_9 - 0.0;
                v8 = cfr_temp_0 == 0.0 ? 0 : (cfr_temp_0 > 0.0 ? 1 : -1);
                if (!var16_4) {
                    if (v8 == false) {
                        return var5_6.getHeight() + var6_7.getHeight();
                    }
                    v8 = (double)false;
                }
                var9_12 = v8;
                var10_14 = var4_5;
                var11_16 = var10_14.length;
                var12_18 = 0;
                while (var12_18 < var11_16) {
                    var13_20 = var10_14[var12_18];
                    var14_21 = var13_20.getLabel();
                    var15_22 = var5_6.stringWidth(var14_21);
                    if (!var16_4) {
                        v9 = var15_22;
                        v10 = (int)var9_12;
                        if (var16_4) break block33;
                        if (v9 > v10) {
                            var9_12 = var15_22;
                        }
                        ++var12_18;
                    }
                    if (!var16_4) continue;
                }
                v9 = var5_6.getHeight();
                v10 = 2;
            }
            return (int)(Math.abs((double)(v9 / v10) * Math.sin(var7_9)) + Math.abs((double)var9_12 * Math.sin(var7_9)) + (double)var6_7.getHeight());
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)var3_3);
    }

    public void setAxisRenderer(AxisRenderer axisRenderer) {
        AxisRenderer axisRenderer2 = this.i;
        this.i = axisRenderer;
        this.f.firePropertyChange("axisRenderer", axisRenderer2, axisRenderer);
    }

    public void setRange(double d2, double d3) {
        this.setRange(new NumericRange(d2, d3));
    }

    public void setRange(Range<?> range) {
        this.setRange(range, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void setRange(Range<?> var1_1, boolean var2_2) {
        block16: {
            block15: {
                block13: {
                    block14: {
                        var7_3 = Axis.u;
                        v0 /* !! */  = var1_1;
                        if (!var7_3) {
                            if (v0 /* !! */  == null) {
                                throw new IllegalArgumentException("Cannot set a range of null!");
                            }
                            v0 /* !! */  = var1_1;
                        }
                        if (!var7_3) {
                            if (v0 /* !! */ .equals(this.c)) {
                                return;
                            }
                            v0 /* !! */  = this.c;
                        }
                        if (!var7_3) {
                            if (v0 /* !! */  != null) {
                                this.c.removePropertyChangeListener(this);
                            }
                            v0 /* !! */  = this.p;
                        }
                        if (var7_3) break block13;
                        if (v0 /* !! */  == null) break block14;
                        v1 = var1_1;
                        if (var7_3) ** GOTO lbl23
                        if (v1.minimum() < this.p.minimum()) {
                            v2 = this.p.minimum();
                        } else {
                            v1 = var1_1;
lbl23:
                            // 2 sources

                            v2 = v1.minimum();
                        }
                        var3_4 = v2;
                        v3 = var1_1;
                        if (var7_3) ** GOTO lbl31
                        if (v3.maximum() > this.p.maximum()) {
                            v4 = this.p.maximum();
                        } else {
                            v3 = var1_1;
lbl31:
                            // 2 sources

                            v4 = v3.maximum();
                        }
                        var5_6 = v4;
                        var1_1 = new NumericRange(var3_4, var5_6);
                    }
                    v0 /* !! */  = this.c;
                }
                var3_5 /* !! */  = v0 /* !! */ ;
                this.c = var1_1;
                this.j = null;
                this.c.addPropertyChangeListener(this);
                Axis.b.fine("Firing property change: old= " + var3_5 /* !! */  + ", new=" + var1_1);
                v5 = this.f;
                v6 = "range";
                v7 /* !! */  = var3_5 /* !! */ ;
                v8 = var1_1;
                if (var7_3) break block15;
                v5.firePropertyChange(v6, v7 /* !! */ , v8);
                if (!var2_2) break block16;
                v5 = this.f;
                v6 = "updateOtherAxes";
                v7 /* !! */  = var3_5 /* !! */ ;
                v8 = var1_1;
            }
            v5.firePropertyChange(v6, v7 /* !! */ , v8);
        }
    }

    public Range<Double> getDomain() {
        return this.p;
    }

    public void setDomain(Range<Double> range) {
        this.p = range;
    }

    public Range<?> getOutputRange() {
        Object object;
        block4: {
            block5: {
                Axis axis;
                block2: {
                    block3: {
                        boolean bl = u;
                        axis = this;
                        if (bl) break block2;
                        if (axis.s == null) break block3;
                        object = this.s;
                        if (bl) break block4;
                        if (!(object instanceof IdentityTransform)) break block5;
                    }
                    axis = this;
                }
                return axis.c;
            }
            object = this.s.transform(this.minimum());
        }
        double d2 = (Double)object;
        double d3 = this.s.transform(this.maximum());
        double d4 = Math.min(d2, d3);
        double d5 = Math.max(d2, d3);
        return new NumericRange(d4, d5);
    }

    public Range<?> getRange() {
        return this.c;
    }

    public InvertibleTransform<Double> getAxisTransform() {
        return this.s;
    }

    public void setAxisTransform(InvertibleTransform<Double> invertibleTransform) {
        this.s = invertibleTransform;
    }

    public AutoPositionedLabel getLabel() {
        return this.e;
    }

    public void setLabel(String string) {
        assert (string != null);
        AutoPositionedLabel autoPositionedLabel = new AutoPositionedLabel(string);
        this.setLabel(autoPositionedLabel);
    }

    public void setLabel(AutoPositionedLabel autoPositionedLabel) {
        AutoPositionedLabel autoPositionedLabel2 = this.e;
        this.e = autoPositionedLabel;
        this.f.firePropertyChange(PROPERTY_LABEL, autoPositionedLabel2, autoPositionedLabel);
    }

    public double maximum() {
        return this.c.maximum();
    }

    public double minimum() {
        return this.c.minimum();
    }

    public double midPoint() {
        return (this.c.maximum() + this.c.minimum()) / 2.0;
    }

    public AxisPlacement getPlacement() {
        return this.g;
    }

    public void setPlacement(AxisPlacement axisPlacement) {
        this.g = axisPlacement;
    }

    public double getFloatingPosition() {
        return this.r;
    }

    public void setFloatingPosition(double d2) {
        this.r = d2;
    }

    public Color getAxisColor() {
        return this.o;
    }

    public void setAxisColor(Color color) {
        Color color2 = this.o;
        this.o = color;
        this.f.firePropertyChange(PROPERTY_AXIS_COLOR, color2, color);
    }

    public Tick[] getTicks() {
        Tick[] tickArray = this.j;
        if (!u) {
            if (tickArray == null) {
                this.updateTicks();
            }
            tickArray = this.j;
        }
        return tickArray;
    }

    protected void updateTicks() {
        Tick[] tickArray = this.j;
        this.j = this.d.calculateTicks(this.c);
        this.f.firePropertyChange(PROPERTY_TICKS, tickArray, this.j);
    }

    public boolean isTicksVisible() {
        return this.h;
    }

    public void setTicksVisible(boolean bl) {
        this.h = bl;
    }

    public boolean isFlipped() {
        return this.q;
    }

    public void setFlipped(boolean bl) {
        this.q = bl;
    }

    public static Range<?> zoom(Axis axis, double d2) {
        AbstractRange abstractRange;
        block4: {
            double d3;
            double d4;
            block6: {
                NumericRange numericRange;
                boolean bl;
                block5: {
                    boolean bl2;
                    NumericRange numericRange2;
                    block2: {
                        block3: {
                            bl = u;
                            numericRange2 = axis.getOutputRange();
                            d4 = axis.midPoint();
                            double d5 = numericRange2.maximum() - numericRange2.minimum();
                            d3 = d5 * d2;
                            bl2 = numericRange2 instanceof TimeRange;
                            if (bl) break block2;
                            if (!bl2) break block3;
                            abstractRange = new TimeRange((long)(d4 - d3 / 2.0), (long)(d4 + d3 / 2.0));
                            if (!bl) break block4;
                        }
                        numericRange = numericRange2;
                        if (bl) break block5;
                        bl2 = numericRange instanceof CategoryRange;
                    }
                    if (!bl2) break block6;
                    numericRange = numericRange2;
                }
                abstractRange = numericRange;
                double d6 = d3 / 2.0;
                double d7 = d4 - d6;
                double d8 = d4 + d6;
                ((CategoryRange)abstractRange).setMinimum(d7);
                ((CategoryRange)abstractRange).setMaximum(d8);
                if (!bl) break block4;
            }
            abstractRange = new NumericRange(d4 - d3 / 2.0, d4 + d3 / 2.0);
        }
        return abstractRange;
    }

    public static Range<?> zoomFromPosition(Axis axis, double d2, double d3) {
        AbstractRange abstractRange;
        block4: {
            double d4;
            double d5;
            block6: {
                NumericRange numericRange;
                boolean bl;
                block5: {
                    boolean bl2;
                    NumericRange numericRange2;
                    block2: {
                        block3: {
                            bl = u;
                            numericRange2 = axis.getOutputRange();
                            d5 = axis.minimum();
                            d4 = axis.maximum();
                            bl2 = numericRange2 instanceof TimeRange;
                            if (bl) break block2;
                            if (!bl2) break block3;
                            abstractRange = new TimeRange((long)(d3 - d2 * (d3 - d5)), (long)(d3 + d2 * (d4 - d3)));
                            if (!bl) break block4;
                        }
                        numericRange = numericRange2;
                        if (bl) break block5;
                        bl2 = numericRange instanceof CategoryRange;
                    }
                    if (!bl2) break block6;
                    numericRange = numericRange2;
                }
                abstractRange = numericRange;
                double d6 = d3 - d2 * (d3 - d5);
                double d7 = d3 + d2 * (d4 - d3);
                ((CategoryRange)abstractRange).setMinimum(d6);
                ((CategoryRange)abstractRange).setMaximum(d7);
                if (!bl) break block4;
            }
            abstractRange = new NumericRange(d3 - d2 * (d3 - d5), d3 + d2 * (d4 - d3));
        }
        return abstractRange;
    }

    public void render(Graphics graphics, int n, int n2, int n3, Orientation orientation) {
        block16: {
            AxisRenderer axisRenderer;
            block15: {
                AxisRenderer axisRenderer2;
                boolean bl;
                block14: {
                    Graphics graphics2;
                    block12: {
                        block13: {
                            block11: {
                                int n4;
                                block10: {
                                    bl = u;
                                    n4 = t;
                                    if (bl) break block10;
                                    if (n4 != 0) break block11;
                                    n4 = n3;
                                }
                                if (n4 < 0) {
                                    throw new AssertionError();
                                }
                            }
                            graphics2 = graphics;
                            if (bl) break block12;
                            graphics2.setColor(this.o);
                            if (orientation != Orientation.vertical) break block13;
                            graphics.drawLine(n, n2, n, n2 + n3);
                            if (!bl) break block14;
                        }
                        graphics2 = graphics;
                    }
                    graphics2.drawLine(n, n2, n + n3, n2);
                }
                axisRenderer = axisRenderer2 = this.getAxisRenderer();
                if (bl) break block15;
                if (axisRenderer == null) break block16;
                axisRenderer = axisRenderer2;
            }
            axisRenderer.renderAxis(graphics, n, n2, n3, orientation);
        }
    }

    public String toString() {
        return String.format("#<Axis label='%s' range=%s>", this.getLabel(), this.getRange());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.j = null;
        this.f.firePropertyChange(propertyChangeEvent);
    }
}

