/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets.watermark;

import com.sillysoft.widgets.watermark.WatermarkPainter;
import java.awt.Graphics;
import javax.swing.JViewport;

public class WatermarkViewport
extends JViewport {
    private WatermarkPainter bgPainter;
    private WatermarkPainter fgPainter;

    public WatermarkViewport(WatermarkPainter bgPainter, WatermarkPainter fgPainter) {
        this.setBackgroundPainter(bgPainter);
        this.setForegroundPainter(fgPainter);
        this.setOpaque(false);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.bgPainter != null) {
            this.bgPainter.paint(g);
        }
    }

    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.fgPainter != null) {
            this.fgPainter.paint(g);
        }
    }

    public void setBackgroundPainter(WatermarkPainter painter) {
        if (this.bgPainter != null) {
            this.bgPainter.setComponent(null);
        }
        this.bgPainter = painter;
        if (this.bgPainter != null) {
            this.bgPainter.setComponent(this);
        }
        this.repaint();
    }

    public void setForegroundPainter(WatermarkPainter painter) {
        if (this.fgPainter != null) {
            this.fgPainter.setComponent(null);
        }
        this.fgPainter = painter;
        if (this.fgPainter != null) {
            this.fgPainter.setComponent(this);
        }
        this.repaint();
    }

    public WatermarkPainter getBackgroundPainter() {
        return this.bgPainter;
    }

    public WatermarkPainter getForegroundPainter() {
        return this.fgPainter;
    }
}

