/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Date;

public class VisualsNotice {
    private String text;
    private Point point;
    private long startTime;
    private long lengthTime;
    private static Font lastFont;

    public VisualsNotice(String text, Point p) {
        this(text, p, 5000L);
    }

    public VisualsNotice(String text, Point p, long lengthTime) {
        this(text, p, lengthTime, true);
    }

    public VisualsNotice(String text, Point p, long lengthTime, boolean alterY) {
        this.text = text;
        this.lengthTime = lengthTime;
        if (alterY) {
            int y = Math.max(0, p.y - 60);
            this.point = new Point(p.x, y);
        } else {
            this.point = new Point(p.x, p.y);
        }
        this.startTime = new Date().getTime();
    }

    public boolean draw(Graphics2D g) {
        GraphicsTool.drawBoxedString(g, this.text, this.point.x, this.point.y, 4, 2, GraphicsTool.transparent(Color.white, 0.9f), Color.BLACK, 1, Color.BLACK);
        return this.stillDrawing();
    }

    public Rectangle getBounds() {
        return this.getBounds(null);
    }

    public Rectangle getBounds(Font font) {
        if (font == null) {
            font = lastFont;
        } else {
            lastFont = font;
        }
        if (font == null) {
            SS.debug("VisualsNotice.getBounds() called before we've set the font", 1);
            return new Rectangle(this.point.x - 100, this.point.y - 50, 200, 100);
        }
        return GraphicsTool.getBoxedStringRectangle(font, this.text, this.point.x, this.point.y, 2, 2, GraphicsTool.transparent(Color.white, 0.75f), Color.BLACK, 1, Color.BLACK);
    }

    public boolean stillDrawing() {
        long nowTime = new Date().getTime();
        return nowTime - this.startTime < this.lengthTime;
    }
}

