/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.GraphicsTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class TexturedPanel
extends JPanel {
    private BufferedImage texture;
    private Color colorFill;
    private boolean ignoreBorders;
    private boolean drawLuxLogo;
    private static Image luxLogo;

    public TexturedPanel(Color color) {
        this(null, false, false, new BorderLayout());
        this.colorFill = color;
    }

    public TexturedPanel(String filetexture) {
        this(filetexture, false, false, new BorderLayout());
    }

    public TexturedPanel(String filetexture, LayoutManager manager) {
        this(filetexture, false, false, manager);
    }

    public TexturedPanel(String filetexture, boolean ignoreBorders, boolean drawLuxLogo, LayoutManager manager) {
        super(manager);
        this.ignoreBorders = ignoreBorders;
        this.drawLuxLogo = drawLuxLogo;
        if (filetexture != null) {
            this.texture = GraphicsTool.getBufferedImageFromJAR(filetexture);
        }
        if (drawLuxLogo && luxLogo == null) {
            luxLogo = GraphicsTool.getImageFromJAR("LuxDeluxLogo.png");
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.texture == null && this.colorFill == null) {
            return;
        }
        if (this.colorFill != null) {
            g2.setColor(this.colorFill);
        } else {
            Rectangle2D.Double tr = new Rectangle2D.Double(0.0, 0.0, this.texture.getWidth(), this.texture.getHeight());
            TexturePaint tp = new TexturePaint(this.texture, tr);
            g2.setPaint(tp);
        }
        if (this.ignoreBorders) {
            g2.fill(g2.getClipRect());
        } else if (this.colorFill != null) {
            g2.fillRect(2, 27, this.getWidth() - 4, this.getHeight() - 29);
        } else {
            g2.fillRect(2, 11, this.getWidth() - 4, this.getHeight() - 13);
        }
    }

    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.drawLuxLogo && luxLogo != null) {
            g.drawImage(luxLogo, 0, 0, null);
        }
    }
}

