/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.widgets.SSApp;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundEffect {
    private static Vector allSounds = new Vector();
    private Clip clip;

    public static void playSoundFromURL(URL aURL) {
        SoundEffect sound = new SoundEffect(aURL);
        sound.play();
        sound.kill();
        sound = null;
    }

    public SoundEffect(String name) {
        try {
            File file = new File(DesktopTool.modernResourcesLocation() + "Sounds" + File.separator + name);
            if (file.exists()) {
                this.loadFromStream(AudioSystem.getAudioInputStream(file.toURL()));
            } else {
                file = new File(DesktopTool.supportFolderPath() + "Sounds" + File.separator + name);
                if (file.exists()) {
                    System.out.println(" -- loading sound mod for " + name);
                    this.loadFromStream(AudioSystem.getAudioInputStream(file.toURL()));
                } else {
                    this.loadFromStream(AudioSystem.getAudioInputStream(SoundEffect.class.getResource("/" + name)));
                }
            }
        }
        catch (Exception e) {
            System.out.println("SoundEffect -> could not load " + name + " (" + e + ")");
        }
    }

    public SoundEffect(URL location) {
        try {
            this.loadFromStream(AudioSystem.getAudioInputStream(location));
        }
        catch (Exception e) {
            System.out.println("SoundEffect -> could not load location " + location + " (" + e + ")");
        }
    }

    private void loadFromStream(AudioInputStream audioInputStream) throws MalformedURLException, IOException, LineUnavailableException {
        AudioFormat audioFormat = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(Clip.class, audioFormat, -1);
        if (!AudioSystem.isLineSupported(info)) {
            AudioFormat sourceFormat = audioFormat;
            AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), sourceFormat.getChannels() * 2, sourceFormat.getSampleRate(), false);
            audioInputStream = AudioSystem.getAudioInputStream(targetFormat, audioInputStream);
            audioFormat = audioInputStream.getFormat();
        }
        this.clip = (Clip)AudioSystem.getLine(info);
        if (this.clip == null) {
            System.out.println("SoundEffect: cannot get Clip for format " + audioFormat);
        }
        this.clip.open(audioInputStream);
        audioInputStream.close();
        this.setVolume((double)Prefs.getInt(SoundEffect.volumeKey(), 100) / 100.0);
        allSounds.add(this);
    }

    public void play() {
        if (this.clip != null && !this.clip.isActive() && Prefs.getBoolean("useSound", true)) {
            this.clip.setFramePosition(0);
            this.clip.start();
        }
    }

    public void play(boolean forceRestart) {
        if (this.clip != null && forceRestart && !SS.isMacintosh && this.clip.isActive() && Prefs.getBoolean("sounds", true)) {
            this.clip.stop();
            this.clip.setFramePosition(0);
            this.clip.start();
            return;
        }
        if (this.clip != null && (forceRestart || !this.clip.isActive())) {
            this.clip.setFramePosition(0);
            this.clip.start();
        }
    }

    public void startLooping() {
        if (this.clip != null && !this.clip.isActive()) {
            this.clip.setFramePosition(0);
            this.clip.loop(50);
        }
    }

    public void stopLooping() {
        if (this.clip != null && this.clip.isActive()) {
            this.clip.loop(0);
        }
    }

    public static void setSoundVolume(double gain) {
        for (int i = 0; i < allSounds.size(); ++i) {
            ((SoundEffect)allSounds.get(i)).setVolume(gain);
        }
    }

    public void setVolume(double gain) {
        if (this.clip != null) {
            FloatControl gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
            float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0);
            gainControl.setValue(dB);
        }
    }

    public void kill() {
        allSounds.remove(this);
        this.clip = null;
    }

    public boolean isActive() {
        return this.clip != null && this.clip.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamSampledAudio(URL url) throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        AudioInputStream ain = null;
        Line line = null;
        try {
            int bytesread;
            ain = AudioSystem.getAudioInputStream(url);
            AudioFormat format = ain.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            if (!AudioSystem.isLineSupported(info)) {
                AudioFormat pcm = new AudioFormat(format.getSampleRate(), 16, format.getChannels(), true, false);
                ain = AudioSystem.getAudioInputStream(pcm, ain);
                format = ain.getFormat();
                info = new DataLine.Info(SourceDataLine.class, format);
            }
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format);
            int framesize = format.getFrameSize();
            byte[] buffer = new byte[4096 * framesize];
            int numbytes = 0;
            boolean started = false;
            while ((bytesread = ain.read(buffer, numbytes, buffer.length - numbytes)) != -1) {
                numbytes += bytesread;
                if (!started) {
                    line.start();
                    double gain = (double)Prefs.getInt(SoundEffect.volumeKey(), 100) / 100.0;
                    FloatControl gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                    float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0);
                    gainControl.setValue(dB);
                    started = true;
                }
                int bytestowrite = numbytes / framesize * framesize;
                line.write(buffer, 0, bytestowrite);
                int remaining = numbytes - bytestowrite;
                if (remaining > 0) {
                    System.arraycopy(buffer, bytestowrite, buffer, 0, remaining);
                }
                numbytes = remaining;
            }
            line.drain();
        }
        finally {
            if (line != null) {
                line.close();
            }
            if (ain != null) {
                ain.close();
            }
        }
    }

    protected static String volumeKey() {
        return SSApp.isVox ? "soundVolume" : "volume";
    }
}

