/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.SS;
import com.sillysoft.widgets.SSTextField;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;

public class SearchField
extends SSTextField {
    private static final Border CANCEL_BORDER = new CancelBorder();
    private boolean sendsNotificationForEachKeystroke = false;
    private boolean showingPlaceholderText = false;
    private boolean armed = false;

    public SearchField(String placeholderText) {
        super(15);
        this.addFocusListener(new PlaceholderText(placeholderText));
        this.initBorder();
        this.initKeyListener();
        this.putClientProperty("JTextField.variant", "search");
    }

    public SearchField() {
        this("Search");
    }

    private void initBorder() {
        this.setBorder(new CompoundBorder(this.getBorder(), CANCEL_BORDER));
        CancelListener mouseInputListener = new CancelListener();
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
    }

    private void initKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SearchField.this.cancel();
                } else if (SearchField.this.sendsNotificationForEachKeystroke) {
                    SearchField.this.maybeNotify();
                }
            }
        });
        if (SS.isMacintosh105 || SS.isMacintosh106) {
            this.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                }

                public void insertUpdate(DocumentEvent e) {
                }

                public void removeUpdate(DocumentEvent e) {
                    SearchField.this.maybeNotify();
                }
            });
        }
    }

    private void cancel() {
        this.setText("");
        this.postActionEvent();
    }

    private void maybeNotify() {
        if (this.showingPlaceholderText) {
            return;
        }
        this.postActionEvent();
    }

    public void setSendsNotificationForEachKeystroke(boolean eachKeystroke) {
        this.sendsNotificationForEachKeystroke = eachKeystroke;
    }

    public void setText(String text, boolean realText) {
        if (realText) {
            this.showingPlaceholderText = false;
        }
        this.setForeground(Color.BLACK);
        super.setText(text);
        if (realText) {
            this.showingPlaceholderText = false;
        }
        this.maybeNotify();
    }

    class PlaceholderText
    implements FocusListener {
        private String placeholderText;
        private String previousText = "";
        private Color previousColor;

        PlaceholderText(String placeholderText) {
            this.placeholderText = placeholderText;
            this.focusLost(null);
        }

        public void focusGained(FocusEvent e) {
            SearchField.this.setForeground(this.previousColor);
            if (!SearchField.this.getText().equals(this.previousText)) {
                SearchField.this.setText(this.previousText);
            }
            SearchField.this.showingPlaceholderText = false;
        }

        public void focusLost(FocusEvent e) {
            this.previousText = SearchField.this.getText();
            this.previousColor = SearchField.this.getForeground();
            if (this.previousText.length() == 0) {
                SearchField.this.showingPlaceholderText = true;
                SearchField.this.setForeground(Color.GRAY);
                SearchField.this.setText(this.placeholderText);
            }
        }
    }

    class CancelListener
    extends MouseInputAdapter {
        CancelListener() {
        }

        private boolean isOverButton(MouseEvent e) {
            if (!SearchField.this.contains(e.getPoint())) {
                return false;
            }
            Rectangle innerArea = SwingUtilities.calculateInnerArea(SearchField.this, null);
            return !innerArea.contains(e.getPoint());
        }

        public void mouseDragged(MouseEvent e) {
            this.arm(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.arm(e);
        }

        public void mouseExited(MouseEvent e) {
            this.disarm();
        }

        public void mousePressed(MouseEvent e) {
            this.arm(e);
        }

        public void mouseReleased(MouseEvent e) {
            if (SearchField.this.armed) {
                SearchField.this.cancel();
            }
            this.disarm();
        }

        private void arm(MouseEvent e) {
            SearchField.this.armed = this.isOverButton(e) && SwingUtilities.isLeftMouseButton(e);
            SearchField.this.repaint();
        }

        private void disarm() {
            SearchField.this.armed = false;
            SearchField.this.repaint();
        }
    }

    static class CancelBorder
    extends EmptyBorder {
        private static final Color GRAY = new Color(0.7f, 0.7f, 0.7f);

        CancelBorder() {
            super(0, 0, 0, 15);
        }

        public void paintBorder(Component c, Graphics oldGraphics, int x, int y, int width, int height) {
            SearchField field = (SearchField)c;
            if (field.showingPlaceholderText || field.getText().length() == 0) {
                return;
            }
            Graphics2D g = (Graphics2D)oldGraphics;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int circleL = 14;
            int circleX = x + width - 14;
            int circleY = y + (height - 14) / 2;
            g.setColor(field.armed ? Color.GRAY : GRAY);
            g.fillOval(circleX, circleY, 14, 14);
            int lineL = 5;
            int lineX = circleX + 4;
            int lineY = circleY + 4;
            g.setColor(Color.WHITE);
            g.setStroke(new BasicStroke(1.3f));
            g.drawLine(lineX, lineY, lineX + 5, lineY + 5);
            g.drawLine(lineX, lineY + 5, lineX + 5, lineY);
        }
    }
}

