/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

public class SSTextField
extends JTextField {
    static Action altDeleteAction;
    static Action altBackspaceAction;
    private boolean drawGrowBox = false;
    private static Image growbox;

    public SSTextField() {
        this.init();
    }

    public SSTextField(int columns) {
        super(columns);
        this.init();
    }

    public SSTextField(String text) {
        super(text);
        this.init();
    }

    public SSTextField(String text, int columns) {
        super(text, columns);
        this.init();
    }

    private void init() {
        if (SS.isMacintosh) {
            this.getInputMap(0).put(KeyStroke.getKeyStroke("UP"), "caret-begin");
            this.getInputMap(0).put(KeyStroke.getKeyStroke("shift UP"), "selection-begin");
            this.getInputMap(0).put(KeyStroke.getKeyStroke("DOWN"), "caret-end");
            this.getInputMap(0).put(KeyStroke.getKeyStroke("shift DOWN"), "selection-end");
            this.getInputMap(0).put(KeyStroke.getKeyStroke("alt DELETE"), "altDeleteAction");
            this.getInputMap(0).put(KeyStroke.getKeyStroke("alt BACK_SPACE"), "altBackspaceAction");
            this.getActionMap().put("altDeleteAction", altDeleteAction);
            this.getActionMap().put("altBackspaceAction", altBackspaceAction);
        }
    }

    public int getTextAsInt() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void selectIfFocused() {
        if (this.isFocusOwner()) {
            this.select(0, 1000);
        }
    }

    public void setDrawGrowBox(boolean value) {
        this.drawGrowBox = value;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.drawGrowBox) {
            if (SS.isMacintosh105 || SS.isMacintosh106) {
                g.drawImage(growbox, this.getWidth() - 16, 12, null);
            } else {
                g.drawImage(growbox, this.getWidth() - 13, 9, null);
            }
        }
    }

    static {
        if (SS.isMacintosh) {
            altDeleteAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    JTextComponent target = (JTextComponent)e.getSource();
                    if (target != null) {
                        try {
                            int offs = target.getCaretPosition();
                            int endOffs = Utilities.getWordEnd(target, offs);
                            target.moveCaretPosition(endOffs);
                            target.replaceSelection("");
                        }
                        catch (BadLocationException exc) {
                            exc.printStackTrace();
                        }
                    }
                }
            };
            altBackspaceAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    JTextComponent target = (JTextComponent)e.getSource();
                    if (target != null) {
                        int offs = target.getCaretPosition();
                        boolean failed = false;
                        try {
                            offs = Utilities.getPreviousWord(target, offs);
                        }
                        catch (BadLocationException bl) {
                            if (offs != 0) {
                                offs = 0;
                            }
                            failed = true;
                        }
                        if (!failed) {
                            target.moveCaretPosition(offs);
                            target.replaceSelection("");
                        } else {
                            SS.debug("altBackspaceAction failed");
                        }
                    }
                }
            };
        }
        if (SS.isMacintosh) {
            growbox = GraphicsTool.getImageFromJAR("growbox_white.gif");
        }
    }
}

