/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.SS;
import com.sillysoft.tools.SwingTool;
import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SSTable
extends JTable {
    public static final Color ROW_COLOR_2 = new Color(241, 245, 250);

    public SSTable(TableModel tm) {
        super(tm);
        if (SS.isVista) {
            SwingTool.fixTableHeader(this);
        }
    }

    public void setColumnWidth(int column, int width) {
        this.getTableHeader().getColumnModel().getColumn(column).setPreferredWidth(width);
    }

    public void setRowSelection(int[] viewRows) {
        this.clearSelection();
        if (viewRows.length == 0) {
            return;
        }
        int min = -1;
        int max = 0;
        int lastRow = -1;
        for (int i = 0; i < viewRows.length; ++i) {
            if (min == -1) {
                min = viewRows[i];
            } else if (viewRows[i] == lastRow + 1) {
                max = viewRows[i];
            } else {
                this.addRowSelectionInterval(min, lastRow);
                min = viewRows[i];
            }
            lastRow = viewRows[i];
        }
        this.addRowSelectionInterval(min, lastRow);
    }

    public void setAlternatingRowColors() {
        AlternatingRowsCellRenderer alt = new AlternatingRowsCellRenderer();
        this.setDefaultRenderer(Object.class, alt);
        this.setDefaultRenderer(Integer.class, alt);
        this.setDefaultRenderer(Double.class, alt);
        this.setDefaultRenderer(Float.class, alt);
    }

    public int getOptimalWidth() {
        JTableHeader header = this.getTableHeader();
        int rowCount = this.getRowCount();
        Enumeration<TableColumn> columns = this.getColumnModel().getColumns();
        int[] preferredWidths = new int[this.getColumnCount()];
        int totalPreferredWidth = 0;
        int i = 0;
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            int col = header.getColumnModel().getColumnIndex(column.getIdentifier());
            int width = (int)this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(this, column.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
            SS.debug("getPerfectLayoutWidth() header[" + i + "] " + this.getColumnModel().getColumn(col).getHeaderValue() + " wanted " + width, 4);
            if (!(this.getColumnModel().getColumn(col).getHeaderValue() instanceof String)) {
                width = Math.min(width, 20);
            }
            for (int row = 0; row < rowCount; ++row) {
                int preferedWidth = (int)this.getCellRenderer(row, col).getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
                width = Math.max(width, preferedWidth);
            }
            SS.debug("getPerfectLayoutWidth() preferredWidths[" + i + "] = " + width, 4);
            preferredWidths[i] = width;
            totalPreferredWidth += width;
            ++i;
        }
        return totalPreferredWidth;
    }

    private class AlternatingRowsCellRenderer
    extends DefaultTableCellRenderer {
        private AlternatingRowsCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                if (row % 2 == 0) {
                    cell.setBackground(ROW_COLOR_2);
                } else {
                    cell.setBackground(Color.WHITE);
                }
            }
            return cell;
        }
    }
}

